/*-------------------------------------------------------------------------
File    : mathlib.c
Author  : John Carmack (id Software) with modifications by C. Newham
Version : 1.0
Date    : 96/08/29

Description
-----------
Contains primatives for vector maths.

Comments
--------
This C version is an almost verbatim copy from Carmack's mathlib.c
provided with the QuakeEd source.

CrossProduct has been modified because I found it was giving Not a Number
(NaN) results for some cases of -0. Machine used: Pentium 133,
Linux 1.2.13, GCC 2.7.0.  As I'm no great expert on IEEE floating point
(or maths in general :) I'd appreciate any answers as to why this
problem occurs (or am I seeing things?).  cam@iinet.com.au.
-------------------------------------------------------------------------*/

#include "mathlib.h"
#include "readmap.h"
#include <math.h>


vec3_t vec3_origin = {0,0,0};


/*--------------------------------------------------------
--------------------------------------------------------*/
double VectorLength(vec3_t v)
{
	int		i;
	double	length;
	
	length = 0;
	for (i=0 ; i< 3 ; i++)
		length += v[i]*v[i];
	length = sqrt (length);		

	return length;
}

/*--------------------------------------------------------
--------------------------------------------------------*/
void VectorMA (vec3_t va, float scale, vec3_t vb, vec3_t vc) //double
{
	vc[0] = va[0] + scale*vb[0];
	vc[1] = va[1] + scale*vb[1];
	vc[2] = va[2] + scale*vb[2];
}

/*--------------------------------------------------------
--------------------------------------------------------*/
int VectorCompare (vec3_t v1, vec3_t v2)
{
	int		i;
	
	for (i=0 ; i<3 ; i++)
		if (v1[i] != v2[i])
			return FALSE;
			
	return TRUE;
}


/*--------------------------------------------------------
Calculates the cross product of two vectors. The cross
product returns a vector perpendicular to two non-parallel
vectors.
--------------------------------------------------------*/
void CrossProduct (vec3_t v1, vec3_t v2, vec3_t cross)
{
/* needed the checks for < MINFLOAT because it can be -0.0
   which returned NaN (Not a Number) - bizarre behaviour IMHO. */  
// Cross[i] is a float value and abs is looking to get the
// absolute of an int. You can take out the MINFLOAT check
// 11-12-96

	cross[0] = v1[1]*v2[2] - v1[2]*v2[1];
        if ((abs((int)cross[0])) < MINFLOAT)
          cross[0] = 0;
	cross[1] = v1[2]*v2[0] - v1[0]*v2[2];
        if ((abs((int)cross[1])) < MINFLOAT)
          cross[1] = 0;
	cross[2] = v1[0]*v2[1] - v1[1]*v2[0];
        if ((abs((int)cross[2])) < MINFLOAT)
          cross[2] = 0;              
    
}

/*--------------------------------------------------------
--------------------------------------------------------*/
vec_t DotProduct (vec3_t v1, vec3_t v2)
{
	return v1[0]*v2[0] + v1[1]*v2[1] + v1[2]*v2[2];
}

/*--------------------------------------------------------
--------------------------------------------------------*/
void VectorSubtract (vec3_t va, vec3_t vb, vec3_t out)
{
	out[0] = va[0]-vb[0];
	out[1] = va[1]-vb[1];
	out[2] = va[2]-vb[2];
}

/*--------------------------------------------------------
--------------------------------------------------------*/
void VectorAdd (vec3_t va, vec3_t vb, vec3_t out)
{
	out[0] = va[0]+vb[0];
	out[1] = va[1]+vb[1];
	out[2] = va[2]+vb[2];
}

/*--------------------------------------------------------
--------------------------------------------------------*/
void VectorCopy (vec3_t in, vec3_t out)
{
	out[0] = in[0];
	out[1] = in[1];
	out[2] = in[2];
}

/*--------------------------------------------------------
--------------------------------------------------------*/
void VectorNormalize (vec3_t v)
{
	int		i;  
	long double length;
	//float	length;  this should probably be looked at 11-12-96
	
	length = 0;
	for (i=0 ; i< 3 ; i++)
		length += v[i]*v[i];
	length =(float) sqrt ((float)length);

	for (i=0 ; i< 3 ; i++)
		v[i] /=(float) length;	
}

/*--------------------------------------------------------
--------------------------------------------------------*/
void VectorScale (vec3_t v, vec_t scale, vec3_t out)
{
	out[0] = v[0] * scale;
	out[1] = v[1] * scale;
	out[2] = v[2] * scale;
}

