//external map/wad functions
#include "bsp.h"
#include "disk.h"
#include "pak.h"
#include "input.h"
#include "svgacc.h"
#include "grfx.h"
//temp
#include <stdio.h>
//end temp

void breakbox(int x0, int y0, int x1, int y1)
{
   drwbox(SET,WHITE,x0+1,y0+1,x1-1,y1-1);
   drwbox(SET,BLACK,x0,y0,x1,y1);
}

void screentextures()
{
   drwfillbox(SET,LTGRAY,0,0,800,600);
   inputbox(0,20,200,312,"Selected Textures");
   drwfillbox(SET,BLACK,5,40,195,308);
   drwfillbox(SET,BLUE,205,45,295,74);
   drwstring(SET,YELLOW,BLUE,"Texture",222,46);
   drwstring(SET,YELLOW,BLUE,"Commands",217,60);
   breakbox(205,45,295,74);
   breakbox(205,75,295,179);
   button(210, 80,290, 95,"  Delete");
   button(210,100,290,115,"  Import");
   button(210,120,290,135,"  Export");
   button(210,140,290,155," Make WAD");
   button(210,160,290,175,"   Exit");
   drwfillbox(SET,BLUE,0,0,800,15);
   drwstring(SET,WHITE,BLUE,"EdQuake v0.02    (c) copyright 1996 Scott Mitting/David Langeliers  ",25,1);
   scrollbutton(184,280,"");
   scrollbutton(184,294,"");
   impress(40,460,477,573);
   pcxput(SET,40,460,"logo.pcx");
   mouseshow();
}

void showmip(int e)
{
   int cx, cy;
   fseek(pak.p,texture[e].pakoffset,0);
   drwfillbox(SET,LTGRAY,298,18,600,276);
   impress(299,19,301+texture[e].width,21+texture[e].height);
   for (cy = 0; cy < texture[e].height; cy++)
     for (cx = 0; cx < texture[e].width; cx++)
	drwpoint(SET,fgetc(pak.p),cx+300,cy+20);
}

void showmenutexture(int showE, int curE)
{
   int t,qt;
   char buf[80];
   qt = 40;
   mousehide();
   for (t = 1; t < 20; t++)
   {
     if (t != curE)
     {
	drwfillbox(SET, BLACK,6,qt,183,qt+14);
	sprintf(buf, "%s", texture[t+showE].name);
	drwstring(SET, WHITE,BLACK,buf,11,qt);
     }
     else
     {
	drwfillbox(SET,RED,6,qt,183,qt+14);
	sprintf(buf, "%s", texture[t+showE].name);
	drwstring(SET, YELLOW,RED,buf,11,qt);
     }
     qt+=14;
   }
   mouseshow();
}

//takes all textures and throws them into a wad
void mip2wad()
{
   char *p;
   FILE *out;
   long t;
   long mipoffset[256];
   long mipsize[256];
   p = wgetstringbox("Create WAD2", "Save as:", "texture.wad");
   out = fopen(p,"wb");
   if (!out) return;
   fwrite("WAD2",4,1,out);
   t = numtex;
   fwrite(&t,4,1,out);
   t = 0;
   fwrite(&t,4,1,out);
   fclose(out);
}

void selecttextures()
{
   //buttons
   button_t delbut, impbut, expbut, exibut, wadbut;
   button_t up, down;
   int showE = 0, curE = 1;
   int i, k, mbuts, mx, my;
   //setupscreen
    up = scrollbutton(184,280,"");
    down = scrollbutton(184,294,"");
   screentextures();
   delbut = button(210, 80,290, 95,"  Delete");
   impbut = button(210,100,290,115,"  Import");
   expbut = button(210,120,290,135,"  Export");
   wadbut = button(210,140,290,155," Make WAD");
   exibut = button(210,160,290,175,"   Exit");
   while (k != 27)
   {
     showmenutexture(showE, curE);
     scrollbar(184,40,279,showE+curE,numtex);
     showmip(showE+curE);
	    while (!kbhit() && !mbuts)
	    {
	       mousestatus(&mx,&my,&mbuts);
	       if (mbuts & 1)//scroll
	       {
		  if (hitbutton(mx,my,up)) curE-=1;
		  if (hitbutton(mx,my,down)) curE+=1;
		  if (hitbutton(mx,my,exibut)) return;
		  if (hitbutton(mx,my,wadbut)) mip2wad();
		  //select
		  if (mx < 184 && my < 300 && my > 40)
		     curE =  ((my - 40) / 14)+1;
	       }
	       if (mbuts & 2)//scroll fast
	       {
		  if (hitbutton(mx,my,up)) showE-=3;
		  if (hitbutton(mx,my,down)) showE+=3;
	       }
	    }
	    if (!mbuts) k = getkey();
	    mbuts = 0;

     if (k == a_DOWN) curE++;
     if (k == a_UP)   curE--;
     if (k == a_PGDN) showE+=15;
     if (k == a_PGUP) showE-=15;
     if (k == a_HOME) curE=1;
     if (k == a_END)  curE=19;
     if (k == a_ESC)   return;
     if (curE > 19) {showE++;curE=19;}
     if (curE < 1)  {showE--;curE=1;}
     if (showE < 0) {showE = 0; curE = 1;}
     if (showE + 20 > numtex) {showE = numtex - 20; curE=19;}
   }
}



