/*EdQuake v0.50 source code
  (c) Copyright 1996 Scott Mitting
  email:smitting@netusa1.net
  ----------------------------------
  RIPPER.C  -  High level functions for Saving files

  __variables:

  __functions:
  void setquakecolors() 	-- sets colors for menus to the quake
				   default palette
  void showcredit(char *info)   -- shows bar at top of screen
  void saveentry(int e)         -- selects file name and saves file
  void savewadentry(int e)      -- selects file name and saves wad
  void ripper()                 -- selects file from pak and saves
				   it to disk.
  void ripperwad()              -- selects file from wad and saves
				   it to disk.
  ----------------------------------
  the entire source code is under renovation to make it easier
  to understand.  happy coding.
*/

#include <stdio.h>
#include <string.h>
#include "pak.h"
#include "input.h"
#include "svgacc.h"
#include "grfx.h"
#include "wad.h"

void setquakecolors()
{
    RED    = 250;
    DKGRAY = 4;
    LTGRAY = 9;
    WHITE  = 15;
    BLUE   = 216;
    BLACK  = 0;
    YELLOW = 243;
}

void showcredit(char *info)
{

   drwfillbox(SET,BLUE,0,0,640,13);
   drwstring(SET, WHITE,BLUE,"  EdQuake v0.01b",0,0);
   drwstring(SET, WHITE,BLUE,info,200,0);
}

void saveentry(int e)
{
   char *p;
   int def;
   getentry(e);

   //get default name
   def = strlen(pakentry.name);
   while (def > 0)
   {
      if (pakentry.name[def] == '/') def=-def;
	 else def--;
   }
   def=-def;
   def++;
   //end get default name

   p = wgetstringbox("Save File As", "Save as:", pakentry.name + def);
   if (p) export(e, p);
   drwfillbox(SET, BLACK, 100,150,430,225);
}

void savewadentry(int e)
{
   char *p;
   getwadentry(e);
   p = wgetstringbox("Save File As", "Save as:", wadentry.name);
   if (p) wadexport(e, p);
   drwfillbox(SET, BLACK, 100,150,430,225);
}

int ripper()
{
   int t;
   mousehide();
   drwfillbox(SET,BLACK,0,0,800,600);
   mouseshow();
   t = selectentry(0);
   if (t > 0) saveentry(t);
   return t;
}

int ripperwad()
{
   int t;
   setquakecolors();
   loadpcx(0,0,"quakepal.pcx");
   drwfillbox(SET,BLACK,0,0,800,600);
   t = selectwadentry(0);
   if (t != -1) savewadentry(t);
   return t;
}

