/*EdQuake v0.50 source code
  (c) Copyright 1996 Scott Mitting
  email:smitting@netusa1.net
  ----------------------------------
  DISK.C  -  Generic disk routines

  __variables:
  <no global variables>
  __functions:
  char * loadDosToMem(char * filename)   -- loads a file from disk to ram
  long fgetl(FILE *f)			 -- gets a long integer
  int fgeti(FILE *f)			 -- gets an integer
  dentry_t fgetd(FILE *p)                -- gets a bsp entry
  ----------------------------------
  the entire source code is under renovation to make it easier
  to understand.  happy coding.
*/

#include <stdio.h>
#include <dir.h>
#include <alloc.h>
#include <dos.h>
#include "svgacc.h"
#include "bsp.h"
#include "grfx.h"
#include "input.h"

struct ffblk far *ff;//files

char * loadDosToMem(char * filename)
{
  char * loadBuffer = NULL;
  long loadBufferIndex = 0;
  long miscNumber;
  long size;
  long bytesLeft;
  FILE * myInStream;
  myInStream = fopen(filename, "rb");
  fseek(myInStream,0, SEEK_END);
  size = ftell(myInStream);
  if (size > 64000) size = 64000;
  loadBuffer = (char *) malloc(size);
  fseek(myInStream,0,SEEK_SET);
  for (bytesLeft = size; bytesLeft > 0;)
  {
    miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
    fread(loadBuffer + loadBufferIndex, (int)miscNumber,1,myInStream);
    bytesLeft -= miscNumber;
    loadBufferIndex += miscNumber;
  }
  return loadBuffer;
}


long fgetl(FILE *f)
{
   long t,
	l;
   l  = fgetc(f);
   t  = fgetc(f);
   l += t << 8;
   t  = fgetc(f);
   l += t << 16;
   t  = fgetc(f);
   l += t << 24;
   return l;
}

int fgeti(FILE *f)
{
   long t,
	l;
   l  = fgetc(f);
   t  = fgetc(f);
   l += t << 8;
   return l;
}

long getfilesize(FILE *f)
{
   long temp, r;
   temp = ftell(f);
   fseek(f,0,2);
   r = ftell(f);
   fseek(f,temp,0);
   return r;
}

void showdir(int cure, int showe)
{
  int t, done;
  char buf[40];
  mousehide();
   for (done = 0; done < 15; done++)
   {
    if (done == cure) t = RED; else t = BLUE;
    if (ff[done+showe].ff_attrib == 0x10)
    {
      sprintf(buf,"  %13s       <DIR>  ", ff[done+showe].ff_name);
      drwstring(SET,WHITE,t,buf,200,(done*14)+250);
    }
    else
    {
      sprintf(buf,"  %13s  %10li  ", ff[done+showe].ff_name,ff[done+showe].ff_fsize);
      drwstring(SET,WHITE,t,buf,200,(done*14)+250);
    }
   }
   mouseshow();
}

char *selectdir(char *ext)
{
   struct ffblk fft;
   int numfile;
   int done, t;
   char buf[40];
   int k;
   int cure = 1, showe = 0;
   int mx, my, mbuts;
   button_t xbutton, up, down, ok, doit;
   ff = farmalloc(8500);
   if (!ff) return 0;
   //get files
   done = findfirst(ext,&fft,0);
   ff[numfile = 0] = fft;
   while (!done)
   {
      done = findnext(&fft);
      ff[numfile++] = fft;
   }
   numfile--;
   //get dirs
   done = findfirst("*.",&fft,0x10);
   ff[numfile++] = fft;
   while (!done)
   {
      done = findnext(&fft);
      ff[numfile++] = fft;
      ff[numfile].ff_attrib = 0x10;
   }
   numfile--;
   //sort contents
   for (t = numfile - 1; t >= 0; t--)
   {
      for (done = t; done >= 0; done--)
      {
	 if (strcmp(ff[done].ff_name,ff[t].ff_name) > 0)
	 {
	    fft = ff[t];
	    ff[t] = ff[done];
	    ff[done] = fft;
	 }
	 if (ff[done].ff_attrib < ff[t].ff_attrib)
	 {
	    fft = ff[t];
	    ff[t] = ff[done];
	    ff[done] = fft;
	 }
      }
   }
  //dump contents
   showe=cure=0;
   t = 0;
   mousehide();
   xbutton = inputbox(194,213,448,464,"Select File");
   sprintf(buf," %s ",ext);
   drwfillbox(SET,BLACK,202,235,370,248);
   drwstring(SET,WHITE,BLACK,buf,202,235);
   doit = clearbutton(200,250,430,450);
   ok = button(375,235,440,248,"   Ok");
   up = scrollbutton(432,433,"");
   down = scrollbutton(432,447,"");
   mouseshow();
   while (mbuts) mousestatus(&mx,&my,&mbuts);
   while (k != 27)
   {
     showdir(cure,showe);
     scrollbar(432,250,433,showe+cure,numfile-1);
	    while (!kbhit() && !mbuts)
	    {
	       mousestatus(&mx,&my,&mbuts);
	       if (mbuts & 1)//scroll
	       {
		  if (hitbutton(mx,my,up))
		  {
		      showe--;
		      while (mbuts) mousestatus(&mx,&my,&mbuts);
		      mbuts = 1;
		  }
		  if (hitbutton(mx,my,down))
		  {
		      showe++;
		      while (mbuts) mousestatus(&mx,&my,&mbuts);
		      mbuts = 1;
		  }
		  if (hitbutton(mx,my,xbutton)) return 0;
		  //select
		  if (hitbutton(mx,my,doit)) cure = (my - 250) / 14;
	       }
	       if (mbuts & 2)//scroll fast
	       {
		  if (hitbutton(mx,my,up)) showe--;
		  if (hitbutton(mx,my,down)) showe++;
		  if (hitbutton(mx,my,doit)) return ff[showe+cure].ff_name;
	       }
	    }
	    if (!mbuts) k = getkey();
	    mbuts = 0;

     if (k == a_DOWN) cure++;
     if (k == a_UP)   cure--;
     if (k == a_PGDN) showe+=14;
     if (k == a_PGUP) showe-=14;
     if (k == a_HOME) cure=1;
     if (k == a_END)  cure=14;
     if (k == a_ENTER) return ff[showe+cure].ff_name;
     if (k == a_ESC)   return 0;
     if (cure > 14) {showe++;cure=14;}
     if (cure < 0)  {showe--;cure=0;}
     if (showe < 0) {showe = 0; cure = 0;}
     if (showe + 15 > numfile) {showe = numfile - 15; cure=14;}
   }
  farfree(ff);
  return 0;
}

