#include <stdio.h>
#include <malloc.h>
#include <mem.h>

#define MAGIC ((dword)(( '2' << 24 ) + ( 'D' << 16 ) + ( 'A' << 8 ) + ( 'W' )))

typedef unsigned char byte;
typedef char          sbyte;
typedef unsigned short word;
typedef short          sword;
typedef unsigned long dword;
typedef long          sdword;

typedef struct {
   byte name[16];
   dword width;
   dword height;
   dword offset[4];
} mip_header;


typedef struct {
   byte magic[4];
   dword numentries;
   dword diroffset;
} wad_header;

typedef struct {
   dword offset;
   dword size;
   dword size2;
   byte type;
   byte compress;
   word dummy;
   byte name[16];
} wad_entry;


FILE *fp;

int main ( word argc, byte **argv ) {
dword counter;
wad_header head;
mip_header test;
wad_entry  *list;
dword num;

if ( argc < 2 ) {
    printf("usage: wadread <wad2file>\n");
    return 1;
}
fp = fopen ( argv[1], "rb");
if ( !fp ) {
    printf("invalid file \"%s\"\n",argv[1]);
    return 1;
}
printf("opened [%s]\n",argv[1]);

fread(&head,sizeof(wad_header),1,fp);
if ( *((dword *)(&head.magic)) != MAGIC ) {
   printf("this is not a WAD2 file\n");
   exit(1);
}
printf("number of entries: %lu\n",head.numentries );
printf("offset of wad directory: %lu\n",head.diroffset);

list = ( wad_entry * ) malloc ( head.numentries );
if ( !list ) {
    printf("could not allocate mem for dir entries\n");
    exit(1);
}
fseek(fp,head.diroffset,SEEK_SET);
fread(list,sizeof(wad_entry),head.numentries,fp);

for ( counter=0; counter<head.numentries; counter++ ) {
 printf("%s ",list[counter].name);
 switch ( list[counter].type ) {
   case 0x40 : printf("(palette) ");
               break;
   case 0x42 : printf("(status bar pic) ");
               break;
   case 0x44 : printf("(mip texture) ");
               break;
   case 0x45 : printf("(console pic) ");
               break;
 }
 printf("size: %lu ",list[counter].size);
 printf("compressed: %02X\n",list[counter].compress);
 if ( list[counter].type == 0x40 )
    continue; // don't check stuff below
 fseek(fp,list[counter].offset,SEEK_SET);

 fread(&test,sizeof(mip_header),1,fp);
 printf("mip name: %s\n",test.name);
 printf("width: %lu height: %lu\n",test.width,test.height);
 printf("offset mip 0: %lu\n",test.offset[0]);
 printf("offset mip 1: %lu\n",test.offset[1]);
 printf("offset mip 2: %lu\n",test.offset[2]);
 printf("offset mip 3: %lu\n",test.offset[3]);
} // end for

free(list);
fclose(fp);
return 0; }

