#include "pcx.h"

void read_pcx ( byte *filename, raw_img *rimg ) {
FILE *fp;
pcx_header head;
dword count;
word subcount;
byte current,rle;

fp = fopen ( filename, "rb" );
if ( !fp ) {
   printf("unable to open file \"%s\"\n",filename);
   exit(1);
}
fread(&head,sizeof(pcx_header),1,fp);
//printf("pcx id      : %u\n",head.id);
//printf("pcx ver     : %u\n",head.version);
//printf("pcx encoding: %u\n",head.encoding);
//printf("bits/pixel  : %u\n",head.bits_pixel);
//printf("xmin: %u ymin: %u xmax: %u ymax: %u\n",
//          head.xmin,head.ymin,head.xmax,head.ymax);
if ( head.bits_pixel != 8 ) {
    printf("pcx file %s is not 8 bit\n",filename);
    exit(1);
}
rimg->width = (head.xmax-head.xmin)+1;
if ( rimg->width%16 ) {
    printf("error: %s: image width must be a multiple of 16\n",filename);
    exit(1);
}
rimg->height = (head.ymax-head.ymin)+1;
if ( rimg->height%16 ) {
    printf("error: %s: image height must be a multiple of 16\n",filename);
    exit(1);
}
 // because the width is a multiple of 16, there will be no need
 // to read pad bytes on scanlines

printf("width: %u height: %u\n",rimg->width, rimg->height);
rimg->data = (byte *) malloc ( rimg->width*rimg->height );
if ( !rimg->data && rimg->width && rimg->height ) {
   printf("unable to allocate pcx data mem\n");
   exit(1);
} // end if

count=0;
while ( count < (rimg->width*rimg->height) ) {
 fread(&current,1,1,fp);
 if ( ( current & 192 ) == 192 ) { // rle byte
   rle = ( current ^ 192 ); // count
   fread(&current,1,1,fp);  // color to repeat
   for ( subcount=0; subcount<rle; subcount++ )
     rimg->data[count+subcount] = current;
   count+=rle;
   continue; // next pixel
 }
 rimg->data[count] = current;
 count++;
} // end while

// read palette
rimg->palette = (byte *) malloc ( 768 );
if ( !rimg->palette ) {
   printf("could not allocate palette mem\n");
   exit(1);
}
fseek(fp,-768L,SEEK_END);
fread(rimg->palette,1,768,fp);
// done
fclose(fp);
return; }
