#include "lbm.h"

void byte_swap( void *data, word size ) {
word count;
byte temp;
for ( count=0; count<(size/2); count++ ) {
 temp = ((byte *)data)[count];
 ((byte *)data)[count] = ((byte *)data)[(size-1)-count];
 ((byte *)data)[(size-1)-count] = temp;
} // end for
return; }

dispatch_entry dispatch_table [] = {
  { ANNO, &read_ANNO },
  { BMHD, &read_BMHD },
  { CMAP, &read_CMAP },
  { BODY, &read_BODY },
  { 0, 0 }
}; // end dispatch_table


void process_chunk ( FILE *fp, raw_img *rimg ) {
dword id;
dword length;
dword oldpos;
dword index;

fread(&id,4,1,fp);
  oldpos = ftell(fp);
  index = 0;
  while ( dispatch_table[index].id ) {
    if ( dispatch_table[index].id == id ) {
      dispatch_table[index].process( fp, rimg );
      break;
    } // end if
   index++;
  } // end while
  fseek(fp,oldpos,SEEK_SET);
  // restore old position ( at chunk length )
fread(&length,4,1,fp);
byte_swap(&length,4);
fseek(fp,length,SEEK_CUR);
return; }



void read_lbm ( byte *filename, raw_img *rimg ) {
iff_header head;
FILE *fp;

fp = fopen ( filename, "rb" );
if ( !fp ) {
   printf("unable to open file \"%s\"\n",filename);
   exit(1);
}
fread(&head,sizeof(iff_header),1,fp);
if ( head.id != FORM ) {
   printf("not a FORM iff\n");
   exit(1);
}
byte_swap(&head.length,4); // fix
fread(&head.id,4,1,fp);
if ( head.id != ILBM ) {
   printf("not an ILBM file\n");
   exit(1);
}

while ( ftell(fp) < 8+head.length ) {
  process_chunk( fp, rimg );
} // end while


fclose(fp);
return ; }




void read_ANNO ( FILE *fp, raw_img *rimg ) {
dword length;
byte string[256];

  fread(&length,4,1,fp);
  byte_swap(&length,4);
  fread(string,1,length,fp);
  string[length] = 0;
 // printf("%s\n",string);
return ; }


BMHD_header head; // needs to be global ( to check compression type )
void read_BMHD ( FILE *fp, raw_img *rimg ) {

 fread(&head,sizeof(BMHD_header),1,fp);
 byte_swap(&head.size,4);
 byte_swap(&head.width,2);
 byte_swap(&head.height,2);

 if ( head.depth != 8 ) {
     printf("lbm is not an 8 bit image\n");
     exit(1);
 }

 rimg->width = head.width;
 rimg->height = head.height;
 if ( (rimg->width%16) || (rimg->height%16) ) {
    printf("lbm's dimensions are not multiples of 16\n");
    exit(1);
 } // end if

 rimg->data = ( byte * ) malloc ( rimg->width*rimg->height );
 if ( !rimg->data ) {
    printf("unable to allocate raw image data\n");
    exit(1);
 }
return ; }



void read_CMAP ( FILE *fp, raw_img *rimg ) {
dword length;
fread(&length,4,1,fp);
byte_swap(&length,4);

rimg->palette = ( byte * ) malloc ( 768 );
if ( !rimg->palette ) {
   printf("unable to allocate palette memory\n");
   exit(1);
}
fread(rimg->palette,1,768,fp);
 // done
return ; }




void read_BODY ( FILE *fp, raw_img *rimg ) {
byte *plane_data;
dword length;

dword inbyte;
word inbit;
word x,y,p;
byte temp;  // compression codes
byte b; // just for simplified calculations

 plane_data = ( byte * ) malloc ( rimg->width );
 if ( !plane_data ) {
    printf("could not allocate plane data buffer\n");
    exit(1);
 }

 fread(&length,4,1,fp);
 byte_swap(&length,4);
  
 if ( head.compressed ) {
   y = 0;
   while ( y < rimg->height ) {
    p=0;
    
    while ( p < 8 ) {
     x=0;
     
     while ( x < (rimg->width>>3) ) {
      fread(&temp,1,1,fp);


         // don't worry about padding here, since everything should
         // be a multiple of 16

      if ( !(temp & 0x80) ) {   //literal data
       fread(&plane_data[p*(rimg->width>>3)+x],1,temp+1,fp);
       x+= temp+1;
       continue; 
      } // end if

      if ( temp == 0x80 ) {  // no op
       continue; 
      } // end if

      if ( temp > 0x80 ) {   // repeat bytes
       byte data;

       fread(&data,1,1,fp);  // byte to repeat
       memset(&plane_data[p*(rimg->width>>3)+x],data,(257-temp));
       x+=(257-temp);
       continue; // not really necessary
      } // end if

     } // end x
    p++;
    } // end p

   // decode this y line
   
   for ( x=0; x<rimg->width; x++ ) {
    inbyte = x / 8;
    inbit  = x % 8;
    inbit  = 7 - inbit; // convert from left-to-right to right-from-left

    rimg->data[y*(rimg->width)+x] = 0; //clear
    for ( p=0; p<8; p++ ) {

    b = plane_data[p*(rimg->width>>3)+inbyte];
    b &= ( 1 << inbit );
    b >>= inbit;          // move into bit 0
    b <<= p;              // move into proper position for byte
    rimg->data[y*(rimg->width)+x] |= b; // set bit in color
    
    } // end p
   } // end x
   
   y++;
   } // end y
 } // end if


 else {  // decompressed
 for ( y = 0; y < rimg->height; y++ ) {
  fread(plane_data,1,rimg->width,fp); // read all planes for scanline
   for ( x=0; x<rimg->width; x++ ) {   // decode plane data
    inbyte = x / 8;
    inbit  = x % 8;
    inbit  = 7 - inbit; // convert from left-to-right to right-from-left

    rimg->data[y*(rimg->width)+x] = 0; //clear
    for ( p=0; p<8; p++ ) {

    b = plane_data[p*(rimg->width>>3)+inbyte];
    b &= ( 1 << inbit );
    b >>= inbit;          // move into bit 0
    b <<= p;              // move into proper position for byte
    rimg->data[y*(rimg->width)+x] |= b; // set bit in color
    
    } // end p
   } // end x
 } // end y

 } // end uncompressed decode

free(plane_data);
return ; }








