#include "gfxlib.h"
#include <sys/nearptr.h>

#include "bmp.h"
#include "pcx.h"

int __djgpp_nearptr_enable(void);

void disp_raw ( raw_img *rimg ) {
word pause;
word pcount;
word x,y;
union REGS inregs,outregs;
byte *video;

if ( __djgpp_nearptr_enable() ) {

video = (byte *) __djgpp_conventional_base + 0xA0000;

inregs.x.ax = 0x13;
int86(0x10,&inregs,&outregs);

// set palette
outportb( 0x3c8, 0 ); // start at color 0
for ( pcount=0; pcount<768; pcount++ ) {
 for(pause=0;pause<50;pause++) ;
 outportb( 0x3c9, ( rimg->palette[pcount] >> 2 ) );
} // end pcount

for ( y=0; y<rimg->height; y++ ) {
 for ( x=0; x<rimg->width; x++ ) {
  video [ y*320 + x ] = rimg->data[ y*rimg->width + x ];
 }
}

inregs.h.ah = 0x8;
int86(0x21,&inregs,&outregs); // pause

inregs.x.ax = 0x03;
int86(0x10,&inregs,&outregs);

__djgpp_nearptr_disable();
}
return; }



word power ( word x, word y ) {
word c0;
word result;

result = 1;
for ( c0=0; c0<y; c0++ ) {
 result *= x;
} // end for
return result; }


void make_mip ( mip_texture *miptxt ) {
word map;
word scale;
word x,y;

miptxt->img[1].width = miptxt->img[0].width / 2;
miptxt->img[1].height = miptxt->img[0].height / 2;
miptxt->img[2].width = miptxt->img[0].width / 4;
miptxt->img[2].height = miptxt->img[0].height / 4;
miptxt->img[3].width = miptxt->img[0].width / 8;
miptxt->img[3].height = miptxt->img[0].height / 8;

// allocate image mem
miptxt->img[1].data =
   ( byte * ) malloc ( miptxt->img[1].width * miptxt->img[1].height );
miptxt->img[2].data =
   ( byte * ) malloc ( miptxt->img[2].width * miptxt->img[2].height );
miptxt->img[3].data =
   ( byte * ) malloc ( miptxt->img[3].width * miptxt->img[3].height );
if ( !miptxt->img[1].data ||
     !miptxt->img[2].data ||
     !miptxt->img[3].data ) {
     printf("unable to fully allocate mip texture mem\n");
     exit(1);
}

// copy palette ptr ( will all be freed at same time, so it doesn't matter)
miptxt->img[1].palette =
miptxt->img[2].palette =
miptxt->img[3].palette =
 miptxt->img[0].palette;

for ( map=1; map<=3; map++ ) {
 scale = power ( 2, map );
 printf("mipping with scale 1/%u\n",scale);
 for ( y=0; y<miptxt->img[map].height; y++ ) {
  for ( x=0; x<miptxt->img[map].width; x++ ) {

  miptxt->img[map].data[ y*(miptxt->img[map].width)+x] =
    miptxt->img[0].data
    [ ( y*scale*(miptxt->img[0].width) ) + (x*scale) ];

  } // end x
 } // end y
} // end map

return; }



