#include "bmp.h"

// ###
void read_bmp ( byte *filename, raw_img *rimg ) {
dword x,y;
byte temp;
word index;
FILE *fp;
bmp_header head;

fp = fopen ( filename, "rb" );
if ( !fp ) {
   printf("unable to open file \"%s\"\n",filename);
   exit(1);
}
fread(&head.id,sizeof(bmp_header)-2,1,fp);
//printf("header id: %c%c\n",(((byte *)&head.id))[0],(((byte *)&head.id))[1]);
//printf("file length: %lu\n",head.length);
//printf("image start: %lu\n",head.image_start);
//printf("header size: %lu\n",head.header_size);
//printf("width: %lu\n",head.width);
//printf("height: %lu\n",head.height);
//printf("planes: %u\n",head.planes);
//printf("bits/pixel: %u\n",head.bits_pixel);
//printf("compression type: %lu\n",head.compression);
//printf("compressed size: %lu\n",head.compressed_size);
//printf("horiz res: %lu\n",head.horiz_res);
//printf("vert res: %lu\n",head.vert_res);
//printf("colors used: %lu\n",head.colors_used);
//printf("colors needed: %lu\n",head.colors_important);
if ( head.id != (word)(('M'<<8)+('B')) ) {
   printf("%s is not a bmp file\n",filename);
   exit(1);
}
if ( head.width%16 || head.height%16 ) {
   printf("%s's dimensions are not multiples of 16\n",filename);
   exit(1);
}

// assign dimensions
  rimg->width = head.width;
  rimg->height = head.height;

if ( head.bits_pixel != 8 ) {
   printf("%s is not 8bit ( 256 colors )\n",filename);
   exit(1);
}
rimg->palette = ( byte * ) malloc ( 1024 );
if ( !rimg->palette ) {
   printf("could not allocate palette memory for bmp\n");
   exit(1);
}
fread(rimg->palette,1,1024,fp);
for ( index=0; index< 256; index++ ) {
 temp = rimg->palette[(index*4)  ]; // get blue to prevent overwrite on index=0
 rimg->palette[(index*3)  ] = rimg->palette[(index*4)+2]; // red
 rimg->palette[(index*3)+1] = rimg->palette[(index*4)+1]; // green
 rimg->palette[(index*3)+2] = temp; // blue
} // end index

// now read image

rimg->data = ( byte * ) malloc ( rimg->width*rimg->height );
if ( !rimg->data ) {
   printf("could not allocate memory for bmp data\n");
   exit(1);
}

if ( head.compression ) {
  y = (rimg->height-1);
  x = 0;
  while ( y != 0xFFFFFFFF ) {
    fread(&temp,1,1,fp);

    if ( temp ) {   // repeating group
      byte count;
      byte color;
      fread(&color,1,1,fp);
      for ( count=0; count<temp; count++ ) {
       rimg->data[(y*rimg->width)+x+count] = color;
      } // end for
      x += temp;
      continue; // read next
    } // end if

    if ( !temp ) {      //literal group or special sequence
      byte limit;
      fread(&limit,1,1,fp); // read number in literal or special code


      if ( limit > 2 ) {        // is a literal group
       fread(&rimg->data[(y*rimg->width)+x],1,limit,fp);
       x+=limit;
       if ( limit%2 )  // all literals must contain even amount of bytes
          fread(&limit,1,1,fp); // read in extra byte
       continue; // next read
      } // end if

      else if ( limit == 0 ) {  // end of row
        x = 0; // reset x
        y--; // next line up
        continue;
      }
      else if ( limit == 01 ) { // end of bitmap
        printf("end of bitmap found, x:%lu y:%lu\n",x,y);
        break;
      }
    } // end if


  } // end while
} // end if
else { // no compression
  // all widths are multiples of 16, so there is no need to check for pad
  // bytes... just one big fread! ( from bottom up, of course )
  for ( y = rimg->height-1 ; y != 0xFFFFFFFF; y-- )
    fread(&rimg->data[y*rimg->width],1,rimg->width,fp);
} // end else
fclose(fp);

return; }
