/*

UTILITY.H

Utility functions and classes for Mipindex

by Ed Kiser (edkiser@jaxnet.com) Copyright (c) 1996

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

History:
Version 1.1
Tue Sept 30 1996 :
 * Created by moving a bunch of stuff out of mipindex.cpp

*/

#ifndef __UTILITY_H
#define __UTILITY_H
#else
#error Multiple includes of UTILITY.H not allowed
#endif

#ifndef _FSTREAM_H
#include <fstream.h>
#endif
#ifndef __dj_include_string_h_
#include <string.h>
#endif
#ifndef __dj_include_unistd_h_
#include <unistd.h>
#endif
#ifndef __dj_include_dir_h_
#include <dir.h>
#endif
#ifndef assert
#include <assert.h>
#endif

#ifndef NDEBUG
#define washere(x) cout << "Was here: " << x << "\n";
#else
#define washere(x)
#endif

void get_full_name(const char * src, char * dest);

bool has_extension(const char * name, const char * ext);

bool ends_with(const char * string, const char * end);

void zero_fill(char * string, int len);

/***** No more bad English! (Or Latin!) *****/

// syntax: cout << howmany("Found % local maxim[um](a).\n",num);

class howmany
{ public:
  howmany(const char * formatstring, int val);
  friend ostream & operator<<(ostream &, howmany const &);
  private:
  const char * fs;
  int i;
};

inline howmany::howmany(const char * formatstring, int val): i(val)
{ fs=formatstring;
};

ostream & operator<< (ostream & o, howmany const & l);
