/*

UTILITY.CPP

Utility functions and classes for Mipindex

by Ed Kiser (edkiser@jaxnet.com) Copyright (c) 1996

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

History:
Version 1.1
Tue Sept 30 1996 :
 * Created by moving a bunch of stuff out of mipindex.cpp

*/

#ifndef __UTILITY_H
#include "utility.h"
#endif

void get_full_name(const char * src, char * dest)
/* requires a trailing slash '/' on directories, e.g. "../" */
{ char buf[260];
  getcwd(buf,260);
  char srcdrive[MAXDRIVE], srcdir[MAXDIR], srcfile[MAXFILE], srcext[MAXEXT];
  fnsplit(src,srcdrive,srcdir,srcfile,srcext);
  char buf2[260];
  fnmerge(buf2,srcdrive,0,0,0);
  chdir(buf2);
  char buf3[260];
  getcwd(buf3,260);
  fnmerge(buf2,srcdrive,srcdir,0,0);
  chdir(buf2);
  getcwd(buf2,260);
  strcat(buf2,"/");
  chdir(buf3);
  chdir(buf);
  fnsplit(buf2,srcdrive,srcdir,0,0);
  fnmerge(buf2,srcdrive,srcdir,srcfile,srcext);
  strcpy(dest,buf2);
};

bool has_extension(const char * name, const char * ext)
{ assert(ext[0]=='.');
  char * period = strchr(name,'.');
  if (period==0) period=".";
  return stricmp(period,ext)==0;
};

bool ends_with(const char * string, const char * end)
{ const char * z=string+strlen(string)-strlen(end);
  if (z<string) return false;;
  return stricmp(z,end)==0;
};

void zero_fill(char * string, int len)
{ bool foundnull=false;
  for (char * p=string; p<string+len; p++)
  { if (foundnull) *p=0;
    else foundnull=(*p==0);
  }
};

ostream & operator<< (ostream & o, howmany const & l)
{ const char * p = l.fs;
  bool printing=true;
  while (*p != 0)
  { switch(*p)
    { case '%': o << l.i; break;
      case '(': printing=(l.i!=1); break;
      case '[': printing=(l.i==1); break;
      case ']': /* fall through */
      case ')': printing=true; break;
      default: if (printing) o << *p; break;
    }
    ++p;
  }
};
