/*

QSTRUCTS.CPP

Quake data structures

by Ed Kiser (edkiser@jaxnet.com) Copyright (c) 1996

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __QSTRUCTS_H
#include "qstructs.h"
#endif

/***** miptex *****/

miptex_id miptex_id::palette_id = {"palette\0\0\0\0\0\0\0\0\0",256,3};
miptex_id miptex_id::bad_id = {"bad in old BSP\0\0",0,0};

miptex::miptex(): _is_valid(false), _is_palette(false) {};

miptex::miptex(istream & i, bool is_palette=false)
{ _is_palette=is_palette;
  int offset=i.tellg();
  if (is_palette)
  { identity=miptex_id::palette_id;
    totalsize=768;
    buffer=new char[768];
    i.read(buffer,768);
    _is_valid=!i.fail();
  } else
  { read_image(identity,i);
    if (identity.is_valid() && !i.fail())
    { identity.clean();
      long ofs[4], iofs[5];
      i.read((char*)ofs,sizeof(long)*4);
      iofs[0]=0;
      for (int img=0; img<4; img++)
      { long size=(imagesize(img)+15)&(~0xfl);
        iofs[img+1]=iofs[img]+size;
      }
      totalsize=iofs[4];
      buffer = new char[totalsize];
      memset(buffer,0,totalsize);
      for (int img=0; img<4; img++)
      { i.seekg(offset+ofs[img]);
        if (i.fail()) throw "Bad offset in miptexture!";
        i.read(buffer+iofs[img],imagesize(img));
      }
      _is_valid=!i.fail();
    } else
    { _is_valid=false;
    }
  }
};

bool miptex::write_bytes(ostream & o) const
{ if (!_is_valid) return false;
  if (!_is_palette)
  { long offset=o.tellp();
    write_image(identity,o);
    long iofs[5];
    iofs[0]=(o.tellp()-offset)+sizeof(long)*4;
    for (int img=0; img<4; img++)
    { long size=(imagesize(img)+15)&(~0xfl);
      iofs[img+1]=iofs[img]+size;
    }
    o.write((char*)&iofs,sizeof(long)*4);
  }
  o.write(buffer,totalsize);
  return !(o.fail());
};

void miptex::becopy(miptex const & o)
{ _is_valid=o._is_valid;
  _is_palette=o._is_palette;
  if (_is_valid)
  { identity=o.identity;
    totalsize=o.totalsize;
    buffer=new char[totalsize];
    memcpy(buffer,o.buffer,totalsize);
  }
};

void miptex::drop()
{ if (_is_valid)
  { delete[] buffer;
    _is_valid=false;
  }
};

const char * bsp_header::entry_name[15]=
 { "entities", "planes", "miptextures", "vertices", "visilists", "nodes",
   "miptexinfo", "faces", "lightmaps", "clipnodes", "leaves", "facelists",
   "edges", "edgelists", "models" };
