/*

MINDEX.H

Mip indexing functions and classes for Mipindex

by Ed Kiser (edkiser@jaxnet.com) Copyright (c) 1996

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

History:
Version 1.1
Tue Sept 30 1996:
 * Created by moving a bunch of stuff out of mipindex.cpp

Thu Oct 10 1996:
 * Decided to move history of all files to mipindex.cpp.

*/

#ifndef __MINDEX_H
#define __MINDEX_H
#else
#error Multiple includes of MINDEX.H not allowed
#endif

#ifndef _FSTREAM_H
#include <fstream.h>
#endif
#ifndef __STRSTREAM_H
#include <strstrea.h>
#endif
#ifndef __UTILITY_H
#include "utility.h"
#endif
#ifndef __QSTRUCTS_H
#include "qstructs.h"
#endif
#ifndef assert
#include <assert.h>
#endif
#ifndef __MAP__
#include <map>
#endif
#ifndef __VECTOR__
#include <vector>
#endif
#ifndef __ALGORITHM__
#include <algorith>
#endif

/***** Miptex visitor *****/

// typical purpose of derived class: add miptex to a WAD2 file

class miptex_visitor
{ public:
  virtual ~miptex_visitor() {};
  virtual void operator()(miptex m) = 0;
};

/***** The filelist *****/

class filelist
{ public:
  filelist();
  ~filelist() { drop(); };
  filelist(filelist const & a) { becopy(a); };
  filelist const & operator=(filelist const & a) { drop(); becopy(a); };
  const char * operator[](int i) const;
  bool add(char * name, int & index_out); // returns true for new files
  int count() const;
  void scratch();    // drop last added name
  void scratch(int); // drop a name, move others down
  private:
  void drop();
  void becopy(filelist const &);
  typedef char * string;
  string * fullpath;
  int files, storage;
  static const int increment;
};

//extern const int filelist::increment;

inline const char * filelist::operator[](int i) const
{ assert(i>=0 && i<files);
  return fullpath[i];
};

inline void filelist::scratch()
{ assert(files>0);
  files--;
  delete[] fullpath[files];
};

inline void filelist::scratch(int i)
{ assert(files>0);
  assert(i<files);
  assert(i>=0);
  delete[] fullpath[i];
  files--;
  for (int q=i; q<files; q++) fullpath[q]=fullpath[q+1];
};

inline int filelist::count() const
{ return files;
};

/***** The location *****/

struct location
{ location(): file(0), offset(0) {};
  location(int a, long b): file(a), offset(b) {};
  bool operator==(location const & a) const;
  bool operator<(location const & a) const;
  int file;
  long offset;
};

inline bool location::operator==(location const & a) const
{ return file==a.file && offset==a.offset;
};

inline bool location::operator<(location const & a) const
{ if (file!=a.file) return file<a.file;
  return offset<a.offset;
};

/***** The miptex_index *****/

class miptex_index
{ public:
  typedef map<miptex_id,location,less<miptex_id> > texlist;

  miptex_index(): holder() {mv = 0;};
  ~miptex_index() { delete mv; };

  miptex_visitor * get_visitor();
  miptex_visitor * set_visitor(miptex_visitor * a);

  void read_file(char * name, ostream & comment);

  void write_text(ostream & out);
  void write_idx(ostream & out, ostream & cout);

  texlist const & miptex_map() const {return holder;};

  bool has(miptex_id const &) const;
  bool get(miptex_id const & n, miptex & out) const;

  private:
  void read_bsp(istream &, int file, ostream & cout);
  void read_pak(istream &, int file, ostream & cout);
  void read_wad2(istream &, int file, ostream & cout);
  void read_idx(istream &, ostream & cout);

  void zap_unused_files();
  texlist holder;
  filelist flist;
  miptex_visitor * mv;
};

inline miptex_visitor * miptex_index::get_visitor()
{ return mv;
};

inline miptex_visitor * miptex_index::set_visitor(miptex_visitor * a)
{ miptex_visitor * p=mv;
  mv=a;
  return p;
};

/***** WAD2 writer *****/

class wad2_writer: public miptex_visitor
{ public:
  wad2_writer(char * name);
  ~wad2_writer();
  virtual void operator()(miptex m);
  private:
  ostrstream * dirstream;
  char * dirbuffer;
  ofstream * data;
  char * filebuffer;
  static const int dirbuffersize, filebuffersize;
//  wad2_header head;
  bool is_written;
  void data_setup();
};

//extern const int wad2_writer::dirbuffersize;
//extern const int wad2_writer::filebuffersize;
