;

;points are float x, float y, float z, dword filler

;

;fiddle around with the parms, can't think off the top of my head what they 
;look like.  You can look these up in 3d graphucs books (graphics gems too)

struc   super_ellipsoid_parms
a1      dd ?                    ;roundness
a2      dd ?                    ;roundness
a3      dd ?                    ;roundness
north   dd ?                    ;scale
east    dd ?                    ;scale
ends

struc   super_toroid_parms
a1      dd ?
a2      dd ?
a3      dd ?
north   dd ?
east    dd ?
alpha   dd ?                    ;hole size
ends

;
;In:
;       ebx: u number of points
;       ecx: v number of points
;       esi: ptr to super_ellisoid_parms
;       edi: ptr to dest. points

align 32
proc    super_ellipsoid n

        fldz
        fst     [se_u]
        fstp    [se_v]

        dec     ebx
        js      @@done
        jz      @@done

        dec     ecx
        js      @@done
        jz      @@done

        mov     [@@temp], ebx
        fld1
        fild    [@@temp]
        fdiv
        fstp    [@@u_add]

        mov     [@@temp], ecx
        fld1
        fild    [@@temp]
        fdiv
        fstp    [@@v_add]
        push    ebx

@@do_pt:
        push    ebx ecx
        call    super_ellipsoid_pt
        pop     ecx ebx

        fld     [se_u]
        fadd    [@@u_add]
        fstp    [se_u]
        
        add     edi, 16
        dec     ebx
        jns     @@do_pt

        pop     ebx
        push    ebx

        fldz
        fstp    [se_u]

        fld     [se_v]
        fadd    [@@v_add]
        fstp    [se_v]

        dec     ecx
        jns     @@do_pt

        pop     ebx

@@done:
        ret

align 8
@@u_add         dq ?
@@v_add         dq ?
@@temp          dd ?

endp

align 8
se_u            dq ?
se_v            dq ?

;
;In:
;       esi: ptr to super_ellisoid_parms
;       edi: prt to dest. point
;       se_u, se_v

align 32
proc    super_ellipsoid_pt n

        fld     [se_u]
        fmul    [@@u_scale]
        fld     [se_v]
        fmul    [@@v_scale]
        fxch    st(1)
        fstp    [@@u_ang]
        fstp    [@@v_ang]

        sub     [@@u_ang], 32768
        sub     [@@v_ang], 16384

        mov     eax, [@@v_ang]
        lea     ebx, [esi + super_ellipsoid_parms.north]
        call    cos_pow
        mov     eax, [pow]
        mov     [@@temp], eax

        mov     eax, [@@u_ang]
        lea     ebx, [esi + super_ellipsoid_parms.east]
        call    cos_pow
        fld     [@@temp]
        fmul    [pow]
        fmul    [esi + super_ellipsoid_parms.a1]
        fstp    [d edi]

        mov     eax, [@@v_ang]
        lea     ebx, [esi + super_ellipsoid_parms.north]
        call    cos_pow
        mov     eax, [pow]
        mov     [@@temp], eax

        mov     eax, [@@u_ang]
        lea     ebx, [esi + super_ellipsoid_parms.east]
        call    sin_pow
        fld     [@@temp]
        fmul    [pow]
        fmul    [esi + super_ellipsoid_parms.a2]
        fstp    [d edi + 4]

        mov     eax, [@@v_ang]
        lea     ebx, [esi + super_ellipsoid_parms.north]
        call    sin_pow
        fld     [pow]
        fmul    [esi + super_ellipsoid_parms.a3]
        fstp    [d edi + 8]

        ret

align 4
@@u_ang         dd ?
@@v_ang         dd ?
@@u_scale       dd 65536.0
@@v_scale       dd 32768.0
@@temp          dd ?

endp

;
;In:
;       ebx: u points
;       ecx: v points
;       esi: super_toroid_parms
;       edi: dest. points

align 32
proc    super_toroid n

        fldz
        fst     [st_u]
        fstp    [st_v]

        dec     ebx
        js      @@done
        jz      @@done

        dec     ecx
        js      @@done
        jz      @@done

        mov     [@@temp], ebx
        fld1
        fild    [@@temp]
        fdiv
        fstp    [@@u_add]

        mov     [@@temp], ecx
        fld1
        fild    [@@temp]
        fdiv
        fstp    [@@v_add]
        push    ebx

@@do_pt:
        push    ebx ecx
        call    super_toroid_pt
        pop     ecx ebx
        
        fld     [st_u]
        fadd    [@@u_add]
        fstp    [st_u]
        
        add     edi, 16
        dec     ebx
        jns     @@do_pt

        pop     ebx
        push    ebx

        fldz
        fstp    [st_u]

        fld     [st_v]
        fadd    [@@v_add]
        fstp    [st_v]

        dec     ecx
        jns     @@do_pt

        pop     ebx

@@done:
        ret

align 8
@@u_add         dq ?
@@v_add         dq ?
@@temp          dd ?

endp

align 8
st_u            dq ?
st_v            dq ?

;
;In:
;       esi: super_toroid_parms
;       edi: dest. point
;       st_u, st_v

align 32
proc    super_toroid_pt n

        fld     [st_u]
        fmul    [@@scale]
        fld     [st_v]
        fmul    [@@scale]
        fxch    st(1)
        fstp    [@@u_ang]
        fstp    [@@v_ang]

        sub     [@@u_ang], 32768
        sub     [@@v_ang], 32768

        mov     eax, [@@v_ang]
        lea     ebx, [esi + super_toroid_parms.north]
        call    cos_pow
        mov     eax, [pow]
        mov     [@@temp], eax

        mov     eax, [@@u_ang]
        lea     ebx, [esi + super_toroid_parms.east]
        call    cos_pow
        fld     [@@temp]
        fadd    [esi + super_toroid_parms.alpha]
        fmul    [pow]
        fmul    [esi + super_toroid_parms.a1]
        fstp    [d edi]

        mov     eax, [@@v_ang]
        lea     ebx, [esi + super_toroid_parms.north]
        call    cos_pow
        mov     eax, [pow]
        mov     [@@temp], eax

        mov     eax, [@@u_ang]
        lea     ebx, [esi + super_toroid_parms.east]
        call    sin_pow
        fld     [@@temp]
        fadd    [esi + super_toroid_parms.alpha]
        fmul    [pow]
        fmul    [esi + super_toroid_parms.a2]
        fstp    [d edi + 4]

        mov     eax, [@@v_ang]
        lea     ebx, [esi + super_toroid_parms.north]
        call    sin_pow
        fld     [pow]
        fmul    [esi + super_toroid_parms.a3]
        fstp    [d edi + 8]

        ret

align 4
@@u_ang         dd ?
@@v_ang         dd ?
@@scale         dd 65536.0
@@temp          dd ?

endp

;
;In:
;       eax: angle
;       ebx: power
;Out:
;       pow: cos(angle)^power

align 32
proc    cos_pow n

        fstcw   [@@cw]
        and     [@@cw], not 110000000000b
        or      [@@cw], 110000000000b
        fldcw   [@@cw]

        call    f_cos
        mov     [@@f], eax
        and     eax, 80000000h

        fld     [d ebx]
        fld     [@@f]
        fabs
        fyl2x

        fst     [@@temp]
        frndint
        fstp    [@@itemp]

        fld     [@@temp]
        fsub    [@@itemp]
        fdiv    [@@two]

        f2xm1
        fld1
        fadd
        fld     st
        fmul
        fstp    [pow]

        fld     [@@itemp]
        fld1
        fscale
        fmul    [pow]
        fstp    [pow]
        fstp    [@@temp]

        or      [pow], eax

        and     [@@cw], not 110000000000b
        fldcw   [@@cw]
        ret

align 4
@@f     dd ?
@@temp  dd ?
@@itemp dd ?
@@two   dd 2.0
@@cw    dw ?

endp

align 4
pow     dd ?

;
;In:
;       eax: angle
;       ebx: power
;Out:
;       pow: sin(angle)^power

align 32
proc    sin_pow n

        fstcw   [@@cw]
        and     [@@cw], not 110000000000b
        or      [@@cw], 110000000000b
        fldcw   [@@cw]

        call    f_sin
        mov     [@@f], eax
        and     eax, 80000000h

        fld     [d ebx]
        fld     [@@f]
        fabs
        fyl2x

        fst     [@@temp]
        frndint
        fstp    [@@itemp]

        fld     [@@temp]
        fsub    [@@itemp]
        fdiv    [@@two]

        f2xm1
        fld1
        fadd
        fld     st
        fmul
        fstp    [pow]

        fld     [@@itemp]
        fld1
        fscale
        fmul    [pow]
        fstp    [pow]
        fstp    [@@temp]

        or      [pow], eax

        and     [@@cw], not 110000000000b
        fldcw   [@@cw]
        ret

align 4
@@f     dd ?
@@temp  dd ?
@@itemp dd ?
@@two   dd 2.0
@@cw    dw ?

endp

;
