/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;

public final class MDLquakeModel
extends MDLModel {
    private int currentSkin;
    private int currentSkinGroup;
    private int currentFrame;
    private int currentSimpleFrame;
    private int totalFrames;
    private int totalSkins;
    private String framesString;
    private String skinsString;
    int shiftY;
    private String filetype;
    private int version;
    private float xscale;
    private float yscale;
    private float zscale;
    private float xoffset;
    private float yoffset;
    private float zoffset;
    private float radius;
    private float eyex;
    private float eyey;
    private float eyez;
    private int num_skins;
    private int skinw;
    private int skinwOver2;
    private int skinh;
    private int num_vertices;
    private int num_triangles;
    private int num_frames;
    private int sync_type;
    private int flags;
    private float ave_size;
    private int k;
    private int j;
    private MDLSkinGroup[] skins;
    private MDLSkinVertex[] sVerts;
    private MDLTriangle[] triangles;
    private MDLFrame[] frames;

    public short getTriangleVertexIndex(int n, int n2) {
        return this.triangles[n].verts[n2];
    }

    public short getSkinVertexT(int n, int n2) {
        return this.sVerts[n2].t;
    }

    public short getSkinVertexS(int n, int n2) {
        if (!this.triangles[n].facesFront && this.sVerts[n2].onseam) {
            return (short)(this.sVerts[n2].s + this.skinwOver2);
        }
        return this.sVerts[n2].s;
    }

    public void setCurrentSkinIndex(int n) {
        this.currentSkinGroup = n;
    }

    public int getCurrentSkinIndex() {
        return this.currentSkinGroup;
    }

    public int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public void setCurrentFrameIndex(int n) {
        this.currentFrame = n;
    }

    public int getNumberOfAnimationFrames(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            n3 += this.frames[n4].num_SimpleFrames;
            ++n4;
        }
        return n3;
    }

    public int getFrameDelayMillis() {
        if (this.frames[this.currentFrame].isGroup) {
            if (this.currentSimpleFrame == 0) {
                return (int)(1000.0f * this.frames[this.currentFrame].time[0]);
            }
            return (int)(1000.0f * (this.frames[this.currentFrame].time[this.currentSimpleFrame] - this.frames[this.currentFrame].time[this.currentSimpleFrame - 1]));
        }
        return 100;
    }

    public void nextSkin() {
        ++this.currentSkin;
        if (this.currentSkin >= this.skins[this.currentSkinGroup].numPics) {
            ++this.currentSkinGroup;
            this.currentSkin = 0;
            if (this.currentSkinGroup >= this.num_skins) {
                this.currentSkinGroup = 0;
            }
        }
    }

    public void lastSkin() {
        --this.currentSkin;
        if (this.currentSkin < 0) {
            --this.currentSkinGroup;
            if (this.currentSkinGroup < 0) {
                this.currentSkinGroup = (short)(this.num_skins - 1);
            }
            this.currentSkin = (short)(this.skins[this.currentSkinGroup].numPics - 1);
        }
    }

    public void lastFrame() {
        --this.currentSimpleFrame;
        if (this.currentSimpleFrame < 0) {
            --this.currentFrame;
            if (this.currentFrame < 0) {
                this.currentFrame = (short)(this.num_frames - 1);
            }
            this.currentSimpleFrame = (short)(this.frames[this.currentFrame].num_SimpleFrames - 1);
        }
    }

    public void nextFrame() {
        ++this.currentSimpleFrame;
        if (this.currentSimpleFrame >= this.frames[this.currentFrame].num_SimpleFrames) {
            ++this.currentFrame;
            this.currentSimpleFrame = 0;
            if (this.currentFrame >= this.num_frames) {
                this.currentFrame = 0;
            }
        }
    }

    public byte getTexel(short s, short s2) {
        return this.skins[this.currentSkinGroup].pixelData[this.currentSkin][s][s2];
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public int getTotalSkins() {
        return this.totalSkins;
    }

    public int getYShift() {
        return this.shiftY;
    }

    public String getFramesInfo() {
        return this.framesString;
    }

    public String getFrameName() {
        return this.frames[this.currentFrame].simple_Frames[this.currentSimpleFrame].name;
    }

    public String getSkinsInfo() {
        return this.skinsString;
    }

    public int getVertsInfo() {
        return this.num_vertices;
    }

    public int getTrianglesInfo() {
        return this.num_triangles;
    }

    public String getFileHeaderString() {
        return this.filetype;
    }

    public int getFileVersion() {
        return this.version;
    }

    public float getBoundingRadius() {
        return this.radius;
    }

    public int getNumberOfSkins() {
        return this.num_skins;
    }

    public int getSkinWidth() {
        return this.skinw;
    }

    public int getSkinHeight() {
        return this.skinh;
    }

    public float getVertexX(int n) {
        return this.frames[this.currentFrame].simple_Frames[this.currentSimpleFrame].frameVerts[n].X;
    }

    public float getVertexY(int n) {
        return this.frames[this.currentFrame].simple_Frames[this.currentSimpleFrame].frameVerts[n].Y;
    }

    public float getVertexZ(int n) {
        return this.frames[this.currentFrame].simple_Frames[this.currentSimpleFrame].frameVerts[n].Z;
    }

    public boolean getClockwiseCull() {
        return true;
    }

    public int getNumberOfVertices() {
        return this.num_vertices;
    }

    public int getNumberOfTriangles() {
        return this.num_triangles;
    }

    public int getNumberOfFrames() {
        return this.num_frames;
    }

    public int getSyncType() {
        return this.sync_type;
    }

    public int getModelFlags() {
        return this.flags;
    }

    public String getModelFormat() {
        return "quake";
    }

    public String getAuthorInfo() {
        return "Copyright T.J.Grey 1998";
    }

    public String getAuthorName() {
        return "Tom Grey";
    }

    private void skip(int n, InputStream inputStream) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            inputStream.read();
            ++n2;
            this.yield();
        }
    }

    protected void loadFrameVertex(InputStream inputStream, MDLFrameVertex mDLFrameVertex) throws IOException {
        mDLFrameVertex.X = this.xscale * (float)inputStream.read();
        mDLFrameVertex.Y = this.yscale * (float)inputStream.read();
        mDLFrameVertex.Z = this.zscale * (float)inputStream.read();
        mDLFrameVertex.X += this.xoffset;
        mDLFrameVertex.Y += this.yoffset;
        mDLFrameVertex.Z += this.zoffset;
        mDLFrameVertex.Z += (float)this.shiftY;
        mDLFrameVertex.lightNormalIndex = (byte)inputStream.read();
    }

    protected void readModelThread(URL uRL, int[] nArray, int[] nArray2, int n) {
        this.shiftY = n;
        this.showStatus("Quake model class for MDLView by T.J.Grey");
        this.debug("Quake model class for MDLView by T.J.Grey");
        String string = uRL.getFile();
        try {
            if (string.endsWith(".zip")) {
                this.debug("MDLView: Attempting opening of zip file!");
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
                zipInputStream.getNextEntry();
                this.modelMethod(zipInputStream, nArray2, nArray);
                this.showStatus("MDLView: Reading model... done");
                this.debug("MDLView: Closing data stream");
                zipInputStream.closeEntry();
                zipInputStream.close();
                this.showStatus("MDLView: Closing data stream");
                zipInputStream = null;
                return;
            }
            this.debug("MDLView: Attempting opening of mdl file");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            this.modelMethod(bufferedInputStream, nArray2, nArray);
            this.showStatus("MDLView: Reading model... done");
            this.debug("MDLView: Closing data stream");
            ((FilterInputStream)bufferedInputStream).close();
            this.showStatus("MDLView: Closing data stream");
            bufferedInputStream = null;
            return;
        }
        catch (IOException iOException) {
            System.out.println("MDLView: Error opening data Stream for model- <" + iOException + ">");
            this.showStatus("MDLView: Error opening data stream model- <" + iOException + ">");
            this.setModelError(true);
            return;
        }
    }

    private void modelMethod(InputStream inputStream, int[] nArray, int[] nArray2) throws IOException {
        this.readModelHeader(inputStream);
        this.readModelSkins(nArray, inputStream);
        this.readSkinVertices(inputStream);
        this.readModelTriangles(inputStream);
        this.readModelFrames(nArray2, inputStream);
        if (this.version != 6) {
            this.version = 6;
        }
        this.framesString = String.valueOf(this.num_frames) + "/" + this.totalFrames;
        this.skinsString = String.valueOf(this.num_skins) + "/" + this.totalSkins;
    }

    protected void readModelHeader(InputStream inputStream) throws IOException {
        this.showStatus("MDLView: Reading model header");
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[n] = (byte)inputStream.read();
            ++n;
        }
        this.filetype = new String(byArray);
        if (!this.filetype.equals("IDPO")) {
            System.out.println("MDLView: Warning this file may not be a quake model file (non IDPO identifier)");
            this.showStatus("MDLView: Warning may not be quake model file");
        }
        this.version = this.readInt(inputStream);
        this.debug("version= " + this.version);
        this.checkNeg(false, this.version, "Model Version");
        this.xscale = this.readFloat(inputStream);
        this.yscale = this.readFloat(inputStream);
        this.zscale = this.readFloat(inputStream);
        this.debug("XSCALE= " + this.xscale + ", YSCALE= " + this.yscale + ", ZSCALE= " + this.zscale);
        this.xoffset = this.readFloat(inputStream);
        this.yoffset = this.readFloat(inputStream);
        this.zoffset = this.readFloat(inputStream);
        this.debug("XOFFSET= " + this.xoffset + ", YOFFSET= " + this.yoffset + ", ZOFFSET= " + this.zoffset);
        this.radius = this.readFloat(inputStream);
        this.debug("radius= " + this.radius);
        this.checkNeg(false, this.radius, "Model Radius");
        this.eyex = this.readFloat(inputStream);
        this.eyey = this.readFloat(inputStream);
        this.eyez = this.readFloat(inputStream);
        this.debug("EYEX= " + this.eyex + ", EYEY= " + this.eyey + ", EYEZ= " + this.eyez);
        this.num_skins = this.readInt(inputStream);
        if (this.checkNeg(true, this.num_skins, "Number of Skins") || this.checkShort(this.num_skins, "Number of Skins")) {
            return;
        }
        this.totalSkins = this.num_skins;
        this.skinw = this.readInt(inputStream);
        this.skinwOver2 = this.skinw / 2;
        this.skinh = this.readInt(inputStream);
        if (this.skinw % 4 != 0) {
            System.out.println("MDLView: Warning skin width not multiple of four");
        }
        if (this.checkNeg(true, this.skinw, "Skin Width") || this.checkShort(this.skinw, "Skin Width")) {
            return;
        }
        if (this.checkNeg(true, this.skinh, "Skin Height") || this.checkShort(this.skinh, "Skin Height")) {
            return;
        }
        this.debug("skinsh,w= " + this.skinh + ", " + this.skinw);
        this.num_vertices = this.readInt(inputStream);
        if (this.checkNeg(true, this.num_vertices, "Number of Vertices") || this.checkShort(this.num_vertices, "Number of Vertices")) {
            return;
        }
        this.num_triangles = this.readInt(inputStream);
        if (this.checkNeg(true, this.num_triangles, "Number of Triangles") || this.checkShort(this.num_triangles, "Number of Triangles")) {
            return;
        }
        this.totalFrames = this.num_frames = this.readInt(inputStream);
        this.debug("skins: " + this.num_skins + ", verts: " + this.num_vertices + ", tri: " + this.num_triangles + ", frams: " + this.num_frames);
        this.sync_type = this.version == 6 ? this.readInt(inputStream) : 0;
        this.debug("synctype= " + this.sync_type);
        this.flags = this.readInt(inputStream);
        this.debug("flags= " + this.flags);
        this.ave_size = this.version == 6 ? this.readFloat(inputStream) : 0.0f;
        this.debug("ave_size= " + this.ave_size);
    }

    protected void readModelSkins(int[] nArray, InputStream inputStream) throws IOException {
        if (nArray[0] == -2) {
            int n = 0;
            while (n < this.num_skins) {
                this.yield();
                this.showStatus("MDLView: Skipping all skins....");
                this.skipModelSkin(inputStream);
                ++n;
            }
            this.num_skins = 0;
            return;
        }
        this.skins = new MDLSkinGroup[this.num_skins];
        int n = 0;
        this.debug("MDLView: Reading model skins");
        this.skins = nArray[0] != -1 ? new MDLSkinGroup[nArray.length] : new MDLSkinGroup[this.num_skins];
        float f = 100.0f / (float)this.num_skins;
        int n2 = 0;
        while (n2 < this.num_skins) {
            this.yield();
            this.showStatus("MDLView: Reading skins.... (about " + (float)n2 * f + "% done)");
            if (nArray[0] == -1) {
                this.readModelSkin(n, inputStream);
                ++n;
            } else if (n >= nArray.length) {
                this.skipModelSkin(inputStream);
            } else if (nArray[n] == n2) {
                this.readModelSkin(n, inputStream);
                ++n;
            } else {
                this.skipModelSkin(inputStream);
            }
            ++n2;
        }
        this.num_skins = n;
    }

    protected void readModelSkin(int n, InputStream inputStream) throws IOException {
        int n2;
        this.showStatus("MDLView: Reading in skin " + n);
        this.skins[n] = new MDLSkinGroup();
        this.skins[n].isGroup = this.readInt(inputStream) != 0;
        this.skins[n].numPics = !this.skins[n].isGroup ? 1 : this.readInt(inputStream);
        if (this.skins[n].isGroup) {
            this.skins[n].time = new float[this.skins[n].numPics];
            n2 = 0;
            while (n2 < this.skins[n].numPics) {
                this.skins[n].time[n2] = this.readFloat(inputStream);
                ++n2;
            }
        }
        this.skins[n].pixelData = new byte[this.skins[n].numPics][this.skinw][this.skinh];
        n2 = 0;
        while (n2 < this.skins[n].numPics) {
            int n3 = 0;
            while (n3 < this.skinh) {
                int n4 = 0;
                while (n4 < this.skinw) {
                    this.skins[n].pixelData[n2][n4][n3] = (byte)inputStream.read();
                    ++n4;
                }
                this.yield();
                ++n3;
            }
            ++n2;
        }
    }

    protected void skipModelSkin(InputStream inputStream) throws IOException {
        int n = 0;
        this.showStatus("MDLView: Skipping skin +");
        boolean bl = this.readInt(inputStream) != 0;
        n = !bl ? 1 : this.readInt(inputStream);
        if (bl) {
            this.skip(4 * n, inputStream);
        }
        this.skip(n * this.skinh * this.skinw, inputStream);
        this.showStatus("MDLView: Skipping skin x");
    }

    protected void readSkinVertices(InputStream inputStream) throws IOException {
        this.showStatus("MDLView: Reading skin vertices");
        this.sVerts = new MDLSkinVertex[this.num_vertices];
        int n = this.num_vertices / 50;
        int n2 = 0;
        while (n2 < this.num_vertices) {
            this.sVerts[n2] = new MDLSkinVertex();
            this.sVerts[n2].onseam = this.readInt(inputStream) > 0;
            this.sVerts[n2].s = (short)this.readInt(inputStream);
            this.sVerts[n2].t = (short)this.readInt(inputStream);
            if (this.sVerts[n2].s > this.skinw || this.sVerts[n2].t > this.skinh) {
                System.out.println("MDLView: Skin vertex prob: " + this.sVerts[n2].s + "," + this.sVerts[n2].s + " outside skin");
            }
            if (n2 % n == 0) {
                this.showStatus("MDLView: Reading skin vertices.... (about " + n2 / n * 2 + "% done)");
                this.yield();
            }
            ++n2;
        }
    }

    protected void readModelTriangles(InputStream inputStream) throws IOException {
        this.showStatus("MDLView: Reading triangles");
        this.debug("MDLView: Reading triangles");
        this.triangles = new MDLTriangle[this.num_triangles];
        int n = 0;
        int n2 = this.num_triangles / 10;
        int n3 = 0;
        while (n3 < this.num_triangles) {
            this.triangles[n3] = new MDLTriangle();
            this.triangles[n3].facesFront = this.readInt(inputStream) > 0;
            this.triangles[n3].verts[0] = (short)this.readInt(inputStream);
            this.triangles[n3].verts[1] = (short)this.readInt(inputStream);
            this.triangles[n3].verts[2] = (short)this.readInt(inputStream);
            if (this.triangles[n3].verts[0] >= this.num_vertices || this.triangles[n3].verts[1] >= this.num_vertices || this.triangles[n3].verts[2] >= this.num_vertices) {
                System.out.println("MDLView: Prob triangle " + n3 + " verts: " + this.triangles[n3].verts[0] + ", " + this.triangles[n3].verts[1] + ", " + this.triangles[n3].verts[2]);
            }
            if (n % n2 == 0) {
                this.showStatus("MDLView: Reading triangles.... (about " + n3 / n2 * 10 + "% done)");
                this.yield();
            }
            ++n;
            ++n3;
        }
    }

    protected void readModelFrames(int[] nArray, InputStream inputStream) throws IOException {
        this.showStatus("MDLView: Reading frames");
        this.debug("MDLView: Reading frames.");
        this.yield();
        int n = 0;
        this.frames = nArray[0] != -1 ? new MDLFrame[nArray.length] : new MDLFrame[this.num_frames];
        int n2 = 0;
        while (n2 < this.num_frames) {
            if (nArray[0] == -1) {
                this.frames[n] = new MDLFrame();
                this.frames[n].isGroup = this.version == 6 ? this.readInt(inputStream) > 0 : false;
                if (!this.frames[n].isGroup) {
                    this.readSingleFrame(n, inputStream);
                } else {
                    this.readGroupFrame(n, inputStream);
                }
                ++n;
            } else if (n >= nArray.length) {
                if (this.version == 6) {
                    if (this.readInt(inputStream) > 0) {
                        this.skipGroupFrame(inputStream);
                    } else {
                        this.skipSingleFrame(inputStream);
                    }
                } else {
                    this.skipSingleFrame(inputStream);
                }
            } else if (nArray[n] == n2) {
                this.frames[n] = new MDLFrame();
                this.frames[n].isGroup = this.version == 6 ? this.readInt(inputStream) > 0 : false;
                if (!this.frames[n].isGroup) {
                    this.readSingleFrame(n, inputStream);
                } else {
                    this.readGroupFrame(n, inputStream);
                }
                ++n;
            } else if (this.version == 6) {
                if (this.readInt(inputStream) > 0) {
                    this.skipGroupFrame(inputStream);
                } else {
                    this.skipSingleFrame(inputStream);
                }
            } else {
                this.skipSingleFrame(inputStream);
            }
            ++n2;
        }
        this.num_frames = n;
        this.showStatus("MDLView: Frames read");
    }

    protected void readSingleFrame(int n, InputStream inputStream) throws IOException {
        this.showStatus("Reading frame " + n);
        this.frames[n].num_SimpleFrames = 1;
        this.frames[n].simple_Frames = new MDLSimpleFrame[1];
        this.frames[n].simple_Frames[0] = new MDLSimpleFrame(this.num_vertices);
        if (this.version != 6) {
            this.loadFrameVertex(inputStream, this.frames[n].min);
        }
        this.loadFrameVertex(inputStream, this.frames[n].min);
        this.loadFrameVertex(inputStream, this.frames[n].max);
        if (this.version == 6) {
            byte[] byArray = new byte[16];
            int n2 = 16;
            int n3 = 0;
            while (n3 < 16) {
                byArray[n3] = (byte)inputStream.read();
                if (byArray[n3] == 0 && n3 < n2) {
                    n2 = n3;
                }
                ++n3;
            }
            this.frames[n].simple_Frames[0].name = new String(byArray, 0, n2);
            this.showStatus("MDLView: Frame name is " + this.frames[n].simple_Frames[0].name);
        } else {
            this.frames[n].simple_Frames[0].name = "noname";
        }
        int n4 = 0;
        while (n4 < this.num_vertices) {
            this.loadFrameVertex(inputStream, this.frames[n].simple_Frames[0].frameVerts[n4]);
            ++n4;
        }
    }

    protected void skipSingleFrame(InputStream inputStream) throws IOException {
        if (this.j == 0) {
            this.showStatus("MDLView: Skipping single frame      <>");
            ++this.j;
        } else if (this.j == 1) {
            this.showStatus("MDLView: Skipping single frame     <-->");
            ++this.j;
        } else if (this.j == 2) {
            this.showStatus("MDLView: Skipping single frame    <---->");
            ++this.j;
        } else if (this.j == 3) {
            this.showStatus("MDLView: Skipping single frame   <------>");
            ++this.j;
        } else if (this.j == 4) {
            this.showStatus("MDLView: Skipping single frame  <-------->");
            ++this.j;
        } else if (this.j == 5) {
            this.showStatus("MDLView: Skipping single frame <---------->");
            ++this.j;
        } else if (this.j == 6) {
            this.showStatus("MDLView: Skipping single frame  <-------->");
            ++this.j;
        } else if (this.j == 7) {
            this.showStatus("MDLView: Skipping single frame   <------>");
            ++this.j;
        } else if (this.j == 8) {
            this.showStatus("MDLView: Skipping single frame    <---->");
            ++this.j;
        } else {
            this.showStatus("MDLView: Skipping single frame     <-->");
            this.j = 0;
        }
        if (this.version != 6) {
            this.skip(4, inputStream);
        }
        if (this.version == 6) {
            this.skip(16, inputStream);
        }
        this.skip(4 * this.num_vertices + 8, inputStream);
    }

    protected void readGroupFrame(int n, InputStream inputStream) throws IOException {
        this.showStatus("MDLView: Reading frame group");
        this.frames[n].num_SimpleFrames = this.readInt(inputStream);
        this.loadFrameVertex(inputStream, this.frames[n].min);
        this.loadFrameVertex(inputStream, this.frames[n].min);
        this.frames[n].time = new float[this.frames[n].num_SimpleFrames];
        this.frames[n].simple_Frames = new MDLSimpleFrame[this.frames[n].num_SimpleFrames];
        this.showStatus("MDLView: Time values for frames in group");
        int n2 = 0;
        while (n2 < this.frames[n].num_SimpleFrames) {
            this.frames[n].time[n2] = this.readFloat(inputStream);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.frames[n].num_SimpleFrames) {
            this.frames[n].simple_Frames[n3] = new MDLSimpleFrame(this.num_vertices);
            this.loadFrameVertex(inputStream, this.frames[n].simple_Frames[n3].min);
            this.loadFrameVertex(inputStream, this.frames[n].simple_Frames[n3].max);
            byte[] byArray = new byte[16];
            int n4 = 0;
            while (n4 < 16) {
                byArray[n4] = (byte)inputStream.read();
                ++n4;
            }
            this.frames[n].simple_Frames[0].name = new String(byArray);
            this.showStatus("MDLView: Frame name is " + this.frames[n].simple_Frames[0].name);
            int n5 = 0;
            while (n5 < this.num_vertices) {
                this.loadFrameVertex(inputStream, this.frames[n].simple_Frames[n3].frameVerts[n5]);
                ++n5;
            }
            ++n3;
        }
    }

    protected void skipGroupFrame(InputStream inputStream) throws IOException {
        this.showStatus("MDLView: Skipping frame group");
        int n = this.readInt(inputStream);
        this.skip(8, inputStream);
        int n2 = 0;
        while (n2 < n) {
            this.skip(4, inputStream);
            ++n2;
        }
        this.skip(8 * n, inputStream);
        this.skip(4 * this.num_vertices + 16, inputStream);
    }
}

