/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class MDLView
extends Applet
implements MDLModelTracker {
    MDLViewCanvas mdlViewCanvas;
    MDLHelpWindow helpWindow;
    MDLMonitorWindow monitorWindow;
    Frame skinWindow;
    static int Version = 96;
    URL codeBase;
    URL docBase;
    URL paletteURL;
    String palFileName;
    URL modelURL;
    IndexColorModel palette;
    MDLModel myModel;
    static final int MDL_VER = 6;
    String modelFileName;
    int mouseX;
    int mouseY;
    boolean moveNotRotate;
    boolean tabReady = true;
    boolean fastRendering = false;
    boolean initialised = false;
    boolean rotating = false;
    boolean modelReady = false;
    boolean DEBUG;
    int shiftY;

    public void init() {
        System.gc();
        this.debugOut("MDLView v" + Version / 100 + "." + Version % 100 + " by T.J.Grey (tjg1@ch.ic.ac.uk)");
        this.showStatus("MDLView: Initialising...");
        this.codeBase = this.getCodeBase();
        this.palFileName = this.getParameter("PALETTE");
        String string = this.getParameter("FORMAT");
        String string2 = this.getParameter("LOADSKINS");
        if (string2 == null || !string2.startsWith("0")) {
            if (this.palFileName == null) {
                if (string == null) {
                    this.debugOut("MDLView: No palette specified, using quake.pal");
                    this.showStatus("MDLView: No palette specified, using quake.pal");
                    this.palFileName = "quake.pal";
                } else {
                    this.debugOut("MDLView: No palette specified, using " + string + ".pal");
                    this.palFileName = String.valueOf(string) + ".pal";
                }
            }
            this.readPalette(this.codeBase, this.palFileName);
        }
        this.DEBUG = this.getParameter("DEBUG") != null;
        this.size();
    }

    public void start() {
        Object object;
        Object object2;
        System.gc();
        System.gc();
        System.gc();
        if (!this.initialised) {
            String string;
            int n;
            int n2;
            int n3;
            String string2;
            Object object3;
            Object object4;
            String string3;
            String string4;
            Object object5;
            Object object6;
            this.codeBase = this.getCodeBase();
            this.docBase = this.getDocumentBase();
            object2 = this.getParameter("FORMAT");
            object = "MDL" + (String)object2 + "Model";
            if (object2 == null) {
                object = "MDLquakeModel";
            }
            try {
                this.debugOut("MDLView: Instancing model as " + (String)object);
                object6 = Class.forName((String)object);
                this.debugOut("MDLView: Model class created");
                object5 = ((Class)object6).newInstance();
                this.debugOut("MDLView: Model class instanced");
                this.myModel = (MDLModel)object5;
                this.debugOut("MDLView: Model class cast");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MDLView: No class (MDL" + (String)object2 + "Model.class) can be found which matches the FORMAT you specifed");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("MDLView: Model class problem: Instancing exception: " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("MDLView: Model class problem: IllegalAccessException exception: " + illegalAccessException);
            }
            this.myModel.setModelTracker(this);
            object6 = this.getParameter("LOADSKINS");
            if (object6 == null || !((String)object6).startsWith("0")) {
                object5 = this.getParameter("PALETTE");
                if (object5 == null) {
                    object5 = object2 == null ? "quake.pal" : String.valueOf(object2) + ".pal";
                }
                if (object5 != this.palFileName) {
                    this.readPalette(this.codeBase, (String)object5);
                    this.palFileName = object5;
                }
            }
            object5 = this.size();
            this.mdlViewCanvas = new MDLViewCanvas((Dimension)object5, this.palette, this.myModel, this.DEBUG);
            this.showStatus("MDLView: Initialised, adding canvas to applet");
            this.setLayout(new BorderLayout());
            this.add("Center", this.mdlViewCanvas);
            this.mdlViewCanvas.initialiseGraphics();
            String string5 = this.getParameter("BCOLOUR");
            if (string5 == null || string5.length() != 7) {
                System.out.println("MDLView: BCOLOUR not specified or specified incorrectly, using white for background");
                System.out.println("... usage eg <PARAM NAME=BCOLOUR VALUE=#FF00FF>");
                string5 = "#FFFFFF";
            }
            if ((string4 = this.getParameter("FCOLOUR")) == null || string4.length() != 7) {
                System.out.println("MDLView: FCOLOUR not specified or specified incorrctly, using black for foreground");
                System.out.println("... usage eg <PARAM NAME=FCOLOUR VALUE=#000000>");
                string4 = "#000000";
            }
            if ((string3 = this.getParameter("BIMAGE")) != null) {
                object4 = new MediaTracker(this);
                object3 = this.getImage(this.getDocumentBase(), string3);
                ((MediaTracker)object4).addImage((Image)object3, 0);
                this.showStatus("MDLView: Loading background");
                this.debugOut("MDLView: Loading background image as " + string3);
                try {
                    ((MediaTracker)object4).waitForAll();
                }
                catch (InterruptedException interruptedException) {}
                this.mdlViewCanvas.setBackgroundImage((Image)object3);
            }
            if ((object4 = this.getParameter("SHIFTY")) != null) {
                try {
                    this.shiftY = Integer.decode((String)object4);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad SHIFTY value: " + (String)object4);
                    this.shiftY = 0;
                }
            } else {
                this.shiftY = 0;
            }
            object3 = this.getParameter("ZOOM");
            float f = 0.0f;
            if (object3 != null) {
                try {
                    f = Double.valueOf((String)object3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad ZOOM value: " + (String)object3);
                }
                this.mdlViewCanvas.setZoom(f);
            }
            if ((string2 = this.getParameter("YANGLE")) != null) {
                try {
                    n3 = Integer.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad YANGLE value: " + string2);
                    n3 = 0;
                }
            } else {
                n3 = 0;
            }
            this.mdlViewCanvas.setZAngle(n3);
            String string6 = this.getParameter("XANGLE");
            if (string6 != null) {
                try {
                    n2 = Integer.decode(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad XANGLE value: " + string6);
                    n2 = 0;
                }
            } else {
                n2 = 0;
            }
            this.mdlViewCanvas.setYAngle(n2);
            String string7 = this.getParameter("STARTSKIN");
            if (string7 != null) {
                try {
                    n = Integer.decode(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad STARTSKIN value: " + string7);
                    n = 0;
                }
            } else {
                n = 0;
            }
            this.mdlViewCanvas.setSkinGroup(n);
            String string8 = this.getParameter("MODEL");
            if (this.modelFileName != string8) {
                if (string8 == null) {
                    System.out.println("MDLView: No model specified... please add to html...");
                    System.out.println("          <PARAM NAME=MODEL VALUE=player.mdl>");
                    this.showStatus("MDLView: !!Fatal!! No model to load");
                    try {
                        this.mdlViewCanvas.setMode("Error");
                    }
                    catch (BadModeException badModeException) {}
                } else {
                    this.modelFileName = string8;
                }
                this.modelReady = false;
            }
            if ((string = this.getParameter("ROTATE")) != null) {
                if ((string = string.toLowerCase()).equals("true")) {
                    this.mdlViewCanvas.setRotating(true);
                    this.rotating = true;
                } else {
                    this.mdlViewCanvas.setRotating(false);
                    this.rotating = false;
                }
            } else {
                this.mdlViewCanvas.setRotating(false);
                this.rotating = false;
            }
            String string9 = this.getParameter("CYCLE");
            if (string9 != null) {
                if ((string9 = string9.toLowerCase()).equals("true")) {
                    this.mdlViewCanvas.startAnimated(true);
                } else {
                    this.mdlViewCanvas.startAnimated(false);
                }
            } else {
                this.mdlViewCanvas.startAnimated(false);
            }
            String string10 = this.getParameter("RENDERMODE");
            try {
                if (this.myModel.getModelError()) {
                    this.mdlViewCanvas.setMode("error");
                } else if (string10 != null) {
                    this.mdlViewCanvas.setMode(string10);
                } else {
                    this.mdlViewCanvas.setMode("wireframe");
                }
            }
            catch (BadModeException badModeException) {
                System.out.println("MDLView: Bad render mode " + string10);
            }
            this.mdlViewCanvas.setForegroundColour(string4);
            this.mdlViewCanvas.setBackgroundColour(string5);
            this.initialised = true;
        }
        if (this.myModel.getModelReady()) {
            this.mdlViewCanvas.modelReady();
            this.mdlViewCanvas.start();
        } else {
            object2 = this.getLoadSkins();
            object = this.getLoadFrames();
            this.getModel(this.docBase, this.modelFileName, (int[])object, (int[])object2, this.shiftY);
            this.mdlViewCanvas.setModel(this.myModel);
        }
        this.repaint();
    }

    public void stop() {
        this.myModel.stopCall();
        this.mdlViewCanvas.stop();
    }

    public void destroy() {
        this.myModel.stopCall();
        System.gc();
    }

    public void debugOut(String string) {
        if (this.DEBUG) {
            System.out.println("DBG: " + string);
        }
    }

    public String getAppletInfo() {
        return "MDLView v" + Version / 100 + "." + Version % 100 + ": An Applet by T.J.Grey to Display Model Files from Idsoftware's Quake";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"MODEL", "relative URL", "The URL of the mdl file relative to document base (ie the HTML page)"}, {"BCOLOUR", "hex number", "Colour of background eg #FFFFFF"}, {"FCOLOUR", "hex number", "Colour used for wireframe eg #000000"}, {"PALETTE", "relative URL", "URL of Palette file, relative to codebase"}, {"FORMAT", "string", "Supported model type- the name of the Model class without 'MDL' or 'Model'"}, {"LOADFRAMES", "string", "Number frames to load, then frame numbers IN ORDER, no spaces eg 4,0-3,5"}, {"LOADSKINS", "string", "Number skins to load, then skin numbers IN ORDER, no spaces eg 2,0,5"}, {"RENDERMODE", "string", "Start mode- currently 'wireframe','hiddenline' or 'texturemapped'"}, {"ROTATE", "boolean", "Start with model rotating either 'true' or 'false'"}, {"YANGLE", "int", "Start with model rotated by this about the vertical angle"}, {"XANGLE", "int", "Start with model rotated by this about the left/right angle"}, {"STARTSKIN", "int", "Start with this skin"}, {"CYCLE", "boolean", "Start with model cycling through frames"}, {"ZOOM", "float", "Zoom level for model- use with care!"}, {"SHIFTY", "int", "Shifts model vertically (use with care!)"}, {"BIMAGE", "FILENAME", "NAME of a gif or jpeg to show behind the model"}};
        return stringArray;
    }

    public void modelReady() {
        this.modelReady = true;
        this.showStatus("MDLView: Model read");
        this.debugOut("MDLView: Model read");
        this.mdlViewCanvas.modelReady();
        this.showStatus("MDLView: Starting renderer");
        this.debugOut("MDLView: Starting renderer");
        this.mdlViewCanvas.start();
    }

    public void statusShow(String string) {
        this.showStatus(string);
    }

    public final String getAuthorInfo() {
        return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
    }

    private void readPalette(URL uRL, String string) {
        try {
            this.paletteURL = new URL(this.codeBase, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLView: Error in palette URL <" + malformedURLException + ">");
            this.showStatus("MDLView: Error in palette URL...");
        }
        this.showStatus("MDLView: Opening connection for palette as " + this.paletteURL);
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(this.paletteURL.openStream());
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.eolIsSignificant(true);
            int n2 = 0;
            while (n2 < 2) {
                n = streamTokenizer.nextToken();
                if (n != 10) continue;
                ++n2;
            }
            streamTokenizer.nextToken();
            n = (int)streamTokenizer.nval;
            if (n != 256) {
                System.out.println("MDLView: !CARE!.. Pal says " + n + " colours.. we use 256");
            }
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            streamTokenizer.eolIsSignificant(false);
            int n3 = 0;
            while (n3 < n) {
                streamTokenizer.nextToken();
                byArray[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray2[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray3[n3] = (byte)streamTokenizer.nval;
                ++n3;
            }
            this.palette = new IndexColorModel(8, n, byArray, byArray2, byArray3, 255);
            inputStreamReader.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("MDLView: Error reading palette- <" + iOException + ">");
            this.showStatus("MDLView: Error reading palette- <" + iOException + ">");
            return;
        }
    }

    private int intFromFourBytes(byte[] byArray) {
        int n = 0;
        n |= (byArray[0] & 0xFF) << 24;
        n |= (byArray[1] & 0xFF) << 16;
        n |= (byArray[2] & 0xFF) << 8;
        return n |= byArray[3] & 0xFF;
    }

    private float floatFromFourBytes(byte[] byArray) {
        float f = 0.0f;
        int n = this.intFromFourBytes(byArray);
        f = Float.intBitsToFloat(n);
        return f;
    }

    private int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.intFromFourBytes(byArray);
    }

    private float readFloat(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.floatFromFourBytes(byArray);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mouseX = n;
        this.mouseY = n2;
        switch (this.mdlViewCanvas.renderMode) {
            default: 
        }
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.mdlViewCanvas.renderMode == 2) {
            this.fastRendering = true;
            try {
                this.mdlViewCanvas.setRenderMode(1);
            }
            catch (BadModeException badModeException) {
                System.out.println("MDLView: Caught BadModeException in MDLView.mouseDrag: " + badModeException);
            }
        }
        if (this.moveNotRotate) {
            this.mdlViewCanvas.translateZ(2 * (this.mouseY - n2));
        } else {
            this.mdlViewCanvas.rotateZ(n - this.mouseX);
            this.mdlViewCanvas.rotateY(n2 - this.mouseY);
        }
        this.mouseX = n;
        this.mouseY = n2;
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        switch (this.mdlViewCanvas.renderMode) {
            case 2: {
                this.showStatus("(" + n + "," + n2 + ") Colour palette index: " + (0xFF & this.mdlViewCanvas.getColourAt(n, n2)));
            }
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        if (n == 63) {
            if (this.helpWindow == null) {
                this.helpWindow = new MDLHelpWindow(Version, this.getAppletContext(), this.myModel);
                this.helpWindow.show();
            } else {
                this.helpWindow.show();
            }
            return true;
        }
        if (n == 109) {
            if (this.monitorWindow == null) {
                this.monitorWindow = new MDLMonitorWindow(this.mdlViewCanvas, this.myModel, this.modelFileName);
                this.monitorWindow.show();
            } else {
                this.monitorWindow.show();
            }
            return true;
        }
        if (n == 115) {
            if (this.getParameter("DEBUG") == null) {
                return true;
            }
            if (this.skinWindow == null) {
                this.skinWindow = new Frame();
                this.skinWindow.setTitle("MDLView: Model skin");
                this.skinWindow.add(new MDLSkinCanvas(this.myModel, this.mdlViewCanvas));
                this.skinWindow.pack();
                this.skinWindow.show();
            } else {
                this.skinWindow.show();
            }
            return true;
        }
        if (n == 122) {
            this.moveNotRotate = true;
            return true;
        }
        if (n == 114) {
            if (this.rotating) {
                this.showStatus("MDLView: Stopping rotation");
                this.mdlViewCanvas.setRotating(false);
                this.rotating = false;
            } else {
                this.showStatus("MDLView: Starting rotation");
                this.mdlViewCanvas.setRotating(true);
                this.rotating = true;
            }
            return true;
        }
        if (n == 9 && this.tabReady) {
            this.showStatus("MDLView: Changing mode");
            this.mdlViewCanvas.nextRenderMode();
            this.tabReady = false;
            return true;
        }
        switch (this.mdlViewCanvas.renderMode) {
            case 2: {
                if (n == 1004) {
                    this.mdlViewCanvas.lastSkin();
                    return true;
                }
                if (n == 1005) {
                    this.mdlViewCanvas.nextSkin();
                    return true;
                }
            }
            case 1: 
            case 3: {
                if (n == 1006) {
                    this.showStatus("MDLView: Retreating one sub-frame");
                    this.mdlViewCanvas.lastSimpleFrame();
                    return true;
                }
                if (n == 1007) {
                    this.mdlViewCanvas.nextSimpleFrame();
                    this.showStatus("MDLView: Advancing one sub-frame");
                    return true;
                }
                if (n != 99) break;
                if (!this.mdlViewCanvas.isAnimated) {
                    this.showStatus("MDLView: Starting animation");
                    this.mdlViewCanvas.startAnimation();
                } else {
                    this.showStatus("MDLView: Stopping animation");
                    this.mdlViewCanvas.stopAnimation();
                }
                return true;
            }
        }
        this.showStatus("Key: " + n);
        return false;
    }

    public boolean keyUp(Event event, int n) {
        if (n == 122) {
            this.moveNotRotate = false;
            return true;
        }
        if (n == 9) {
            this.tabReady = true;
        }
        if (n == 115) {
            this.skinWindow.dispose();
        }
        switch (this.mdlViewCanvas.renderMode) {
            case 1: {
                this.showStatus("");
            }
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.fastRendering) {
            this.fastRendering = false;
            try {
                this.mdlViewCanvas.setRenderMode(2);
            }
            catch (BadModeException badModeException) {
                System.out.println("MDLView: Caught BadModeException in MDLView.mouseRelease: " + badModeException);
            }
            return true;
        }
        switch (this.mdlViewCanvas.renderMode) {
            default: 
        }
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.requestFocus();
        this.showStatus("MDLView: For help press '?'");
        switch (this.mdlViewCanvas.renderMode) {
            default: 
        }
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.showStatus("");
        return false;
    }

    private int[] getLoadFrames() {
        String string = this.getParameter("LOADFRAMES");
        if (string == null) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        return this.intArrayFromString(string, "load frames");
    }

    private int[] getLoadSkins() {
        String string = this.getParameter("LOADSKINS");
        if (string == null) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        return this.intArrayFromString(string, "load skins");
    }

    protected int[] intArrayFromString(String string, String string2) {
        Object object;
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String string3 = stringTokenizer.nextToken();
        try {
            n = Integer.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MDLView: Error in " + string2 + " string... loading all frames/skins");
            int[] nArray = new int[]{-1};
            return nArray;
        }
        if (n == 0) {
            int[] nArray = new int[]{-2};
            return nArray;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).indexOf("-") >= 0) {
                if (((String)object).indexOf("-") == 0 || ((String)object).indexOf("-") == ((String)object).length()) {
                    System.out.println("MDLView: Error LOADFRAMES token starts/ends with hyphen not a number");
                    continue;
                }
                String string4 = ((String)object).substring(0, ((String)object).lastIndexOf("-"));
                String string5 = ((String)object).substring(((String)object).lastIndexOf("-") + 1, ((String)object).length());
                try {
                    int n3 = Integer.decode(string4);
                    int n4 = Integer.decode(string5);
                    if (n3 < n4 && n3 >= 0 && n4 >= 0) {
                        int n5 = n3;
                        while (n5 <= n4) {
                            nArray[n2] = n5++;
                            ++n2;
                        }
                        continue;
                    }
                    System.out.println("MDLView: " + string2 + ", bad start/end values, " + n3 + ", " + n4 + ", items may be missing");
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Error in " + string2 + " items may be missing");
                }
                continue;
            }
            try {
                int n6;
                nArray[n2] = n6 = Integer.decode((String)object).intValue();
                ++n2;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MDLView: Error in " + string2 + " items may be missing");
            }
        }
        object = new int[n2];
        int n7 = 0;
        while (n7 < n2) {
            object[n7] = nArray[n7];
            ++n7;
        }
        return object;
    }

    private void getModel(URL uRL, String string, int[] nArray, int[] nArray2, int n) {
        try {
            this.modelURL = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLView: Error in model URL <" + malformedURLException + ">");
            this.showStatus("MDLView: Error in model URL...");
        }
        this.myModel.readModel(this.modelURL, nArray, nArray2, n);
        this.showStatus("MDLView: Opening connection for model as " + this.modelURL);
    }
}

