/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class MDLMovieCanvas
extends Canvas
implements Runnable {
    long startTime;
    int delayTime = 100;
    int currentFrame;
    Image[] frames;
    Image bImage;
    boolean haveBImage = false;
    int[] delays;
    Thread aniThread;
    int height;
    int width;
    Dimension mySize;
    boolean isAnimated = false;
    int num_frames;
    public String message = "Generating Images";

    public MDLMovieCanvas(Dimension dimension) {
        this.height = dimension.height;
        this.width = dimension.width;
        this.mySize = dimension;
        this.frames = new Image[1];
        this.delays = new int[1];
    }

    public void setNumberOfFrames(int n) {
        this.frames = new Image[n];
        this.delays = new int[n];
        this.num_frames = n;
    }

    public void setDelayTime(int n) {
        if (n < 1000) {
            this.delayTime = n;
        }
    }

    public void setBackgroundImage(Image image) {
        this.haveBImage = true;
        this.bImage = image;
    }

    public void addFrame(Image image, int n, int n2) {
        this.delays[n2] = n;
        Image image2 = this.createImage(this.width, this.height);
        Graphics graphics = image2.getGraphics();
        if (this.haveBImage) {
            graphics.drawImage(this.bImage, 0, 0, this.width, this.height, this);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
        }
        graphics.drawImage(image, 0, 0, this.width, this.height, this);
        this.frames[n2] = image2;
        this.currentFrame = n2;
        this.update(this.getGraphics());
    }

    public void addFrame(Image image, int n) {
        this.delays[n] = this.delayTime;
        Image image2 = this.createImage(this.width, this.height);
        Graphics graphics = image2.getGraphics();
        if (this.haveBImage) {
            graphics.drawImage(this.bImage, 0, 0, this.width, this.height, this);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.width, this.height);
        }
        graphics.drawImage(image, 0, 0, this.width, this.height, this);
        this.frames[n] = image2;
        this.currentFrame = n;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.mySize;
    }

    public Dimension getPreferedSize() {
        return this.mySize;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (this.frames[this.currentFrame] != null) {
            graphics.drawImage(this.frames[this.currentFrame], 0, 0, this.width, this.height, this);
            return;
        }
        graphics.drawString(this.message, 10, 10);
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void startAnimation() {
        if (!this.isAnimated) {
            this.isAnimated = true;
            this.startTime = System.currentTimeMillis();
            this.aniThread = new Thread((Runnable)this, "animateThread");
            this.aniThread.start();
        }
    }

    public void stopAnimation() {
        this.isAnimated = false;
    }

    public void run() {
        while (this.isAnimated) {
            Thread.yield();
            ++this.currentFrame;
            this.currentFrame %= this.num_frames;
            this.update(this.getGraphics());
            try {
                this.startTime += (long)this.delays[this.currentFrame];
                Thread.sleep(Math.max(0L, this.startTime - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interupted animation thread");
            }
        }
    }

    public int getFrameNumber() {
        return this.currentFrame;
    }

    public static final String getAuthorInfo() {
        return "Copyright T.J.Grey 1998";
    }
}

