/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class MDLMovie
extends Applet
implements MDLModelTracker {
    MDLViewCanvas mdlViewCanvas;
    MDLMovieCanvas mdlMovieCanvas;
    static int Version = 96;
    URL codeBase;
    URL docBase;
    URL paletteURL;
    URL modelURL;
    IndexColorModel palette;
    MDLModel myModel;
    static final int MDL_VER = 6;
    String modelFileName;
    String palFileName;
    int movieType = 1;
    static final int movieRotate = 1;
    static final int movieAnimate = 2;
    Dimension d;
    int[] loadframes;
    int[] loadskins;
    boolean initialised = false;
    int shiftY;
    boolean modelReady = false;
    boolean DEBUG;

    public void init() {
        System.gc();
        this.debugOut("MDLMovie v" + Version / 100 + "." + Version % 100 + " by T.J.Grey (tjg1@ch.ic.ac.uk)");
        this.showStatus("MDLView: Initialising...");
        this.codeBase = this.getCodeBase();
        String string = this.getParameter("PALETTE");
        String string2 = this.getParameter("FORMAT");
        if (string == null) {
            if (string2 == null) {
                this.debugOut("MDLMovie: No palette specified, using quake.pal");
                this.showStatus("MDLMovie: No palette specified, using quake.pal");
                string = "quake.pal";
            } else {
                this.debugOut("MDLView: No palette specified, using " + string2 + ".pal");
                string = String.valueOf(string2) + ".pal";
            }
        }
        this.readPalette(this.codeBase, string);
        this.DEBUG = this.getParameter("DEBUG") != null;
        this.d = this.size();
        this.mdlMovieCanvas = new MDLMovieCanvas(this.d);
        this.mdlMovieCanvas.message = "Loading...";
        this.setLayout(new BorderLayout());
        this.add("Center", this.mdlMovieCanvas);
    }

    public void start() {
        this.codeBase = this.getCodeBase();
        this.docBase = this.getDocumentBase();
        System.gc();
        System.gc();
        System.gc();
        Dimension dimension = this.size();
        if (!this.initialised) {
            int n;
            int n2;
            String string;
            int n3;
            String string2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            this.codeBase = this.getCodeBase();
            this.docBase = this.getDocumentBase();
            String string3 = this.getParameter("FORMAT");
            String string4 = "MDL" + string3 + "Model";
            if (string3 == null) {
                string4 = "MDLquakeModel";
            }
            try {
                this.debugOut("MDLView: Instancing model as " + string4);
                object4 = Class.forName(string4);
                this.debugOut("MDLView: Model class created");
                object3 = ((Class)object4).newInstance();
                this.debugOut("MDLView: Model class instanced");
                this.myModel = (MDLModel)object3;
                this.debugOut("MDLView: Model class cast");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("MDLView: No class can be found which matches the FORMAT you specifed");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("MDLView: Model class problem: Instancing exception: " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("MDLView: Model class problem: IllegalAccessException exception: " + illegalAccessException);
            }
            this.myModel.setModelTracker(this);
            object4 = this.getParameter("PALETTE");
            if (object4 == null) {
                object4 = string3 == null ? "quake.pal" : String.valueOf(string3) + ".pal";
            }
            if (object4 != this.palFileName) {
                this.readPalette(this.codeBase, (String)object4);
                this.palFileName = object4;
            }
            this.mdlViewCanvas = new MDLViewCanvas(dimension, this.palette, this.myModel, this.DEBUG);
            object3 = this.getParameter("MOVIETYPE");
            if (object3 == null) {
                object3 = "rotate";
            }
            this.movieType = ((String)(object3 = ((String)object3).toLowerCase())).equals("animate") ? 2 : 1;
            String string5 = this.getParameter("BIMAGE");
            if (string5 != null) {
                object2 = new MediaTracker(this);
                object = this.getImage(this.getDocumentBase(), string5);
                ((MediaTracker)object2).addImage((Image)object, 0);
                this.showStatus("MDLView: Loading background");
                this.debugOut("MDLView: Loading background image as " + string5);
                try {
                    ((MediaTracker)object2).waitForAll();
                }
                catch (InterruptedException interruptedException) {}
                this.mdlMovieCanvas.setBackgroundImage((Image)object);
            }
            if ((object2 = this.getParameter("BCOLOUR")) == null || ((String)object2).length() != 7) {
                System.out.println("MDLView: BCOLOUR not specified or specified incorrectly, using white for background");
                System.out.println("... usage eg <PARAM NAME=BCOLOUR VALUE=#FF00FF>");
                object2 = "#FFFFFF";
            }
            if ((object = this.getParameter("SHIFTY")) != null) {
                try {
                    this.shiftY = Integer.decode((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad SHIFTY value: " + (String)object);
                    this.shiftY = 0;
                }
            } else {
                this.shiftY = 0;
            }
            if ((string2 = this.getParameter("DELAYTIME")) != null) {
                try {
                    n3 = Integer.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad DELAYTIME value: " + string2);
                    n3 = 100;
                }
            } else {
                n3 = 100;
            }
            this.mdlMovieCanvas.setDelayTime(n3);
            String string6 = this.getParameter("ZOOM");
            float f = 0.0f;
            if (string6 != null) {
                try {
                    f = Double.valueOf(string6).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad ZOOM value: " + string6);
                }
                this.mdlViewCanvas.setZoom(f);
            }
            if ((string = this.getParameter("YANGLE")) != null) {
                try {
                    n2 = Integer.decode(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad YANGLE value: " + string);
                    n2 = 0;
                }
            } else {
                n2 = 0;
            }
            this.mdlViewCanvas.setZAngle(n2);
            String string7 = this.getParameter("XANGLE");
            if (string7 != null) {
                try {
                    n = Integer.decode(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Bad XANGLE value: " + string7);
                    n = 0;
                }
            } else {
                n = 0;
            }
            this.mdlViewCanvas.setYAngle(n);
            String string8 = this.getParameter("MODEL");
            if (this.modelFileName != string8) {
                if (string8 == null) {
                    System.out.println("MDLView: No model specified... please add to html...");
                    System.out.println("          <PARAM NAME=MODEL VALUE=player.mdl>");
                    this.showStatus("MDLView: !!Fatal!! No model to load");
                    try {
                        this.mdlViewCanvas.setMode("Error");
                    }
                    catch (BadModeException badModeException) {}
                } else {
                    this.modelFileName = string8;
                }
                this.modelReady = false;
            }
            try {
                this.mdlViewCanvas.setMode("texturemapped");
            }
            catch (BadModeException badModeException) {
                System.out.println("MDLMovie: Internal bad render mode");
            }
            this.mdlViewCanvas.setBackgroundColour((String)object2);
            super.setBackground(this.getColourFromHex((String)object2));
            this.loadframes = this.getLoadFrames();
            this.loadskins = this.getLoadSkins();
            if (this.movieType == 1 && (this.loadframes.length > 1 || this.loadframes[0] == -1)) {
                System.out.println("MDLMovie: Bad load frames- only need ONE frame for rotation");
                this.loadframes = new int[1];
                this.loadframes[0] = 0;
            }
            if (this.movieType == 2 && this.loadframes.length > 30) {
                System.out.println("MDLMovie: Can't have more than 30 frames!");
            }
            this.getModel(this.docBase, this.modelFileName, this.loadframes, this.loadskins, this.shiftY);
            this.mdlViewCanvas.setModel(this.myModel);
            return;
        }
        this.mdlMovieCanvas.startAnimation();
    }

    public void stop() {
        if (this.myModel != null) {
            this.myModel.stopCall();
        }
        this.mdlMovieCanvas.stopAnimation();
    }

    public void debugOut(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public String getAppletInfo() {
        return "MDLMovie v" + Version / 100 + "." + Version % 100 + ": An Applet by T.J.Grey to Display Model Files";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"MODEL", "relative URL", "The URL of the mdl file relative to document base (ie the HTML page)"}, {"MOVIETYPE", "String", "Type of movie: 'ROTATE' or 'ANIMATE'"}, {"BCOLOUR", "hex number", "Colour of background eg #FFFFFF"}, {"PALETTE", "relative URL", "URL of Palette file, relative to codebase"}, {"LOADFRAMES", "string", "Number frames to load , then frame numbers IN ORDER, no spaces eg 4,0-3,5 (NB need only one frame for a ROTATE movie)"}, {"LOADSKINS", "string", "Number skins to load, then skin numbers IN ORDER, no spaces eg 2,0,5"}, {"DELAYTIME", "int", "Time between frames in milliseconds if < 100"}, {"YANGLE", "int", "Start with model rotated by this about the vertical angle"}, {"XANGLE", "int", "Start with model rotated by this about the left/right angle"}, {"ZOOM", "float", "Zoom level for model- use with care!"}, {"SHIFTY", "int", "Shifts model vertically (use with care!)"}, {"BIMAGE", "relative URL", "Image to be used as background"}};
        return stringArray;
    }

    public void modelReady() {
        this.showStatus("MDLMovie: Model read");
        this.debugOut("MDLMovie: Model read");
        this.mdlViewCanvas.modelReady();
        this.showStatus("MDLMovie: Generating animation");
        this.debugOut("MDLMovie: Generating animation");
        if (this.movieType == 2) {
            int n = this.myModel.getNumberOfAnimationFrames(0, this.loadframes.length - 1);
            this.myModel.setCurrentFrameIndex(0);
            n = Math.min(30, n);
            this.mdlMovieCanvas.setNumberOfFrames(n);
            int n2 = 0;
            while (n2 < n) {
                this.showStatus("MDLMovie: Generating frame " + n2);
                this.debugOut("MDLMovie: Generating frame " + n2);
                this.mdlMovieCanvas.addFrame(this.mdlViewCanvas.getImage(), this.myModel.getFrameDelayMillis(), n2);
                this.mdlViewCanvas.nextSimpleFrame();
                ++n2;
            }
        } else {
            this.mdlMovieCanvas.setNumberOfFrames(20);
            int n = 0;
            while (n < 20) {
                this.showStatus("MDLMovie: Generating frame " + n);
                this.mdlMovieCanvas.message = "Generating images...";
                this.mdlMovieCanvas.addFrame(this.mdlViewCanvas.getImage(), n);
                this.mdlViewCanvas.rotateZ(18);
                ++n;
            }
        }
        this.add("Center", this.mdlMovieCanvas);
        this.mdlMovieCanvas.startAnimation();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        this.showStatus("MDLMovie: Starting movie");
        this.mdlViewCanvas = null;
        this.myModel = null;
        this.initialised = true;
        this.repaint();
    }

    public void statusShow(String string) {
        this.showStatus(string);
    }

    public final String getAuthorInfo() {
        return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
    }

    private void readPalette(URL uRL, String string) {
        try {
            this.paletteURL = new URL(this.codeBase, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLView: Error in palette URL <" + malformedURLException + ">");
            this.showStatus("MDLView: Error in palette URL...");
        }
        this.showStatus("MDLView: Opening connection for palette as " + this.paletteURL);
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(this.paletteURL.openStream());
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.eolIsSignificant(true);
            int n2 = 0;
            while (n2 < 2) {
                n = streamTokenizer.nextToken();
                if (n != 10) continue;
                ++n2;
            }
            streamTokenizer.nextToken();
            n = (int)streamTokenizer.nval;
            if (n != 256) {
                System.out.println("MDLView: !CARE!.. Pal says " + n + " colours.. we use 255");
            }
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            streamTokenizer.eolIsSignificant(false);
            int n3 = 0;
            while (n3 < n) {
                streamTokenizer.nextToken();
                byArray[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray2[n3] = (byte)streamTokenizer.nval;
                streamTokenizer.nextToken();
                byArray3[n3] = (byte)streamTokenizer.nval;
                ++n3;
            }
            this.palette = new IndexColorModel(8, n, byArray, byArray2, byArray3, 255);
            inputStreamReader.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("MDLView: Error reading palette- <" + iOException + ">");
            this.showStatus("MDLView: Error reading palette- <" + iOException + ">");
            return;
        }
    }

    private int intFromFourBytes(byte[] byArray) {
        int n = 0;
        n |= (byArray[0] & 0xFF) << 24;
        n |= (byArray[1] & 0xFF) << 16;
        n |= (byArray[2] & 0xFF) << 8;
        return n |= byArray[3] & 0xFF;
    }

    private float floatFromFourBytes(byte[] byArray) {
        float f = 0.0f;
        int n = this.intFromFourBytes(byArray);
        f = Float.intBitsToFloat(n);
        return f;
    }

    private int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.intFromFourBytes(byArray);
    }

    private float readFloat(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[3 - n] = (byte)inputStream.read();
            ++n;
        }
        return this.floatFromFourBytes(byArray);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.mdlMovieCanvas.isAnimated()) {
            this.showStatus("MDLMovie: Starting movie...");
            this.mdlMovieCanvas.startAnimation();
        } else {
            this.showStatus("MDLMovie: Stopping movie..");
            this.mdlMovieCanvas.stopAnimation();
        }
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.requestFocus();
        return false;
    }

    private int[] getLoadFrames() {
        String string = this.getParameter("LOADFRAMES");
        if (string == null) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        return this.intArrayFromString(string, "load frames");
    }

    private int[] getLoadSkins() {
        String string = this.getParameter("LOADSKINS");
        if (string == null) {
            int[] nArray = new int[]{-1};
            return nArray;
        }
        return this.intArrayFromString(string, "load skins");
    }

    protected int[] intArrayFromString(String string, String string2) {
        Object object;
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String string3 = stringTokenizer.nextToken();
        try {
            n = Integer.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MDLView: Error in " + string2 + " string... loading all frames/skins");
            int[] nArray = new int[]{-1};
            return nArray;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).indexOf("-") >= 0) {
                if (((String)object).indexOf("-") == 0 || ((String)object).indexOf("-") == ((String)object).length()) {
                    System.out.println("MDLView: Error LOADFRAMES token starts/ends with hyphen not a number");
                    continue;
                }
                String string4 = ((String)object).substring(0, ((String)object).lastIndexOf("-"));
                String string5 = ((String)object).substring(((String)object).lastIndexOf("-") + 1, ((String)object).length());
                try {
                    int n3 = Integer.decode(string4);
                    int n4 = Integer.decode(string5);
                    if (n3 < n4 && n3 >= 0 && n4 >= 0) {
                        int n5 = n3;
                        while (n5 <= n4) {
                            nArray[n2] = n5++;
                            ++n2;
                        }
                        continue;
                    }
                    System.out.println("MDLView: " + string2 + ", bad start/end values, " + n3 + ", " + n4 + ", items may be missing");
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("MDLView: Error in " + string2 + " items may be missing");
                }
                continue;
            }
            try {
                int n6;
                nArray[n2] = n6 = Integer.decode((String)object).intValue();
                ++n2;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("MDLView: Error in " + string2 + " items may be missing");
            }
        }
        object = new int[n2];
        int n7 = 0;
        while (n7 < n2) {
            object[n7] = nArray[n7];
            ++n7;
        }
        return object;
    }

    private void getModel(URL uRL, String string, int[] nArray, int[] nArray2, int n) {
        this.mdlMovieCanvas.message = "Loading model...";
        try {
            this.modelURL = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MDLView: Error in model URL <" + malformedURLException + ">");
            this.showStatus("MDLView: Error in model URL...");
        }
        this.myModel.readModel(this.modelURL, nArray, nArray2, n);
        this.showStatus("MDLView: Opening connection for model as " + this.modelURL);
    }

    private Color getColourFromHex(String string) throws NumberFormatException {
        String string2 = "0x" + string.substring(1, 3);
        String string3 = "0x" + string.substring(3, 5);
        String string4 = "0x" + string.substring(5, 7);
        int n = Integer.decode(string2);
        int n2 = Integer.decode(string3);
        int n3 = Integer.decode(string4);
        return new Color(n, n2, n3);
    }
}

