/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class MDLMonitorWindow
extends Frame
implements Runnable {
    MDLViewCanvas myCanvas;
    MDLModel myModel;
    long startTime;
    Thread monitorThread;
    static final Label padding = new Label("                                                                                                            ");
    static Button okBut;
    static Panel okPan;
    static Panel textPan;
    static Label modelLabel;
    Label frames;
    Label skins;
    Label others;
    static Label canvasLabel;
    Label frameTime;
    Label currentFrame;
    Label currentSkin;
    Label angles;
    Label zoom;
    Label shifty;

    public MDLMonitorWindow(MDLViewCanvas myCan, MDLModel myMod, String modName) {
        this.setForeground(Color.black);
        this.startTime = System.currentTimeMillis();
        this.myCanvas = myCan;
        this.myModel = myMod;
        this.setTitle("MDLView Monitor: " + modName);
        this.setLayout(new BorderLayout());
        okBut = new Button("Dismiss");
        okPan = new Panel();
        textPan = new Panel();
        textPan.setLayout(new GridLayout(0, 1));
        okPan.add(okBut);
        modelLabel = new Label("MODEL INFO:");
        this.frames = new Label("Frames loaded: ??");
        this.skins = new Label("Skins loaded: ??");
        this.others = new Label("Vertices: ??  Triangles: ??");
        canvasLabel = new Label("RENDERER INFO:");
        this.frameTime = new Label("Rendertime: ??ms");
        this.currentFrame = new Label("Frame: ?,?,?");
        this.currentSkin = new Label("Skin: ?");
        this.angles = new Label("Angles Y: ?, X: ?");
        this.zoom = new Label("Zoom: ?");
        this.shifty = new Label("Vertical shift: ??");
        textPan.add(padding);
        textPan.add(modelLabel);
        textPan.add(this.frames);
        textPan.add(this.skins);
        textPan.add(this.others);
        textPan.add(canvasLabel);
        textPan.add(this.frameTime);
        textPan.add(this.currentFrame);
        textPan.add(this.currentSkin);
        textPan.add(this.angles);
        textPan.add(this.zoom);
        textPan.add(this.shifty);
        this.add("Center", textPan);
        this.add("South", okPan);
        this.pack();
        this.show();
    }

    public final String getAuthorInfo() {
        return "Copyright Thomas James Grey 1998";
    }

    public void show() {
        super.show();
        this.monitorThread = new Thread(this);
        this.monitorThread.start();
    }

    public void run() {
        while (this.isVisible()) {
            try {
                if (this.myModel.getModelReady()) {
                    this.frames.setText("Frames loaded: " + this.myModel.getFramesString());
                    this.skins.setText("Skins loaded: " + this.myModel.getSkinsString());
                    this.others.setText("Vertices: " + this.myModel.getNumberOfVertices() + " Triangles: " + this.myModel.getNumberOfTriangles());
                    this.frameTime.setText("Rendertime: " + this.myCanvas.getFrameTime() + "ms");
                    this.currentFrame.setText("Frame: " + this.myCanvas.getFrameNumber() + ", " + this.myCanvas.getFrameName());
                    this.currentSkin.setText("Skin: " + this.myModel.getCurrentSkinIndex());
                    this.angles.setText("Angles Y: " + this.myCanvas.getTheta() + ", X: " + this.myCanvas.getPhi());
                    this.zoom.setText("Zoom: " + this.myCanvas.getZoom());
                    this.shifty.setText("Vertical shift: " + this.myModel.getYShift());
                }
                this.startTime += 95L;
                this.repaint();
                Thread.sleep(Math.max(0L, this.startTime - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof Button) {
            ((Component)this).hide();
            return true;
        }
        return false;
    }
}

