//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "mdl.h"
#include "mdl_gif.h"
#include <math.h>

typedef unsigned char byte;

void add_frame_raw(MDL_model *model, char *fname, double *);
void insert_frame_raw(int frame, MDL_model *, double *);
void add_frame_ptlist(MDL_model *model, char *fname, BG_3pt *);
void insert_frame_ptlist(int frame, MDL_model *, BG_3pt *);
void new_frame_raw(MDL_model *model, char *fname, double *, int);
// import frames: raw
int import_mdl_frame(char *filename, int frame, MDL_model *model)
{

//	if(frame<=0)
//	{
//		printf("Error: Too small of a frame number\n");
//		getch();
//		return 1;
//	}

	strlwr(filename);
	// jethro tull rules... I hate this windows key on my new keyboard...
	// queensyche rules too... now I'm getting used to that key...
	if(strstr(filename,".raw"))
	{
		FILE *in;
		char str[256];

		double *rv;

		in=fopen(filename,"rt");
		if(in==NULL) { printf("Error: can't open file\n"); getch(); return 1; }
		if(!quiet) printf("reading raw file...\n");

		unsigned num_read_v=0;
		unsigned length;
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) break;
			// if a number add vertex
			if(((str[0]>=48)&&(str[0]<=57))||(str[0]==43)||(str[0]==45)||(str[0]==46))
			{
				num_read_v++;
			}
		}

		rv=new (double)[num_read_v];
		if(rv==NULL) exit(1);
		num_read_v=0;
		rewind(in);
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) break;
			// if a number add vertex
			if(((str[0]>=48)&&(str[0]<=57))||(str[0]==43)||(str[0]==45)||(str[0]==46))
			{
				num_read_v++;
				if(model->num_frames!=0)
				{
					if(num_read_v>(model->num_triangles*9))
					{
						printf("\nError: Number of points read is greater than those used in the model!\n");
						printf("Hit any key...\n");
						getch();
						fclose(in);
						return 1;
					}
				}
				*(rv+num_read_v-1)=(double)atof(str);
			}
		}
		//switch order (rotate about z axis 90 degrees)
		for(int i=0; i<num_read_v; i+=3)
		{
			float temp;
			temp=rv[i]; rv[i]=rv[i+1]; rv[i+1]=-temp;
		}

		if(model->num_frames!=0)
		{
			if(num_read_v<(model->num_triangles*9))
			{
				printf("\nError: Number of points read is less than those used in the model!\n");
				printf("Hit any key...\n");
				getch();
				fclose(in);
				return 1;
			}
			if(frame>model->blocks)
			{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
				strncpy(name,filename,16);
				ptr=strpbrk(name,".");
				ptr[0]=0;
				ptr++;
				strcpy(ptr,"MedDLe");

				add_frame_raw(model,name,rv);
			}
			else
			 insert_frame_raw(frame-1, model, rv);
		}
		else
		{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
			strncpy(name,filename,16);
			ptr=strpbrk(name,".");
			ptr[0]=0;
			ptr++;
			strcpy(ptr,"MedDLe");

			new_frame_raw(model,name,rv,num_read_v);
		}
		delete [] rv;

		fclose(in);

	}
	else if(strstr(filename,".asc"))
	{
		FILE *in;
		char str[256];

		in=fopen(filename,"rt");
		if(in==NULL) { printf("Error: can't open file\n"); getch(); return 1; }
		if(!quiet) printf("reading asc file...\n");


		char *keyword[]={"vertices","vertex","faces","face",NULL};

		unsigned num_verts=0;
		unsigned num_tris=0;
		float *base_pts;
		int *tri;
		unsigned tri_cnt=0;
		unsigned base_cnt=0;

		unsigned length;
		unsigned prev_size=0;
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) break;
			for(int i=0; keyword[i]!=NULL; i++)
			{
				strlwr(str);
				if(strstr(str,keyword[i]))
				{
					char junk[16];
					switch (i)
					{
						case 0:
						int verts;
						fscanf(in,"%s",str);
						verts=atoi(str);
						if(num_verts>0)
							base_pts=(float*)realloc(base_pts,(verts+num_verts)*4*3);
						else
							base_pts=(float*)calloc((verts+num_verts)*3,4);
						prev_size=num_verts;
						num_verts+=verts;
						break;

						case 1: //get vertex
						int vertnum;
						fscanf(in,"%s",str);
						strlwr(str);
						if(!strstr(str,"list"))
						{
							vertnum=atoi(str);
							for(int j=0; j<3; j++)
							{

								fscanf(in,"%s",str);
								char *p;
								if(!(p=strstr(str,":"))) p=&str[0];
								else
								{
									int l;

									l=strlen(p);
									if(l<=1) {fscanf(in,"%s",str);p=&str[0];}
									else p++;
								}
								base_pts[base_cnt++]=atoi(p);
							}
						 //	for(int j=0; j<3; j++)
							//{
							//	fscanf(in,"%s%s",junk,str);
							//	base_pts[base_cnt++] =atof(str);
						 //	}
						}
						break;

						case 2:
						int faces;
						fscanf(in,"%s",str);
						faces=atoi(str);
						if(num_tris>0)
							tri=(int*)realloc(tri,(faces+num_tris)*4*3);
						else
							tri=(int*)calloc((faces+num_tris)*3,4);
						num_tris+=faces;
						break;

						case 3:
						int facenum;
						fscanf(in,"%s",str);
						strlwr(str);
						if(!strstr(str,"list"))
						{
							facenum=atoi(str);
							for(int j=0; j<3; j++)
							{
								fscanf(in,"%s",str);
								char *p;
								if(!(p=strstr(str,":"))) p=&str[0];
								else p++;

								tri[tri_cnt++]=atoi(p)+prev_size;
							}

						}
						break;

					}
					break;
				}

			}

		}
		fclose(in);

//		if(!quiet) printf("verts:%u tris:%u\n",num_verts,num_tris);
//		if(!quiet) printf("read v:%u read t:%u\n",base_cnt,tri_cnt);
//		getch();
		unsigned v1,v2,v3;
		double *rv;
		rv=new(double)[num_tris*9];
		// now stic in raw form!
		unsigned cnt=0;
		for(int i=0; i<num_tris; i++)
		{
//			for(int j=0; j<3; j++)
			{
				// reverse order
				int j=0;
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]];
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]+1];
				rv[cnt++]=(double)base_pts[3*tri[i*3+j]+2];
				j=2;
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]];
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]+1];
				rv[cnt++]=(double)base_pts[3*tri[i*3+j]+2];
				j=1;
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]];
				rv[cnt++]=-(double)base_pts[3*tri[i*3+j]+1];
				rv[cnt++]=(double)base_pts[3*tri[i*3+j]+2];
			}
		}
//		if(!quiet) printf("cnt:%u to %u\n",cnt,model->num_triangles*9);

		free(base_pts);
		free(tri);


		//switch order (rotate about z axis 90 degrees)
		for(int i=0; i<cnt; i+=3)
		{
			float temp;
			temp=rv[i]; rv[i]=rv[i+1]; rv[i+1]=-temp;
		}

		if(model->num_frames!=0)
		{
			if(cnt!=(model->num_triangles*9))
			{
				printf("\nError: Number of points read different from that in model!\n");
				printf("Hit any key...\n");
				getch();
				fclose(in);
				return 1;
			}
			if(frame>model->blocks)
			{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
				strncpy(name,filename,16);
				ptr=strpbrk(name,".");
				ptr[0]=0;
				ptr++;
				strcpy(ptr,"MedDLe");

				add_frame_raw(model,name,rv);
			}
			else
			 insert_frame_raw(frame-1, model, rv);
		}
		else
		{
				char name[32];
				char *ptr,*p,*q;
				while((p=strpbrk(filename,"\\"))||(q=strpbrk(filename,"/")))
				{
					if(p>q) strcpy(filename,++p);
					else strcpy(filename,++q);
				}
			strncpy(name,filename,16);
			ptr=strpbrk(name,".");
			ptr[0]=0;
			ptr++;
			strcpy(ptr,"MedDLe");
			new_frame_raw(model,name,rv,cnt);
		}
		delete [] rv;

	}
	else
	{
		printf("Don't know that file extension for a frame.\n");
//		getch();
		return 1;
	}


	return 0;
}
void new_frame_raw(MDL_model *model, char *fname, double *raw_pts, int n)
{
	model->num_frames=1;
	model->frame = new (struct MDL_frame);
	model->frame[0].type=0;
  for (int i=0; i<16; i++)
	{
		model->frame[0].sframe.name[i]=fname[i];
  }

	// construct pt list
	float x,y,z;
	double *pt_list;
	double minx,miny,minz,maxx,maxy,maxz;
	pt_list=new(double)[n];
	pt_list[0]=raw_pts[0];pt_list[1]=raw_pts[1];pt_list[2]=raw_pts[2];
	minx=raw_pts[0];miny=raw_pts[1];minz=raw_pts[2];
	maxx=raw_pts[0];maxy=raw_pts[1];maxz=raw_pts[2];
	model->num_vertices=1;
	model->num_triangles=n/9;
	model->triangle = new (unsigned)[model->num_triangles*4];


	// construct the triangles
	int vc=0;
//	printf("making 3d faces\n");
	model->num_vertices=0;

	for(int i=0; i<model->num_triangles; i++)
	{
		model->triangle[i*4]=0; // on back
		for(int k=0; k<3; k++)
		{
			int vertnum=-1;

			x=raw_pts[vc++]; y=raw_pts[vc++]; z=raw_pts[vc++];

			for(int j=0; j<model->num_vertices;j++)
			{
				if((x==pt_list[j*3])&&(y==pt_list[j*3+1])&&(z==pt_list[j*3+2]))
				{
					vertnum=j;
			//		model->triangle[i*4+1+k]=j;
					break;
				}
			}
			if (vertnum == -1)
			{
				int N=model->num_vertices;
				pt_list[N*3]=x;pt_list[N*3+1]=y;pt_list[N*3+2]=z;
				vertnum = model->num_vertices;
				model->num_vertices++;
				if(x<minx) minx=x;
				if(y<miny) miny=y;
				if(z<minz) minz=z;
				if(x>maxx) maxx=x;
				if(y>maxy) maxy=y;
				if(z>maxz) maxz=z;

			}

		model->triangle[i*4+1+k]= vertnum;

		}
	}
	model->frame[0].sframe.tv = new (trivertex)[model->num_vertices];

	model->xoffset=minx;
	model->yoffset=miny;
	model->zoffset=minz;
	model->xscale=(maxx-minx)/255.7;
	model->yscale=(maxy-miny)/255.7;
	model->zscale=(maxz-minz)/255.7;
	model->radius= sqrt((maxx-minx) * (maxx-minx) +
								 (maxy-miny)* (maxy-miny) +
								(maxz-minz) * (maxz-minz));

//	setup_3d_data(model);
	delete [] pt_list;
	printf("triangles: %d\n",model->num_triangles);
	printf("vertices: %d\n",model->num_vertices);

	printf("adding data to model\n");
	insert_frame_raw(-1, model, raw_pts);


}

void insert_frame_raw(int frame, MDL_model *model, double *raw_pts)
{

	if(frame!=-1)
	{

		// get bounds of raw points
		unsigned k=0;
		double rx,ry,rz;
		double rxmin,rxmax,rymin,rymax,rzmin,rzmax;
		rxmin= raw_pts[0];
		rymin= raw_pts[1];
		rzmin= raw_pts[2];
		rxmax= raw_pts[0];
		rymax= raw_pts[1];
		rzmax= raw_pts[2];
		for(int j=0; j< model->num_triangles*3; j++)
		{

				rx=raw_pts[k++];
				ry=raw_pts[k++];
				rz=raw_pts[k++];

				if(rx>rxmax) rxmax=rx;
				if(ry>rymax) rymax=ry;
				if(rz>rzmax) rzmax=rz;
				if(rx<rxmin) rxmin=rx;
				if(ry<rymin) rymin=ry;
				if(rz<rzmin) rzmin=rz;
		}
		// get the max and min of all
		unsigned num_pts=model->num_vertices;
		for (int i=0; i<model->blocks; i++)
		{
			//min
			if(model->block[i].ptlist[num_pts].x<rxmin) rxmin=model->block[i].ptlist[num_pts].x;
			if(model->block[i].ptlist[num_pts].y<rymin) rymin=model->block[i].ptlist[num_pts].y;
			if(model->block[i].ptlist[num_pts].z<rzmin) rzmin=model->block[i].ptlist[num_pts].z;
			//max
			if(model->block[i].ptlist[num_pts+1].x>rxmax) rxmax=model->block[i].ptlist[num_pts+1].x;
			if(model->block[i].ptlist[num_pts+1].y>rymax) rymax=model->block[i].ptlist[num_pts+1].y;
			if(model->block[i].ptlist[num_pts+1].z>rzmax) rzmax=model->block[i].ptlist[num_pts+1].z;

		}

		double rxs;
		rxs=(rxmax-rxmin)/255.7;
		double rys;
		rys=(rymax-rymin)/255.7;
		double rzs;
		rzs=(rzmax-rzmin)/255.7;
		int rescale=0;

		if(rxs>model->xscale) {rescale=1; model->xscale=rxs;}
		if(rys>model->yscale) {rescale=1; model->yscale=rys;}
		if(rzs>model->zscale) {rescale=1; model->zscale=rzs;}
		if(rxmin<model->xoffset) {rescale=1; model->xoffset=rxmin;}
		if(rymin<model->yoffset) {rescale=1; model->yoffset=rymin;}
		if(rzmin<model->zoffset) {rescale=1; model->zoffset=rzmin;}

		// must recalculate all with new bounds!
		if( rescale==1 )
		{
			printf("resizing frames..\n");
			double xo=model->xoffset;
			double yo=model->yoffset;
			double zo=model->zoffset;

			for(int f=0; f<model->blocks; f++)
			{
				byte xmin=255,xmax=0;
				byte ymin=255,ymax=0;
				byte zmin=255,zmax=0;

				k=0;

				unsigned p;
				for(int j=0; j< model->num_triangles; j++)
				{
					byte x,y,z;

					//each vertex of triangle
					for(int i=0; i<3; i++)
					{
						p=model->triangle[j*4L+1L+i];
						x=(byte)((model->block[f].ptlist[p].x-xo)/model->xscale);
						y=(byte)((model->block[f].ptlist[p].y-yo)/model->yscale);
						z=(byte)((model->block[f].ptlist[p].z-zo)/model->zscale);
						model->frame[f].sframe.tv[p].v[0]=x;
						model->frame[f].sframe.tv[p].v[1]=y;
						model->frame[f].sframe.tv[p].v[2]=z;

						if(x>xmax) xmax=x;
						if(y>ymax) ymax=y;
						if(z>zmax) zmax=z;
						if(x<xmin) xmin=x;
						if(y<ymin) ymin=y;
						if(z<zmin) zmin=z;
					}

				}
				model->frame[f].sframe.bboxmin.v[0]=xmin;
				model->frame[f].sframe.bboxmin.v[1]=ymin;
				model->frame[f].sframe.bboxmin.v[2]=zmin;
				model->frame[f].sframe.bboxmax.v[0]=xmax;
				model->frame[f].sframe.bboxmax.v[1]=ymax;
				model->frame[f].sframe.bboxmax.v[2]=zmax;
			}
		}

		delete_3d_data(model);
	}

	// else new frame
	else frame=0;

	// every
	double xo=model->xoffset;
	double yo=model->yoffset;
	double zo=model->zoffset;
	byte xmin=255,xmax=0;
	byte ymin=255,ymax=0;
	byte zmin=255,zmax=0;
	unsigned p;

	unsigned k=0;

	for(int j=0; j< model->num_triangles; j++)
	{
		unsigned p;
		int x,y,z;
		for(int i=0; i<3; i++)
		{
			p=model->triangle[j*4L+1L+i];
			x=((raw_pts[k++]-xo)/model->xscale);
			y=((raw_pts[k++]-yo)/model->yscale);
			z=((raw_pts[k++]-zo)/model->zscale);
      if(x>255) x=255;
			if(y>255) y=255;
			if(z>255) z=255;
      if(x<0) x=0;
      if(y<0) y=0;
      if(z<0) z=0;
 			model->frame[frame].sframe.tv[p].v[0]=x;
			model->frame[frame].sframe.tv[p].v[1]=y;
			model->frame[frame].sframe.tv[p].v[2]=z;

			if(x>xmax) xmax=x;
			if(y>ymax) ymax=y;
			if(z>zmax) zmax=z;
			if(x<xmin) xmin=x;
			if(y<ymin) ymin=y;
			if(z<zmin) zmin=z;
		}
	}
//	printf("bounding boxs\n");
	model->frame[frame].sframe.bboxmin.v[0]=xmin;
	model->frame[frame].sframe.bboxmin.v[1]=ymin;
	model->frame[frame].sframe.bboxmin.v[2]=zmin;
	model->frame[frame].sframe.bboxmax.v[0]=xmax;
	model->frame[frame].sframe.bboxmax.v[1]=ymax;
	model->frame[frame].sframe.bboxmax.v[2]=zmax;

	// set up 3d data
//	printf("set up normals\n");
	setup_3d_data(model);

	// now find vertex normals!
	#include"mdl_norm.h"


	double avex,avey,avez;
	int norm_count;
	BG_3pt vnormal;
	for(int j=0;j<model->num_vertices; j++)
	{
		avex=avey=avez=0.0;
		norm_count=0;

		for(int i=0; i<model->num_triangles; i++)
		{

			if((j==model->triangle[i*4L+1L])||(j==model->triangle[i*4L+2L])||(j==model->triangle[i*4L+3L]) )
			{
				avex+=model->block[frame].side_normal[i].x;
				avey+=model->block[frame].side_normal[i].y;
				avez+=model->block[frame].side_normal[i].z;
				norm_count++;
			}

		}
		vnormal.x=avex/(double)norm_count;
		vnormal.y=avey/(double)norm_count;
		vnormal.z=avez/(double)norm_count;
		int k=0; /// this is the index!
		double dotted_val, hi_dot;
		hi_dot=BG_DotProduct(&vertex_normal[0],&vnormal);

		for(int i=1; i<162; i++)
		{
			dotted_val=BG_DotProduct(&vertex_normal[i],&vnormal);
			if(dotted_val>hi_dot)
			{
				hi_dot=dotted_val;
				k=i;
			}
		}

		model->frame[frame].sframe.tv[j].vnormal=(unsigned char)k;
	}

}


// only works for non-group type only
// ie you can't add to groups of frames (like flame)

void add_frame_raw(MDL_model *model, char *fname, double *raw_pts)
{
	struct MDL_frame *frame;
	frame = new (struct MDL_frame)[model->num_frames];

	delete_3d_data(model);

	// copy all frame data
	for(int k=0; k<model->num_frames;  k++)
	{
		frame[k].type=model->frame[k].type;
		if(frame[k].type==0)
		{
			memcpy(frame[k].sframe.bboxmin.v,model->frame[k].sframe.bboxmin.v,3);
			memcpy(frame[k].sframe.bboxmax.v,model->frame[k].sframe.bboxmax.v,3);
			for(int ii=0; ii<16; ii++) frame[k].sframe.name[ii]=model->frame[k].sframe.name[ii];
			frame[k].sframe.tv = new (trivertex)[model->num_vertices];
			memcpy(frame[k].sframe.tv,model->frame[k].sframe.tv,sizeof(trivertex)*model->num_vertices);
		}

		else
		{
			frame[k].gframe.num_gsframes=model->frame[k].gframe.num_gsframes;
			memcpy(frame[k].gframe.bboxmin.v,model->frame[k].gframe.bboxmin.v,3);
			memcpy(frame[k].gframe.bboxmax.v,model->frame[k].gframe.bboxmax.v,3);
			frame[k].gframe.gsframe_interval = new (float)[model->frame[k].gframe.num_gsframes];
			frame[k].gframe.gsframe = new (MDL_model_frame)[model->frame[k].gframe.num_gsframes];

			memcpy(frame[k].gframe.gsframe_interval,model->frame[k].gframe.gsframe_interval,sizeof(float)*model->frame[k].gframe.num_gsframes);

			for(int j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				memcpy(frame[k].gframe.gsframe[j].bboxmin.v,model->frame[k].gframe.gsframe[j].bboxmin.v,3);
				memcpy(frame[k].gframe.gsframe[j].bboxmax.v,model->frame[k].gframe.gsframe[j].bboxmax.v,3);
				strncpy(frame[k].gframe.gsframe[j].name,model->frame[k].gframe.gsframe[j].name,16);
				frame[k].gframe.gsframe[j].tv = new (trivertex)[model->num_vertices];
				memcpy(frame[k].gframe.gsframe[j].tv,model->frame[k].gframe.gsframe[j].tv,sizeof(trivertex)*model->num_vertices);

			}
		}
	}

	// delete original data
	for(int k=0; k<model->num_frames;  k++)
	{
		if(model->frame[k].type==0)
			delete [] model->frame[k].sframe.tv;

		else
		{

			for(int j=0; j<model->frame[k].gframe.num_gsframes; j++)
			delete [] model->frame[k].gframe.gsframe[j].tv;
			delete [] model->frame[k].gframe.gsframe_interval;
			delete [] model->frame[k].gframe.gsframe;
		}
	}
	delete [] model->frame;


	model->num_frames++;
	model->frame = new (struct MDL_frame)[model->num_frames];

	//model->frame = (MDL_frame *)realloc(model->frame,sizeof(MDL_frame)*model->num_frames);
	//reload everything now
	for(int k=0; k<(model->num_frames-1);  k++)
	{
		model->frame[k].type=frame[k].type;
		if(model->frame[k].type==0)
		{
			memcpy(model->frame[k].sframe.bboxmin.v,frame[k].sframe.bboxmin.v,3);
			memcpy(model->frame[k].sframe.bboxmax.v,frame[k].sframe.bboxmax.v,3);
			for(int ii=0; ii<16; ii++) model->frame[k].sframe.name[ii]=frame[k].sframe.name[ii];
			model->frame[k].sframe.tv = new (trivertex)[model->num_vertices];
			memcpy(model->frame[k].sframe.tv,frame[k].sframe.tv,sizeof(trivertex)*model->num_vertices);
		}

		else
		{
			model->frame[k].gframe.num_gsframes=frame[k].gframe.num_gsframes;
			memcpy(model->frame[k].gframe.bboxmin.v,frame[k].gframe.bboxmin.v,3);
			memcpy(model->frame[k].gframe.bboxmax.v,frame[k].gframe.bboxmax.v,3);
			model->frame[k].gframe.gsframe_interval = new (float)[model->frame[k].gframe.num_gsframes];
			model->frame[k].gframe.gsframe = new (MDL_model_frame)[model->frame[k].gframe.num_gsframes];

			memcpy(model->frame[k].gframe.gsframe_interval,frame[k].gframe.gsframe_interval,sizeof(float)*model->frame[k].gframe.num_gsframes);

			for(int j=0; j<model->frame[k].gframe.num_gsframes; j++)
			{
				memcpy(model->frame[k].gframe.gsframe[j].bboxmin.v,frame[k].gframe.gsframe[j].bboxmin.v,3);
				memcpy(model->frame[k].gframe.gsframe[j].bboxmax.v,frame[k].gframe.gsframe[j].bboxmax.v,3);
				strncpy(model->frame[k].gframe.gsframe[j].name,frame[k].gframe.gsframe[j].name,16);
				model->frame[k].gframe.gsframe[j].tv = new (trivertex)[model->num_vertices];
				memcpy(model->frame[k].gframe.gsframe[j].tv,frame[k].gframe.gsframe[j].tv,sizeof(trivertex)*model->num_vertices);
			}
		}
	}

	// add the new frame (use other vertices)
	model->frame[model->num_frames-1].type=0;
//	for(ii=0; ii<16; ii) model->frame[k].sframe.name[ii]=frame[k].sframe.name[ii];

	for(int ii=0; ii<16; ii++) model->frame[model->num_frames-1].sframe.name[ii]=fname[ii];
	memcpy(model->frame[model->num_frames-1].sframe.bboxmin.v,model->frame[model->num_frames-2].sframe.bboxmin.v,3);
	memcpy(model->frame[model->num_frames-1].sframe.bboxmax.v,model->frame[model->num_frames-2].sframe.bboxmax.v,3);
	model->frame[model->num_frames-1].sframe.tv = new (trivertex)[model->num_vertices];
	memcpy(model->frame[model->num_frames-1].sframe.tv,model->frame[model->num_frames-2].sframe.tv,sizeof(trivertex)*model->num_vertices);

	//set the 3d data
	setup_3d_data(model);

	// delete temp stuff
	for(int k=0; k<(model->num_frames-1);  k++)
	{
		if(frame[k].type==0)
			delete [] frame[k].sframe.tv;

		else
		{

			for(int j=0; j<frame[k].gframe.num_gsframes; j++)
				delete [] frame[k].gframe.gsframe[j].tv;
			delete [] frame[k].gframe.gsframe_interval;
			delete [] frame[k].gframe.gsframe;
		}
	}
	delete [] frame;

	insert_frame_raw(model->num_frames-1, model, raw_pts);

}




int import_mdl_skin(char *filename, int skin, MDL_model *model)
{

	strlwr(filename);
	if(strstr(filename,".gif"))
	{
		int	Error, NumFiles, ExtCode;
		GifRecordType RecordType;
		GifByteType *Extension;
		GifRowType *ImageBuffer;
		GifFileType *GifFileIn = NULL;

		unsigned char bmppal[256*3];
		unsigned bmpw, bmph;
		unsigned char *pic;
		int i,j;

		GifFileIn = DGifOpenFileName(filename);
		if(GifFileIn == NULL) return 1;
		do
		{
			if (DGifGetRecordType(GifFileIn, &RecordType) == 0) exit(1);

			switch (RecordType)
			{
				case IMAGE_DESC_RECORD_TYPE:
					if (DGifGetImageDesc(GifFileIn) == 0) exit(1);
					pic = new (unsigned char)[GifFileIn->Image.Height*GifFileIn->Image.Width];
					for (i = 0; i < GifFileIn->Image.Height; i++)
						DGifGetLine(GifFileIn, &pic[i*GifFileIn->Image.Width], GifFileIn->Image.Width);
					break;
				case EXTENSION_RECORD_TYPE:
					/* Skip any extension blocks in file: */
					DGifGetExtension(GifFileIn, &ExtCode, &Extension);
					/* No support to more than one extension blocks, so discard: */
					while (Extension != NULL) DGifGetExtensionNext(GifFileIn, &Extension);
					break;
				case TERMINATE_RECORD_TYPE:
					break;
			}
		}while (RecordType != TERMINATE_RECORD_TYPE);

		bmpw=GifFileIn->Image.Width;
		bmph=GifFileIn->Image.Height;

		for (i = 0; i < 256; i++)
		{
			bmppal[i*3]=GifFileIn->SColorMap->Colors[i].Red;
			bmppal[i*3+1]=GifFileIn->SColorMap->Colors[i].Green;
			bmppal[i*3+2]=GifFileIn->SColorMap->Colors[i].Blue;
		}

		DGifCloseFile(GifFileIn);

		// now stick the info in the model...
		// match colors up
		if(!quiet) printf("matching colors\n");
		char close_color[256];
		for(i=0; i<256; i++)
		{
			close_color[i]=i;
			float error, error0=1.566e5;
			float e1,e2,e3;
			for(j=0; j<256; j++)
			{
				e1= (float)(pal[j*3]-bmppal[i*3]);
				e2= (float)(pal[j*3+1]-bmppal[i*3+1]);
				e3= (float)(pal[j*3+2]-bmppal[i*3+2]);
				error=e1*e1+e2*e2+e3*e3;
				if(error<=error0)
				{
					error0=error;
					close_color[i]=j;
				}
			}
		}

		//if adding a skin (not replacing)
		if(skin>model->num_skins)
		{
//			printf("adding ...\n");
			model->num_skins=1+model->num_skins;
			skin=model->num_skins;
			// make room for more skin!
			struct MDL_model_skin *tempskin;
			tempskin=new(MDL_model_skin)[model->num_skins-1];
			memcpy (tempskin, model->skin,sizeof(MDL_model_skin)*(model->num_skins-1));
			delete [] model->skin;
			model->skin = new (MDL_model_skin)[model->num_skins];
			memcpy (model->skin,tempskin,sizeof(MDL_model_skin)*(model->num_skins-1));
			delete [] tempskin;
//			model->skin =(MDL_model_skin *)realloc[model->skin,sizeof(MDL_model_skin)*model->num_skins];
			model->skin[skin-1].bitmap=new (unsigned char)[model->skinw*model->skinh];
			model->skin[skin-1].type=0;

		}

		// resize pic if needed and add to model
		if(!quiet) printf("resizing pic\n");
		double scalew, scaleh;
		scalew=(double)(bmpw)/(double)(model->skinw);
		scaleh=(double)(bmph)/(double)(model->skinh);

		for(j=0; j<model->skinh;j++)
		{
			for(i=0;i<model->skinw;i++)
			{
				unsigned pic_index;
				double di, dj;
				di=(double)i;
				dj=(double)j;
				pic_index=(unsigned)(scalew*di)+(unsigned)(scaleh*dj)*(bmpw);
				model->skin[skin-1].bitmap[i+j*model->skinw]=close_color[pic[pic_index]];
			}
		}

		delete [] pic;

	}

	else if(strstr(filename,".bmp"))
	{
		FILE *in;
		unsigned char bmppal[256*3];
		unsigned bmpw, bmph;
		unsigned char *pic;
		int i,j;

		in=fopen(filename,"rb");
		if(in==NULL) return 1;
		rewind(in);
		fseek(in,18,SEEK_SET);
		fread(&bmpw,4,1,in);
		fread(&bmph,4,1,in);
		fseek(in,28,SEEK_CUR);

		for (i = 0; i < 256; i++)
		{
			fread(bmppal+i*3 + 2,1,1,in);
			fread(bmppal+i*3 + 1,1,1,in);
			fread(bmppal+i*3 + 0,1,1,in);
			fseek(in,1,SEEK_CUR);
		}

		//read new pic
		pic=new (unsigned char)[(bmpw*bmph)];
		int ali;
		unsigned char junk[4];
		//  this is to make length end on a long
		if(bmpw<4) ali=4-bmpw;
		else ali=bmpw%4;

		for(j=bmph;j>0;j--)
		{
			for(i=0;i<bmpw;i++)
			{
				fread(&pic[i+bmpw*(j-1)],1,1,in);
			}
			if(ali!=0) fread(&junk[0],ali,1,in);
		}
		fclose(in);

		// now stick the info in the model...
		// match colors up
		if(!quiet) printf("matching colors\n");
		char close_color[256];
		for(i=0; i<256; i++)
		{
			close_color[i]=i;
			float error, error0=1.566e5;
			float e1,e2,e3;
			for(j=0; j<256; j++)
			{
				e1= (float)(pal[j*3]-bmppal[i*3]);
				e2= (float)(pal[j*3+1]-bmppal[i*3+1]);
				e3= (float)(pal[j*3+2]-bmppal[i*3+2]);
				error=e1*e1+e2*e2+e3*e3;
				if(error<=error0)
				{
					error0=error;
					close_color[i]=j;
				}
			}

		}

		//if adding a skin (not replacing)
		if(skin>model->num_skins)
		{
			model->num_skins++; skin=model->num_skins;
			// make room for more skin!
//			model->skin =(MDL_model_skin *)realloc[model->skin,sizeof(MDL_model_skin)*model->num_skins];
			struct MDL_model_skin *tempskin;
			tempskin=new(MDL_model_skin)[model->num_skins-1];
			memcpy (tempskin, model->skin,sizeof(MDL_model_skin)*(model->num_skins-1));
			delete [] model->skin;
			model->skin = new (MDL_model_skin)[model->num_skins];
			memcpy (model->skin,tempskin,sizeof(MDL_model_skin)*(model->num_skins-1));
			delete [] tempskin;

			model->skin[skin-1].bitmap=new (unsigned char)[model->skinw*model->skinh];
			model->skin[skin-1].type=0;
		}

		// resize pic if needed and add to model
		if(!quiet) printf("resizing pic\n");
		double scalew, scaleh;
		scalew=(double)(bmpw)/(double)(model->skinw);
		scaleh=(double)(bmph)/(double)(model->skinh);

		for(j=0; j<model->skinh;j++)
		{
			for(i=0;i<model->skinw;i++)
			{
				unsigned pic_index;
				double di, dj;
				di=(double)i;
				dj=(double)j;
				pic_index=(unsigned)(scalew*di)+(unsigned)(scaleh*dj)*(bmpw);
				model->skin[skin-1].bitmap[i+j*model->skinw]=close_color[pic[pic_index]];
			}
		}

		delete [] pic;
	}
	else
	{
		printf("Don't know that file extension.\nHit a key.\n");
		getch();
		return 1;

	}
	return 0;

}