/***
****  QuBE --- Windowing routines for graphics display, if possible.
****
****  Definitely needs work; better support of, well, everything.
***/

#include "qube.h"

#ifdef QUBE_MSDOS
#include "svgagrph.h"
#include "svgamous.h"
#include "f14nsans.h"
#include "keyboard.h"
#endif
#ifdef QUBE_UNIX
#include "xgfx.h"
#endif

struct WinTag {
	struct WinTag *child, *parent;
	int x, y, width, height;
	void (*doevent)(int event, int window);
	int windnum;
};
typedef struct WinTag Win;

void InitWindow(void);
int OpenWindow(int x, y, width, height, void (*doevent)(int event, int window));
int CloseWindow(int window);
void WindPaint(int color, int window);
void TotalRepaint(void);

static void RootUpdate(int event, int window);

Win RootWin = { NULL, NULL, 0, 0, 640, 480, RootUpdate, 0 };
Win *LastWin = &RootWin;

static Win *hashtable[128];

static void RootUpdate(int event, int window)
{
}

void InitWindow(void)
{
	int i;

	for (i = 0; i < 128; i++)
		hashtable[i] = NULL;

	hashtable[0] = &RootWin;

	Repaint(0, 0, 639, 479);
}

int OpenWindow(int x, y, width, height, void (*doevent)(int event, int window))
{
	int w, wp;

	for (w = 0; w < 128 && hashtable[w] == NULL; w++);

	hashtable[w] = wp = Qmalloc(sizeof(Win));

	wp->x = x;
	wp->y = y;
	wp->width = width;
        wp->height = height;
	wp->doevent = doevent;
	wp->parent = LastWin;
	LastWin->child = wp;
        LastWin = wp;
	wp->child = NULL;

	Repaint(x, y, x+width-1, y+height-1);

	return(w);
}

int CloseWindow(int window)
{
	Win *wp = hashtable[window];

	hashtable[window] = NULL;
	wp->parent->child = wp->child;
	if (wp->child != NULL)
		wp->child->parent = wp->parent;
	else
		LastWin = wp->parent;

	Repaint(wp->x, wp->y, wp->x + wp->width - 1, wp->y + wp->height - 1);

	Qfree(wp);
}

void Repaint(int x1, y1, x2, y2)
{
	Area *canvas = MakeUnion(&RootWindow, x1, y1, x2, y2);

}
