#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "area.h"

static void DumpArea(Area *a);
static void DumpSpace(Area *a);

main()
{
	int x1, y1, x2, y2;
        Area *area1 = AreaCreate();

	clrscr();
        randomize();

	while (1) {
		x1 = random(80);
		x2 = random(80);
		y1 = random(24);
		y2 = random(24);

		if (x1 > x2) {
			int t = x1;
			x1 = x2;
			x2 = t;
		}
		if (y1 > y2) {
			int t = y1;
			y1 = y2;
			y2 = t;
		}

		gotoxy(1, 25);
		cprintf("(%d,%d)-(%d,%d)        ", x1, y1, x2, y2);

		textattr(0x70);
                gotoxy(x1+1, y1+1);
		cprintf("[");
		gotoxy(x1+1, y2);
		cprintf("{");
		gotoxy(x2, y1+1);
		cprintf("]");
		gotoxy(x2, y2);
		cprintf("}");
		textattr(0x07);

		gotoxy(1, 25);
                if (getch() == 27) exit(1);

		if (random(3))
			area1 = AreaUnionRect(area1, x1, y1, x2, y2);
		else
			area1 = AreaSubRect(area1, x1, y1, x2, y2);

                DumpSpace(area1);
	}
}

static void DumpArea(Area *a)
{
        int i;

	printf("%d\n", a->count);

	for (i = 0; i < a->count; i++)
		printf("(%d,%d)-(%d,%d)\n", a->rects[i].x1, a->rects[i].y1, a->rects[i].x2, a->rects[i].y2);

	printf("***\n");
}

static void DumpSpace(Area *a)
{
	int aspace[25][80];
	int x, y, i;

        for (y = 0; y < 23; y++)
		for (x = 0; x < 80; x++)
			aspace[y][x] = 0;
	for (i = 0; i < a->count; i++)
		for (y = a->rects[i].y1; y < a->rects[i].y2; y++)
			for (x = a->rects[i].x1; x < a->rects[i].x2; x++)
				aspace[y][x]++;

	for (y = 0; y < 23; y++) {
		for (x = 0; x < 79; x++) {
			gotoxy(x+1, y+1);
			if (aspace[y][x]) cprintf("%d", aspace[y][x]);
			else cprintf(" ");
		}
	}

	gotoxy(1, 25);
        if (getch() == 27) exit(1);
}

