/***
****  QuBE  --- Main header file.
***/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
**  This is the header on the BSP file.  Its definitions are now based on the
**  information available in the Unofficial Quake Specs, V3.0.	If you need to
**  know what the stuff below means, read my source or get the specs:
**  http://www.stud.montefiore.ulg.ac.be/ftp-mirror/quake/docs/
*/

struct headertag {
	/* File type identifier; appears to be 0x17 for .BSP files */
        unsigned long id;                       /* 00 - should be 17 */

	/* The entities list */
        unsigned long entities;                 /* 04 */
	unsigned long entitieslen;		/* 08 */

	/* The map planes */
	unsigned long planes;			/* 0C */
	unsigned long planeslen;		/* 10 */

	/* The wall textures */
        unsigned long pictures;                 /* 14 */
	unsigned long piclen;			/* 18 */

	/* The map vertices */
	unsigned long vertices; 		/* 1C */
	unsigned long verticeslen;		/* 20 */

	/* The visibility lists */
	unsigned long PVS;			/* 24 */
	unsigned long PVSlen;			/* 28 */

	/* Hull BSP nodes */
	unsigned long nodes;			/* 2C */
	unsigned long nodeslen; 		/* 30 */

	/* The map surfaces */
	unsigned long surfaces; 		/* 34 */
	unsigned long surfaceslen;		/* 38 */

	/* The light maps */
	unsigned long lightmaps;		/* 3C */
	unsigned long lightmapslen;		/* 40 */

	/* The hull BSP tree */
        unsigned long tree;                     /* 44 */
	unsigned long treelen;			/* 48 */

	/* The hull BSP leaves */
	unsigned long leaves;			/* 4C */
	unsigned long leaveslen;		/* 50 */

	/* The list of surfaces */
	unsigned long surfacelist;		/* 54 */
	unsigned long surfacelistlen;		/* 58 */

	/* The original surface edges */
	unsigned long orgedges; 		/* 5C */
	unsigned long orgedgeslen;		/* 60 */

	/* The list of surfaces edges */
	unsigned long edges;			/* 64 */
	unsigned long edgeslen; 		/* 68 */

	/* The list of hulls */
	unsigned long hulls;			/* 6C */
	unsigned long hullslen; 		/* 70 */
};

/* Structure of a vertex.  Note that it uses floating point.  That probably
   means that it'll be the first to change when the final release of Quake
   comes out. */

typedef struct {
	float x, y, z;
} vertex;

/* The header and the input file will be
   needed everywhere, so they're global */

extern struct headertag header;
extern FILE *fi;
extern int filenamearg;
extern int justcreated;
extern int verbose;

void Error(char *format, ...);
int main(int argc, char **argv);
int MatchName(char *expr, char *string);

void *Qmalloc(long int size);
void *Qrealloc(void *buffer, long int size);
void Qfree(void *buffer);

