/***
****  QuBE --- Vertex manipulation routines.
***/

#include "qube.h"
#include "edge.h"

/*
**  EdgeList.  Dumps out the edges in a BSP file.
*/

void EdgeList(void)
{
	short int i, j, k;
	unsigned long readcount;
	struct {
		int start, end;
        } edge;

	if (header.id != 0x17)
		Error("Not a valid .BSP file");

	fseek(fi, header.edges, SEEK_SET);

	for (i = 0, readcount = 0L; readcount < header.edgeslen; readcount += 4, i++) {
		fread((char *)&edge, 1, 4, fi);
		printf("%4d:  %5d %5d\n", i, edge.start, edge.end);
        }
}

