/*
 * Unwad.c - Uses the routines in the QEU library to extract data
 *           from a Doom/Heretic/Hexen WAD file.
 *
 * Do whatever you want with this file, but don't blame me if
 * something doesn't work.  If you manage to destroy your hard disk
 * with it, that's too bad for you...  Use it at your own risks!
 */

#include "qeu.h"
#include "q_misc.h"
#include "q_files.h"
#include "f_wad.h"

void main(int argc, char *argv[])
{
  char      *filename = NULL;
  FILE      *file;
  int        ftype;
  WADDirPtr  dir;
  UInt16     dirsize, n;
  Bool       view = FALSE;
  char      *dirname = NULL;

  /* read the parameters... */
  for (argv++, argc--; argc && **argv == '-'; argv++, argc--)
    if ((*argv)[1] == 'h')
      {
	fprintf(stderr, "UNWAD %s by Raphael Quinet\n\n", QEU_VERSION);
	fprintf(stderr, "Usage: unwad [-h] [-v] [-c] [-d <directory>] file.wad [entryname...]\n");
	fprintf(stderr, "       -h  -- display this help screen\n");
	fprintf(stderr, "       -v  -- view the contents of the wad file without extracting any data\n");
	fprintf(stderr, "       -d  -- use the specified directory for extraction\n");
	fprintf(stderr, "By default, unwad will extract all entries from the wad file in a directory\n");
	fprintf(stderr, "which has the same name as the wad file but the extension '.dir'.  If some\n");
	fprintf(stderr, "names are given after the file name, only these entries will be extracted.\n");
	exit(1);
      }
    else if ((*argv)[1] == 'v')
      view = TRUE;
    else if ((*argv)[1] == 'd' && argc-- > 1)
      dirname = *++argv;
    else
      ProgError("Invalid argument (%s).  Use unwad -h for help.", *argv);
  if (argc > 0)
    filename = *argv;
  else
    ProgError("Missing argument.  Use unwad -h for help.");
  if (dirname == NULL)
    dirname = ChangeFileExtension(filename, NULL, "dir");

  /* open the WAD file... */
  file = OpenFileReadMagic(filename, &ftype);
  if (file == NULL)
    ProgError("File not found (%s)", filename);
  if (ftype != FTYPE_IWAD && ftype != FTYPE_PWAD)
    ProgError("File is not a WAD file (%s)", filename);

  /* do something... */
  dir = ReadWADDirectory(file, 0, &dirsize);
  if (dir == NULL)
    ProgError("Cannot read main directory from %s", filename);
  if (view == TRUE)
    DumpWADDirectory(stdout, dir, dirsize);
  else if (argc > 1)
    for (argv++, argc--; argc; argv++, argc--)
      {
	n = FindWADEntry(dir, dirsize, *argv);
	if (n >= dirsize)
	  ProgError("Could not find entry %s in directory", *argv);
	if (UnWADFile(stdout, file, 0, dir, dirsize, n, dirname) == FALSE)
	  ProgError("Could not unpack entry %s from %s", *argv, filename);
      }
  else
    if (UnWADFile(stdout, file, 0, dir, dirsize, dirsize, dirname) == FALSE)
      ProgError("Could not unpack all entries from %s", filename);

  /* close the file and say goodbye */
  fclose(file);
  exit(0);
}
