/*
 * Rewad2.c - Uses the routines in the QEU library to re-create a
 *            Quake WAD2 file from a list of separate files.
 *
 * Do whatever you want with this file, but don't blame me if
 * something doesn't work.  If you manage to destroy your hard disk
 * with it, that's too bad for you...  Use it at your own risks!
 */

#include "qeu.h"
#include "q_misc.h"
#include "q_files.h"
#include "f_bitmap.h"
#include "f_wad2.h"


void main(int argc, char *argv[])
{
  char       *filename;
  FILE       *file;
  FILE       *srcfile;
  int         ftype;
  WAD2DirPtr  dir;
  UInt16      dirsize;
  char       *indexname = NULL;
  Bool        convert = FALSE;
  UInt32      size, count;
  char       *entryname;
  UInt8       type;

  /* read the parameters... */
  for (argv++, argc--; argc && **argv == '-'; argv++, argc--)
    if ((*argv)[1] == 'h')
      {
	fprintf(stderr, "REWAD2 %s by Raphael Quinet\n\n", QEU_VERSION);
	fprintf(stderr, "Usage: rewad2 [-h] [-c] [-i <indexfile>] file.wad [entryname...]\n");
	fprintf(stderr, "       -h  -- display this help screen\n");
        fprintf(stderr, "       -c  -- convert BMP files to bitmaps\n");
	fprintf(stderr, "       -i  -- get the list of files from the specified index file\n");
	fprintf(stderr, "Rewad2 will create a WAD2 file containing all the files specified on the\n");
	fprintf(stderr, "command line, or append them to the WAD2 file if it already exists\n");
	fprintf(stderr, "If the -i option is used, the list of files is read from the specified\n");
	fprintf(stderr, "index file (usually %s, as created by unwad2).\n", QEU_INDEX_FILE);
	exit(1);
      }
    else if ((*argv)[1] == 'c')
      convert = TRUE;
    else if ((*argv)[1] == 'i' && argc-- > 1)
      indexname = *++argv;
    else
      ProgError("Invalid argument (%s).  Use rewad2 -h for help.", *argv);
  if (argc <= 0)
    ProgError("Missing argument.  Use rewad2 -h for help.");
  filename = *argv;
  if (indexname == NULL && argc < 2)
    ProgError("List of files missing.  Use rewad2 -h for help.");

  if (convert == TRUE)
    ProgWarning("Option -c not implemented yet.  Ignored.\n"); /*! ... */

  /* check if the file exists */
  file = OpenFileReadMagic(filename, &ftype);
  if (file == NULL)
    {
      /* create a new WAD2 file */
      file = fopen(filename, "wb");
      if (file == NULL)
	ProgError("Cannot create file (%s)", filename);
      if (WriteWAD2Header(file, &count, &dir, &dirsize) == FALSE)
	ProgError("Cannot write WAD2 file header");
    }
  else
    {
      /* append to an existing WAD2 file */
      if (ftype != FTYPE_WAD2)
	ProgError("File is not a WAD2 file (%s)", filename);
      dir = ReadWAD2Directory(file, 0L, &dirsize);
      if (dir == NULL)
	ProgError("Cannot read main directory from %s", filename);
      /* re-open file for writing */
      fclose(file);
      file = fopen(filename, "r+b");
      count = dir[dirsize - 1].offset + dir[dirsize - 1].size;
      if (file == NULL || fseek(file, count, SEEK_SET) < 0)
	ProgError("Cannot re-open file for writing (%s)", filename);
    }

  /* parse the index file and read all the files listed in it */
  if (indexname != NULL)
    ProgError("Option -i not implemented yet.  Sorry...\n"); /*! missing */

  /* if there are extra arguments on the command line, read these files too */
  for (argv++, argc--; argc; argv++, argc--)
    {
      entryname = QStrNDupHack(*argv, 16);
      /* hack for guessing the type of the entry... */
      if (!strnicmp(entryname, "PALETTE", 7))
	type = '@';
      else if (!strnicmp(entryname, "CONBACK", 7)
	       || !strnicmp(entryname, "CONCHARS", 8))
	type = 'E';
      else
	type = 'B';
      srcfile = fopen(*argv, "rb");
      if (srcfile == NULL)
	ProgError("File not found (%s)", *argv);
      size = GetFileSize(srcfile);
      printf("Copying %lu bytes from %s\n", size, *argv);
      if (CopyBytes(file, srcfile, size) == FALSE)
	ProgError("Cannot copy data");
      if (AddWAD2Entry(file, &count, &dir, &dirsize, entryname, size, type) == FALSE)
	ProgError("Cannot register entry in WAD2 directory (%s)", entryname);
      fclose(srcfile);
      QFree(entryname);
    }

  /* write the directory */
  size = WriteWAD2Directory(file, &count, dir, dirsize);
  if (size == 0L)
    ProgError("Cannot write WAD2 directory");
  printf("Total size of %s: %lu bytes\n", filename, size);

  /* close the file and say goodbye */
  fclose(file);
  exit(0);
}
