/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

/*
 * QEU.H - Main defines for all programs.
 *
 * This file was derived from DEU.H (Doom Editing Utilities 5.3),
 * written by the DEU Team: Raphael Quinet, Brandon Wyber, Ted
 * Vessenes and others.
 *
 * Note: I assume that this file is included first in all *.C files, so
 *       there is no need to include it in other *.H files.
 */

#ifndef _QEU_H_
#define _QEU_H_

#define QEU_VER_NUM             "0.3"  /* the version number */


/*
 * Common includes (for all systems/compilers).
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>


/*
 * Compiler- and OS-specific includes and definitions.
 */

#if !defined(QEU_UNIX) && !defined(QEU_DOS)
/* if the right symbols have not been passed to the compiler from the
   Makefile or project file, then we have to guess them.
*/
#if defined(__TURBOC__)
/* if QEU is compiled with Borland C / Turbo C */
#define QEU_OSCOMPILER          "BC-BGI"
#define QEU_DOS                 /* mess-DOS */
#define QEU_GFX_BGI             /* BGI graphics */

#elif defined(__GO32__)
/* if QEU is compiled with DJGPP (GCC + GO32) */
#define QEU_OSCOMPILER          "GCC-GRX"
#define QEU_DOS                 /* mess-DOS */
#define QEU_GFX_GRX             /* GRX graphics */
#define far                     /* no far pointers */
#define huge                    /* no huge pointers */

#elif defined(__sgi)
/* if QEU is compiled on an SGI (compiler doesn't matter) */
#define QEU_OSCOMPILER          "SGI-GL"
#define QEU_UNIX                /* UNIX operating system */
#define QEU_GFX_SGI             /* SGI graphics (GL) */
#define far                     /* no far pointers */
#define huge                    /* no huge pointers */
#define FAT_ENDIAN              /* MSB last */

#elif defined(__UNIX__) || defined(__unix)
/* if QEU is compiled on some UNIX system (compiler doesn't matter) */
#define QEU_OSCOMPILER          "UNIX-X11"
#define QEU_UNIX                /* UNIX operating system */
#define QEU_GFX_X11             /* X Window graphics (X11) */
#define far                     /* no far pointers */
#define huge                    /* no huge pointers */
/*! more big endian systems should be added here... AIX? HP? */
#if defined(_BIG_ENDIAN) || defined(__sun)
#define FAT_ENDIAN              /* MSB last */
#endif

#else
#error Cannot guess your operating system type.  Check the Makefile.
#endif
#endif /* !QEU_UNIX && !QEU_DOS */

#ifndef QEU_OSCOMPILER
#define QEU_OSCOMPILER          "(Unknown)"
#endif

/* the full version number (including OS or compiler) */
#define QEU_VERSION             QEU_VER_NUM " " QEU_OSCOMPILER


/*
 * Some useful typedefs for integer types.  The default "int" type
 * should be used when the number of bits doesn't matter or when using
 * va_arg with integer constants.  Never use "long" or "short"
 * directly in the code, because the number of bits may vary (e.g. DEC
 * Alpha: long = 64 bits).  Always use these typedefs instead.  They
 * will be modified if QEU is ported to "exotic" systems.  This is
 * easier than having to modify all source files...
 */
typedef char           Int8;
typedef short          Int16;
typedef long           Int32;
typedef unsigned char  UInt8;
typedef unsigned short UInt16;
typedef unsigned long  UInt32;

/*
 * Some useful typedefs for floating-point numbers.  These should be
 * used instead of the native types, in order to increase portability
 * (see the previous comment for integer types).
 */
typedef float          Float32;
typedef double         Float64;

/*
 * Boolean data: can be TRUE or FALSE.
 */
typedef int            Bool;


/*
 * The macros and constants.
 */

/* get the maximum and minimum of two integers */
#define MAX(a, b)              (((a) > (b)) ? (a) : (b))
#define MIN(a, b)              (((a) < (b)) ? (a) : (b))

/* get a random number */
#ifdef __TURBOC__
#define RANDOM(x)              (random(x))
#define RANDOMIZE()             randomize()
#else
#define RANDOM(x)              (random() % (x))
#define RANDOMIZE()             srand((int) time(NULL))
#endif

/* boolean constants */
#ifndef TRUE
#define TRUE                    1
#define FALSE                   0
#endif

/* other symbols */
#define QEU_INDEX_FILE          "Index.txt"

#endif /* _QEU_H_ */
/* end of file */
