/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

/*
 * F_BITMAP.H - Filters for bitmap file formats.
 */

#ifndef _F_BITMAP_H_
#define _F_BITMAP_H_

struct RGB
{
  UInt8 R;
  UInt8 G;
  UInt8 B;
};

typedef struct
{
  UInt16      width;            /* width of the bitmap (num. columns) */
  UInt16      height;           /* height of the bitmap (num. rows) */
  UInt8 huge *data;             /* pointer to bitmap data */
} BitMap;

struct RGB *ReadPalette256(FILE *file, UInt32 offset);
UInt32  SavePalette256(FILE *file, struct RGB *palette256);

BitMap *NewBitMap();
void    FreeBitMap(BitMap *bmptr);
BitMap *ReadBitMap(FILE *file, UInt32 offset);
BitMap *ReadRawBitMap(FILE *file, UInt32 offset, UInt16 width, UInt16 height);
UInt32  SaveBitMap(FILE *file, BitMap *bmptr);
UInt32  SaveRawBitMap(FILE *file, BitMap *bmptr);
void    DumpBitMap(FILE *outf, BitMap *bmptr);

UInt32  SavePPM(FILE *file, BitMap *bmptr, struct RGB *palette256);
UInt32  SaveBMP(FILE *file, BitMap *bmptr, struct RGB *palette256);

#endif /* _F_BITMAP_H_ */
/* end of file */
