#include "stdio.h"

typedef float scalar_t;

typedef struct
{
	scalar_t x;
	scalar_t y;
	scalar_t z;
} vec3_t;

typedef struct
{
	vec3_t   min;
	vec3_t   max;
} boundbox_t;

typedef struct 
{
	vec3_t normal;
	scalar_t dist;
	long type;
	long firstsurf;
	long numsurf;
} plane_t;

typedef struct 
{
	float x;
	float y;
	float z;
} vertex_t;

typedef struct 
{
	long planenum;
	unsigned short front;
	unsigned short back;
	boundbox_t box;
} node_t;

typedef struct 
{
	unsigned short planenum;
	unsigned short side;
	unsigned char texnum;
	unsigned char sofs;
	unsigned char tofs;
	unsigned char flips;
	long firstedge;
	long numedge;
	unsigned char light;
	unsigned char unknown0;
	unsigned short unknown1;
	unsigned long lightmap;
} surface_t;

typedef struct 
{
	unsigned long planenum;
	short front;
	short back;
} dhullbound_t;

typedef struct 
{
	unsigned long code;
	boundbox_t bound;
	unsigned long vislist;
	long firstsurf;
	long numsurf;
	unsigned long zeroes[3];
	unsigned short zero;
	unsigned short flag;
} dleaf_t;

typedef struct
{
	unsigned short startvertex;
	unsigned short endvertex;
} edge_t;

typedef struct 
{
	boundbox_t bound;
	long zero[3];
	long node;
	long boundnode;
	long numleafs;
	long firstsurface;
	long numsurfaces;
} dhull_t;

int main()
{
	FILE * lmp;
	FILE * txt;
	char textbuf;
	unsigned short ushortbuf;
	short i;
	plane_t plane;
	vertex_t vertex;
	unsigned char visentry;
	node_t node;
	surface_t surface;
	dhullbound_t dhullbound;
	dleaf_t dleaf;
	edge_t edge;
	dhull_t dhull;
	float fpsupport;
	short entcount;
	fpsupport = (float)1.0000;
	printf("\n");
	printf("Quake Text To BSP Entry Converter\n");
	printf("Version 1.0\n");
	printf("Copyright (C) 1996 Richard Felker, aka Dalias");
	printf("\n");
	/*lmp = fopen("entry00.lmp", "r"); txt = fopen("entry00.txt", "w");
	for (i = 1; i <= entcount; i++)
	{
		fwrite(&textbuf, 1, 1, lmp);
		fwrite(&textbuf, 1, 1, txt);
	}
	fclose(lmp); fclose(txt);*/
	printf("Converting Planes...\n");
	lmp = fopen("entry01.lmp", "wb"); txt = fopen("planes.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%f %f %f %f %ld %ld %ld",
			&plane.normal.x,
			&plane.normal.y,
			&plane.normal.z,
			&plane.dist,
			&plane.type,
			&plane.firstsurf,
			&plane.numsurf);
		fwrite(&plane, sizeof(plane_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Vertices...\n");
	lmp = fopen("entry03.lmp", "wb"); txt = fopen("vertices.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%f %f %f",
			&vertex.x,
			&vertex.y,
			&vertex.z);
		fwrite(&vertex, sizeof(vertex_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Nodes...\n");
	lmp = fopen("entry05.lmp", "wb"); txt = fopen("nodes.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%ld %hu %hu %f %f %f %f %f %f",
			&node.planenum,
			&node.front,
			&node.back,
			&node.box.min.x,
			&node.box.min.y,
			&node.box.min.z,
			&node.box.max.x,
			&node.box.max.y,
			&node.box.max.z
			);
		fwrite(&node, sizeof(node_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Surfaces...\n");
	lmp = fopen("entry06.lmp", "wb"); txt = fopen("surfaces.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%hu %hu %hu %hu %hu %hu %ld %ld %hu %hu %hu %lu",
			&surface.planenum,
			&surface.side,
			&surface.texnum,
			&surface.sofs,
			&surface.tofs,
			&surface.flips,
			&surface.firstedge,
			&surface.numedge,
			&surface.light,
			&surface.unknown0,
			&surface.unknown1,
			&surface.lightmap
			);
		fwrite(&surface, sizeof(surface_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Hull Bound Nodes...\n");
	lmp = fopen("entry08.lmp", "wb"); txt = fopen("dhullbnd.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%lu %hd %hd",
			&dhullbound.planenum,
			&dhullbound.front,
			&dhullbound.back
			);
		fwrite(&dhullbound, sizeof(dhullbound_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Leaves...\n");
	lmp = fopen("entry09.lmp", "wb"); txt = fopen("dleaves.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%lu %f %f %f %f %f %f %lu %ld %ld %lu %lu %lu %hu %hu",
			&dleaf.code,
			&dleaf.bound.min.x,
			&dleaf.bound.min.y,
			&dleaf.bound.min.z,
			&dleaf.bound.max.x,
			&dleaf.bound.max.y,
			&dleaf.bound.max.z,
			&dleaf.vislist,
			&dleaf.firstsurf,
			&dleaf.numsurf,
			&dleaf.zeroes[0],
			&dleaf.zeroes[1],
			&dleaf.zeroes[2],
			&dleaf.zero,
			&dleaf.flag
			);
		fwrite(&dleaf, sizeof(dleaf_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Surface List...\n");
	lmp = fopen("entry10.lmp", "wb"); txt = fopen("surflist.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%hu",
			&ushortbuf
			);
		fwrite(&ushortbuf, sizeof(unsigned short), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Edges...\n");
	lmp = fopen("entry11.lmp", "wb"); txt = fopen("edges.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%hu %hu",
			&edge.startvertex,
			&edge.endvertex
			);
		fwrite(&edge, sizeof(edge_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Edge List...\n");
	lmp = fopen("entry12.lmp", "wb"); txt = fopen("edgelist.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%hu",
			&ushortbuf
			);
		fwrite(&ushortbuf, sizeof(unsigned short), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	printf("Converting Hulls...\n");
	lmp = fopen("entry13.lmp", "wb"); txt = fopen("hulls.txt", "r");
	fscanf(txt, "%hd", &entcount);
	for (i = 1; i <= entcount; i++)
	{
		fscanf(txt, "%f %f %f %f %f %f %ld %ld %ld %ld %ld %ld %ld %ld",
			&dhull.bound.min.x,
			&dhull.bound.min.y,
			&dhull.bound.min.z,
			&dhull.bound.max.x,
			&dhull.bound.max.y,
			&dhull.bound.max.z,
			&dhull.zero[0],
			&dhull.zero[1],
			&dhull.zero[2],
			&dhull.node,
			&dhull.boundnode,
			&dhull.numleafs,
			&dhull.firstsurface,
			&dhull.numsurfaces
			);
		fwrite(&dhull, sizeof(dhull_t), 1, lmp);
	}
	fclose(lmp); fclose(txt);
	return 0;
}
















