#include "stdio.h"

typedef struct
{
	long  offset;
	long  size;
} dentry_t;

int main()
{
	FILE * lmp;
	FILE * bsp;
	char entfile[64];
	dentry_t entry[14];
	long i, j;
	unsigned char data;
	long ver;
	printf("\n");
	printf("Quake BSP File Rebuilder\n");
	printf("Version 1.0\n");
	printf("Copyright (C) 1996 Richard Felker, aka Dalias");
	printf("\n");
	bsp = fopen("tmp.bsp", "wb");
	ver = 0x17;
	fwrite(&ver, 4, 1, bsp);
	fwrite(entry, sizeof(dentry_t) * 14, 1, bsp);
	for (i = 0; i < 14; i++)
	{
		sprintf(entfile, "ENTRY%02hd.LMP", i);
		lmp = fopen(entfile, "rb");
		entry[i].offset = ftell(bsp);
		entry[i].size = 0;
		printf("File: %s  ", entfile);
		printf("Offset %ld  ", entry[i].offset);
		if (lmp == 0) printf("Not found.  ");
		else printf("Found  ");
		j = 0;
		while (lmp && !feof(lmp))
		{
			fread(&data, 1, 1, lmp);
			if (feof(lmp)) break;
			fwrite(&data, 1, 1, bsp);
			j++;
		}
		fclose(lmp);
		entry[i].size = j;
		printf("%ld bytes.\n", entry[i].size);
	}
	fseek(bsp, SEEK_SET, 0);
	ver = 0x17;
	fwrite(&ver, 4, 1, bsp);
	fwrite(entry, sizeof(dentry_t) * 14, 1, bsp);
	fclose(bsp);
	printf("\n");
	return 0;
}










