#include "stdio.h"

typedef float scalar_t;

typedef struct
{
	scalar_t x;
	scalar_t y;
	scalar_t z;
} vec3_t;

typedef struct
{
	vec3_t   min;
	vec3_t   max;
} boundbox_t;

typedef struct 
{
	vec3_t normal;
	scalar_t dist;
	long type;
	long firstsurf;
	long numsurf;
} plane_t;

typedef struct 
{
	float x;
	float y;
	float z;
} vertex_t;

typedef struct 
{
	long planenum;
	unsigned short front;
	unsigned short back;
	boundbox_t box;
} node_t;

typedef struct 
{
	unsigned short planenum;
	unsigned short side;
	unsigned char texnum;
	unsigned char sofs;
	unsigned char tofs;
	unsigned char flips;
	long firstedge;
	long numedge;
	unsigned char light;
	unsigned char unknown0;
	unsigned short unknown1;
	unsigned long lightmap;
} surface_t;

typedef struct 
{
	unsigned long planenum;
	short front;
	short back;
} dhullbound_t;

typedef struct 
{
	unsigned long code;
	boundbox_t bound;
	unsigned long vislist;
	long firstsurf;
	long numsurf;
	unsigned long zeroes[3];
	unsigned short zero;
	unsigned short flag;
} dleaf_t;

typedef struct
{
	unsigned short startvertex;
	unsigned short endvertex;
} edge_t;

typedef struct 
{
	boundbox_t bound;
	long zero[3];
	long node;
	long boundnode;
	long numleafs;
	long firstsurface;
	long numsurfaces;
} dhull_t;

long fsize(FILE * file)
{
	long pos, end;
	pos = ftell(file);
	fseek(file, 0, SEEK_END);
	end = ftell(file);
	fseek(file, pos, SEEK_SET);
	return end;
}

int main()
{
	FILE * lmp;
	FILE * txt;
	char textbuf;
	unsigned short ushortbuf;
	short i;
	plane_t plane;
	vertex_t vertex;
	unsigned char visentry;
	node_t node;
	surface_t surface;
	dhullbound_t dhullbound;
	dleaf_t dleaf;
	edge_t edge;
	dhull_t dhull;
	long entcount;
	printf("\n");
	printf("Quake BSP Entry To Text Converter\n");
	printf("Version 1.0\n");
	printf("Copyright (C) 1996 Richard Felker, aka Dalias");
	printf("\n");
	/*lmp = fopen("entry00.lmp", "rb"); txt = fopen("entry00.txt", "w");
	for(i = 1; i <= entcount; i++)
	{
		fread(&textbuf, 1, 1, lmp);
		fwrite(&textbuf, 1, 1, txt);
	}
	fclose(lmp); fclose(txt);*/
	lmp = fopen("entry01.lmp", "rb"); txt = fopen("planes.txt", "w");
	entcount = fsize(lmp) / sizeof(plane_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&plane, sizeof(plane_t), 1, lmp);
		fprintf(txt, "%f %f %f %f %ld %ld %ld\n",
			plane.normal.x,
			plane.normal.y,
			plane.normal.z,
			plane.dist,
			plane.type,
			plane.firstsurf,
			plane.numsurf);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry03.lmp", "rb"); txt = fopen("vertices.txt", "w");
	entcount = fsize(lmp) / sizeof(vertex_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&vertex, sizeof(vertex_t), 1, lmp);
		fprintf(txt, "%.2f %.2f %.2f\n",
			vertex.x,
			vertex.y,
			vertex.z);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry05.lmp", "rb"); txt = fopen("nodes.txt", "w");
	entcount = fsize(lmp) / sizeof(node_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&node, sizeof(node_t), 1, lmp);
		fprintf(txt, "%ld %hu %hu %.2f %.2f %.2f %.2f %.2f %.2f\n",
			node.planenum,
			node.front,
			node.back,
			node.box.min.x,
			node.box.min.y,
			node.box.min.z,
			node.box.max.x,
			node.box.max.y,
			node.box.max.z
			);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry06.lmp", "rb"); txt = fopen("surfaces.txt", "w");
	entcount = fsize(lmp) / sizeof(surface_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&surface, sizeof(surface_t), 1, lmp);
		fprintf(txt, "%hu %hu %hu %hu %hu %hu %ld %ld %hu %hu %hu %lu\n",
			surface.planenum,
			surface.side,
			surface.texnum,
			surface.sofs,
			surface.tofs,
			surface.flips,
			surface.firstedge,
			surface.numedge,
			surface.light,
			surface.unknown0,
			surface.unknown1,
			surface.lightmap
			);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry08.lmp", "rb"); txt = fopen("dhullbnd.txt", "w");
	entcount = fsize(lmp) / sizeof(dhullbound_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&dhullbound, sizeof(dhullbound_t), 1, lmp);
		fprintf(txt, "%lu %hd %hd\n",
			dhullbound.planenum,
			dhullbound.front,
			dhullbound.back
			);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry09.lmp", "rb"); txt = fopen("dleaves.txt", "w");
	entcount = fsize(lmp) / sizeof(dleaf_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&dleaf, sizeof(dleaf_t), 1, lmp);
		fprintf(txt, "%lu %.2f %.2f %.2f %.2f %.2f %.2f %lu %ld %ld %lu %lu %lu %hu %hu\n",
			dleaf.code,
			dleaf.bound.min.x,
			dleaf.bound.min.y,
			dleaf.bound.min.z,
			dleaf.bound.max.x,
			dleaf.bound.max.y,
			dleaf.bound.max.z,
			dleaf.vislist,
			dleaf.firstsurf,
			dleaf.numsurf,
			dleaf.zeroes[0],
			dleaf.zeroes[1],
			dleaf.zeroes[2],
			dleaf.zero,
			dleaf.flag
			);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry10.lmp", "rb"); txt = fopen("surflist.txt", "w");
	entcount = fsize(lmp) / sizeof(unsigned short);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&ushortbuf, sizeof(unsigned short), 1, lmp);
		fprintf(txt, "%hu\n",
			ushortbuf
			);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry11.lmp", "rb"); txt = fopen("edges.txt", "w");
	entcount = fsize(lmp) / sizeof(edge_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&edge, sizeof(edge_t), 1, lmp);
		fprintf(txt, "%hu %hu\n",
			edge.startvertex,
			edge.endvertex
			);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry12.lmp", "rb"); txt = fopen("edgelist.txt", "w");
	entcount = fsize(lmp) / sizeof(unsigned short);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&ushortbuf, sizeof(unsigned short), 1, lmp);
		fprintf(txt, "%hu\n",
			ushortbuf
			);
	}
	fclose(lmp); fclose(txt);
	lmp = fopen("entry13.lmp", "rb"); txt = fopen("hulls.txt", "w");
	entcount = fsize(lmp) / sizeof(dhull_t);
	fprintf(txt, "%ld\n", entcount);
	for(i = 1; i <= entcount; i++)
	{
		fread(&dhull, sizeof(dhull_t), 1, lmp);
		fprintf(txt, "%.2f %.2f %.2f %.2f %.2f %.2f %ld %ld %ld %ld %ld %ld %ld %ld\n",
			dhull.bound.min.x,
			dhull.bound.min.y,
			dhull.bound.min.z,
			dhull.bound.max.x,
			dhull.bound.max.y,
			dhull.bound.max.z,
			dhull.zero[0],
			dhull.zero[1],
			dhull.zero[2],
			dhull.node,
			dhull.boundnode,
			dhull.numleafs,
			dhull.firstsurface,
			dhull.numsurfaces
			);
	}
	fclose(lmp); fclose(txt);
	return 0;
}
















