Binary files v101qc/zaxe.dem and zaxe/zaxe.dem differ
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/zombie.qc zaxe/zombie.qc
--- v101qc/zombie.qc	Thu Jul 25 01:51:24 1996
+++ zaxe/zombie.qc	Tue Aug 27 07:01:38 1996
@@ -415,9 +415,24 @@
 void(entity attacker, float take) zombie_pain =
 {
 	local float r;
+	local vector v;
 
 	self.health = 60;		// allways reset health
 
+	if (self.axhitme) {
+		self.axhitme = 0;
+		self.cnt = self.cnt + 1;
+		if (random() < 0.4)  // Meat spray only, most of the time
+			ThrowGib("progs/zom_gib.mdl", self.health);
+       		else if (random() < 0.3)
+               		ThrowGib("progs/gib1.mdl", self.health);
+       		else if (random() < 0.5)
+               		ThrowGib("progs/gib2.mdl", self.health);
+       		else
+               		ThrowGib("progs/gib3.mdl", self.health);
+		if(self.cnt > 5)
+			T_Damage(self, attacker, attacker, 100);
+	}
 	if (take < 9)
 		return;				// totally ignore
 
@@ -497,6 +512,7 @@
 
 	setsize (self, '-16 -16 -24', '16 16 40');
 	self.health = 60;
+	self.cnt = 0;  // 5 axe hits kills me
 
 	self.th_stand = zombie_stand1;
 	self.th_walk = zombie_walk1;
