diff -ur --new-file origqw/client.qc qw/client.qc
--- origqw/client.qc	Fri Dec 13 20:55:12 1996
+++ qw/client.qc	Thu Jan  2 15:38:32 1997
@@ -831,6 +831,12 @@
  		self.weapon = W_BestWeapon ();
  		W_SetCurrentAmmo ();
  	}
+
+// TOLLERTON: MOTD code, from Zoid's CTF sources.
+	if (self.motd_on && self.motd_time > time)
+		centerprint(self, "Rich Tollerton's Physics Mods\nBuild 1-2-97\nNOT TO BE INCLUDED IN OTHER SOURCES WITHOUT\nRICH TOLLERTON'S EXPRESSIVE PERMISSION.\n");
+	else if (self.motd_on && self.motd_time < time)
+		self.motd_on = 0;
 };
 	
 /*
@@ -1046,6 +1052,10 @@
 // a client connecting during an intermission can cause problems
 	if (intermission_running)
 		GotoNextMap ();
+
+// TOLLERTON: From Zoid's CTF code, some MOTD. Shameless, no?
+	self.motd_on = 1;
+	self.motd_time = time + 2;
 };
 
 
diff -ur --new-file origqw/defs.qc qw/defs.qc
--- origqw/defs.qc	Thu Dec  5 21:24:42 1996
+++ qw/defs.qc	Thu Jan  2 15:40:28 1997
@@ -496,6 +496,10 @@
 .float		bubble_count;	// keeps track of the number of bubbles
 .string		deathtype;		// keeps track of how the player died
 
+// TOLLERTON: For MOTD stuff. Shamelessly copied from Zoid's work, no less.
+.float motd_on;
+.float motd_time;
+
 //
 // object stuff
 //
diff -ur --new-file origqw/weapons.qc qw/weapons.qc
--- origqw/weapons.qc	Fri Dec 13 20:30:44 1996
+++ qw/weapons.qc	Thu Jan  2 15:25:50 1997
@@ -248,6 +248,15 @@
 };
 
 /*
+ TOLLERTON: Great. Not once in this file is the muzzle distance (from player
+ to the end of the barrel) used or shown. It will come in handy later, when
+ I want to simulate 'stringing' (I think that's the word: it's when you fire
+ while quickly rotating, making the shot pattern elliptical and parallel to
+ your rotation; caused by the different muzzle locations when the first and
+ last shots leave the barrel). I'll have to rip the shotgun MDLs and
+ estimate the lengths myself, then...
+*/
+/*
 ================
 W_FireShotgun
 ================
@@ -262,7 +271,14 @@
 	WriteByte (MSG_ONE, SVC_SMALLKICK);
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
+
+// TOLLERTON: Quake trivia fact: Using this method, shot is calculated to
+// be 100 times faster than rockets. But the way the damage is calculated,
+// the shot travels infinitely fast.
 	dir = aim (self, 100000);
+
+// TOLLERTON: '0.04 0.04 0' is the radius of the shot pattern (which should
+// be a cone), NOT the muzzle distance.
 	FireBullets (6, dir, '0.04 0.04 0');
 };
 
@@ -288,6 +304,8 @@
 	WriteByte (MSG_ONE, SVC_BIGKICK);
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
+
+// TOLLERTON: See notes above on shot speed and blast radius.
 	dir = aim (self, 100000);
 	FireBullets (14, dir, '0.14 0.08 0');
 };
@@ -356,15 +374,29 @@
 
 	newmis = spawn ();
 	newmis.owner = self;
+
+// TOLLETON: Missiles are still affected by gravity, without the lift
+// imparted by the fins and possible secondary thrust systems figured in.
+// But standard gravity is too much for rockets, and gravity is hardcoded
+// in physics appearantly, so I won't mess with this for now.
 	newmis.movetype = MOVETYPE_FLYMISSILE;
 	newmis.solid = SOLID_BBOX;
 		
 // set newmis speed	
 
 	makevectors (self.v_angle);
+
+// TOLLERTON: This definitely doesn't look too fast, but gameplay suffers if
+// I increase it any (I think).
 	newmis.velocity = aim(self, 1000);
-	newmis.velocity = newmis.velocity * 1000;
+//	newmis.velocity = newmis.velocity * 1000;
+
+// TOLLERTON: I had to change the velocity to account for player movement
+// *AFTER* the missile.angle is set, or else the missile will point in
+// the direction it is moving. Instead, it should still point straight ahead.
 	newmis.angles = vectoangles(newmis.velocity);
+
+	newmis.velocity = newmis.velocity * 1000 + self.velocity;
 	
 	newmis.touch = T_MissileTouch;
 	
@@ -374,6 +406,8 @@
 
 	setmodel (newmis, "progs/missile.mdl");
 	setsize (newmis, '0 0 0', '0 0 0');		
+
+// TOLLERTON: '0 0 16' is the muzzle distance.
 	setorigin (newmis, self.origin + v_forward*8 + '0 0 16');
 };
 
@@ -538,12 +572,14 @@
 	makevectors (self.v_angle);
 
 	if (self.v_angle_x)
-		newmis.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+		newmis.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10 + self.velocity;
 	else
 	{
+// TOLLERTON: Though it looks at first as if the grenade is calculated to be
+// LOTS faster than a rocket, in reality it's about 30-70% as fast.
 		newmis.velocity = aim(self, 10000);
-		newmis.velocity = newmis.velocity * 600;
-		newmis.velocity_z = 200;
+		newmis.velocity = newmis.velocity * 600 + self.velocity;
+		newmis.velocity_z = 200 + self.velocity_z;
 	}
 
 	newmis.avelocity = '300 300 300';
@@ -557,6 +593,10 @@
 	newmis.think = GrenadeExplode;
 
 	setmodel (newmis, "progs/grenade.mdl");
+
+// TOLLERTON: Phooey. Grenades start at the player's location, not in front
+// of him (like it should be). I'll change it so that there is a muzzle later;
+// right now there's no real difference.
 	setsize (newmis, '0 0 0', '0 0 0');		
 	setorigin (newmis, self.origin);
 };
@@ -592,7 +632,9 @@
 	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
 	setorigin (newmis, org);
 
-	newmis.velocity = dir * 1000;
+// TOLLERTON: Yet another trivia note: Nails travel at exactly the same speed
+// that rockets do!
+	newmis.velocity = dir * 1000 + self.velocity;
 };
 
 void() W_FireSuperSpikes =
@@ -604,6 +646,8 @@
 	self.attack_finished = time + 0.2;
 	self.currentammo = self.ammo_nails = self.ammo_nails - 2;
 	dir = aim (self, 1000);
+
+// TOLLERTON: See below for muzzle distance notes.
 	launch_spike (self.origin + '0 0 16', dir);
 	newmis.touch = superspike_touch;
 	setmodel (newmis, "progs/s_spike.mdl");
@@ -636,6 +680,9 @@
 	self.attack_finished = time + 0.2;
 	self.currentammo = self.ammo_nails = self.ammo_nails - 1;
 	dir = aim (self, 1000);
+
+// TOLLERTON: '0 0 16' is the same muzzle distance used in rocket launchers
+// and nailguns.
 	launch_spike (self.origin + '0 0 16' + v_right*ox, dir);
 
 	msg_entity = self;
@@ -728,6 +775,11 @@
 ===============================================================================
 */
 
+/*
+ TOLLERTON: I wonder if it's possible to display the weapon MDL's *backwards*.
+ Bludgeon your enemies with the butt of your gun!
+*/
+
 void() W_SetCurrentAmmo =
 {
 	player_run ();		// get out of any weapon firing states
@@ -1009,6 +1061,8 @@
 */
 void() CheatCommand =
 {
+// TOLLERTON: Phooey :)
+
 //	if (deathmatch || coop)
 		return;
 
