diff -ur --new-file ..\v106qc/client.qc .\QC/client.qc
--- ..\v106qc/client.qc	Mon Jul 21 23:06:00 1997
+++ .\QC/client.qc	Fri Oct 24 21:57:24 1997
@@ -1231,8 +1231,18 @@
 				attacker.frags = attacker.frags - 1;
 				bprint (targ.netname);
 				
-				if (targ.weapon == 64 && targ.waterlevel > 1)
+				if (targ.weapon == IT_LIGHTNING && targ.waterlevel > 1)
 				{
+					if (targ.watertype == CONTENT_LAVA)			/// Discharge
+					{								/// Discharge
+						bprint (" discharges into the lava.\n");	/// Discharge
+						return;						/// Discharge
+					}								/// Discharge
+					if (targ.watertype == CONTENT_SLIME)		/// Discharge
+					{								/// Discharge
+						bprint (" discharges into the slime.\n");	/// Discharge
+						return;						/// Discharge
+					}								/// Discharge
 					bprint (" discharges into the water.\n");
 					return;
 				}
@@ -1261,7 +1271,7 @@
 			{
 				attacker.frags = attacker.frags + 1;
 
-				rnum = attacker.weapon;
+				rnum = parm16;							/// Death Fix
 				if (rnum == IT_AXE)
 				{
 					deathstring = " was ax-murdered by ";
diff -ur --new-file ..\v106qc/misc.qc .\QC/misc.qc
--- ..\v106qc/misc.qc	Mon Jul 21 23:06:10 1997
+++ .\QC/misc.qc	Fri Oct 24 21:57:24 1997
@@ -176,7 +176,7 @@
 	self.nextthink = time + (random() * 5);
 	self.think = fire_fly;
 	if (!self.speed)
-		self.speed == 1000;
+		self.speed = 1000;								/// Typo fixed
 };
 
 void() fire_fly =
diff -ur --new-file ..\v106qc/monsters.qc .\QC/monsters.qc
--- ..\v106qc/monsters.qc	Mon Jul 21 23:06:12 1997
+++ .\QC/monsters.qc	Fri Oct 24 21:57:24 1997
@@ -115,7 +115,7 @@
 	}
 
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 };
 
 
@@ -123,7 +123,7 @@
 {
 // delay drop to floor to make sure all doors have been spawned
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 	self.think = walkmonster_start_go;
 	total_monsters = total_monsters + 1;
 };
@@ -171,12 +171,15 @@
 		self.pausetime = 99999999;
 		self.th_stand ();
 	}
+
+// spread think times so they don't all happen at same time				/// Statue Fix
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 };
 
 void() flymonster_start =
 {
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 	self.think = flymonster_start_go;
 	total_monsters = total_monsters + 1;
 };
@@ -191,7 +194,7 @@
 	}
 
 	self.takedamage = DAMAGE_AIM;
-	total_monsters = total_monsters + 1;
+//	total_monsters = total_monsters + 1;						/// Rotfish fix
 
 	self.ideal_yaw = self.angles * '0 1 0';
 	if (!self.yaw_speed)
@@ -222,13 +225,13 @@
 	}
 
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 };
 
 void() swimmonster_start =
 {
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 	self.think = swimmonster_start_go;
 	total_monsters = total_monsters + 1;
 };
diff -ur --new-file ..\v106qc/oldone.qc .\QC/oldone.qc
--- ..\v106qc/oldone.qc	Mon Jul 21 23:06:12 1997
+++ .\QC/oldone.qc	Fri Oct 24 21:57:24 1997
@@ -187,6 +187,8 @@
 	local entity	n;
 
 	sound (self, CHAN_VOICE, "boss2/pop2.wav", 1, ATTN_NORM);
+	killed_monsters = killed_monsters + 1;						/// Shub Kill Fix
+	WriteByte (MSG_ALL, SVC_KILLEDMONSTER);						/// Shub Kill Fix
 	
 	oldo = self.origin;
 
diff -ur --new-file ..\v106qc/triggers.qc .\QC/triggers.qc
--- ..\v106qc/triggers.qc	Mon Jul 21 23:06:18 1997
+++ .\QC/triggers.qc	Fri Oct 24 21:57:24 1997
@@ -324,7 +324,10 @@
 	if (other.classname == "player")
 	{
 		if (other.invincible_finished > time)
+		{
 			self.classname = "teledeath2";
+			T_Damage (self.owner, self, self, 50000);				/// Satan Telefrag
+		}
 		if (self.owner.classname != "player")
 		{	// other monsters explode themselves
 			T_Damage (self.owner, self, self, 50000);
diff -ur --new-file ..\v106qc/weapons.qc .\QC/weapons.qc
--- ..\v106qc/weapons.qc	Mon Jul 21 23:06:22 1997
+++ .\QC/weapons.qc	Fri Oct 24 21:57:24 1997
@@ -51,6 +51,7 @@
 	{
 		trace_ent.axhitme = 1;
 		SpawnBlood (org, '0 0 0', 20);
+		parm16 = IT_AXE;									/// Death Fix
 		T_Damage (trace_ent, self, self, 20);
 	}
 	else
@@ -272,6 +273,7 @@
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
 	dir = aim (self, 100000);
+	parm16 = IT_SHOTGUN;									/// Death Fix
 	FireBullets (6, dir, '0.04 0.04 0');
 };
 
@@ -297,6 +299,7 @@
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
 	dir = aim (self, 100000);
+	parm16 = IT_SUPER_SHOTGUN;								/// Death Fix
 	FireBullets (14, dir, '0.14 0.08 0');
 };
 
@@ -341,6 +344,8 @@
 
 	damg = 100 + random()*20;
 	
+	parm16 = IT_ROCKET_LAUNCHER;								/// Death Fix
+
 	if (other.health)
 	{
 		if (other.classname == "monster_shambler")
@@ -474,6 +479,8 @@
 		return;
 	}
 
+	parm16 = IT_LIGHTNING;									/// Death Fix
+
 // explode if under water
 	if (self.waterlevel > 1)
 	{
@@ -516,6 +523,7 @@
 
 void() GrenadeExplode =
 {
+	parm16 = IT_GRENADE_LAUNCHER;								/// Death Fix
 	T_RadiusDamage (self, self.owner, 120, world);
 
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
@@ -629,6 +637,7 @@
 	local vector	dir;
 	local entity	old;
 	
+	parm16 = IT_SUPER_NAILGUN;								/// Death Fix
 	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
 	self.attack_finished = time + 0.2;
 	self.currentammo = self.ammo_nails = self.ammo_nails - 2;
@@ -691,6 +700,7 @@
 	if (other.takedamage)
 	{
 		spawn_touchblood (9);
+		parm16 = IT_NAILGUN;								/// Death Fix
 		T_Damage (other, self, self.owner, 9);
 	}
 	else
@@ -731,6 +741,7 @@
 	if (other.takedamage)
 	{
 		spawn_touchblood (18);
+		parm16 = IT_SUPER_NAILGUN;							/// Death Fix
 		T_Damage (other, self, self.owner, 18);
 	}
 	else
