#!/usr/local/bin/perl5
#
###############################################################################
## ------------------------------------------------------------------------- ##
## ProgramName......... TripleX RankingS - rank.pl                           ##
## ------------------------------------------------------------------------- ##
## Programmer.......... TripleX                                              ##
## eMail............... mrbrain@cs.tu-berlin.de                              ##
## Homepage............ http://user.cs.tu-berlin.de/~mrbrain/                ##
## ------------------------------------------------------------------------- ##
## current Version..... 2.02                                                 ##
## ReleaseDate......... none                                                 ##
## SoftwareStatus...... private                                              ##
## ------------------------------------------------------------------------- ##
## Requirements........ - Perl as Version 5 or above                         ##
## ------------------------------------------------------------------------- ##
## History..... v1.00 : - first initial Try                                  ##
##              v1.01 : - completed first Tables                             ##
##              v1.02 : - added another ColorSceme for printable Output      ##
##              v1.03 : - changed to CGI again                               ##
##              v1.04 : - added PlayerStats                                  ##
##              v1.05 : - corrected Sorting on Skill                         ##
##                      - added Overview in selected Player to Details       ##
##              v1.06 : - changed PlayerCollsion to TeleFrag                 ##
##              v1.07 : - corrected Usage of TeleFrags in all Tables         ##
##                      - added FragsOverMatch to PlayerDetails              ##
##                      - corrected BFG10k-Phrases                           ##
##                      - changed SelfKill with misc. Weapon to RL           ##
##                      - PlayerList now sorted on Frags                     ##
##                                                                           ##
##              v2.00 : - splitted RankingCGI into multiple Parts            ##
##                      - removed FragsOverMatch-Stats                       ##
##              v2.01 : - added _total - Value to Kills, Deaths, Suicids     ##
##                      - skipps Lines > 255                                 ##
##              v2.02 : - changed Usage over the CommandLine                 ##
##                      - now allways extends Database (delete               ##
##                        or rename to create some new)                      ##
## ------------------------------------------------------------------------- ##
## Purpose............. Ranks the ConsoleLogFile into a Database.            ##
## ------------------------------------------------------------------------- ##
## Features............ - builds Database out of ConsoleLogFile              ##
##                      - extends Database with new ConsoleLogFile           ##
##                      - ranks Quake II v3.12 Deathmatch only               ##
##                      - needed for RANK.CGI to present some Rankings       ##
## ------------------------------------------------------------------------- ##
## known Bugs.......... none                                                 ##
## ------------------------------------------------------------------------- ##
## Usage............... This Script is used to build up the DataBase needed  ##
##                      by RANK.CGI. This Script reads in the ConsoleLogFile ##
##                      and adds it to the DataBase. If no DataBase exists   ##
##                      a new will be created.                               ##
##                                                                           ##
##                      Simply start that Script in the Shell:               ##
##                                                                           ##
##                      $> perl rank.pl <consolelogfile>                     ##
##                                                                           ##
##                      On most Systems the PERL in Front can be left off.   ##
##                      This will read the LogFile and rank all needed       ##
##                      Data out of it!                                      ##
##                                                                           ##
##                      While the LogFile will allways be added to the       ##
##                      allready existing DataBase you should move the       ##
##                      LogFile of your Server to this Directory so          ##
##                      no Data will be ranked twice! This is very important ##
##                      to get it work right.                                ##
##                                                                           ##
##                      The Server will create a new LogFile which can be    ##
##                      ranked again without the Problem of DoubleRankings.  ##
##                      It's your Choice to do this Job by Hand every Day    ##
##                      or with some Script that controlls the Server.       ##
##                                                                           ##
##                      To create a new DataBase you'll have to rename or    ##
##                      delete the old one.                                  ##
##                                                                           ##
##                                                                           ##
##                      Don't forget to make this executable if you're       ##
##                      using some UnixSystem.                               ##
##                      Make sure that the FileFormat remains as needed.     ##
##                      On Unix-Systems the LineFeeds are other than on Win. ##
## ------------------------------------------------------------------------- ##
##         (C) Copyright 1998 by TripleX - All Rights reserved!              ##
## ------------------------------------------------------------------------- ##
###############################################################################

###################################################################
# set some Variables ##############################################
###################################################################

$version    = "v2.02";
$database   = "rankings.dat";
$playerbase = "players.dat";

###################################################################
# take the Action #################################################
###################################################################

&start;
&check_args;
&load;
&rank;
&save;
exit;

###################################################################
# Subroutines #####################################################
###################################################################

sub start {
  print "\n";
  print "  -=[ TripleX RankingS $version - Ranker ]=-\n";
  print "\n";
}

sub check_args {
  print "  Checking Arguments... ";
  if (!@ARGV) { print "ERROR: Filename missing!\n"; &usage; exit; }
  $ARGS{'file'} = $ARGV[0];
  print "done\n";
}

sub usage {
  print "\n";
  print "  Usage: perl rank.pl <consolelogfile>\n";
  print "\n";
}

sub rank {
  print "  Ranking ConsoleLogFile... ";
  ##### read saved File...
  if (!open(FILE,$ARGS{'file'})) { die "ERROR: Can't open ConsoleLogFile!\n"; }
  @console = <FILE>;
  close(FILE);

  ##### build up the RankingArrays...
  $lines = 0;
  foreach $line (@console) {
    $line =~ s/\n//g;
    $line =~ s/\r//g;
    if (($line =~ s/(.)/\1/g) > 255) { }
    elsif ($line =~ /^.* died\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) died\.$/\1/;
      $DATA{$player1.'_suicids_unknown'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* feels pain\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) feels pain\.$/\1/;
      $DATA{$player1.'_suicids_unknown'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* killed himself\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) killed himself\.$/\1/;
      $DATA{$player1.'_suicids_command'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* killed herself\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) killed herself\.$/\1/;
      $DATA{$player1.'_suicids_command'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* should have used a smaller gun\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) should have used a smaller gun\.$/\1/;
      $DATA{$player1.'_suicids_rocketlauncher'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* blew himself up\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) blew himself up\.$/\1/;
      $DATA{$player1.'_suicids_rocketlauncher'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* blew herself up\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) blew herself up\.$/\1/;
      $DATA{$player1.'_suicids_rocketlauncher'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* tripped on his own grenade\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) tripped on his own grenade\.$/\1/;
      $DATA{$player1.'_suicids_handgrenade'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* tripped on her own grenade\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) tripped on her own grenade\.$/\1/;
      $DATA{$player1.'_suicids_handgrenade'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* tried to put the pin back in\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) tried to put the pin back in\.$/\1/;
      $DATA{$player1.'_suicids_grenadelauncher'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* was in the wrong place\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) was in the wrong place\.$/\1/;
      $DATA{$player1.'_suicids_bfg'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* got blasted\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) got blasted\.$/\1/;
      $DATA{$player1.'_suicids_trapblaster'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* saw the light\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) saw the light\.$/\1/;
      $DATA{$player1.'_suicids_traplaser'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* found a way out\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) found a way out\.$/\1/;
      $DATA{$player1.'_suicids_unknown'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* blew up\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) blew up\.$/\1/;
      $DATA{$player1.'_suicids_explosive'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* does a back flip into the lava\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) does a back flip into the lava\.$/\1/;
      $DATA{$player1.'_suicids_lava'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* melted\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) melted\.$/\1/;
      $DATA{$player1.'_suicids_slime'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* sank like a rock\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) sank like a rock\.$/\1/;
      $DATA{$player1.'_suicids_water'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* was squished\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) was squished\.$/\1/;
      $DATA{$player1.'_suicids_squish'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* cratered\.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) cratered\.$/\1/;
      $DATA{$player1.'_suicids_freefall'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* suicides$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) suicides$/\1/;
      $DATA{$player1.'_suicids_command'}++;
      $DATA{$player1.'_suicids_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
    }
    elsif ($line =~ /^.* tried to invade .*'s personal space$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) tried to invade (.*)'s personal space$/\1/;
      $player2 =~ s/^(.*) tried to invade (.*)'s personal space$/\2/;
      $DATA{$player1.'_deaths_telefrag'}++;
      $DATA{$player2.'_kills_telefrag'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* didn't see .*'s handgrenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) didn't see (.*)'s handgrenade$/\1/;
      $player2 =~ s/^(.*) didn't see (.*)'s handgrenade$/\2/;
      $DATA{$player1.'_deaths_handgrenade'}++;
      $DATA{$player2.'_kills_handgrenade'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* caught .*'s handgrenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) caught (.*)'s handgrenade$/\1/;
      $player2 =~ s/^(.*) caught (.*)'s handgrenade$/\2/;
      $DATA{$player1.'_deaths_handgrenade'}++;
      $DATA{$player2.'_kills_handgrenade'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* couldn't hide from .*'s BFG$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) couldn't hide from (.*)'s BFG$/\1/;
      $player2 =~ s/^(.*) couldn't hide from (.*)'s BFG$/\2/;
      $DATA{$player1.'_deaths_bfg'}++;
      $DATA{$player2.'_kills_bfg'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was disintegrated by .*'s BFG blast$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was disintegrated by (.*)'s BFG blast$/\1/;
      $player2 =~ s/^(.*) was disintegrated by (.*)'s BFG blast$/\2/;
      $DATA{$player1.'_deaths_bfg'}++;
      $DATA{$player2.'_kills_bfg'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* saw the pretty lights from .*'s BFG$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) saw the pretty lights from (.*)'s BFG$/\1/;
      $player2 =~ s/^(.*) saw the pretty lights from (.*)'s BFG$/\2/;
      $DATA{$player1.'_deaths_bfg'}++;
      $DATA{$player2.'_kills_bfg'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was melted by .*'s hyperblaster$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was melted by (.*)'s hyperblaster$/\1/;
      $player2 =~ s/^(.*) was melted by (.*)'s hyperblaster$/\2/;
      $DATA{$player1.'_deaths_hyperblaster'}++;
      $DATA{$player2.'_kills_hyperblaster'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was railed by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was railed by (.*)$/\1/;
      $player2 =~ s/^(.*) was railed by (.*)$/\2/;
      $DATA{$player1.'_deaths_railgun'}++;
      $DATA{$player2.'_kills_railgun'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* almost dodged .*'s rocket$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) almost dodged (.*)'s rocket$/\1/;
      $player2 =~ s/^(.*) almost dodged (.*)'s rocket$/\2/;
      $DATA{$player1.'_deaths_rocketlauncher'}++;
      $DATA{$player2.'_kills_rocketlauncher'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* ate .*'s rocket$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) ate (.*)'s rocket$/\1/;
      $player2 =~ s/^(.*) ate (.*)'s rocket$/\2/;
      $DATA{$player1.'_deaths_rocketlauncher'}++;
      $DATA{$player2.'_kills_rocketlauncher'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was shredded by .*'s shrapnel$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was shredded by (.*)'s shrapnel$/\1/;
      $player2 =~ s/^(.*) was shredded by (.*)'s shrapnel$/\2/;
      $DATA{$player1.'_deaths_grenadelauncher'}++;
      $DATA{$player2.'_kills_grenadelauncher'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was popped by .*'s grenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was popped by (.*)'s grenade$/\1/;
      $player2 =~ s/^(.*) was popped by (.*)'s grenade$/\2/;
      $DATA{$player1.'_deaths_grenadelauncher'}++;
      $DATA{$player2.'_kills_grenadelauncher'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was cut in half by .*'s chaingun$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was cut in half by (.*)'s chaingun$/\1/;
      $player2 =~ s/^(.*) was cut in half by (.*)'s chaingun$/\2/;
      $DATA{$player1.'_deaths_chaingun'}++;
      $DATA{$player2.'_kills_chaingun'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was machinegunned by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was machinegunned by (.*)$/\1/;
      $player2 =~ s/^(.*) was machinegunned by (.*)$/\2/;
      $DATA{$player1.'_deaths_machinegun'}++;
      $DATA{$player2.'_kills_machinegun'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was blown away by .*'s super shotgun$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was blown away by (.*)'s super shotgun$/\1/;
      $player2 =~ s/^(.*) was blown away by (.*)'s super shotgun$/\2/;
      $DATA{$player1.'_deaths_supershotgun'}++;
      $DATA{$player2.'_kills_supershotgun'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was blasted by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was blasted by (.*)$/\1/;
      $player2 =~ s/^(.*) was blasted by (.*)$/\2/;
      $DATA{$player1.'_deaths_blaster'}++;
      $DATA{$player2.'_kills_blaster'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
    elsif ($line =~ /^.* was gunned down by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was gunned down by (.*)$/\1/;
      $player2 =~ s/^(.*) was gunned down by (.*)$/\2/;
      $DATA{$player1.'_deaths_shotgun'}++;
      $DATA{$player2.'_kills_shotgun'}++;
      $DATA{$player1.'_deaths_total'}++;
      $DATA{$player2.'_kills_total'}++;
      $found=0; foreach $player (@players) { if ($player eq $player1) { $found=1; } } if (!$found) { @players = (@players, $player1) }
      $found=0; foreach $player (@players) { if ($player eq $player2) { $found=1; } } if (!$found) { @players = (@players, $player2) }
    }
  }
  print "done\n";
}

sub load {
  print "  Loading old DataBase... ";
  if (!open(FILE,"$database")) { print "ERROR: Not found! New DataBase will be created!\n"; }
  @rankdata = <FILE>;
  close(FILE);
  foreach $pair (@rankdata) {
    $pair =~ s/\n//g;
    $pair =~ s/\r//g;
    if ($pair ne '') {
      ($variable,$value) = split (/ = /,$pair);
      $DATA{$variable} = $value;
    }
  }
  if (@rankdata) { print "done\n"; }
  print "  Loading old PlayerBase... ";
  if (!open(FILE,"$playerbase")) { print "ERROR: Not found! New PlayerBase will be created!\n"; }
  @playerdata = <FILE>;
  close(FILE);
  foreach $line (@playerdata) {
    $line =~ s/\n//g;
    $line =~ s/\r//g;
    if ($line ne '') { @players = (@players, $line);  }
  }
  if (@playerdata) { print "done\n"; }
}

sub save {
  print "  Saving new DataBase... ";
  if (!open(FILE,">$database")) { die "ERROR: Couldn't create DataBase!\n"; }
  foreach $value (keys %DATA) {
    print FILE "$value = $DATA{$value}\n";
  }
  close(FILE);
  print "done\n";
  print "  Saving new PlayerBase... ";
  if (!open(FILE,">$playerbase")) { die "ERROR: Couldn't create PlayerBase!\n"; }
  foreach $player (@players) {
    print FILE "$player\n";
  }
  close(FILE);
  print "done\n";
}
             