#!/usr/local/bin/perl5
#
###############################################################################
## ------------------------------------------------------------------------- ##
## ProgramName......... TripleX RankingS - rank.cgi                          ##
## ------------------------------------------------------------------------- ##
## Programmer.......... TripleX                                              ##
## eMail............... mrbrain@cs.tu-berlin.de                              ##
## Homepage............ http://user.cs.tu-berlin.de/~mrbrain/                ##
## ------------------------------------------------------------------------- ##
## current Version..... 2.02                                                 ##
## ReleaseDate......... none                                                 ##
## SoftwareStatus...... private                                              ##
## ------------------------------------------------------------------------- ##
## Requirements........ - Perl as Version 5 or above                         ##
##                      - CGI-Usage on WebServer                             ##
##                      - some Space for the LogFiles                        ## 
## ------------------------------------------------------------------------- ##
## History..... v1.00 : - first initial Try                                  ##
##              v1.01 : - completed first Tables                             ##
##              v1.02 : - added another ColorSceme for printable Output      ##
##              v1.03 : - changed to CGI again                               ##
##              v1.04 : - added PlayerStats                                  ##
##              v1.05 : - corrected Sorting on Skill                         ##
##                      - added Overview in selected Player to Details       ##
##              v1.06 : - changed PlayerCollsion to TeleFrag                 ##
##              v1.07 : - corrected Usage of TeleFrags in all Tables         ##
##                      - added FragsOverMatch to PlayerDetails              ##
##                      - corrected BFG10k-Phrases                           ##
##                      - changed SelfKill with misc. Weapon to RL           ##
##                      - PlayerList now sorted on Frags                     ##
##                                                                           ##
##              v2.00 : - splitted old CGI into multiple Parts               ##
##                      - mentioned for WebAccess to the Database            ##
##                      - canceled FragsOverTime-Stats                       ##
##                      - added CommandLineParsing                           ##
##              v2.01 : - changed some Syntax do to new Variables provided   ##
##                      - perfected Scaling of BarCharts                     ##
##                      - added Top 10, Top 50, Top 100 and Complete         ##
##                      - added Sorting on Kills, Deaths, Suicids, Frags,    ##
##                        Skill and Name                                     ##
##              v2.02 : - redesigned ControlLinks                            ##
##                      - added SummaryLine for Overview                     ##
##                      - added Top 25                                       ##
## ------------------------------------------------------------------------- ##
## Purpose............. Provides CGI-WebPages with Content of Database.      ##
## ------------------------------------------------------------------------- ##
## Features............ - Overview on all Players                            ##
##                      - Details on used Weapons and Suicids                ##
##                      - clear TableDesign with grafic BarCharts            ##
##                      - 2 different ColorScemes                            ##
##                      - Details for every single Player                    ##
##                      - Top 10, 25, 50, 100 and complete Listing           ##
##                      - Sorting on Name, Kills, Deaths, Suicids, Frags &   ##
##                        Skill                                              ##
##                      - CommandLineParser for Testing over Shell           ##
## ------------------------------------------------------------------------- ##
## known Bugs.......... none                                                 ##
## ------------------------------------------------------------------------- ##
## Usage............... Simply call the CGI without any Arguments...         ##
##                                                                           ##
##                      http://.../rank.cgi                                  ##
##                                                                           ##
##                      From there every Feature of the Rankings is          ##
##                      provided with Links. You don't need any more Infos.  ##
##                      To start the CGI with some special Configuration     ##
##                      simply copy the URL of the Version you like most!    ##
##                                                                           ##
##                      Note that the created Tables need some Time to       ##
##                      display in the Browser - the more Players are used   ##
##                      the longer the Table need to show up. So you should  ##
##                      set the Top10 as default on your Webpage!            ##
##                                                                           ##
##                      It is clear that some Database allready has to       ##
##                      exist! So be sure to use RANK.PL first!              ##
##                                                                           ##
##                      Make sure that the FileFormat remains as needed.     ##
##                      On Unix-Systems the LineFeeds are other than on Win. ##
## ------------------------------------------------------------------------- ##
##         (C) Copyright 1998 by TripleX - All Rights reserved!              ##
## ------------------------------------------------------------------------- ##
###############################################################################

###################################################################
# set some Variables ##############################################
###################################################################

$version    = "v2.02";
$database   = "rankings.dat";
$playerbase = "players.dat";

##### automated Variable-Settings...
@script   = split(/\//,$0);
$cgi      = $script[(@script)-1];

###################################################################
# get Input and Arguments #########################################
###################################################################

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/<(.*)>/&lt;\1>/g;
   $value =~ s/\n//g;
   $value =~ s/\r//g;
   $value =~ s/\\/\//g;
   $ARGS{$name} = $value;
}

$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/<(.*)>/&lt;\1>/g;
   $value =~ s/\n//g;
   $value =~ s/\r//g;
   $value =~ s/\\/\//g;
   $ARGS{$name} = $value;
}

foreach $pair (@ARGV) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/<(.*)>/&lt;\1>/g;
   $value =~ s/\n//g;
   $value =~ s/\r//g;
   $value =~ s/\\/\//g;
   $ARGS{$name} = $value;
}

###################################################################
# get Date and Time ###############################################
###################################################################

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

$month = ($mon + 1);

if ($sec < 10) { $sec = "0$sec"; }
if ($min < 10) { $min = "0$min"; }
if ($hour < 10) { $hour = "0$hour"; }
if ($month < 10) { $month = "0$month"; }
if ($mday < 10) { $mday = "0$mday"; }

$date = "$year/$month/$mday";
$time = "$hour\:$min\:$sec";

###################################################################
# take the Action #################################################
###################################################################

##### set Colors for the Tables...
if ($ARGS{'color'} == 2) { $c1 = "#FFFFFF"; $c2 = "#448866"; $c3 = "#66AA88"; $c4 = "#DDDDDD"; $c5 = "#000000"; $c6 = "#000000"; $c7= "#000088"; $c8 = "#002200"; }
else { $c1 = "#000000"; $c2 = "#111144"; $c3 = "#222266"; $c4 = "#222222"; $c5 = "#444444"; $c6 = "#AAAAAA"; $c7= "#FF0000"; $c8 = "#008800"; }

##### let's go...
if ($ARGS{'action'} eq 'details') { &header("TripleX RankingS"); &load; &sort; &html_details; &footer; exit; }
else { &header("TripleX RankingS"); &load; &sort; &html_main; &footer; exit; }

###################################################################
# Subroutines #####################################################
###################################################################

sub header {
  ##### Header of HTML-File...
  print "Content-type: text/html\n\n";
  print "<HTML><HEAD><TITLE>@_</TITLE>\n";
  print "  <STYLE TYPE=\"text\/css\">\n";
  print "    <!--\n";
  print "    A\:link {text-decoration: none}\n";
  print "    A\:visited {text-decoration: none}\n";
  print "    A\:active {text-decoration: none}\n";
  print "    -->\n";
  print "  </STYLE></HEAD>\n";
  print "<BODY BGCOLOR=\"$c1\" TEXT=\"$c6\" LINK=\"$c7\" ALINK=\"$c7\" VLINK=\"$c7\">\n";
  print "<FONT FACE=\"Tahoma,Verdana,Arial\">\n\n";
}

sub footer {
  print "<BR>\n";
  print "<CENTER><FONT FACE=\"Tahoma,Verdana,Arial\" SIZE=1>\n";
  print "-=[ Output generated by TripleX QuakE-II-RankingS $version ]=-<BR>\n";
  print "-=[ Copyright 1998 by <A HREF=\"mailto:mrbrain\@cs.tu-berlin.de\">TripleX</A> - All Rights reserved! ]=-\n";
  print "</FONT></CENTER>\n";
  print "\n\n</FONT>\n";
  print "</BODY></HTML>\n";
}

sub error_msg {
  &header("Ups!");
  print "<BR><BR>\n";
  print "<BR><BR><CENTER><FONT COLOR=\"#FF0000\" SIZE=8><BLINK><B>ERROR</B></BLINK></FONT></CENTER>\n";
  print "<BR><BR><CENTER><B>@_</B></CENTER>\n";
  &footer;
  exit;
}

sub load {
  if (!open(FILE,"$database")) { &error_msg("Couldn't open DataBase!"); }
  @rankdata = <FILE>;
  close(FILE);
  foreach $pair (@rankdata) {
    $pair =~ s/\n//g;
    $pair =~ s/\r//g;
    if ($pair ne '') {
      ($variable,$value) = split (/ = /,$pair);
      $DATA{$variable} = $value;
    }
  }
  if (!open(FILE,"$playerbase")) { &error_msg("Couldn't open PlayerBase!"); }
  @playerdata = <FILE>;
  close(FILE);
  foreach $line (@playerdata) {
    $line =~ s/\n//g;
    $line =~ s/\r//g;
    if ($line ne '') { @players = (@players, $line);  }
  }
}

sub sort {
  if ($ARGS{'sort'} eq 'name') { @players = sort {uc($a) cmp uc($b)}@players; }
  elsif ($ARGS{'sort'} eq 'kills') { @players = sort {$DATA{$b.'_kills_total'} <=> $DATA{$a.'_kills_total'}} @players; }
  elsif ($ARGS{'sort'} eq 'deaths') { @players = sort {$DATA{$b.'_deaths_total'} <=> $DATA{$a.'_deaths_total'}} @players; }
  elsif ($ARGS{'sort'} eq 'suicids') { @players = sort {$DATA{$b.'_suicids_total'} <=> $DATA{$a.'_suicids_total'}} @players; }
  elsif ($ARGS{'sort'} eq 'frags') { @players = sort {($DATA{$b.'_kills_total'} - $DATA{$b.'_suicids_total'}) <=> ($DATA{$a.'_kills_total'} - $DATA{$a.'_suicids_total'})} @players; }
  elsif ($ARGS{'sort'} eq 'skill') { @players = sort {($DATA{$b.'_kills_total'} / ($DATA{$b.'_deaths_total'} + $DATA{$b.'_suicids_total'} + 1)) <=> ($DATA{$a.'_kills_total'} / ($DATA{$a.'_deaths_total'} + $DATA{$a.'_suicids_total'} + 1))} @players; }
}

sub html_main {
  print "<CENTER><TABLE><TR><TD ALIGN=CENTER VALIGN=TOP>\n";
    ##### some first Links to all the Features...
    print "<BR><BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=2 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Control</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\"><TD ALIGN=LEFT WIDTH=50><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Sort by</B></FONT></TD><TD ALIGN=LEFT WIDTH=50><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Show</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c1\"><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=$ARGS{'number'}&sort=name&color=$ARGS{'color'}\">Name</A></FONT></TD><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=10&sort=$ARGS{'sort'}&color=$ARGS{'color'}\">Top 10</A></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c1\"><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=$ARGS{'number'}&sort=kills&color=$ARGS{'color'}\">Kills</A></FONT></TD><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=25&sort=$ARGS{'sort'}&color=$ARGS{'color'}\">Top 25</A></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c1\"><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=$ARGS{'number'}&sort=deaths&color=$ARGS{'color'}\">Deaths</A></FONT></TD><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=50&sort=$ARGS{'sort'}&color=$ARGS{'color'}\">Top 50</A></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c1\"><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=$ARGS{'number'}&sort=suicids&color=$ARGS{'color'}\">Suicids</A></FONT></TD><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=100&sort=$ARGS{'sort'}&color=$ARGS{'color'}\">Top 100</A></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c1\"><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=$ARGS{'number'}&sort=frags&color=$ARGS{'color'}\">Frags</A></FONT></TD><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?sort=$ARGS{'sort'}&color=$ARGS{'color'}\">Complete</A></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c1\"><TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=$ARGS{'number'}&sort=skill&color=$ARGS{'color'}\">Skill</A></FONT></TD><TD></TD></TR>\n";
    print "<TR BGCOLOR=\"$c4\"><TD ALIGN=CENTER COLSPAN=2><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\"><A HREF=\"$cgi?number=$ARGS{'number'}&sort=$ARGS{'sort'}&color=2\" TARGET=\"_blank\">printable Version</A></FONT></TD></TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";
  print "</TD><TD ALIGN=CENTER VALIGN=TOP>\n";
    ##### Overview-Table...
    print "<BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=8 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Overview on Players</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT WIDTH=75><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Name</B></FONT></TD>\n";
    print "<TD ALIGN=RIGHT WIDTH=10><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Nr</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Kills</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Deaths</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Suicids</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Frags</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT WIDTH=75 COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Skill</B></FONT></TD>\n";
    print "</TR>\n";
    $n = 0;
    ##### compute right ScaleVariable...
    $last = 0;
    foreach $player (@players) {
      $skill = $DATA{$player.'_kills_total'} / ($DATA{$player.'_deaths_total'} + $DATA{$player.'_suicids_total'} + 1);
      if ($skill > $last) { $last = $skill; }
    }
    $scale = ( 50 / $last);
    $n=0;
    foreach $player (@players) {
      $n++;
      ##### check for Top-something-Limit...
      if (($n > $ARGS{'number'})&&($ARGS{'number'})) { last; }
      ##### current Background...
      if ($bgcolor eq "$c1") { $bgcolor = "$c4"; } else { $bgcolor = "$c1"; }
      ##### some Values...
      $kills = $DATA{$player.'_kills_total'}; $sum_kills += $kills;
      $deaths = $DATA{$player.'_deaths_total'}; $sum_deaths += $deaths;
      $suicids = $DATA{$player.'_suicids_total'}; $sum_suicids += $suicids;
      $frags = $kills - $suicids;
      $skill = $kills / ($deaths + $suicids + 1);
      $width = int($skill * $scale) + 1;
      $hexplayer = $player; $hexplayer =~ s/ /%20/g;
      ##### the TableRow...
      print "<TR BGCOLOR=\"$bgcolor\">\n";
      print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">";
      print "<A HREF=\"$cgi?action=details&player=$hexplayer&sort=$ARGS{'sort'}&color=$ARGS{'color'}\">$player</A></FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$n</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$kills</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$deaths</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$suicids</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$frags</FONT></TD>\n";
      printf ("<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">%.3f</FONT></TD>\n",$skill);
      print "<TD ALIGN=LEFT VALIGN=CENTER><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$width HEIGHT=7></TD>\n";
      print "</TR>\n";
    }
    ##### Summary below...
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Summary</B></FONT></TD>\n";
    print "<TD ALIGN=CENTER><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>-</B></FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>$sum_kills</B></FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>$sum_deaths</B></FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>$sum_suicids</B></FONT></TD>\n";
    print "<TD ALIGN=CENTER><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>-</B></FONT></TD>\n";
    print "<TD ALIGN=CENTER><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>-</B></FONT></TD>\n";
    print "<TD ALIGN=CENTER><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>-</B></FONT></TD>\n";
    print "</TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";

  print "</TD></TR></TABLE></CENTER>\n";
  print "<CENTER><TABLE><TR><TD ALIGN=CENTER VALIGN=TOP>\n";

    ##### Kills-Table...
    print "<BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Kills</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Weapon</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Kills</B></FONT></TD>\n";
    print "</TR>\n";
    $n=0;
    foreach $player (@players) {
      $n++;
      if (($n > $ARGS{'number'})&&($ARGS{'number'})) { last; }
      $w_blaster += $DATA{$player.'_kills_blaster'}; 
      $w_shotgun += $DATA{$player.'_kills_shotgun'}; 
      $w_supershotgun += $DATA{$player.'_kills_supershotgun'}; 
      $w_machinegun += $DATA{$player.'_kills_machinegun'}; 
      $w_chaingun += $DATA{$player.'_kills_chaingun'}; 
      $w_grenadelauncher += $DATA{$player.'_kills_grenadelauncher'}; 
      $w_rocketlauncher += $DATA{$player.'_kills_rocketlauncher'}; 
      $w_hyperblaster += $DATA{$player.'_kills_hyperblaster'}; 
      $w_railgun += $DATA{$player.'_kills_railgun'}; 
      $w_bfg += $DATA{$player.'_kills_bfg'}; 
      $w_handgrenade += $DATA{$player.'_kills_handgrenade'}; 
      $w_telefrag += $DATA{$player.'_kills_telefrag'}; 
    }
    $last = 0;
    if ($w_blaster > $last) { $last = $w_blaster; }
    if ($w_shotgun > $last) { $last = $w_shotgun; }
    if ($w_supershotgun > $last) { $last = $w_supershotgun; }
    if ($w_machinegun > $last) { $last = $w_machinegun; }
    if ($w_chaingun > $last) { $last = $w_chaingun; }
    if ($w_grenadelauncher > $last) { $last = $w_grenadelauncher; }
    if ($w_rocketlauncher > $last) { $last = $w_rocketlauncher; }
    if ($w_hyperblaster > $last) { $last = $w_hyperblaster; }
    if ($w_railgun > $last) { $last = $w_railgun; }
    if ($w_bfg > $last) { $last = $w_bfg; }
    if ($w_handgrenade > $last) { $last = $w_handgrenade; }
    if ($w_telefrag > $last) { $last = $w_telefrag; }
    $scale = (50 / $last);
    $p_blaster = int($w_blaster * $scale) + 1;
    $p_shotgun = int($w_shotgun * $scale) + 1;
    $p_supershotgun = int($w_supershotgun * $scale) + 1;
    $p_machinegun = int($w_machinegun * $scale) + 1;
    $p_chaingun = int($w_chaingun * $scale) + 1;
    $p_grenadelauncher = int($w_grenadelauncher * $scale) + 1;
    $p_rocketlauncher = int($w_rocketlauncher * $scale) + 1;
    $p_hyperblaster = int($w_hyperblaster * $scale) + 1;
    $p_railgun = int($w_railgun * $scale) + 1;
    $p_bfg = int($w_bfg * $scale) + 1;
    $p_handgrenade = int($w_handgrenade * $scale) + 1;
    $p_telefrag = int($w_telefrag * $scale) + 1;
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Blaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_blaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_blaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Shotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_shotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_shotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">SuperShotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_supershotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_supershotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">MachineGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_machinegun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_machinegun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">ChainGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_chaingun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_chaingun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">GrenadeLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_grenadelauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_grenadelauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RocketLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_rocketlauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_rocketlauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HyperBlaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_hyperblaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_hyperblaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RailGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_railgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_railgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BFG10k</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_bfg</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_bfg HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HandGrenade</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_handgrenade</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_handgrenade HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Telefrag</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_telefrag</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_telefrag HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";
  
  print "</TD><TD ALIGN=CENTER VALIGN=TOP>\n";

    ##### Deaths-Table...
    print "<BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Deaths</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Weapon</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Deaths</B></FONT></TD>\n";
    print "</TR>\n";
    $n=0;
    foreach $player (@players) {
      $n++;
      if (($n > $ARGS{'number'})&&($ARGS{'number'})) { last; }
      $d_blaster += $DATA{$player.'_deaths_blaster'}; 
      $d_shotgun += $DATA{$player.'_deaths_shotgun'}; 
      $d_supershotgun += $DATA{$player.'_deaths_supershotgun'}; 
      $d_machinegun += $DATA{$player.'_deaths_machinegun'}; 
      $d_chaingun += $DATA{$player.'_deaths_chaingun'}; 
      $d_grenadelauncher += $DATA{$player.'_deaths_grenadelauncher'}; 
      $d_rocketlauncher += $DATA{$player.'_deaths_rocketlauncher'}; 
      $d_hyperblaster += $DATA{$player.'_deaths_hyperblaster'}; 
      $d_railgun += $DATA{$player.'_deaths_railgun'}; 
      $d_bfg += $DATA{$player.'_deaths_bfg'}; 
      $d_handgrenade += $DATA{$player.'_deaths_handgrenade'}; 
      $d_telefrag += $DATA{$player.'_deaths_telefrag'}; 
    }
    $last = 0;
    if ($d_blaster > $last) { $last = $d_blaster; }
    if ($d_shotgun > $last) { $last = $d_shotgun; }
    if ($d_supershotgun > $last) { $last = $d_supershotgun; }
    if ($d_machinegun > $last) { $last = $d_machinegun; }
    if ($d_chaingun > $last) { $last = $d_chaingun; }
    if ($d_grenadelauncher > $last) { $last = $d_grenadelauncher; }
    if ($d_rocketlauncher > $last) { $last = $d_rocketlauncher; }
    if ($d_hyperblaster > $last) { $last = $d_hyperblaster; }
    if ($d_railgun > $last) { $last = $d_railgun; }
    if ($d_bfg > $last) { $last = $d_bfg; }
    if ($d_handgrenade > $last) { $last = $d_handgrenade; }
    if ($d_telefrag > $last) { $last = $d_telefrag; }
    $scale = (50 / $last);
    $t_blaster = int($d_blaster * $scale) + 1;
    $t_shotgun = int($d_shotgun * $scale) + 1;
    $t_supershotgun = int($d_supershotgun * $scale) + 1;
    $t_machinegun = int($d_machinegun * $scale) + 1;
    $t_chaingun = int($d_chaingun * $scale) + 1;
    $t_grenadelauncher = int($d_grenadelauncher * $scale) + 1;
    $t_rocketlauncher = int($d_rocketlauncher * $scale) + 1;
    $t_hyperblaster = int($d_hyperblaster * $scale) + 1;
    $t_railgun = int($d_railgun * $scale) + 1;
    $t_bfg = int($d_bfg * $scale) + 1;
    $t_handgrenade = int($d_handgrenade * $scale) + 1;
    $t_telefrag = int($d_telefrag * $scale) + 1;
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Blaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_blaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_blaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Shotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_shotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_shotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">SuperShotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_supershotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_supershotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">MachineGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_machinegun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_machinegun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">ChainGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_chaingun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_chaingun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">GrenadeLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_grenadelauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_grenadelauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RocketLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_rocketlauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_rocketlauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HyperBlaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_hyperblaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_hyperblaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RailGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_railgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_railgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BFG10k</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_bfg</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_bfg HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HandGrenade</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_handgrenade</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_handgrenade HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Telefrag</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_telefrag</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_telefrag HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";
  
  print "</TD><TD ALIGN=CENTER VALIGN=TOP>\n";

    ##### Suicids-Table...
    print "<BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Suicids</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Reason</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Suicids</B></FONT></TD>\n";
    print "</TR>\n";
    $n=0;
    foreach $player (@players) {
      $n++;
      if (($n > $ARGS{'number'})&&($ARGS{'number'})) { last; }
      $s_lava += $DATA{$player.'_suicids_lava'}; 
      $s_slime += $DATA{$player.'_suicids_slime'}; 
      $s_water += $DATA{$player.'_suicids_water'}; 
      $s_squish += $DATA{$player.'_suicids_squish'}; 
      $s_explosive += $DATA{$player.'_suicids_explosive'}; 
      $s_rocketlauncher += $DATA{$player.'_suicids_rocketlauncher'}; 
      $s_handgrenade += $DATA{$player.'_suicids_handgrenade'}; 
      $s_grenadelauncher += $DATA{$player.'_suicids_grenadelauncher'}; 
      $s_bfg += $DATA{$player.'_suicids_bfg'}; 
      $s_trapblaster += $DATA{$player.'_suicids_trablaster'}; 
      $s_traplaser += $DATA{$player.'_suicids_traplaser'}; 
      $s_freefall += $DATA{$player.'_suicids_freefall'}; 
      $s_command += $DATA{$player.'_suicids_command'}; 
      $s_unknown += $DATA{$player.'_suicids_unknown'}; 
    }
    $last = 0;
    if ($s_lava > $last) { $last = $s_lava; }
    if ($s_slime > $last) { $last = $s_slime; }
    if ($s_water > $last) { $last = $s_water; }
    if ($s_squish > $last) { $last = $s_squish; }
    if ($s_explosive > $last) { $last = $s_explosive; }
    if ($s_rocketlauncher > $last) { $last = $s_rocketlauncher; }
    if ($s_handgrenade > $last) { $last = $s_handgrenade; }
    if ($s_grenadelauncher > $last) { $last = $s_grenadelauncher; }
    if ($s_bfg > $last) { $last = $s_bfg; }
    if ($s_trapblaster > $last) { $last = $s_trapblaster; }
    if ($s_traplaser > $last) { $last = $s_traplaser; }
    if ($s_freefall > $last) { $last = $s_freefall; }
    if ($s_command > $last) { $last = $s_command; }
    if ($s_unknown > $last) { $last = $s_unknown; }
    $scale = (50 / $last);
    $a_lava = int($s_lava * $scale) + 1;
    $a_slime = int($s_slime * $scale) + 1;
    $a_water = int($s_water * $scale) + 1;
    $a_squish = int($s_squish * $scale) + 1;
    $a_explosive = int($s_explosive * $scale) + 1;
    $a_rocketlauncher = int($s_rocketlauncher * $scale) + 1;
    $a_handgrenade = int($s_handgrenade * $scale) + 1;
    $a_grenadelauncher = int($s_grenadelauncher * $scale) + 1;
    $a_bfg = int($s_bfg * $scale) + 1;
    $a_trapblaster = int($s_trapblaster * $scale) + 1;
    $a_traplaser = int($s_traplaser * $scale) + 1;
    $a_freefall = int($s_freefall * $scale) + 1;
    $a_command = int($s_command * $scale) + 1;
    $a_unknown = int($s_unknown * $scale) + 1;
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Lava</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_lava</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_lava HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Slime</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_slime</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_slime HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Water</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_water</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_water HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Squish</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_squish</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_squish HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Explosive</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_explosive</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_explosive HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">GrenadeLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_grenadelauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_grenadelauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RocketLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_rocketlauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_rocketlauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BFG10k</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_bfg</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_bfg HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HandGrenade</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_handgrenade</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_handgrenade HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BlasterTrap</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_trapblaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_trapblaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">LaserTrap</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_traplaser</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_traplaser HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">free Fall</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_freefall</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_freefall HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Command KILL</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_command</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_command HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">unknown</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_unknown</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_unknown HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";

  print "</TD></TR></TABLE></CENTER>\n";
}            

sub html_details {
  ##### Overview-Table...
  print "<BR><BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
  print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=8 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Details of single Player</B></FONT></TD></TR>\n";
  print "<TR BGCOLOR=\"$c3\">\n";
  print "<TD ALIGN=LEFT WIDTH=75><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Name</B></FONT></TD>\n";
  print "<TD ALIGN=RIGHT WIDTH=10><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Nr</B></FONT></TD>\n";
  print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Kills</B></FONT></TD>\n";
  print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Deaths</B></FONT></TD>\n";
  print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Suicids</B></FONT></TD>\n";
  print "<TD ALIGN=LEFT WIDTH=30><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Frags</B></FONT></TD>\n";
  print "<TD ALIGN=LEFT WIDTH=75 COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Skill</B></FONT></TD>\n";
  print "</TR>\n";
  $n = 0;
  foreach $player (@players) {
    $n++;
    if ($player eq $ARGS{'player'}) {
      $kills = $DATA{$player.'_kills_total'};
      $deaths = $DATA{$player.'_deaths_total'};
      $suicids = $DATA{$player.'_suicids_total'};
      $frags = $kills - $suicids;
      $skill = $kills / ($deaths + $suicids + 1);
      $width = int($skill * 10) + 1;
      print "<TR BGCOLOR=\"$c1\">\n";
      print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$player</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$n</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$kills</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$deaths</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$suicids</FONT></TD>\n";
      print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$frags</FONT></TD>\n";
      printf ("<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">%.3f</FONT></TD>\n",$skill);
      print "<TD ALIGN=LEFT VALIGN=CENTER><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$width HEIGHT=7></TD>\n";
      print "</TR>\n";
    }
  }
  print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";

  print "<CENTER><TABLE><TR><TD ALIGN=CENTER VALIGN=TOP>\n";

    ##### Kills-Table...
    print "<BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Kills</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Weapon</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Kills</B></FONT></TD>\n";
    print "</TR>\n";
    foreach $player (@players) {
      if ($player eq $ARGS{'player'}) {
        $w_blaster = $DATA{$player.'_kills_blaster'}; 
        $w_shotgun = $DATA{$player.'_kills_shotgun'}; 
        $w_supershotgun = $DATA{$player.'_kills_supershotgun'}; 
        $w_machinegun = $DATA{$player.'_kills_machinegun'}; 
        $w_chaingun = $DATA{$player.'_kills_chaingun'}; 
        $w_grenadelauncher = $DATA{$player.'_kills_grenadelauncher'}; 
        $w_rocketlauncher = $DATA{$player.'_kills_rocketlauncher'}; 
        $w_hyperblaster = $DATA{$player.'_kills_hyperblaster'}; 
        $w_railgun = $DATA{$player.'_kills_railgun'}; 
        $w_bfg = $DATA{$player.'_kills_bfg'}; 
        $w_handgrenade = $DATA{$player.'_kills_handgrenade'}; 
        $w_telefrag = $DATA{$player.'_kills_telefrag'}; 
      }
    }
    $last = 0;
    if ($w_blaster > $last) { $last = $w_blaster; }
    if ($w_shotgun > $last) { $last = $w_shotgun; }
    if ($w_supershotgun > $last) { $last = $w_supershotgun; }
    if ($w_machinegun > $last) { $last = $w_machinegun; }
    if ($w_chaingun > $last) { $last = $w_chaingun; }
    if ($w_grenadelauncher > $last) { $last = $w_grenadelauncher; }
    if ($w_rocketlauncher > $last) { $last = $w_rocketlauncher; }
    if ($w_hyperblaster > $last) { $last = $w_hyperblaster; }
    if ($w_railgun > $last) { $last = $w_railgun; }
    if ($w_bfg > $last) { $last = $w_bfg; }
    if ($w_handgrenade > $last) { $last = $w_handgrenade; }
    if ($w_telefrag > $last) { $last = $w_telefrag; }
    $scale = (50 / $last);
    $p_blaster = int($w_blaster * $scale) + 1;
    $p_shotgun = int($w_shotgun * $scale) + 1;
    $p_supershotgun = int($w_supershotgun * $scale) + 1;
    $p_machinegun = int($w_machinegun * $scale) + 1;
    $p_chaingun = int($w_chaingun * $scale) + 1;
    $p_grenadelauncher = int($w_grenadelauncher * $scale) + 1;
    $p_rocketlauncher = int($w_rocketlauncher * $scale) + 1;
    $p_hyperblaster = int($w_hyperblaster * $scale) + 1;
    $p_railgun = int($w_railgun * $scale) + 1;
    $p_bfg = int($w_bfg * $scale) + 1;
    $p_handgrenade = int($w_handgrenade * $scale) + 1;
    $p_telefrag = int($w_telefrag * $scale) + 1;
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Blaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_blaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_blaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Shotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_shotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_shotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">SuperShotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_supershotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_supershotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">MachineGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_machinegun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_machinegun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">ChainGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_chaingun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_chaingun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">GrenadeLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_grenadelauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_grenadelauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RocketLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_rocketlauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_rocketlauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HyperBlaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_hyperblaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_hyperblaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RailGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_railgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_railgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BFG10k</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_bfg</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_bfg HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HandGrenade</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_handgrenade</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_handgrenade HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Telefrag</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$w_telefrag</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$p_telefrag HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";
  
  print "</TD><TD ALIGN=CENTER VALIGN=TOP>\n";

    ##### Deaths-Table...
    print "<BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Deaths</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Weapon</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Deaths</B></FONT></TD>\n";
    print "</TR>\n";
    foreach $player (@players) {
      if ($player eq $ARGS{'player'}) {
        $d_blaster = $DATA{$player.'_deaths_blaster'}; 
        $d_shotgun = $DATA{$player.'_deaths_shotgun'}; 
        $d_supershotgun = $DATA{$player.'_deaths_supershotgun'}; 
        $d_machinegun = $DATA{$player.'_deaths_machinegun'}; 
        $d_chaingun = $DATA{$player.'_deaths_chaingun'}; 
        $d_grenadelauncher = $DATA{$player.'_deaths_grenadelauncher'}; 
        $d_rocketlauncher = $DATA{$player.'_deaths_rocketlauncher'}; 
        $d_hyperblaster = $DATA{$player.'_deaths_hyperblaster'}; 
        $d_railgun = $DATA{$player.'_deaths_railgun'}; 
        $d_bfg = $DATA{$player.'_deaths_bfg'}; 
        $d_handgrenade = $DATA{$player.'_deaths_handgrenade'}; 
        $d_telefrag = $DATA{$player.'_deaths_telefrag'}; 
      }
    }
    $last = 0;
    if ($d_blaster > $last) { $last = $d_blaster; }
    if ($d_shotgun > $last) { $last = $d_shotgun; }
    if ($d_supershotgun > $last) { $last = $d_supershotgun; }
    if ($d_machinegun > $last) { $last = $d_machinegun; }
    if ($d_chaingun > $last) { $last = $d_chaingun; }
    if ($d_grenadelauncher > $last) { $last = $d_grenadelauncher; }
    if ($d_rocketlauncher > $last) { $last = $d_rocketlauncher; }
    if ($d_hyperblaster > $last) { $last = $d_hyperblaster; }
    if ($d_railgun > $last) { $last = $d_railgun; }
    if ($d_bfg > $last) { $last = $d_bfg; }
    if ($d_handgrenade > $last) { $last = $d_handgrenade; }
    if ($d_telefrag > $last) { $last = $d_telefrag; }
    $scale = (50 / $last);
    $t_blaster = int($d_blaster * $scale) + 1;
    $t_shotgun = int($d_shotgun * $scale) + 1;
    $t_supershotgun = int($d_supershotgun * $scale) + 1;
    $t_machinegun = int($d_machinegun * $scale) + 1;
    $t_chaingun = int($d_chaingun * $scale) + 1;
    $t_grenadelauncher = int($d_grenadelauncher * $scale) + 1;
    $t_rocketlauncher = int($d_rocketlauncher * $scale) + 1;
    $t_hyperblaster = int($d_hyperblaster * $scale) + 1;
    $t_railgun = int($d_railgun * $scale) + 1;
    $t_bfg = int($d_bfg * $scale) + 1;
    $t_handgrenade = int($d_handgrenade * $scale) + 1;
    $t_telefrag = int($d_telefrag * $scale) + 1;
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Blaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_blaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_blaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Shotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_shotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_shotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">SuperShotgun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_supershotgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_supershotgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">MachineGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_machinegun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_machinegun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">ChainGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_chaingun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_chaingun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">GrenadeLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_grenadelauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_grenadelauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RocketLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_rocketlauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_rocketlauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HyperBlaster</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_hyperblaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_hyperblaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RailGun</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_railgun</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_railgun HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BFG10k</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_bfg</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_bfg HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HandGrenade</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_handgrenade</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_handgrenade HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Telefrag</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$d_telefrag</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$t_telefrag HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";
  
  print "</TD><TD ALIGN=CENTER VALIGN=TOP>\n";

    ##### Suicids-Table...
    print "<BR><CENTER><TABLE BGCOLOR=\"$c5\" CELLSPACING=0 CELLPADDING=2 BORDER=0><TR><TD><TABLE BGCOLOR=\"$c1\" CELLSPACING=0 CELLPADDING=0 BORDER=0><TR><TD><TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1>\n";
    print "<TR BGCOLOR=\"$c2\"><TD COLSPAN=3 ALIGN=CENTER><FONT SIZE=3 FACE=\"Tahoma,Verdana,Arial\"><B>Suicids</B></FONT></TD></TR>\n";
    print "<TR BGCOLOR=\"$c3\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Reason</B></FONT></TD>\n";
    print "<TD ALIGN=LEFT COLSPAN=2><FONT SIZE=1 FACE=\"Tahoma,Verdana,Arial\"><B>Suicids</B></FONT></TD>\n";
    print "</TR>\n";
    foreach $player (@players) {
      if ($player eq $ARGS{'player'}) {
        $s_lava = $DATA{$player.'_suicids_lava'}; 
        $s_slime = $DATA{$player.'_suicids_slime'}; 
        $s_water = $DATA{$player.'_suicids_water'}; 
        $s_squish = $DATA{$player.'_suicids_squish'}; 
        $s_explosive = $DATA{$player.'_suicids_explosive'}; 
        $s_rocketlauncher = $DATA{$player.'_suicids_rocketlauncher'}; 
        $s_handgrenade = $DATA{$player.'_suicids_handgrenade'}; 
        $s_grenadelauncher = $DATA{$player.'_suicids_grenadelauncher'}; 
        $s_bfg = $DATA{$player.'_suicids_bfg'}; 
        $s_trapblaster = $DATA{$player.'_suicids_trablaster'}; 
        $s_traplaser = $DATA{$player.'_suicids_traplaser'}; 
        $s_freefall = $DATA{$player.'_suicids_freefall'}; 
        $s_command = $DATA{$player.'_suicids_command'}; 
        $s_unknown = $DATA{$player.'_suicids_unknown'}; 
      }
    }
    $last = 0;
    if ($s_lava > $last) { $last = $s_lava; }
    if ($s_slime > $last) { $last = $s_slime; }
    if ($s_water > $last) { $last = $s_water; }
    if ($s_squish > $last) { $last = $s_squish; }
    if ($s_explosive > $last) { $last = $s_explosive; }
    if ($s_rocketlauncher > $last) { $last = $s_rocketlauncher; }
    if ($s_handgrenade > $last) { $last = $s_handgrenade; }
    if ($s_grenadelauncher > $last) { $last = $s_grenadelauncher; }
    if ($s_bfg > $last) { $last = $s_bfg; }
    if ($s_trapblaster > $last) { $last = $s_trapblaster; }
    if ($s_traplaser > $last) { $last = $s_traplaser; }
    if ($s_freefall > $last) { $last = $s_freefall; }
    if ($s_command > $last) { $last = $s_command; }
    if ($s_unknown > $last) { $last = $s_unknown; }
    $scale = (50 / $last);
    $a_lava = int($s_lava * $scale) + 1;
    $a_slime = int($s_slime * $scale) + 1;
    $a_water = int($s_water * $scale) + 1;
    $a_squish = int($s_squish * $scale) + 1;
    $a_explosive = int($s_explosive * $scale) + 1;
    $a_rocketlauncher = int($s_rocketlauncher * $scale) + 1;
    $a_handgrenade = int($s_handgrenade * $scale) + 1;
    $a_grenadelauncher = int($s_grenadelauncher * $scale) + 1;
    $a_bfg = int($s_bfg * $scale) + 1;
    $a_trapblaster = int($s_trapblaster * $scale) + 1;
    $a_traplaser = int($s_traplaser * $scale) + 1;
    $a_freefall = int($s_freefall * $scale) + 1;
    $a_command = int($s_command * $scale) + 1;
    $a_unknown = int($s_unknown * $scale) + 1;
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Lava</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_lava</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_lava HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Slime</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_slime</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_slime HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Water</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_water</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_water HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Squish</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_squish</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_squish HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Explosive</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_explosive</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_explosive HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">GrenadeLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_grenadelauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_grenadelauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">RocketLauncher</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_rocketlauncher</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_rocketlauncher HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BFG10k</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_bfg</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_bfg HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">HandGrenade</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_handgrenade</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_handgrenade HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">BlasterTrap</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_trapblaster</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_trapblaster HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">LaserTrap</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_traplaser</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_traplaser HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">free Fall</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_freefall</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_freefall HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c1\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">Command KILL</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_command</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_command HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "<TR BGCOLOR=\"$c4\">\n";
    print "<TD ALIGN=LEFT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">unknown</FONT></TD>\n";
    print "<TD ALIGN=RIGHT><FONT SIZE=2 FACE=\"Tahoma,Verdana,Arial\">$s_unknown</FONT></TD>\n";
    print "<TD ALIGN=LEFT><IMG SRC=\"PatternColorRed.jpg\" WIDTH=$a_unknown HEIGHT=7></TD>\n";
    print "</TR>\n";
    print "</TABLE></TD></TR></TABLE></TD></TR></TABLE></CENTER><BR>\n";

  print "</TD></TR></TABLE></CENTER>\n";
}            
             