/* sock.h */

#ifndef SOCK_H
#define SOCK_H

#define MAX(a,b)	((a)>(b)?(a):(b))
#define MIN(a,b)	((a)<(b)?(a):(b))


#include <stdlib.h>
#include <limits.h>

#define SOCKREAD_MAX	(1024*16)

#include <string.h>

#ifdef __TURBOC__
#include <tcp.h>
#else

#ifdef _WIN32

#include <winsock.h>
#define SockClose(sd)	closesocket(sd)

#else
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <netdb.h>

#define INVALID_SOCKET		-1
#define SOCKET_ERROR		-1

#define SockClose(sd)	close(sd)

#endif

#endif

#ifdef AIX
#include <sys/select.h>
#include <strings.h>
#endif

#ifdef __STDC__
#ifdef __TURBOC__
int SockOpen(tcp_Socket *, char *, int, int);
int SockWrite(tcp_Socket *, char *, int);
int SockRead(tcp_Socket *, char *, int);
#else
int SockOpen(char *, int, int, struct sockaddr_in *);
int SockWrite(int, char *, int);
int SockRead(int, char *, int);
#endif
#else
int SockOpen();
int SockWrite();
int SockRead();
#endif


#endif
