#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <sys/stat.h>
#include "qslist.h"
#include "sock.h"
#include "sockio.h"
#include "config.h"

//#define MAIN 
//#define DEBUG	1

#ifndef MAIN
#include "../g_local.h"
#else
typedef void edict_t;
#endif

#define DEFAULT_SOURCEFILE	"slist.dat"
#define DEFAULT_SOURCEURL	"http://204.182.161.21/q2servers/q2gamespy.txt"
//#define DEFAULT_SOURCEURL	"http://asp.planetquake.com/q2servers/q2gamespy.txt"

#define MAX_QMSG	2000

char configfile[MAX_STRING] = "slist.ini";
char source[MAX_STRING] = "file";
char sourcefile[MAX_STRING] = DEFAULT_SOURCEFILE;
char sourceurl[MAX_STRING] = DEFAULT_SOURCEURL;
char savelist[MAX_STRING] = "yes";
char saveonly[MAX_STRING] = "all";
char autostart[MAX_STRING] = "yes";
char screenshots[MAX_STRING] = "yes";
char execfile[MAX_STRING] = "";
int numpackets = 2;
int maxbookmark = 9;
int maxactive = 16;

int started = 0;
int configread = 0;
#define TIMEDELAY	2

#ifdef _WIN32
#include <winsock.h>
#endif


#ifdef DEBUG
int verbose = DEBUG;
#else
int verbose = 0;
#endif

int qtimeout = 8;		/* query timeout in seconds */
int qretries = 1;		/* number of query retries */
int qretrydelay = 10;	/* number of seconds before retrying */

int curpage = 0;
int maxpage = 10;
int numpages = 0;
int listactive = 0;
int curitem = 0;
int numpings = 0;

char *slist[MAX_SERVERS];
int numservers=0;

int numqueried;
int numactive;
int numup, numdown, numunknown;

struct timeval starttime;
struct timeval endtime;
long totalquerytime = 0;

serverinfo_t sinfo[MAX_SERVERS];
int sorted[MAX_SERVERS];

Config slistcfg[] = {
	{ "source", "STR", source, "file", "", "Server List Source: \"file\" \"http\" \"file&http\"" },
	{ "sourcefile", "STR", sourcefile, DEFAULT_SOURCEFILE, "", "Local Server List File" },
	{ "sourceurl", "STR", sourceurl, DEFAULT_SOURCEURL, "", "URL of Server List Source" },
	{ "numbookmarks", "INT", &maxbookmark, "9", "", "Number of bookmark entries to save" },
	{ "savelist", "STR", savelist, "yes", "", "Save serverlist on exit?" },
	{ "saveonly", "STR", saveonly, "all", "", "What to save: \"all\" \"up\"" },
	{ "autostart", "STR", autostart, "yes", "", "Start queries on startup?" },
	{ "screenshots", "STR", screenshots, "yes", "", "Display map screenshots?" },
	{ "execfile", "STR", execfile, "", "", ".cfg file to execute before connecting" },
	{ "numpackets", "INT", &numpackets, "2", "", "Number of query packets to send" },
	{ "timeout", "INT", &qtimeout, "8", "", "Number of seconds before giving up on a server" },
	{ "maxactive", "INT", &maxactive, "16", "", "Maximum number of servers to query at once" },
};
#define NUMINI	(sizeof(slistcfg)/sizeof(Config))

/*
char *levelnames[] = {
"base1", "base2", "base3", "bunk1", "ware1", "ware2", "jail1", "jail2",
"jail3", "jail4", "jail5", "security", "mintro", "mine1", "mine2", "mine3",
"mine4", "fact1", "fact2", "power1", "power2", "cool1", "waste1", "waste2",
"waste3", "biggun", "hangar1", "hangar2", "lab", "command", "strike", "city1",
"city2", "city3", "boss1", "boss2", "train", "fact3", "space",
};

int inbaseq2(char *lev)
{
	int i;
	int nlevels = sizeof(levelnames)/sizeof(char *);

	for (i=0; i<nlevels; i++){
		if (!strcmp(lev,levelnames[i])) return(1);
	}
	return(0);
}
*/

int strtolower(char *s)
{
	if (s) for (;*s;s++) *s = tolower(*s);
	return(0);
}

int readfromfile();
int readfromhttp();


#if 0
char statline[2048];
int statusline(char *format, ...)
{
	va_list         argptr;

	va_start (argptr, format);
	vsprintf (statline, format,argptr);
	va_end (argptr);

#ifndef MAIN
	gi.bprintf(PRINT_HIGH, "%s\n", statline);
#endif

	printf("%s\n", statline);
	return(0);
}
#endif


int setrfds(rfds)
fd_set *rfds;
{
	int i;
	int maxfd = 0;
	
	FD_ZERO(rfds);
	for (i=0; i < numservers; i++){
		if (sinfo[i].status == S_OPEN && sinfo[i].numquery > 0){
			FD_SET(sinfo[i].sd, rfds);
			if (sinfo[i].sd > maxfd) maxfd = sinfo[i].sd;
		}
	}
	return(maxfd);
}

int readfromfile(fname)
char *fname;
{
	FILE *fp;
	char line[128];

	fp = fopen(fname, "r");
	if (fp == NULL){ return(0); }

	while (fgets(line, 80, fp) != NULL){
		while (isspace(line[strlen(line)-1])){
			line[strlen(line)-1] = 0;
		}
		slist[numservers] = (char *)malloc(strlen(line)+1);
		strcpy(slist[numservers], line);
		++numservers;
	}

	fclose(fp);
	return(numservers);
}

int qping(serverinfo_t *si)
{
	int p;

	if (si->ping > 0) p = si->ping;
	else p = 20000;
	switch (si->status){
		case S_UP:
			break;
		default:
			p += 10000;
			break;
	}
	return(p);
}

int scompare(s1, s2)
int *s1, *s2;
{
	int i1 = *s1, i2 = *s2;

	if (qping(&sinfo[i1]) < qping(&sinfo[i2])) return(-1);
	if (qping(&sinfo[i1]) > qping(&sinfo[i2])) return(1);

/*
	//if (sinfo[i1].status == S_UP && sinfo[i2].status == S_UP){
	if (sinfo[i1].ping > 0 && sinfo[i2].ping > 0){
		if (sinfo[i1].ping < sinfo[i2].ping) return(-1);
		if (sinfo[i1].ping > sinfo[i2].ping) return(1);
		return(0);
	}
	if (sinfo[i1].status == S_UP) return(-1);
	if (sinfo[i2].status == S_UP) return(1);
	if (sinfo[i1].status == S_OPEN) return(-1);
	if (sinfo[i2].status == S_OPEN) return(1);
*/

	return(0);
}

char *fmtstr(pg)
int pg;
{
	int i;
	static char str[2048];
	static int loopi=0;
	char entry[2048];
	char statusstr[64];
	int numping = 0;
	char statchars[] = {'-', '\\', '|', '/', };
	int stati;
	char serverport[1024];
	char map_host[1024];
	int y;
	struct stat statbuf;

	str[0] = 0;

	//curpage = curitem/maxpage;
	curpage = pg;

	/* sort entries */
	for (i=0; i<numservers; i++){
		//memcpy(&sorted[i], &sinfo[i], sizeof(serverinfo_t));
		sorted[i] = i;
		strtolower(sinfo[i].map);
	}

	//qsort(sorted, numservers, sizeof(serverinfo_t), scompare);
	qsort(sorted, numservers, sizeof(int), scompare);

#ifndef MAIN
	for (i=0; i<maxbookmark; i++){
		sprintf(entry, "adr%d", i);
		if (sinfo[sorted[i]].port == DEFAULT_Q2_PORT)
			sprintf(serverport, "%s", sinfo[sorted[i]].host);
		else
			sprintf(serverport, "%s:%d", sinfo[sorted[i]].host,
				sinfo[sorted[i]].port);
		//gi.cvar_set(entry, sorted[i].host);
		gi.cvar_set(entry, serverport);
	}
#endif

	numping = numqueried - numactive;

	if (numservers > 0) numpages = ((numservers-1)/maxpage) +1;
	else numpages = 0;

	if (strstr(screenshots, "yes") || strstr(screenshots, "on")){
		sprintf(entry, "slist/pics/%s.pcx", sinfo[sorted[curitem]].map);
		if (stat(entry, &statbuf) == 0)
			sprintf(entry, "xv 0 yv 0 picn %s ", sinfo[sorted[curitem]].map);
		else {
			sprintf(entry, "slist/pics/%s.pcx", "space");
			if (stat(entry, &statbuf) == 0)
				sprintf(entry, "xv 0 yv 0 picn space ");
			else entry[0] = 0;		
		}
		if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);	
	}


	sprintf(entry, "xv 8 yv 1 cstring \"slist 1.00 page %d/%d\" ", 
		curpage+1, numpages);
	if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);	

	if (numping<numservers){
		stati = ++loopi % 4;
		sprintf(entry, "xv 1 yv %d string2 \" %3d%% %d/%d %d%c %lds pass %d\" ", 
			9*3 -4,
			((numping*100)/numservers), 
			numping, numservers, numactive, statchars[stati],
			totalquerytime/1000,
			numpings
			);
	}
	else {
		sprintf(entry, "xv 1 yv %d string2 \" %d servers in %ld seconds \" ", 
			9*3 -4,
			numservers,
			totalquerytime/1000
			);
	}
	if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);	

	y = 9*4;
	sprintf(entry, "xv 1 yv %d string2 \" PING MAP      HOSTNAME\" ", y);
	if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);	

	y = 32 +9 + (maxpage) * 9 + 9 + 9*2 + 9*7;
	sprintf(entry, "yv %d string2 \"<ENTER> = connect to selected server\" ",y);
	if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);	

	for (i=pg*maxpage; i<pg*maxpage +maxpage && i < numservers; i++){
		y = 9*4 + 9*2 + (i%maxpage) * 9;

		if (sinfo[sorted[i]].port == DEFAULT_Q2_PORT){
			sprintf(serverport, "%s", sinfo[sorted[i]].host);
		}
		else {
			sprintf(serverport, "%s:%d", sinfo[sorted[i]].host, sinfo[sorted[i]].port);
		}

		//switch (sorted[i].status){
		if (sinfo[sorted[i]].ping != -1){
			if (sinfo[sorted[i]].ping < 10000)
				sprintf(statusstr, "%4d", sinfo[sorted[i]].ping);
			else
				sprintf(statusstr, "%3ds", sinfo[sorted[i]].ping/1000);
		}
		else switch (sinfo[sorted[i]].status){
			case S_INIT: sprintf(statusstr, "----"); break; 
			case S_ADDROK: sprintf(statusstr, "++++"); break;
			case S_OPEN: sprintf(statusstr, "OPEN"); break;
			case S_UP: break;
			case S_DOWN: sprintf(statusstr, "DOWN"); break;	
			default: sprintf(statusstr, "????"); break;
		}
		if (strlen(sinfo[sorted[i]].map)+strlen(sinfo[sorted[i]].hostname)>0)
			sprintf(map_host, "%-8s %s", sinfo[sorted[i]].map, sinfo[sorted[i]].hostname);
		else sprintf(map_host, "%-8s %s", " ", serverport);

		/* make sure it's within screen */
		map_host[8+1+25] = 0;

		if (i!=curitem){
			sprintf(entry, "yv %d string \" %s %s\" ", 
				y, statusstr, map_host);
		}
		else {
			sprintf(entry, "yv %d string2 \">%s %s\" ", 
				y, statusstr, map_host);
		}
		if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);
		

		//if (i==curitem && sinfo[sorted[i]].status == S_UP){
		if (i==curitem && sinfo[sorted[i]].ping > 0){
			y = 32 +9 + (maxpage) * 9 + 9 + 9*2;

			sprintf(entry, "yv %d string2 \"%s\" ",
			y,
			sinfo[sorted[i]].hostname
			);
			if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);

			sprintf(entry, "yv %d string2 \"%s\" ",
				y+9*1,
				serverport
				);
			if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);

			if (sinfo[sorted[i]].numplayers != -1)
				sprintf(entry, "yv %d string \"players: %d/%d\" ",
					y+9*2,
					sinfo[sorted[i]].numplayers,
					sinfo[sorted[i]].maxplayers
				);
			if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);


			sprintf(entry, "yv %d string \"version:%s%s%s%s%s\" ",
			y+9*3,
			sinfo[sorted[i]].version,
			strlen(sinfo[sorted[i]].protocol)>0? " protocol:":"",
			sinfo[sorted[i]].protocol,
			strlen(sinfo[sorted[i]].game)>0? " game:":"",
			sinfo[sorted[i]].game
			);
			if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);

			sprintf(entry, "yv %d string \"time:%d frag:%d dmflags:%d\" ",
			y+9*4,
			sinfo[sorted[i]].timelimit,
			sinfo[sorted[i]].fraglimit,
			sinfo[sorted[i]].dmflags
			);
			if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);

			if (numpings > 0){
				sprintf(entry, "yv %d string \"ping min/ave/max: %d/%d/%d %d/%d\" ",
				y+9*5,
				sinfo[sorted[i]].pingmin,
				sinfo[sorted[i]].ping,
				sinfo[sorted[i]].pingmax,
				sinfo[sorted[i]].nping, numpings
				//((numpings -sinfo[sorted[i]].nping) * 100) / numpings
				);
				if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);
			}

		}
		//if (strlen(str) > 1000) printf("strlen=(%d)\n", strlen(str));
	}

	/* print the status line */
	//sprintf(entry, "xv 8 yv 10 string2 \"%s\" ", statline);
	//if (strlen(str)+strlen(entry) < MAX_QMSG) strcat(str, entry);	

	return(str);
}


int displaylist(edict_t *ent, int pg)
{
	char *s;

	s = fmtstr(pg);

#ifndef MAIN
	ent->client->showscores = true;
	ent->client->showinventory = false;

	gi.WriteByte (svc_layout);
	gi.WriteString (s);
	gi.unicast (ent, false);
#endif

	return(0);
}


void stuffcmd(edict_t *ent, char *cmd)
{
#ifndef svc_stuffcmd
#define svc_stuffcmd	11
#endif
#ifndef MAIN
	gi.WriteByte(svc_stuffcmd);
	gi.WriteString(cmd);
	gi.unicast(ent, true);
#endif
}

int bindkeys(edict_t *ent)
{
	stuffcmd(ent, "bind UPARROW \"cmd slist item prev\"\n");
	stuffcmd(ent, "bind DOWNARROW \"cmd slist item next\"\n");
	stuffcmd(ent, "bind ENTER \"cmd slist connect\"\n");
	stuffcmd(ent, "bind PGUP \"cmd slist page prev\"\n");
	stuffcmd(ent, "bind PGDN \"cmd slist page next\"\n");
	return(0);
}

int unbindkeys(edict_t *ent)
{
	stuffcmd(ent, "bind UPARROW \"+forward\"\n");
	stuffcmd(ent, "bind DOWNARROW \"+back\"\n");
	stuffcmd(ent, "bind ENTER \"invuse\"\n");

	stuffcmd(ent, "bind PGDN \"+lookup\"\n");
	return(0);
}

void qslistloop(edict_t *ent)
{
	int stat = 0;
	int i;
	int maxfd;
	fd_set rfds, efds;
	struct timeval tv;
	int qslist();


	if (!configread){
		if (readconfig(configfile, "", slistcfg, NUMINI) == -1){
			printf("Cannot open configfile[%s]... using defaults.\n", configfile);
		}
		configread = 1;
	}

	if (!started && strstr(autostart, "yes")){
		bindkeys(ent);
		qslist(ent, 1);
		return;
	}

	if (numactive > 0){

		tv.tv_usec = 5;
		tv.tv_sec = 0;

		/* read replies*/
		maxfd = setrfds(&rfds);
		efds = rfds;
		stat = select(maxfd, &rfds, NULL, &efds, &tv);
		if (stat > 0){ /* */
			if (verbose > 3) printf("select > 0\n");
			for (i=0; i<numservers; i++){
				if (verbose > 2) printf("server=%s\n", sinfo[i].host);
/*
				if (FD_ISSET(sinfo[i].sd, &efds)){
					ServerClose(&sinfo[i], S_DOWN);
				}
*/
				if (sinfo[i].status == S_OPEN && FD_ISSET(sinfo[i].sd, &rfds)){
					ServerGetInfo(&sinfo[i]);
				}
			}
		}


		/* timeout: send query to all open servers */
		if (stat == 0){
			for (i=0; i < numservers; i++){
				ServerSendQuery(&sinfo[i]);
			}
		}

		gettimeofday(&endtime, NULL);
		totalquerytime = timediff(&starttime, &endtime);

	}

	if (listactive) displaylist(ent, curpage);

	if (numactive == 0){
		while ((numactive < maxactive) && (numqueried < numservers)){
			ServerOpen(&sinfo[numqueried]);
			//ServerSendQuery(&sinfo[numqueried]);
			numqueried++;
		}
	}

	if (numactive == 0 && numpings < numpackets){
		qslist(ent, 0);
		return;
	}

	return;
}


int qslist(edict_t *ent, int reloadsource)
{
#ifdef MAIN
#ifdef _WIN32
    WORD version =  MAKEWORD(1, 1);  /* winsock version 1.1 */
    WSADATA wsadata;
	int rc;
#endif
#endif

	int i;


#ifdef MAIN
#ifdef _WIN32

    rc = WSAStartup(version, &wsadata);
    if(rc) {
        printf("Error Initializing Winsock: %d\n", rc);
        exit;
    }

#ifdef DEBUG
    printf("Windows Sockets: %-40s\n", wsadata.szDescription);
    printf("System status:   %-40s\n", wsadata.szSystemStatus);
    printf("Winsock version: %04x\n", wsadata.wVersion);
    printf("Max Sockets:     %d\n", wsadata.iMaxSockets);
    printf("Max Datagram:    %d\n", wsadata.iMaxUdpDg);
#endif

#endif
#endif


	started = 1;
	if (readconfig(configfile, "", slistcfg, NUMINI) == -1){
		printf("Cannot open configfile[%s]... using defaults.\n", configfile);
	}
	configread = 1;

	for (i=0; i< NUMINI; i++){
		printf("%s\n", printvar(&slistcfg[i]));
	}

	numup = numdown = numunknown = 0;
	numactive = 0;
	numqueried = 0;

	curpage = 0;
	curitem = 0;
	listactive = 1;

	if (reloadsource){
		numpings = 0;
		while (numservers > 0){
			--numservers;
			free(slist[numservers]);
		}
		if (strstr(source, "file")){
			printf("reading file [%s]...\n", sourcefile);
			readfromfile(sourcefile);
		}
		if (strstr(source, "http")){
			printf("getting url [%s]...\n", sourceurl);
			readfromhttp(sourceurl);
		}

	//remove duplicates: not yet finished
	//qsort(slist, numservers, sizeof(char *), strcmp);
	//for (i=1; i<numservers; i++){
	//	if (!strcmp(slist[i],slist[i-1])){
	//		strcpy(slist[i-1], "");
	//	}
	//}

	}

	for (i=0; i < numservers; i++){
		char *s;
		char stmp[1024];
		if (verbose > 2) printf("slist[%d]=[%s]\n", i, slist[i]);

		sprintf(stmp, "%s:%d", sinfo[i].host, sinfo[i].port);
		if (!strcmp(stmp, slist[i]) && sinfo[i].status != S_INIT){
			/* not changed */
			sinfo[i].status = S_ADDROK;
		}
		else sinfo[i].status = S_INIT;

		sinfo[i].closed = 0;
		if (reloadsource){
			strncpy(sinfo[i].host, slist[i], MAX_STRING);
	
			if ((s = strchr(sinfo[i].host, ':')) != NULL){
				*s = '\0';
				s++;
				sinfo[i].port = atoi(s);
			}
			else sinfo[i].port = DEFAULT_Q2_PORT;

			strcpy(sinfo[i].hostname, "");
			strcpy(sinfo[i].map, "");
			strcpy(sinfo[i].version, "");
			strcpy(sinfo[i].game, "");
			strcpy(sinfo[i].protocol, "");
			sinfo[i].numplayers = -1;
			sinfo[i].maxplayers = 0;
			sinfo[i].timelimit = 0;
			sinfo[i].fraglimit = 0;
			sinfo[i].dmflags = 16;
			sinfo[i].ping = -1;
			sinfo[i].nping = 0;
			sinfo[i].pingtotal = 0;
			sinfo[i].pingmax = 0;
			sinfo[i].pingmin = 30000;
		}
	}

	numpings++;
	if (verbose) printf("querying %d servers...\n", numservers);

	if (numpings == 1 || numpings > numpackets){
		gettimeofday(&starttime, NULL);
		gettimeofday(&endtime, NULL);
	}

#ifdef MAIN
	while (numqueried < numservers){
		qslistloop(NULL);
	}
#else
	gi.configstring (CS_STATUSBAR, "");
	//ent->client->pers.hand = CENTER_HANDED;

	//qslistloop(ent);
#endif

/*
	printf("LIST\n");
	for (i=0; i<numservers; i++){
		if (sinfo[i].status == S_UP){
			printf("%20s:%d %30s %8s %5d\n",
				sinfo[i].host, sinfo[i].port, sinfo[i].hostname, sinfo[i].map, sinfo[i].ping);
		}
	}
*/

#ifdef MAIN
#ifdef _WIN32
    WSACleanup();
#endif
#endif

	return(0);
}

#ifdef MAIN
int main(argc, argv)
int argc;
char *argv[];
{
	qslist(NULL, 1);
	return(0);
}
#endif



int saveserverlist(fname)
char *fname;
{
	int i;
	FILE *fp;
	char serverport[1024];

	fp = fopen(fname, "w");
	if (!fp) return(0);
	for (i=0; i<numservers; i++){
		if (sinfo[sorted[i]].port == DEFAULT_Q2_PORT)
			sprintf(serverport, "%s", sinfo[sorted[i]].host);
		else
			sprintf(serverport, "%s:%d", sinfo[sorted[i]].host,
				sinfo[sorted[i]].port);

		if (strstr(saveonly, "up")){
			if (sinfo[sorted[i]].status == S_UP)
				fprintf(fp, "%s\n", serverport);
		}
		else
			fprintf(fp, "%s\n", serverport);
	}
	fclose(fp);
	return(numservers);
}

void Cmd_Slist_f(edict_t *ent)
{
#ifndef MAIN
	int i;
	char command[2048];

	if (numservers > 0) numpages = ((numservers-1)/maxpage) +1;
	else numpages = 0;
	if (gi.argc() > 1){
		i = 1;
		//for (i=1; i< gi.argc(); i++){
			if (!strcmp(gi.argv(i), "page")){
				if (i+1 < gi.argc()){
					if (strstr(gi.argv(i+1), "prev")){
						if (curpage > 0) --curpage;
					}
					else if (strstr(gi.argv(i+1), "next")){
						if (curpage < numpages-1) ++curpage;
					}
					else {
						curpage = atoi(gi.argv(i+1));
					}
					curitem = curpage * maxpage;

					i++;
					listactive = 1;
					//if (numactive == 0) displaylist(ent, curpage);
				}
			}
			else if (!strcmp(gi.argv(i), "refresh")){
				qslist(ent, 0);
			}
			else if (!strcmp(gi.argv(i), "close")){
				listactive = 0;
				ent->client->showscores = false;
			}
			else if (!strcmp(gi.argv(i), "item")){
				if (i+1 < gi.argc()){
					if (strstr(gi.argv(i+1), "prev")){
						if (curitem > 0) --curitem;
					}
					else if (strstr(gi.argv(i+1), "next")){
						if (curitem < numservers-1) ++curitem;
					}
					else {
						curitem = atoi(gi.argv(i+1));
					}
					curpage = curitem/maxpage;
					listactive = 1;
					//if (numactive == 0) displaylist(ent, curpage);
				}
			}
			else if (!strcmp(gi.argv(i), "connect")){
				if (numservers > 0){
					unbindkeys(ent);
					if (strlen(execfile)){
						sprintf(command, "exec %s\n", execfile);
						stuffcmd(ent, command);
					}

					printf("connecting to %s:%d...\n",
						sinfo[sorted[curitem]].host, sinfo[sorted[curitem]].port);
					sprintf(command, "connect %s:%d\n", 
						sinfo[sorted[curitem]].host, sinfo[sorted[curitem]].port);
					stuffcmd(ent, command);
				}
				else { qslist(ent, 1); }
			}
			else if (!strcmp(gi.argv(i), "test")){
				BeginIntermission(ent);
				MoveClientToIntermission(ent);
				ent->client->showscores = false;
				stuffcmd(ent, "screenshot\n");
			}
			else if (!strcmp(gi.argv(i), "save")){
				if (i+1 < gi.argc())
					saveserverlist(gi.argv(i+1));
				else
					saveserverlist(sourcefile);
			}
			else if (!strcmp(gi.argv(i), "go")){
				if (numpings > 0){
					listactive = 1;
					//if (numactive == 0) displaylist(ent, curpage);
				}
				else { qslist(ent, 1); }
			}
			else {
				char *s;
				/* try to get cvars at cmdline */
				s = gi.args();
				configline(s, slistcfg, NUMINI);
				printf("%s\n", printvar(slistcfg));
				saveconfig(configfile, "", slistcfg, NUMINI);
			}
		//}
	}
	else{ qslist(ent, 1); }
#endif

}

/*
int qslist_think(edict_t *ent, usercmd_t *ucmd)
{
	if (ucmd->buttons & BUTTON_USE)
		stuffcmd(ent, "cmd slist connect\n");

	//if (ucmd->forwardmove > 0)
	//	stuffcmd(ent, "cmd slist item prev\n");
	//if (ucmd->forwardmove < 0)
	//	stuffcmd(ent, "cmd slist item next\n");

	return(0);
}
*/

