/* config.c */

/*

 * Copyright 1996 A.Oliver De Guzman <oliber@aiko.upd.edu.ph>

 *   Permission is granted to any individual to copy, use, and/or
 * distribute this software provided that the distribution retains this
 * entire copyright notice. No part of this software may be used and/or
 * sold for profit or used with any commercial product.

 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "config.h"

#define MAXPATH			1024


/* ini file
# type: INT, STR, CHAR, BOOL
# range:
#   1-10
#   {2,4,6}
#   {"up","down","left","right"}
#
# NAME			type	default		range		desc
sv_friction		INT		100			0-300		Friction
sv_gravity		INT		2000		0-*			World Gravity
sv_stopspeed	INT		0			0,1			Stop Speed
hostname		STR		"qserver"	*			Server Hostname
*/

char *nexttoken(s)
char **s;
{
	char *p, *q, *r;
	int i;

	/* skip white spaces */
	p = *s;
	while (*p && isspace(*p)){
		p++;
	}
	if (!(*p)) return(NULL);
	q = p;

	if (*q == '\"'){
		p++; q++;
		/* until we hit a " */
		while (*q && !((*(q-1)!='\\') && (*q == '\"'))){
			q++;
		}
	}
	else{
		/* until we hit a space ... */
		while (*q && !isspace(*q)){
			q++;
		}
	}

	/* copy the token; */
	r = (char *) malloc(sizeof(char)*(q-p+1));
	for (i=0; i<q-p+1; i++){
		r[i] = p[i];
	}
	r[q-p+1-1] = '\0';
	*s = q+1;
	return(r);
}

int readini(fname, fpath, rconfigs)
char *fname;
char *fpath;
Config **rconfigs;
{
	Config *configs;
	char path[MAXPATH];
	char line[MAXCFGLINE];
	int n;
	FILE *fp;

	configs = (Config *) malloc(sizeof(Config)*64); /* FIX */

	strcpy(path, fname);
	if (!(fp = fopen(path, "r"))){
		sprintf(path, "%s/%s", fpath, fname);
		if (!(fp = fopen(path, "r"))) return(-1);
	}
	n = 0;
	while (fgets(line, MAXCFGLINE, fp) != NULL){
		/* Strip Comments */
		if (line[0] != '#'){
			/* hostname		STR		"server"	*			"Server Hostname" */
			char *pp;
			pp = line;
			configs[n].cfgname = nexttoken(&pp);
			if (configs[n].cfgname != NULL){
				configs[n].cfgtype = nexttoken(&pp);
				configs[n].cfgdefault = nexttoken(&pp);
				configs[n].cfgrange = nexttoken(&pp);
				configs[n].cfgdesc = nexttoken(&pp);
				configs[n].cfgvar = NULL;
				n++;
			}
		}
	}

	*rconfigs = configs;

	return(n);
}

int readconfig(fname, fpath, configs, nconfigs)
char *fname;
char *fpath;
Config configs[];
int nconfigs;
{
	FILE *fp;
	char *comment, path[MAXPATH];
	char line[MAXCFGLINE];
	char line2[MAXCFGLINE];
	int n=0, k=0;

	strcpy(path, fname);
	if (!(fp = fopen(path, "r"))){
		sprintf(path, "%s/%s", fpath, fname);
		if (!(fp = fopen(path, "r"))) return(-1);
	}

	while (fgets(line, MAXCFGLINE, fp) != NULL){
		k += strlen(line);
		while (isspace(line[strlen(line)-1]))
			line[strlen(line)-1] = '\0';

		while (!((comment=(char *)strstr(line,"#")) &&
			!(comment!=line && (*(comment-1)=='%'))) &&
			line[strlen(line)-1] == '\\'){

			line[strlen(line)-1] = '\0';
			if (fgets(line2, MAXCFGLINE,fp))
				strncat(line, line2, MAXCFGLINE);
		}

		if (comment && !(comment!=line && (*(comment-1)=='%')))
			*comment = '\0';

		 n += (configline(line, configs, nconfigs) != -1);
	}

	fclose(fp);
	return(n);
}

int whatcfgtype(s)
char *s;
{
	if (!strcmp(s, "INT") || !strcmp(s, "int")){
		return(CFG_INT);
	}
	else if (!strcmp(s, "STR") || !strcmp(s, "str")){
		return(CFG_STR);
	}
	else if (!strcmp(s, "CHAR") || !strcmp(s, "char")){
		return(CFG_STR);
	}
	else return(CFG_UNKNOWN);
}

int configline(line, configs, nconfigs)
char *line;
Config configs[];
int nconfigs;
{
	char name[MAXCFGLINE], *s;
	int i, n= -1;

	name[0] = '\0';
	sscanf(line," %[_A-Za-z]", name);
	for (i=0; i<nconfigs; i++){
		if (!strcmp(name, configs[i].cfgname)){
			n = i;
			switch (whatcfgtype(configs[i].cfgtype)){
				case CFG_KEY :
					break;
				case CFG_INT :
					if (configs[i].cfgvar == NULL){
						configs[i].cfgvar = (int *) malloc(sizeof(int));
					}
					sscanf(line," %[_A-Za-z] %d",name, (int *)configs[i].cfgvar);
					break;
				case CFG_CHAR :
					if (configs[i].cfgvar == NULL){
						configs[i].cfgvar = (char *) malloc(sizeof(char));
					}
					sscanf(line," %[_A-Za-z] %c",name, (char *)configs[i].cfgvar);
					break;
				case CFG_STR :
					if (configs[i].cfgvar == NULL){
						configs[i].cfgvar = (char **)
						  malloc(sizeof(char)*(strlen(name)+1));
					}
					s = line+strlen(name);
					while (*s && isspace(*s)) s++;
					if (*s == '"'){
						char *p;

						s++;
						p = strchr(s, '"');
						if (p != NULL) *p = '\0';
					}

					strcpy((char *)configs[i].cfgvar, s);	
					break;
				default:
					printf("Unknown type: [%s]\n", configs[i].cfgtype);
					break;
			}
		}
	}
	return(n);
}

char *printvar(cc)
Config *cc;
{
	static char varstr[4096];

	switch (whatcfgtype(cc->cfgtype)){
			case CFG_KEY:
				sprintf(varstr, "%s ????", cc->cfgname);
				break;
			case CFG_INT:
				sprintf(varstr, "%s %d", cc->cfgname, (*(int *)cc->cfgvar));
				break;
			case CFG_STR:
				sprintf(varstr, "%s \"%s\"", cc->cfgname, (char *)cc->cfgvar);
				break;
/* FIX
			case CFG_CHAR:
				sprintf(varstr, "%s %c", (char)cc->cfgname, (*(char *)(cc->cfgvar)));
				break;
*/
			default: sprintf(varstr, "error: unknown cfgtype");
				break;
	}
	return(varstr);
}

