#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <string.h>
#include <stdlib.h>
#include <direct.h>

#include <mmsystem.h>
#include "g_local.h"
#include "g_playmidi.h"
#include "g_map_mod.h"
#include <io.h>
#include <FCNTL.H>

int mid_mod = 0;
int NumMidiFiles = 0;
int MidiCurrent = 0;
char MidiNames[50][50];

int CheckCount = 0;
UINT wDeviceID = NULL;

void MidiSetup(void)
{
	int file;
	char file_name[256];
	cvar_t *game_dir;
	
	game_dir = gi.cvar ("game", "", 0);
	sprintf(file_name,".\\%s\\midi.txt",game_dir->string);

	file = _open(file_name,_O_RDONLY | _O_TEXT);
	mid_mod = 0;
	MidiCurrent = -1;  

	

	NumMidiFiles = 0;
	if (file != -1)
	{
		long file_size;
		char *p_buffer;
		char *p_name;
		long counter = 0;
		int n_chars = 0;

		file_size = _filelength(file);
		p_buffer = malloc(file_size);
		memset(p_buffer,0,file_size);

		file_size = _read(file, (void *)p_buffer, file_size);

		gi.dprintf("Reading from midi.txt: ");

		p_name = p_buffer;
		do
		{
			while (*p_name != '\r' && *p_name != '\n' && counter < file_size)
			{
				n_chars++;
				counter++;
				p_name++;
			}
			if (n_chars)
			{
				memcpy(&MidiNames[NumMidiFiles][0], p_name - n_chars, n_chars);
				memset(&MidiNames[NumMidiFiles][n_chars], 0, 1);
				gi.dprintf("%s ",MidiNames[NumMidiFiles]);
				NumMidiFiles++;
				n_chars = 0;
			}
			counter++;
			p_name++;

		} while (counter < file_size);

		free(p_buffer);
		_close(file);

		if (NumMidiFiles)
		{
			mid_mod = true;
			gi.dprintf("\n");
			gi.dprintf("%i midi files in sequence.\n",NumMidiFiles);

	
		}
	}
}


void playMIDIForLevel(void)
{
	char QDir[256], file_name[256];
	
	cvar_t *game_dir;
	
	game_dir = gi.cvar ("game", "", 0);


	MidiCurrent++;
	if (MidiCurrent == NumMidiFiles)
		MidiCurrent = 0;
	
	_getcwd(QDir, _MAX_PATH);

	sprintf(file_name,"%s\\%s\\%s",QDir,game_dir->string,MidiNames[MidiCurrent]);

	gi.dprintf("Playing MIDI file %s\n",file_name);
	playMIDIFile(file_name);

}

// Plays a specified MIDI file by using MCI_OPEN and MCI_PLAY. Returns 
// as soon as playback begins. The window procedure function for the 
// specified window will be notified when playback is complete. 
// Returns 0L on success; otherwise, it returns an MCI error code.
int playMIDIFile(char *lpszMIDIFileName)
{

	char mciErrStr[100];
    int dwReturn;
    MCI_OPEN_PARMS mciOpenParms;
    MCI_PLAY_PARMS mciPlayParms;
    MCI_STATUS_PARMS mciStatusParms;
    MCI_SEQ_SET_PARMS mciSeqSetParms;
	MCI_GENERIC_PARMS mciGenParms;

	gi.dprintf("Opening new MCI device\n");
	// Open the device by specifying the device and filename.
	// MCI will attempt to choose the MIDI mapper as the output port.
	mciOpenParms.lpstrDeviceType = "sequencer";
	mciOpenParms.lpstrElementName = lpszMIDIFileName;
	if (dwReturn = mciSendCommand(NULL, MCI_OPEN,
		MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,
		(DWORD)(LPVOID) &mciOpenParms))
	{
		// Failed to open device. Don't close it; just return error.
		mciGetErrorString(dwReturn,mciErrStr,100);
		gi.dprintf("PlayMidi - status returned: %s\n",mciErrStr);

		return (dwReturn);
	}

	// The device opened successfully; get the device ID.
	wDeviceID = mciOpenParms.wDeviceID;

    if (dwReturn = mciSendCommand(wDeviceID, MCI_PLAY, 0, 
        (DWORD)(LPVOID) &mciPlayParms))
    {
        //mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
        return (dwReturn);
    }

    return (0L);
}
 

void StopMidi(void)
{
    int dwReturn;
    MCI_OPEN_PARMS mciOpenParms;
    MCI_PLAY_PARMS mciPlayParms;
    MCI_STATUS_PARMS mciStatusParms;
    MCI_SEQ_SET_PARMS mciSeqSetParms;
	MCI_GENERIC_PARMS mciGenParms;
	char mciErrStr[100];

	gi.dprintf("Closing MCI Device\n");
	mciStatusParms.dwItem = MCI_STATUS_MODE;
	dwReturn = mciSendCommand(wDeviceID, MCI_STATUS, 
			MCI_STATUS_ITEM, (DWORD)(LPVOID) &mciStatusParms);
	if (dwReturn)
	{
		mciGetErrorString(dwReturn,mciErrStr,100);
		gi.dprintf("StopMidi - status returned: %s\n",mciErrStr);
	}


	if (mciStatusParms.dwReturn == MCI_MODE_PLAY)
		mciSendCommand(wDeviceID, MCI_STOP, 0,(DWORD)(LPVOID) &mciGenParms);
    
	dwReturn = mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
	if (dwReturn)
	{
		mciGetErrorString(dwReturn,mciErrStr,100);
		gi.dprintf("StopMidi - stop returned: %s\n",mciErrStr);
	}


}


void CheckMidiRepeat()
{
	MCI_STATUS_PARMS mciStatus;
    MCI_PLAY_PARMS mciPlayParms;
	MCI_SEEK_PARMS mciSeekParms;
	char mciErrStr[100];

    int dwReturn;

	CheckCount++;

	
	if (CheckCount > 40) 
	{
		//gi.dprintf("Checking MIDI status\n");
		mciStatus.dwItem = MCI_STATUS_MODE;
		dwReturn = mciSendCommand(wDeviceID, MCI_STATUS, 
				MCI_STATUS_ITEM, (DWORD)(LPVOID) &mciStatus);

		if (dwReturn)
		{
			mciGetErrorString(dwReturn,mciErrStr,100);
			//gi.dprintf("Status returned: %s\n",mciErrStr);
			return;

		}

		//if (mciStatus.dwReturn == MCI_MODE_PLAY)
		//	gi.dprintf("MIDI playing\n");
		
		else if (mciStatus.dwReturn == MCI_MODE_STOP)
		{
			//gi.dprintf("Restarting MIDI file\n");
			dwReturn = mciSendCommand(wDeviceID, MCI_SEEK, MCI_SEEK_TO_START, (DWORD)(LPVOID) &mciSeekParms);
			if (dwReturn)
			{
				mciGetErrorString(dwReturn,mciErrStr,100);
				gi.dprintf("Seek returned: %s\n",mciErrStr);
			}

			dwReturn = mciSendCommand(wDeviceID, MCI_PLAY, 0, (DWORD)(LPVOID) &mciPlayParms);
			if (dwReturn)
			{
				mciGetErrorString(dwReturn,mciErrStr,100);
				gi.dprintf("Play returned: %s\n",mciErrStr);
			}

		}

		CheckCount = 0;
	}


}