//
// Map Mod 
// by Jeremy Mappus - Jerm a.k.a DarkTheties
//
// This mod will load a file called maps.txt in the baseq2 directory. It will take any names
// seperated by white spaces and list them as seperate name entries into the map_mod_names_ 
// table. It also provides a function for checking the change level. 
//

#include "g_local.h"
#include "g_map_mod.h"
#include <io.h>
#include <FCNTL.H>

int  map_mod_ = 0;
int  map_mod_current_level_ = -1; 
int  map_mod_n_levels_ = 0;
char map_mod_names_[50][100];
int  map_mod_scan_done = 0;

extern int MidiCurrent;
extern int NumMidiFiles;
extern int mid_mod;

//
//
void map_mod_set_up()
{
	int file;
	char file_name[256];
	cvar_t *game_dir;
	
	game_dir = gi.cvar ("game", "", 0);
	sprintf(file_name,".\\%s\\maps.txt",game_dir->string);

	file = _open(file_name,_O_RDONLY | _O_TEXT);
	map_mod_ = 0;
	map_mod_current_level_ = -1;  
	map_mod_scan_done = 0;
	map_mod_n_levels_ = 0;
	if (file != -1)
	{
		long file_size;
		char *p_buffer;
		char *p_name;
		long counter = 0;
		int n_chars = 0;

		file_size = _filelength(file);
		p_buffer = malloc(file_size);
		memset(p_buffer,0,file_size);

		file_size = _read(file, (void *)p_buffer, file_size);

		gi.dprintf("Reading from maps.txt: ");

		p_name = p_buffer;
		do
		{
			while (*p_name != '\r' && *p_name != '\n' && counter < file_size)
			{
				n_chars++;
				counter++;
				p_name++;
			}
			if (n_chars)
			{
				memcpy(&map_mod_names_[map_mod_n_levels_][0], p_name - n_chars, n_chars);
				memset(&map_mod_names_[map_mod_n_levels_][n_chars], 0, 1);
				gi.dprintf("%s ",map_mod_names_[map_mod_n_levels_]);
				map_mod_n_levels_++;
				n_chars = 0;
			}
			counter++;
			p_name++;

		} while (counter < file_size);

		free(p_buffer);
		_close(file);

		if (map_mod_n_levels_)
		{
			map_mod_ = true;
			gi.dprintf("\n");
			gi.dprintf("%i maps in sequence.\n",map_mod_n_levels_);
			
		}
	}
}


//
//
char* map_mod_next_map()
{
	map_mod_current_level_++;
	if (map_mod_current_level_ == map_mod_n_levels_)
	{
		map_mod_current_level_ = 0;
	}

	return map_mod_names_[map_mod_current_level_];
}

//
// SJS Enhancement to MAP_MOD
void map_mod_get_startpoint(char *mapname)
{
	int i;
	// Scan for start point
	// Done once ONLY

	// Allows you to start mid-way through the list & progress
	// sequentially (orig version jumps to index 0 always after first map)



	if (map_mod_scan_done == 0)
	{
		map_mod_scan_done = true;
		for (i=0; i < map_mod_n_levels_;i++)
		{
			if (!Q_strcasecmp(mapname,map_mod_names_[i]))
			{
				gi.dprintf("Level is number %i of %i\n",i+1,map_mod_n_levels_);
				map_mod_current_level_ = i;
				break;
			}
		}
		if (mid_mod)
		{
			// Sync MIDI
			MidiCurrent = map_mod_current_level_ - 1;
			while (MidiCurrent >= NumMidiFiles)
				MidiCurrent = MidiCurrent - NumMidiFiles;
			if (MidiCurrent < -1)
				MidiCurrent = -1;

		}

	
	}
}

