typedef unsigned long u_long;
typedef unsigned char byte; //as used by John Carmack

/*
==============================================================================

  .BSP definitions

==============================================================================
*/


typedef struct                 // A Directory entry
{ long  offset;                // Offset to entry, in bytes, from start of file
  long  size;                  // Size of entry in file, in bytes
} dentry_t;


typedef struct                 // The BSP file header
{ long  version;               // Model version, must be 0x17 (23).
  dentry_t entities;           // List of Entities.
  dentry_t planes;             // Map Planes.
                               // numplanes = size/sizeof(plane_t)
  dentry_t miptex;             // Wall Textures.
  dentry_t vertices;           // Map Vertices.
                               // numvertices = size/sizeof(vertex_t)
  dentry_t visilist;           // Leaves Visibility lists.
  dentry_t nodes;              // BSP Nodes.
                               // numnodes = size/sizeof(node_t)
  dentry_t surfaces;           // Map Surfaces.
                               // numsurfaces = size/sizeof(surface_t)
  dentry_t lightmaps;          // Wall Light Maps.
  dentry_t boundnodes;         // BSP bound nodes, for Hulls.
                               // numbounds = size/sizeof(hullbound_t)
  dentry_t leaves;             // BSP Leaves.
                               // numlaves = size/sizeof(leaf_t)
  dentry_t lstsurf;            // List of Surfaces.
  dentry_t edges;              // Original surface Edges.
                               // numedges = Size/sizeof(edge_t)
  dentry_t lstedges;           // List of surfaces Edges.
  dentry_t hulls;              // List of Hulls.
                               // numhulls = Size/sizeof(hull_t)
} dheader_t;




typedef struct                 // Mip Texture
{ char name[16];               // Name of the texture.
  u_long width;                // width of picture, must be a multiple of 8
  u_long height;               // height of picture, must be a multiple of 8
  u_long offset1;              // offset to u_char Pix[width   * height]
  u_long offset2;              // offset to u_char Pix[width/2 * height/2]
  u_long offset4;              // offset to u_char Pix[width/4 * height/4]
  u_long offset8;              // offset to u_char Pix[width/8 * height/8]
} miptex_t;


/*
==============================================================================
  .WAL texture file format
==============================================================================
*/

#define	MIPLEVELS	4
    typedef struct {
    char name[32];
    unsigned long width, height;
    unsigned long offsets[MIPLEVELS]; // four mip maps stored
    char animname[32];		// next frame in animation chain
    int	flags;
    int	contents;
    int value;
} wal_miptex_t;

/*
==============================================================================
PCX structure (John Carmack's)
==============================================================================

*/
typedef struct {
    char manufacturer;
    char version;
    char encoding;
    char bits_per_pixel;
    unsigned short xmin,ymin,xmax,ymax;
    unsigned short hres,vres;
    unsigned char palette[48];
    char reserved;
    char color_planes;
    unsigned short bytes_per_line;
    unsigned short palette_type;
    char filler[58];
    unsigned char data;	// unbounded
} pcx_t;

//function declarations
void load_pcx_file (char *filename, byte **pic, byte **palette, int *width, int *height);
void write_pcx_file (char *filename, byte *data, int width, int height, byte *palette);

unsigned char closest_colour(int red, int green, int blue);
void write_mip_file(char * filename, byte *data, int width, int height, char *tex_name);

