#!/usr/local/bin/perl5
#
###############################################################################
## ------------------------------------------------------------------------- ##
## ProgramName......... TripleX RankingS - rank.cgi                          ##
## ------------------------------------------------------------------------- ##
## Programmer.......... TripleX                                              ##
## eMail............... mrbrain@cs.tu-berlin.de                              ##
## Homepage............ http://user.cs.tu-berlin.de/~mrbrain/                ##
## ------------------------------------------------------------------------- ##
##         (C) Copyright 1998 by TripleX - All Rights reserved!              ##
## ------------------------------------------------------------------------- ##
###############################################################################

###################################################################
# get Input and Arguments #########################################
###################################################################

$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/\n//g;
   $value =~ s/\r//g;
   $value =~ s/\\/\//g;
   $ARGS{$name} = $value;
}

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/\n//g;
   $value =~ s/\r//g;
   $value =~ s/\\/\//g;
   $ARGS{$name} = $value;
}

foreach $pair (@ARGV) {
   ($name, $value) = split(/=/, $pair);
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/\n//g;
   $value =~ s/\r//g;
   $value =~ s/\\/\//g;
   $ARGS{$name} = $value;
}

###################################################################
# get Date and Time ###############################################
###################################################################

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

$month = ($mon + 1);

if ($sec < 10) { $sec = "0$sec"; }
if ($min < 10) { $min = "0$min"; }
if ($hour < 10) { $hour = "0$hour"; }
if ($month < 10) { $month = "0$month"; }
if ($mday < 10) { $mday = "0$mday"; }

$date = "$year/$month/$mday";
$time = "$hour\:$min\:$sec";

###################################################################
# take the Action #################################################
###################################################################

&readConfig;
&readPlayers;
&readRankings;
&searchMaps;
&sortPlayers;
if ($ARGS{'action'} eq 'show')   { &showAll; exit; }
if ($ARGS{'action'} eq 'detail') { &showDetail; exit; }
&showAll; 
exit;

###################################################################
# Subroutines #####################################################
###################################################################

sub convert_html {
  my $s_string = shift(@_);
  $s_string =~ s/ /%20/g;
  $s_string =~ s/&/%26/g;
  $s_string =~ s/\?/%3f/g;
  $s_string =~ s/=/%3d/g;
  return $s_string;
}

sub convert_reg {
  my $s_conv = shift(@_);
  $s_conv =~ s/\\/\\\\/g;
  $s_conv =~ s/\^/\\\^/g;
  $s_conv =~ s/\$/\\\$/g;
  $s_conv =~ s/\@/\\\@/g;
  $s_conv =~ s/\//\\\//g;
  $s_conv =~ s/\|/\\\|/g;
  $s_conv =~ s/\?/\\\?/g;
  $s_conv =~ s/\./\\\./g;
  $s_conv =~ s/\*/\\\*/g;
  $s_conv =~ s/\+/\\\+/g;
  $s_conv =~ s/\[/\\\[/g;
  $s_conv =~ s/\]/\\\]/g;
  $s_conv =~ s/\{/\\\{/g;
  $s_conv =~ s/\}/\\\}/g;
  $s_conv =~ s/\(/\\\(/g;
  $s_conv =~ s/\)/\\\)/g;
  return $s_conv;
}

sub max {
  my $s_one = shift(@_);
  my $s_two = shift(@_);
  if ($s_one > $s_two) { return $s_one; }
  else { return $s_two; }
}

sub min {
  my $s_one = shift(@_);
  my $s_two = shift(@_);
  if ($s_one < $s_two) { return $s_one; }
  else { return $s_two; }
}

sub errorMsg {
  print "Content-type: text/html\n\n";
  print "<HTML><HEAD><TITLE>TripleX QuakE II RankingS - ERROR</TITLE></HEAD>\n";
  print "<BODY BGCOLOR=\"#000000\" TEXT=\"#AAAAAA\">\n\n";
  print "<BR><BR><B>\n";
  print "<FONT FACE=\"Verdana,Tahoma,Arial\" COLOR=\"#FF0000\" SIZE=5>ERROR : </FONT>\n";
  print "<FONT COLOR=\"#FF0000\" SIZE=3>@_</FONT>\n";
  print "</B>\n\n";
  print "</BODY></HTML>\n";
}

sub getArgs {
  my $s_string = '';
  foreach $s_key (keys %ARGS) {
    $s_value = &convert_html($ARGS{$s_key});
    $s_key = &convert_html($s_key);
    $s_string = $s_string.'&'.$s_key.'='.$s_value;
  }
  $s_string =~ s/^&(.*)$/\1/;
  return $s_string;
}

sub readConfig {
  if (!($ARGS{'cfg'})) { &errorMsg("No ConfigFile specified!"); exit; }
  if (!open(FILE,"config/$ARGS{'cfg'}.cfg")) { &errorMsg("Can't read ConfigFile!"); exit; }
  my @s_config = <FILE>;
  close(FILE);
  for ($x=0; $x<@s_config; $x++) {
    $s_config[$x] =~ s/\r//g;
    $s_config[$x] =~ s/\n//g;
    if ($s_config[$x] =~ /^\/\/.*$/) { next; }
    if ($s_config[$x] eq '') { next; }
    ($d_name,$d_value) = split(/\t+/,$s_config[$x]);
    $CONFIG{$d_name} = $d_value;
  }
}

sub readPlayers {
  @PLAYERS = ();
  if (!open(FILE,$CONFIG{'db_players'})) { &errorMsg("Can't read Database of Players!"); exit; }
  my @s_players = <FILE>;
  close(FILE);
  for ($x=0; $x<@s_players; $x++) {
    $s_players[$x] =~ s/\r//g;
    $s_players[$x] =~ s/\n//g;
    push(@PLAYERS,$s_players[$x]);
  }
}

sub readRankings {
  if (!open(FILE,$CONFIG{'db_rankings'})) { &errorMsg("Can't read Database of Rankings!"); exit; }
  my @s_rankings = <FILE>;
  close(FILE);
  for ($x=0; $x<@s_rankings; $x++) {
    $s_rankings[$x] =~ s/\r//g;
    $s_rankings[$x] =~ s/\n//g;
    ($d_name,$d_value) = split(/ = /,$s_rankings[$x]);
    $RANKINGS{$d_name} = $d_value;
  }
}

sub searchMaps {
  foreach $s_key (keys %RANKINGS) {
    $d_key = $s_key;
    if ($d_key =~ /^.+_map_([^_]+)_.+$/) {
      $d_key =~ s/^.+_map_([^_]+)_.+$/\1/;
      $d_key = uc($d_key);
      $found = 0;
      for ($i=0; $i<@MAPS; $i++) { if ($MAPS[$i] eq $d_key) { $found = 1; last; } }
      if ((!$found) && ($d_key ne "CURRENT")) { push(@MAPS,$d_key); }
    }
  }
}

sub searchPlayers {
  my @s_players = ();
  my @s_players_num = ();
  my @s_names = ();
  my $s_pattern = &convert_reg(uc($ARGS{'search'}));
  my @s_names = split(/ AND /,$s_pattern);
  for ($i=0; $i<@PLAYERS; $i++) {
    for ($j=0; $j<@s_names; $j++) {
      $s_pattern = @s_names[$j];
      if (uc($PLAYERS[$i]) =~ /$s_pattern/) { push(@s_players,$PLAYERS[$i]); push(@s_players_num,$i+1); last; }
    }
  }
  @PLAYERS = @s_players;
  @PLAYERSNUM = @s_players_num;
}

sub sortPlayers {
  if (!($ARGS{'sort'})) { $ARGS{'sort'} = $CONFIG{'sort_default'}; }
  if    ($ARGS{'sort'} eq 'name')    { @PLAYERS = sort {uc($a) cmp uc($b)} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'kills')   { @PLAYERS = sort {$RANKINGS{$b.'_kills_total'} <=> $RANKINGS{$a.'_kills_total'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'deaths')  { @PLAYERS = sort {$RANKINGS{$b.'_deaths_total'} <=> $RANKINGS{$a.'_deaths_total'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'suicids') { @PLAYERS = sort {$RANKINGS{$b.'_suicids_total'} <=> $RANKINGS{$a.'_suicids_total'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'frags')   { @PLAYERS = sort {($RANKINGS{$b.'_kills_total'} - $RANKINGS{$b.'_suicids_total'}) <=> ($RANKINGS{$a.'_kills_total'} - $RANKINGS{$a.'_suicids_total'})} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'skill')   { @PLAYERS = sort {&cmpSkill($b,$a)} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'eff')     { @PLAYERS = sort {&cmpEfficiency($b,$a)} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'date')    { @PLAYERS = sort {$RANKINGS{$b.'_lastseen'} cmp $RANKINGS{$a.'_lastseen'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctffs')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_flag_stole'} <=> $RANKINGS{$a.'_ctf_flag_stole'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctffl')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_flag_lost'} <=> $RANKINGS{$a.'_ctf_flag_lost'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctffc')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_flag_capture'} <=> $RANKINGS{$a.'_ctf_flag_capture'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctffr')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_flag_return'} <=> $RANKINGS{$a.'_ctf_flag_return'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctffd')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_flag_defend'} <=> $RANKINGS{$a.'_ctf_flag_defend'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctfck')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_carrier_killed'} <=> $RANKINGS{$a.'_ctf_carrier_killed'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctfcd')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_carrier_defend'} <=> $RANKINGS{$a.'_ctf_carrier_defend'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctfac')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_capture_assist'} <=> $RANKINGS{$a.'_ctf_capture_assist'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctfar')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_return_assist'} <=> $RANKINGS{$a.'_ctf_return_assist'}} @PLAYERS; }
  elsif ($ARGS{'sort'} eq 'ctfbd')   { @PLAYERS = sort {$RANKINGS{$b.'_ctf_base_defend'} <=> $RANKINGS{$a.'_ctf_base_defend'}} @PLAYERS; }
  elsif ($ARGS{'sort'} =~ /^hi_.+_k$/) { $s_map = $ARGS{'sort'}; $s_map =~s /^hi_(.+)_k$/\1/; @PLAYERS = sort {$RANKINGS{$b.'_hiscore_'.$s_map.'_kills'} <=> $RANKINGS{$a.'_hiscore_'.$s_map.'_kills'}} @PLAYERS; }
  elsif ($ARGS{'sort'} =~ /^hi_.+_d$/) { $s_map = $ARGS{'sort'}; $s_map =~s /^hi_(.+)_d$/\1/; @PLAYERS = sort {$RANKINGS{$b.'_hiscore_'.$s_map.'_deaths'} <=> $RANKINGS{$a.'_hiscore_'.$s_map.'_deaths'}} @PLAYERS; }
  elsif ($ARGS{'sort'} =~ /^hi_.+_s$/) { $s_map = $ARGS{'sort'}; $s_map =~s /^hi_(.+)_s$/\1/; @PLAYERS = sort {$RANKINGS{$b.'_hiscore_'.$s_map.'_suicids'} <=> $RANKINGS{$a.'_hiscore_'.$s_map.'_suicids'}} @PLAYERS; }
  elsif ($ARGS{'sort'} =~ /^map_.+_k$/) { $s_map = $ARGS{'sort'}; $s_map =~s /^map_(.+)_k$/\1/; @PLAYERS = sort {$RANKINGS{$b.'_map_'.$s_map.'_kills'} <=> $RANKINGS{$a.'_map_'.$s_map.'_kills'}} @PLAYERS; }
  elsif ($ARGS{'sort'} =~ /^map_.+_d$/) { $s_map = $ARGS{'sort'}; $s_map =~s /^map_(.+)_d$/\1/; @PLAYERS = sort {$RANKINGS{$b.'_map_'.$s_map.'_deaths'} <=> $RANKINGS{$a.'_map_'.$s_map.'_deaths'}} @PLAYERS; }
  elsif ($ARGS{'sort'} =~ /^map_.+_s$/) { $s_map = $ARGS{'sort'}; $s_map =~s /^map_(.+)_s$/\1/; @PLAYERS = sort {$RANKINGS{$b.'_map_'.$s_map.'_suicids'} <=> $RANKINGS{$a.'_map_'.$s_map.'_suicids'}} @PLAYERS; }
}

sub cmpSkill {
  my $s_a = shift(@_);
  my $s_b = shift(@_);
  my $s_frags_a = $RANKINGS{$s_a.'_kills_total'} - $RANKINGS{$s_a.'_suicids_total'};
  my $s_frags_b = $RANKINGS{$s_b.'_kills_total'} - $RANKINGS{$s_b.'_suicids_total'};
  if ($CONFIG{'skill_fraglimit'} > $s_frags_a) { $s_skill_a = '0.000'; } else { $s_skill_a = sprintf("%.3f", ($RANKINGS{$s_a.'_kills_total'} / ($RANKINGS{$s_a.'_deaths_total'} + $RANKINGS{$s_a.'_suicids_total'} + 1)) ); }
  if ($CONFIG{'skill_fraglimit'} > $s_frags_b) { $s_skill_b = '0.000'; } else { $s_skill_b = sprintf("%.3f", ($RANKINGS{$s_b.'_kills_total'} / ($RANKINGS{$s_b.'_deaths_total'} + $RANKINGS{$s_b.'_suicids_total'} + 1)) ); }
  if ($s_skill_a > $s_skill_b) { return 1; }
  if ($s_skill_a < $s_skill_b) { return -1; }
}

sub cmpEfficiency {
  my $s_a = shift(@_);
  my $s_b = shift(@_);
  my $s_frags_a = $RANKINGS{$s_a.'_kills_total'} - $RANKINGS{$s_a.'_suicids_total'};
  my $s_frags_b = $RANKINGS{$s_b.'_kills_total'} - $RANKINGS{$s_b.'_suicids_total'};
  if ($CONFIG{'eff_fraglimit'} > $s_frags_a) { $s_eff_a = 0; } else { $s_eff_a = int((($s_frags_a * 100) / ($s_frags_a + $RANKINGS{$s_a.'_deaths_total'} + 1))); }
  if ($CONFIG{'eff_fraglimit'} > $s_frags_b) { $s_eff_b = 0; } else { $s_eff_b = int((($s_frags_b * 100) / ($s_frags_b + $RANKINGS{$s_b.'_deaths_total'} + 1))); }
  if ($s_eff_a > $s_eff_b) { return 1; }
  if ($s_eff_a < $s_eff_b) { return -1; }
}

sub showAll {

  ##### Read all needed HTML-Files first.
  ##### If they can't be read an ErrorMsg will be printed and the CGI will exit!
  ##### The Content of the Files will be stored in Arrays.

  if (!open(FILE,$CONFIG{'html_main'})) { &errorMsg("Can't read HTML for MainPage!"); exit; }
  my @html_main = <FILE>;
  close(FILE);

  ##### If a SearchString is specified only matching Players will be listed.
  ##### This makes it easier to show all known ClanMembers or similar.

  if ($ARGS{'search'}) { &searchPlayers; }

  ##### First compute all needed Values for the MainPage.
  ##### If no Number of Players is specified it will default to the Value in the ConfigFile.
  ##### The Values covering total Values are only counted for the Number of Players specified.

  if (!$ARGS{'num'}) {
    if ($CONFIG{'num_players'} < @PLAYERS) { $s_count = $CONFIG{'num_players'}; } else { $s_count = @PLAYERS; }
  }
  else {
    if ($ARGS{'num'} < @PLAYERS) { $s_count = $ARGS{'num'}; } else { $s_count = @PLAYERS; }
  }


  for ($x=0; $x<$s_count; $x++) {

    $s_kills[$x] = $RANKINGS{$PLAYERS[$x].'_kills_total'};
    $s_deaths[$x] = $RANKINGS{$PLAYERS[$x].'_deaths_total'};
    $s_suicids[$x] = $RANKINGS{$PLAYERS[$x].'_suicids_total'};
    $s_frags[$x] = $s_kills[$x] - $s_suicids[$x];
    if ($CONFIG{'skill_fraglimit'} > $s_frags[$x]) { $s_skill[$x] = '0.000'; } else { $s_skill[$x] = sprintf("%.3f", ($s_kills[$x] / ($s_deaths[$x] + $s_suicids[$x] + 1)) ); }
    if ($CONFIG{'eff_fraglimit'} > $s_frags[$x]) { $s_eff[$x] = 0; } else { $s_eff[$x] = int((($s_frags[$x] * 100) / ($s_frags[$x] + $s_deaths[$x] + 1))); }
    $s_date[$x] = $RANKINGS{$PLAYERS[$x].'_lastseen'};

    for ($y=0; $y<@MAPS; $y++) {
      $maptotal{'kills_'.$x.'_'.$MAPS[$y]} = $RANKINGS{$PLAYERS[$x].'_map_'.$MAPS[$y].'_kills'};
      $maptotal{'deaths_'.$x.'_'.$MAPS[$y]} = $RANKINGS{$PLAYERS[$x].'_map_'.$MAPS[$y].'_deaths'};
      $maptotal{'suicids_'.$x.'_'.$MAPS[$y]} = $RANKINGS{$PLAYERS[$x].'_map_'.$MAPS[$y].'_suicids'};
      $maphiscore{'kills_'.$x.'_'.$MAPS[$y]} = $RANKINGS{$PLAYERS[$x].'_hiscore_'.$MAPS[$y].'_kills'};
      $maphiscore{'deaths_'.$x.'_'.$MAPS[$y]} = $RANKINGS{$PLAYERS[$x].'_hiscore_'.$MAPS[$y].'_deaths'};
      $maphiscore{'suicids_'.$x.'_'.$MAPS[$y]} = $RANKINGS{$PLAYERS[$x].'_hiscore_'.$MAPS[$y].'_suicids'};
    }

    $s_hexplayer[$x] = &convert_html($PLAYERS[$x]);

    $sum_kills += $s_kills[$x];
    $sum_deaths += $s_deaths[$x];
    $sum_suicids += $s_suicids[$x];
    $sum_frags += $s_frags[$x];

    $s_ctf_base_defend[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_base_defend'};
    $s_ctf_capture_assist[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_capture_assist'};
    $s_ctf_carrier_defend[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_carrier_defend'};
    $s_ctf_carrier_killed[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_carrier_killed'};
    $s_ctf_flag_capture[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_flag_capture'};
    $s_ctf_flag_defend[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_flag_defend'};
    $s_ctf_flag_lost[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_flag_lost'};
    $s_ctf_flag_return[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_flag_return'};
    $s_ctf_flag_stole[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_flag_stole'};
    $s_ctf_return_assist[$x] = $RANKINGS{$PLAYERS[$x].'_ctf_return_assist'};

    $sum_ctf_base_defend += $s_ctf_base_defend[$x];
    $sum_ctf_capture_assist += $s_ctf_capture_assist[$x];
    $sum_ctf_carrier_defend += $s_ctf_carrier_defend[$x];
    $sum_ctf_carrier_killed += $s_ctf_carrier_killed[$x];
    $sum_ctf_flag_capture += $s_ctf_flag_capture[$x];
    $sum_ctf_flag_defend += $s_ctf_flag_defend[$x];
    $sum_ctf_flag_lost += $s_ctf_flag_lost[$x];
    $sum_ctf_flag_return += $s_ctf_flag_return[$x];
    $sum_ctf_flag_stole += $s_ctf_flag_stole[$x];
    $sum_ctf_return_assist += $s_ctf_return_assist[$x];
  }

  for ($x=0; $x<$s_count; $x++) {
    $sum_skill += $s_skill[$x];
  }
  if ($s_count) { $sum_skill = sprintf("%.3f", ($sum_skill / $s_count) ); }

  for ($x=0; $x<$s_count; $x++) {
    $sum_eff += $s_eff[$x];
  }
  if ($s_count) { $sum_eff = int($sum_eff / $s_count); }

  $s_max = 0;
  for ($x=0; $x<$s_count; $x++) {
    if ($s_skill[$x] > $s_max) { $s_max = $s_skill[$x]; }
  }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }
  for ($x=0; $x<$s_count; $x++) {
    $s_skill_gfx[$x] = int($s_skill[$x] * $s_scale) + 1;
  }

  $s_max = 0;
  for ($x=0; $x<$s_count; $x++) {
    if ($s_eff[$x] > $s_max) { $s_max = $s_eff[$x]; }
  }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }
  for ($x=0; $x<$s_count; $x++) {
    $s_eff_gfx[$x] = int($s_eff[$x] * $s_scale) + 1;
  }

  for ($x=0; $x<$s_count; $x++) {
    if ($x >= @PLAYERS) { last; }
    $sum_kills_blaster         += $RANKINGS{$PLAYERS[$x].'_kills_blaster'};
    $sum_kills_shotgun         += $RANKINGS{$PLAYERS[$x].'_kills_shotgun'};
    $sum_kills_supershotgun    += $RANKINGS{$PLAYERS[$x].'_kills_supershotgun'};
    $sum_kills_machinegun      += $RANKINGS{$PLAYERS[$x].'_kills_machinegun'};
    $sum_kills_chaingun        += $RANKINGS{$PLAYERS[$x].'_kills_chaingun'};
    $sum_kills_grenadelauncher += $RANKINGS{$PLAYERS[$x].'_kills_grenadelauncher'};
    $sum_kills_rocketlauncher  += $RANKINGS{$PLAYERS[$x].'_kills_rocketlauncher'};
    $sum_kills_hyperblaster    += $RANKINGS{$PLAYERS[$x].'_kills_hyperblaster'};
    $sum_kills_railgun         += $RANKINGS{$PLAYERS[$x].'_kills_railgun'};
    $sum_kills_bfg             += $RANKINGS{$PLAYERS[$x].'_kills_bfg'};
    $sum_kills_grenade         += $RANKINGS{$PLAYERS[$x].'_kills_handgrenade'};
    $sum_kills_hook            += $RANKINGS{$PLAYERS[$x].'_kills_hook'};
    $sum_kills_telefrag        += $RANKINGS{$PLAYERS[$x].'_kills_telefrag'};
    $sum_kills_unknown         += $RANKINGS{$PLAYERS[$x].'_kills_unknown'};
    $sum_deaths_blaster         += $RANKINGS{$PLAYERS[$x].'_deaths_blaster'};
    $sum_deaths_shotgun         += $RANKINGS{$PLAYERS[$x].'_deaths_shotgun'};
    $sum_deaths_supershotgun    += $RANKINGS{$PLAYERS[$x].'_deaths_supershotgun'};
    $sum_deaths_machinegun      += $RANKINGS{$PLAYERS[$x].'_deaths_machinegun'};
    $sum_deaths_chaingun        += $RANKINGS{$PLAYERS[$x].'_deaths_chaingun'};
    $sum_deaths_grenadelauncher += $RANKINGS{$PLAYERS[$x].'_deaths_grenadelauncher'};
    $sum_deaths_rocketlauncher  += $RANKINGS{$PLAYERS[$x].'_deaths_rocketlauncher'};
    $sum_deaths_hyperblaster    += $RANKINGS{$PLAYERS[$x].'_deaths_hyperblaster'};
    $sum_deaths_railgun         += $RANKINGS{$PLAYERS[$x].'_deaths_railgun'};
    $sum_deaths_bfg             += $RANKINGS{$PLAYERS[$x].'_deaths_bfg'};
    $sum_deaths_grenade         += $RANKINGS{$PLAYERS[$x].'_deaths_handgrenade'};
    $sum_deaths_hook            += $RANKINGS{$PLAYERS[$x].'_deaths_hook'};
    $sum_deaths_telefrag        += $RANKINGS{$PLAYERS[$x].'_deaths_telefrag'};
    $sum_deaths_unknown         += $RANKINGS{$PLAYERS[$x].'_deaths_unknown'};
    $sum_suicids_lava            += $RANKINGS{$PLAYERS[$x].'_suicids_lava'};
    $sum_suicids_slime           += $RANKINGS{$PLAYERS[$x].'_suicids_slime'};
    $sum_suicids_water           += $RANKINGS{$PLAYERS[$x].'_suicids_water'};
    $sum_suicids_squish          += $RANKINGS{$PLAYERS[$x].'_suicids_squish'};
    $sum_suicids_explosive       += $RANKINGS{$PLAYERS[$x].'_suicids_explosive'};
    $sum_suicids_rocketlauncher  += $RANKINGS{$PLAYERS[$x].'_suicids_rocketlauncher'};
    $sum_suicids_grenadelauncher += $RANKINGS{$PLAYERS[$x].'_suicids_grenadelauncher'};
    $sum_suicids_grenade         += $RANKINGS{$PLAYERS[$x].'_suicids_handgrenade'};
    $sum_suicids_bfg             += $RANKINGS{$PLAYERS[$x].'_suicids_bfg'};
    $sum_suicids_trapblaster     += $RANKINGS{$PLAYERS[$x].'_suicids_trapblaster'};
    $sum_suicids_traplaser       += $RANKINGS{$PLAYERS[$x].'_suicids_traplaser'};
    $sum_suicids_freefall        += $RANKINGS{$PLAYERS[$x].'_suicids_freefall'};
    $sum_suicids_command         += $RANKINGS{$PLAYERS[$x].'_suicids_command'};
    $sum_suicids_unknown         += $RANKINGS{$PLAYERS[$x].'_suicids_unknown'};
    for ($y=0; $y<@MAPS; $y++) {
      $maptotalsum{'kills_'.$MAPS[$y]} += $RANKINGS{$PLAYERS[$x].'_map_'.$MAPS[$y].'_kills'};
      $maptotalsum{'deaths_'.$MAPS[$y]} += $RANKINGS{$PLAYERS[$x].'_map_'.$MAPS[$y].'_deaths'};
      $maptotalsum{'suicids_'.$MAPS[$y]} += $RANKINGS{$PLAYERS[$x].'_map_'.$MAPS[$y].'_suicids'};
    }
  }

  $s_max = 0;
  if ($sum_kills_blaster > $s_max)         { $s_max = $sum_kills_blaster; }
  if ($sum_kills_shotgun > $s_max)         { $s_max = $sum_kills_shotgun; }
  if ($sum_kills_supershotgun > $s_max)    { $s_max = $sum_kills_supershotgun; }
  if ($sum_kills_machinegun > $s_max)      { $s_max = $sum_kills_machinegun; }
  if ($sum_kills_chaingun > $s_max)        { $s_max = $sum_kills_chaingun; }
  if ($sum_kills_grenadelauncher > $s_max) { $s_max = $sum_kills_grenadelauncher; }
  if ($sum_kills_rocketlauncher > $s_max)  { $s_max = $sum_kills_rocketlauncher; }
  if ($sum_kills_hyperblaster > $s_max)    { $s_max = $sum_kills_hyperblaster; }
  if ($sum_kills_railgun > $s_max)         { $s_max = $sum_kills_railgun; }
  if ($sum_kills_bfg > $s_max)             { $s_max = $sum_kills_bfg; }
  if ($sum_kills_grenade > $s_max)         { $s_max = $sum_kills_grenade; }
  if ($sum_kills_hook > $s_max)            { $s_max = $sum_kills_hook; }
  if ($sum_kills_telefrag > $s_max)        { $s_max = $sum_kills_telefrag; }
  if ($sum_kills_unknown > $s_max)         { $s_max = $sum_kills_unknown; }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }

  $gfx_kills_blaster         = int($sum_kills_blaster * $s_scale) + 1;
  $gfx_kills_shotgun         = int($sum_kills_shotgun * $s_scale) + 1;
  $gfx_kills_supershotgun    = int($sum_kills_supershotgun * $s_scale) + 1;
  $gfx_kills_machinegun      = int($sum_kills_machinegun * $s_scale) + 1;
  $gfx_kills_chaingun        = int($sum_kills_chaingun * $s_scale) + 1;
  $gfx_kills_grenadelauncher = int($sum_kills_grenadelauncher * $s_scale) + 1;
  $gfx_kills_rocketlauncher  = int($sum_kills_rocketlauncher * $s_scale) + 1;
  $gfx_kills_hyperblaster    = int($sum_kills_hyperblaster * $s_scale) + 1;
  $gfx_kills_railgun         = int($sum_kills_railgun * $s_scale) + 1;
  $gfx_kills_bfg             = int($sum_kills_bfg * $s_scale) + 1;
  $gfx_kills_grenade         = int($sum_kills_grenade * $s_scale) + 1;
  $gfx_kills_hook            = int($sum_kills_hook * $s_scale) + 1;
  $gfx_kills_telefrag        = int($sum_kills_telefrag * $s_scale) + 1;
  $gfx_kills_unknown         = int($sum_kills_unknown * $s_scale) + 1;

  $s_max = 0;
  if ($sum_deaths_blaster > $s_max)         { $s_max = $sum_deaths_blaster; }
  if ($sum_deaths_shotgun > $s_max)         { $s_max = $sum_deaths_shotgun; }
  if ($sum_deaths_supershotgun > $s_max)    { $s_max = $sum_deaths_supershotgun; }
  if ($sum_deaths_machinegun > $s_max)      { $s_max = $sum_deaths_machinegun; }
  if ($sum_deaths_chaingun > $s_max)        { $s_max = $sum_deaths_chaingun; }
  if ($sum_deaths_grenadelauncher > $s_max) { $s_max = $sum_deaths_grenadelauncher; }
  if ($sum_deaths_rocketlauncher > $s_max)  { $s_max = $sum_deaths_rocketlauncher; }
  if ($sum_deaths_hyperblaster > $s_max)    { $s_max = $sum_deaths_hyperblaster; }
  if ($sum_deaths_railgun > $s_max)         { $s_max = $sum_deaths_railgun; }
  if ($sum_deaths_bfg > $s_max)             { $s_max = $sum_deaths_bfg; }
  if ($sum_deaths_grenade > $s_max)         { $s_max = $sum_deaths_grenade; }
  if ($sum_deaths_hook > $s_max)            { $s_max = $sum_deaths_hook; }
  if ($sum_deaths_telefrag > $s_max)        { $s_max = $sum_deaths_telefrag; }
  if ($sum_deaths_unknown > $s_max)         { $s_max = $sum_deaths_unknown; }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }

  $gfx_deaths_blaster         = int($sum_deaths_blaster * $s_scale) + 1;
  $gfx_deaths_shotgun         = int($sum_deaths_shotgun * $s_scale) + 1;
  $gfx_deaths_supershotgun    = int($sum_deaths_supershotgun * $s_scale) + 1;
  $gfx_deaths_machinegun      = int($sum_deaths_machinegun * $s_scale) + 1;
  $gfx_deaths_chaingun        = int($sum_deaths_chaingun * $s_scale) + 1;
  $gfx_deaths_grenadelauncher = int($sum_deaths_grenadelauncher * $s_scale) + 1;
  $gfx_deaths_rocketlauncher  = int($sum_deaths_rocketlauncher * $s_scale) + 1;
  $gfx_deaths_hyperblaster    = int($sum_deaths_hyperblaster * $s_scale) + 1;
  $gfx_deaths_railgun         = int($sum_deaths_railgun * $s_scale) + 1;
  $gfx_deaths_bfg             = int($sum_deaths_bfg * $s_scale) + 1;
  $gfx_deaths_grenade         = int($sum_deaths_grenade * $s_scale) + 1;
  $gfx_deaths_hook            = int($sum_deaths_hook * $s_scale) + 1;
  $gfx_deaths_telefrag        = int($sum_deaths_telefrag * $s_scale) + 1;
  $gfx_deaths_unknown         = int($sum_deaths_unknown * $s_scale) + 1;

  $s_max = 0;
  if ($sum_suicids_lava > $s_max)            { $s_max = $sum_suicids_lava; }
  if ($sum_suicids_slime > $s_max)           { $s_max = $sum_suicids_slime; }
  if ($sum_suicids_water > $s_max)           { $s_max = $sum_suicids_water; }
  if ($sum_suicids_squish > $s_max)          { $s_max = $sum_suicids_squish; }
  if ($sum_suicids_explosive > $s_max)       { $s_max = $sum_suicids_explosive; }
  if ($sum_suicids_rocketlauncher > $s_max)  { $s_max = $sum_suicids_rocketlauncher; }
  if ($sum_suicids_grenadelauncher > $s_max) { $s_max = $sum_suicids_grenadelauncher; }
  if ($sum_suicids_grenade > $s_max)         { $s_max = $sum_suicids_grenade; }
  if ($sum_suicids_bfg > $s_max)             { $s_max = $sum_suicids_bfg; }
  if ($sum_suicids_trapblaster > $s_max)     { $s_max = $sum_suicids_trapblaster; }
  if ($sum_suicids_traplaser > $s_max)       { $s_max = $sum_suicids_traplaser; }
  if ($sum_suicids_freefall > $s_max)        { $s_max = $sum_suicids_freefall; }
  if ($sum_suicids_command > $s_max)         { $s_max = $sum_suicids_command; }
  if ($sum_suicids_unknown > $s_max)         { $s_max = $sum_suicids_unknown; }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }

  $gfx_suicids_lava            = int($sum_suicids_lava * $s_scale) + 1;
  $gfx_suicids_slime           = int($sum_suicids_slime * $s_scale) + 1;
  $gfx_suicids_water           = int($sum_suicids_water * $s_scale) + 1;
  $gfx_suicids_squish          = int($sum_suicids_squish * $s_scale) + 1;
  $gfx_suicids_explosive       = int($sum_suicids_explosive * $s_scale) + 1;
  $gfx_suicids_rocketlauncher  = int($sum_suicids_rocketlauncher * $s_scale) + 1;
  $gfx_suicids_grenadelauncher = int($sum_suicids_grenadelauncher * $s_scale) + 1;
  $gfx_suicids_grenade         = int($sum_suicids_grenade * $s_scale) + 1;
  $gfx_suicids_bfg             = int($sum_suicids_bfg * $s_scale) + 1;
  $gfx_suicids_trapblaster     = int($sum_suicids_trapblaster * $s_scale) + 1;
  $gfx_suicids_traplaser       = int($sum_suicids_traplaser * $s_scale) + 1;
  $gfx_suicids_freefall        = int($sum_suicids_freefall * $s_scale) + 1;
  $gfx_suicids_command         = int($sum_suicids_command * $s_scale) + 1;
  $gfx_suicids_unknown         = int($sum_suicids_unknown * $s_scale) + 1;

  ##### Here the PlayerLoopHTML will be created first.
  ##### This is needed to place it in the MainHTML later.
  ##### Remember that only certain KeyWords get replaced at this
  ##### Point.
  ##### As more than one Loops are supported every Loop has to
  ##### be filled with the Data!

  $html_main = "@html_main";
  $s_args = &getArgs;

  for ($n=1; $n<=$CONFIG{'html_playerloop_count'}; $n++) {
    if (!open(FILE,$CONFIG{'html_playerloop_'.$n})) { &errorMsg("Can't read HTML for PlayerLoop $n!"); exit; }
    $s_playerloop = "";
    @html_playerloop = ();
    @html_playerloop = <FILE>;
    close(FILE);
  
    for ($x=0; $x<$s_count; $x++) {
      $s_num = $x+1;
      $s_html_player = $PLAYERS[$x];
      $s_html_player =~ s/\</\&lt\;/g;
      if ($s_num > @PLAYERS) { last; }
      $pat_playerloop = "@html_playerloop";
      $pat_playerloop =~ s/#QUERYSTRING#/$s_args/g;
      if ($ARGS{'search'}) {
        $pat_playerloop =~ s/#PLAYER_NUMBER#/$PLAYERSNUM[$x]/g;
      } else {
        $pat_playerloop =~ s/#PLAYER_NUMBER#/$s_num/g;
      }
      $pat_playerloop =~ s/#PLAYER_NAME#/$s_html_player/g;
      $pat_playerloop =~ s/#PLAYER_NAME_HEX#/$s_hexplayer[$x]/g;
      $pat_playerloop =~ s/#PLAYER_KILLS#/$s_kills[$x]/g;
      $pat_playerloop =~ s/#PLAYER_DEATHS#/$s_deaths[$x]/g;
      $pat_playerloop =~ s/#PLAYER_SUICIDS#/$s_suicids[$x]/g;
      $pat_playerloop =~ s/#PLAYER_FRAGS#/$s_frags[$x]/g;
      $pat_playerloop =~ s/#PLAYER_SKILL#/$s_skill[$x]/g;
      $pat_playerloop =~ s/#PLAYER_SKILL_GFX#/$s_skill_gfx[$x]/g;
      $pat_playerloop =~ s/#PLAYER_EFF#/$s_eff[$x]/g;
      $pat_playerloop =~ s/#PLAYER_EFF_GFX#/$s_eff_gfx[$x]/g;
      $pat_playerloop =~ s/#PLAYER_DATE#/$s_date[$x]/g;
      for ($y=0; $y<@MAPS; $y++) {
        $pat_playerloop =~ s/#PLAYER_HISCORE_$MAPS[$y]_KILLS#/$maphiscore{'kills_'.$x.'_'.$MAPS[$y]}/g;
        $pat_playerloop =~ s/#PLAYER_HISCORE_$MAPS[$y]_DEATHS#/$maphiscore{'deaths_'.$x.'_'.$MAPS[$y]}/g;
        $pat_playerloop =~ s/#PLAYER_HISCORE_$MAPS[$y]_SUICIDS#/$maphiscore{'suicids_'.$x.'_'.$MAPS[$y]}/g;
        $pat_playerloop =~ s/#PLAYER_MAP_$MAPS[$y]_KILLS#/$maptotal{'kills_'.$x.'_'.$MAPS[$y]}/g;
        $pat_playerloop =~ s/#PLAYER_MAP_$MAPS[$y]_DEATHS#/$maptotal{'deaths_'.$x.'_'.$MAPS[$y]}/g;
        $pat_playerloop =~ s/#PLAYER_MAP_$MAPS[$y]_SUICIDS#/$maptotal{'suicids_'.$x.'_'.$MAPS[$y]}/g;
      }
      $pat_playerloop =~ s/#PLAYER_CTF_BASE_DEFEND#/$s_ctf_base_defend[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_CAPTURE_ASSIST#/$s_ctf_capture_assist[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_CARRIER_DEFEND#/$s_ctf_carrier_defend[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_CARRIER_KILLED#/$s_ctf_carrier_killed[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_FLAG_CAPTURE#/$s_ctf_flag_capture[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_FLAG_DEFEND#/$s_ctf_flag_defend[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_FLAG_LOST#/$s_ctf_flag_lost[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_FLAG_RETURN#/$s_ctf_flag_return[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_FLAG_STOLE#/$s_ctf_flag_stole[$x]/g;
      $pat_playerloop =~ s/#PLAYER_CTF_RETURN_ASSIST#/$s_ctf_return_assist[$x]/g;

      $s_playerloop = $s_playerloop.$pat_playerloop;
    }
    $html_main =~ s/#PLAYERLOOP_$n#/$s_playerloop/g;
  }

  ##### Now that all Values are computed the MainHTML will be searched for all known
  ##### Keywords. Of course the allready build PlayerLoop will be inserted if the needed
  ##### Keyword is found. All other Keywords get replaced with their Values.

  $html_main =~ s/#QUERYSTRING#/$s_args/g;
  $html_main =~ s/#LASTUPDATE#/$RANKINGS{'last_update'}/g;

  $html_main =~ s/#TOTAL_KILLS_ALL#/$sum_kills/g;
  $html_main =~ s/#TOTAL_DEATHS_ALL#/$sum_deaths/g;
  $html_main =~ s/#TOTAL_SUICIDS_ALL#/$sum_suicids/g;
  $html_main =~ s/#TOTAL_FRAGS_ALL#/$sum_frags/g;
  $html_main =~ s/#TOTAL_SKILL_ALL#/$sum_skill/g;
  $html_main =~ s/#TOTAL_EFF_ALL#/$sum_eff/g;

  for ($y=0; $y<@MAPS; $y++) {
    $html_main =~ s/#TOTAL_MAP_$MAPS[$y]_KILLS_ALL#/$maptotalsum{'kills_'.$MAPS[$y]}/g;
    $html_main =~ s/#TOTAL_MAP_$MAPS[$y]_DEATHS_ALL#/$maptotalsum{'deaths_'.$MAPS[$y]}/g;
    $html_main =~ s/#TOTAL_MAP_$MAPS[$y]_SUICIDS_ALL#/$maptotalsum{'suicids_'.$MAPS[$y]}/g;
  }

  $html_main =~ s/#TOTAL_CTF_BASE_DEFEND#/$sum_ctf_base_defend/g;
  $html_main =~ s/#TOTAL_CTF_CAPTURE_ASSIST#/$sum_ctf_capture_assist/g;
  $html_main =~ s/#TOTAL_CTF_CARRIER_DEFEND#/$sum_ctf_carrier_defend/g;
  $html_main =~ s/#TOTAL_CTF_CARRIER_KILLED#/$sum_ctf_carrier_killed/g;
  $html_main =~ s/#TOTAL_CTF_FLAG_CAPTURE#/$sum_ctf_flag_capture/g;
  $html_main =~ s/#TOTAL_CTF_FLAG_DEFEND#/$sum_ctf_flag_defend/g;
  $html_main =~ s/#TOTAL_CTF_FLAG_LOST#/$sum_ctf_flag_lost/g;
  $html_main =~ s/#TOTAL_CTF_FLAG_RETURN#/$sum_ctf_flag_return/g;
  $html_main =~ s/#TOTAL_CTF_FLAG_STOLE#/$sum_ctf_flag_stole/g;
  $html_main =~ s/#TOTAL_CTF_RETURN_ASSIST#/$sum_ctf_return_assist/g;

  $html_main =~ s/#TOTAL_KILLS_BLASTER#/$sum_kills_blaster/g;
  $html_main =~ s/#TOTAL_KILLS_SHOTGUN#/$sum_kills_shotgun/g;
  $html_main =~ s/#TOTAL_KILLS_SUPERSHOTGUN#/$sum_kills_supershotgun/g;
  $html_main =~ s/#TOTAL_KILLS_MACHINEGUN#/$sum_kills_machinegun/g;
  $html_main =~ s/#TOTAL_KILLS_CHAINGUN#/$sum_kills_chaingun/g;
  $html_main =~ s/#TOTAL_KILLS_GRENADELAUNCHER#/$sum_kills_grenadelauncher/g;
  $html_main =~ s/#TOTAL_KILLS_ROCKETLAUNCHER#/$sum_kills_rocketlauncher/g;
  $html_main =~ s/#TOTAL_KILLS_HYPERBLASTER#/$sum_kills_hyperblaster/g;
  $html_main =~ s/#TOTAL_KILLS_RAILGUN#/$sum_kills_railgun/g;
  $html_main =~ s/#TOTAL_KILLS_BFG10K#/$sum_kills_bfg/g;
  $html_main =~ s/#TOTAL_KILLS_GRENADE#/$sum_kills_grenade/g;
  $html_main =~ s/#TOTAL_KILLS_HOOK#/$sum_kills_hook/g;
  $html_main =~ s/#TOTAL_KILLS_TELEFRAG#/$sum_kills_telefrag/g;
  $html_main =~ s/#TOTAL_KILLS_UNKNOWN#/$sum_kills_unknown/g;

  $html_main =~ s/#TOTAL_KILLS_BLASTER_GFX#/$gfx_kills_blaster/g;
  $html_main =~ s/#TOTAL_KILLS_SHOTGUN_GFX#/$gfx_kills_shotgun/g;
  $html_main =~ s/#TOTAL_KILLS_SUPERSHOTGUN_GFX#/$gfx_kills_supershotgun/g;
  $html_main =~ s/#TOTAL_KILLS_MACHINEGUN_GFX#/$gfx_kills_machinegun/g;
  $html_main =~ s/#TOTAL_KILLS_CHAINGUN_GFX#/$gfx_kills_chaingun/g;
  $html_main =~ s/#TOTAL_KILLS_GRENADELAUNCHER_GFX#/$gfx_kills_grenadelauncher/g;
  $html_main =~ s/#TOTAL_KILLS_ROCKETLAUNCHER_GFX#/$gfx_kills_rocketlauncher/g;
  $html_main =~ s/#TOTAL_KILLS_HYPERBLASTER_GFX#/$gfx_kills_hyperblaster/g;
  $html_main =~ s/#TOTAL_KILLS_RAILGUN_GFX#/$gfx_kills_railgun/g;
  $html_main =~ s/#TOTAL_KILLS_BFG10K_GFX#/$gfx_kills_bfg/g;
  $html_main =~ s/#TOTAL_KILLS_GRENADE_GFX#/$gfx_kills_grenade/g;
  $html_main =~ s/#TOTAL_KILLS_HOOK_GFX#/$gfx_kills_hook/g;
  $html_main =~ s/#TOTAL_KILLS_TELEFRAG_GFX#/$gfx_kills_telefrag/g;
  $html_main =~ s/#TOTAL_KILLS_UNKNOWN_GFX#/$gfx_kills_unknown/g;

  $html_main =~ s/#TOTAL_DEATHS_BLASTER#/$sum_deaths_blaster/g;
  $html_main =~ s/#TOTAL_DEATHS_SHOTGUN#/$sum_deaths_shotgun/g;
  $html_main =~ s/#TOTAL_DEATHS_SUPERSHOTGUN#/$sum_deaths_supershotgun/g;
  $html_main =~ s/#TOTAL_DEATHS_MACHINEGUN#/$sum_deaths_machinegun/g;
  $html_main =~ s/#TOTAL_DEATHS_CHAINGUN#/$sum_deaths_chaingun/g;
  $html_main =~ s/#TOTAL_DEATHS_GRENADELAUNCHER#/$sum_deaths_grenadelauncher/g;
  $html_main =~ s/#TOTAL_DEATHS_ROCKETLAUNCHER#/$sum_deaths_rocketlauncher/g;
  $html_main =~ s/#TOTAL_DEATHS_HYPERBLASTER#/$sum_deaths_hyperblaster/g;
  $html_main =~ s/#TOTAL_DEATHS_RAILGUN#/$sum_deaths_railgun/g;
  $html_main =~ s/#TOTAL_DEATHS_BFG10K#/$sum_deaths_bfg/g;
  $html_main =~ s/#TOTAL_DEATHS_GRENADE#/$sum_deaths_grenade/g;
  $html_main =~ s/#TOTAL_DEATHS_HOOK#/$sum_deaths_hook/g;
  $html_main =~ s/#TOTAL_DEATHS_TELEFRAG#/$sum_deaths_telefrag/g;
  $html_main =~ s/#TOTAL_DEATHS_UNKNOWN#/$sum_deaths_unknown/g;

  $html_main =~ s/#TOTAL_DEATHS_BLASTER_GFX#/$gfx_deaths_blaster/g;
  $html_main =~ s/#TOTAL_DEATHS_SHOTGUN_GFX#/$gfx_deaths_shotgun/g;
  $html_main =~ s/#TOTAL_DEATHS_SUPERSHOTGUN_GFX#/$gfx_deaths_supershotgun/g;
  $html_main =~ s/#TOTAL_DEATHS_MACHINEGUN_GFX#/$gfx_deaths_machinegun/g;
  $html_main =~ s/#TOTAL_DEATHS_CHAINGUN_GFX#/$gfx_deaths_chaingun/g;
  $html_main =~ s/#TOTAL_DEATHS_GRENADELAUNCHER_GFX#/$gfx_deaths_grenadelauncher/g;
  $html_main =~ s/#TOTAL_DEATHS_ROCKETLAUNCHER_GFX#/$gfx_deaths_rocketlauncher/g;
  $html_main =~ s/#TOTAL_DEATHS_HYPERBLASTER_GFX#/$gfx_deaths_hyperblaster/g;
  $html_main =~ s/#TOTAL_DEATHS_RAILGUN_GFX#/$gfx_deaths_railgun/g;
  $html_main =~ s/#TOTAL_DEATHS_BFG10K_GFX#/$gfx_deaths_bfg/g;
  $html_main =~ s/#TOTAL_DEATHS_GRENADE_GFX#/$gfx_deaths_grenade/g;
  $html_main =~ s/#TOTAL_DEATHS_HOOK_GFX#/$gfx_deaths_hook/g;
  $html_main =~ s/#TOTAL_DEATHS_TELEFRAG_GFX#/$gfx_deaths_telefrag/g;
  $html_main =~ s/#TOTAL_DEATHS_UNKNOWN_GFX#/$gfx_deaths_unknown/g;

  $html_main =~ s/#TOTAL_SUICID_LAVA#/$sum_suicids_lava/g;
  $html_main =~ s/#TOTAL_SUICID_SLIME#/$sum_suicids_slime/g;
  $html_main =~ s/#TOTAL_SUICID_WATER#/$sum_suicids_water/g;
  $html_main =~ s/#TOTAL_SUICID_SQUISH#/$sum_suicids_squish/g;
  $html_main =~ s/#TOTAL_SUICID_EXPLOSIVE#/$sum_suicids_explosive/g;
  $html_main =~ s/#TOTAL_SUICID_GRENADELAUNCHER#/$sum_suicids_grenadelauncher/g;
  $html_main =~ s/#TOTAL_SUICID_ROCKETLAUNCHER#/$sum_suicids_rocketlauncher/g;
  $html_main =~ s/#TOTAL_SUICID_BFG10K#/$sum_suicids_bfg/g;
  $html_main =~ s/#TOTAL_SUICID_GRENADE#/$sum_suicids_grenade/g;
  $html_main =~ s/#TOTAL_SUICID_BLASTERTRAP#/$sum_suicids_trapblaster/g;
  $html_main =~ s/#TOTAL_SUICID_LASERTRAP#/$sum_suicids_traplaser/g;
  $html_main =~ s/#TOTAL_SUICID_FREEFALL#/$sum_suicids_freefall/g;
  $html_main =~ s/#TOTAL_SUICID_KILLCOMMAND#/$sum_suicids_command/g;
  $html_main =~ s/#TOTAL_SUICID_UNKNOWN#/$sum_suicids_unknown/g;

  $html_main =~ s/#TOTAL_SUICID_LAVA_GFX#/$gfx_suicids_lava/g;
  $html_main =~ s/#TOTAL_SUICID_SLIME_GFX#/$gfx_suicids_slime/g;
  $html_main =~ s/#TOTAL_SUICID_WATER_GFX#/$gfx_suicids_water/g;
  $html_main =~ s/#TOTAL_SUICID_SQUISH_GFX#/$gfx_suicids_squish/g;
  $html_main =~ s/#TOTAL_SUICID_EXPLOSIVE_GFX#/$gfx_suicids_explosive/g;
  $html_main =~ s/#TOTAL_SUICID_GRENADELAUNCHER_GFX#/$gfx_suicids_grenadelauncher/g;
  $html_main =~ s/#TOTAL_SUICID_ROCKETLAUNCHER_GFX#/$gfx_suicids_rocketlauncher/g;
  $html_main =~ s/#TOTAL_SUICID_BFG10K_GFX#/$gfx_suicids_bfg/g;
  $html_main =~ s/#TOTAL_SUICID_GRENADE_GFX#/$gfx_suicids_grenade/g;
  $html_main =~ s/#TOTAL_SUICID_BLASTERTRAP_GFX#/$gfx_suicids_trapblaster/g;
  $html_main =~ s/#TOTAL_SUICID_LASERTRAP_GFX#/$gfx_suicids_traplaser/g;
  $html_main =~ s/#TOTAL_SUICID_FREEFALL_GFX#/$gfx_suicids_freefall/g;
  $html_main =~ s/#TOTAL_SUICID_KILLCOMMAND_GFX#/$gfx_suicids_command/g;
  $html_main =~ s/#TOTAL_SUICID_UNKNOWN_GFX#/$gfx_suicids_unknown/g;

  $html_main =~ s/#\w+#//g;

  ##### The HTML should be complete now. So it will be uploaded to the User.
  ##### The CGI-HTML-Header is needed.

  print "Content-type: text/html\n\n";
  print "$html_main";

}

sub showDetail {

  ##### Read all needed HTML-Files first.
  ##### If they can't be read an ErrorMsg will be printed and the CGI will exit!
  ##### The Content of the Files will be stored in Arrays.

  if (!open(FILE,$CONFIG{'html_playerdetail'})) { &errorMsg("Can't read HTML for DetailsPage!"); exit; }
  my @html_detail = <FILE>;
  close(FILE);
  if (!open(FILE,$CONFIG{'html_victimloop'})) { &errorMsg("Can't read HTML for VictimsLoop!"); exit; }
  my @html_victim = <FILE>;
  close(FILE);
  if (!open(FILE,$CONFIG{'html_enemyloop'})) { &errorMsg("Can't read HTML for EnemiesLoop!"); exit; }
  my @html_enemy = <FILE>;
  close(FILE);

  ##### First compute all needed Values for the MainPage.
  ##### If no Number of Enemies or Victims is specified it will default to the Value in the ConfigFile.

  if (!$ARGS{'enemies'}) {
    if ($CONFIG{'num_enemies'} < @PLAYERS) { $s_count_enemies = $CONFIG{'num_enemies'}; } else { $s_count_enemies = @PLAYERS; }
  }
  else {
    if ($ARGS{'enemies'} < @PLAYERS) { $s_count_enemies = $ARGS{'enemies'}; } else { $s_count_enemies = @PLAYERS; }
  }
  if (!$ARGS{'victims'}) {
    if ($CONFIG{'num_victims'} < @PLAYERS) { $s_count_victims = $CONFIG{'num_victims'}; } else { $s_count_victims = @PLAYERS; }
  }
  else {
    if ($ARGS{'victims'} < @PLAYERS) { $s_count_victims = $ARGS{'victims'}; } else { $s_count_victims = @PLAYERS; }
  }

  @s_enemies = @PLAYERS;
  @s_enemies = sort { $RANKINGS{$ARGS{'player'}.'_enemy_'.$b} <=> $RANKINGS{$ARGS{'player'}.'_enemy_'.$a} } @s_enemies;
  @s_victims = @PLAYERS;
  @s_victims = sort { $RANKINGS{$ARGS{'player'}.'_victim_'.$b} <=> $RANKINGS{$ARGS{'player'}.'_victim_'.$a} } @s_victims;


  for ($x=0; $x<$s_count_enemies; $x++) {
    $s_enemies_kills[$x] = $RANKINGS{$ARGS{'player'}.'_enemy_'.$s_enemies[$x]};
    $s_hexenemies[$x] = &convert_html($s_enemies[$x]);
  }
  for ($x=0; $x<$s_count_victims; $x++) {
    $s_victims_kills[$x] = $RANKINGS{$ARGS{'player'}.'_victim_'.$s_victims[$x]};
    $s_hexvictims[$x] = &convert_html($s_victims[$x]);
  }

  for ($x=0; $x<$s_count_enemies; $x++) {
    $s_enemies_kills[$x] = $RANKINGS{$ARGS{'player'}.'_enemy_'.$s_enemies[$x]}
  }
  for ($x=0; $x<$s_count_victims; $x++) {
    $s_victims_kills[$x] = $RANKINGS{$ARGS{'player'}.'_victim_'.$s_victims[$x]}
  }

  $s_max = 0;
  for ($x=0; $x<$s_count_enemies; $x++) {
    if ($s_enemies_kills[$x] > $s_max) { $s_max = $s_enemies_kills[$x]; }
  }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }
  for ($x=0; $x<$s_count_enemies+1; $x++) {
    $s_enemies_gfx[$x] = int($s_enemies_kills[$x] * $s_scale) + 1;
  }

  $s_max = 0;
  for ($x=0; $x<$s_count_victims; $x++) {
    if ($s_victims_kills[$x] > $s_max) { $s_max = $s_victims_kills[$x]; }
  }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }
  for ($x=0; $x<$s_count_victims+1; $x++) {
    $s_victims_gfx[$x] = int($s_victims_kills[$x] * $s_scale) + 1;
  }

  $s_name = $ARGS{'player'};
  $s_hexname = &convert_html($s_name);
  $s_name =~ s/\</\&lt\;/g;
  for ($x=0; $x<@PLAYERS; $x++) {
    if ($PLAYERS[$x] eq $ARGS{'player'}) { $s_number = $x+1; last; }
  }
  $s_kills = $RANKINGS{$ARGS{'player'}.'_kills_total'};
  $s_deaths = $RANKINGS{$ARGS{'player'}.'_deaths_total'};
  $s_suicids = $RANKINGS{$ARGS{'player'}.'_suicids_total'};
  $s_frags = $s_kills - $s_suicids;
  if ($CONFIG{'skill_fraglimit'} > $s_frags) { $s_skill = '0.000'; }
  else { $s_skill = sprintf("%.3f", ($s_kills / ($s_deaths + $s_suicids + 1)) ); }
  if ($CONFIG{'eff_fraglimit'} > $s_frags) { $s_eff = 0; }
  else { $s_eff = int((($s_frags * 100) / ($s_frags + $s_deaths + 1))); }
  $s_date = $RANKINGS{$ARGS{'player'}.'_lastseen'};

  for ($y=0; $y<@MAPS; $y++) {
    $maptotal{'kills_'.$MAPS[$y]} = $RANKINGS{$ARGS{'player'}.'_map_'.$MAPS[$y].'_kills'};
    $maptotal{'deaths_'.$MAPS[$y]} = $RANKINGS{$ARGS{'player'}.'_map_'.$MAPS[$y].'_deaths'};
    $maptotal{'suicids_'.$MAPS[$y]} = $RANKINGS{$ARGS{'player'}.'_map_'.$MAPS[$y].'_suicids'};
    $maphiscore{'kills_'.$MAPS[$y]} = $RANKINGS{$ARGS{'player'}.'_hiscore_'.$MAPS[$y].'_kills'};
    $maphiscore{'deaths_'.$MAPS[$y]} = $RANKINGS{$ARGS{'player'}.'_hiscore_'.$MAPS[$y].'_deaths'};
    $maphiscore{'suicids_'.$MAPS[$y]} = $RANKINGS{$ARGS{'player'}.'_hiscore_'.$MAPS[$y].'_suicids'};
  }

  $s_ctf_base_defend = $RANKINGS{$ARGS{'player'}.'_ctf_base_defend'};
  $s_ctf_capture_assist = $RANKINGS{$ARGS{'player'}.'_ctf_capture_assist'};
  $s_ctf_carrier_defend = $RANKINGS{$ARGS{'player'}.'_ctf_carrier_defend'};
  $s_ctf_carrier_killed = $RANKINGS{$ARGS{'player'}.'_ctf_carrier_killed'};
  $s_ctf_flag_capture = $RANKINGS{$ARGS{'player'}.'_ctf_flag_capture'};
  $s_ctf_flag_defend = $RANKINGS{$ARGS{'player'}.'_ctf_flag_defend'};
  $s_ctf_flag_lost = $RANKINGS{$ARGS{'player'}.'_ctf_flag_lost'};
  $s_ctf_flag_return = $RANKINGS{$ARGS{'player'}.'_ctf_flag_return'};
  $s_ctf_flag_stole = $RANKINGS{$ARGS{'player'}.'_ctf_flag_stole'};
  $s_ctf_return_assist = $RANKINGS{$ARGS{'player'}.'_ctf_return_assist'};

  $sum_kills_blaster         = $RANKINGS{$ARGS{'player'}.'_kills_blaster'};
  $sum_kills_shotgun         = $RANKINGS{$ARGS{'player'}.'_kills_shotgun'};
  $sum_kills_supershotgun    = $RANKINGS{$ARGS{'player'}.'_kills_supershotgun'};
  $sum_kills_machinegun      = $RANKINGS{$ARGS{'player'}.'_kills_machinegun'};
  $sum_kills_chaingun        = $RANKINGS{$ARGS{'player'}.'_kills_chaingun'};
  $sum_kills_grenadelauncher = $RANKINGS{$ARGS{'player'}.'_kills_grenadelauncher'};
  $sum_kills_rocketlauncher  = $RANKINGS{$ARGS{'player'}.'_kills_rocketlauncher'};
  $sum_kills_hyperblaster    = $RANKINGS{$ARGS{'player'}.'_kills_hyperblaster'};
  $sum_kills_railgun         = $RANKINGS{$ARGS{'player'}.'_kills_railgun'};
  $sum_kills_bfg             = $RANKINGS{$ARGS{'player'}.'_kills_bfg'};
  $sum_kills_grenade         = $RANKINGS{$ARGS{'player'}.'_kills_handgrenade'};
  $sum_kills_hook            = $RANKINGS{$ARGS{'player'}.'_kills_hook'};
  $sum_kills_telefrag        = $RANKINGS{$ARGS{'player'}.'_kills_telefrag'};
  $sum_kills_unknown         = $RANKINGS{$ARGS{'player'}.'_kills_unknown'};
  $sum_deaths_blaster         = $RANKINGS{$ARGS{'player'}.'_deaths_blaster'};
  $sum_deaths_shotgun         = $RANKINGS{$ARGS{'player'}.'_deaths_shotgun'};
  $sum_deaths_supershotgun    = $RANKINGS{$ARGS{'player'}.'_deaths_supershotgun'};
  $sum_deaths_machinegun      = $RANKINGS{$ARGS{'player'}.'_deaths_machinegun'};
  $sum_deaths_chaingun        = $RANKINGS{$ARGS{'player'}.'_deaths_chaingun'};
  $sum_deaths_grenadelauncher = $RANKINGS{$ARGS{'player'}.'_deaths_grenadelauncher'};
  $sum_deaths_rocketlauncher  = $RANKINGS{$ARGS{'player'}.'_deaths_rocketlauncher'};
  $sum_deaths_hyperblaster    = $RANKINGS{$ARGS{'player'}.'_deaths_hyperblaster'};
  $sum_deaths_railgun         = $RANKINGS{$ARGS{'player'}.'_deaths_railgun'};
  $sum_deaths_bfg             = $RANKINGS{$ARGS{'player'}.'_deaths_bfg'};
  $sum_deaths_grenade         = $RANKINGS{$ARGS{'player'}.'_deaths_handgrenade'};
  $sum_deaths_hook            = $RANKINGS{$ARGS{'player'}.'_deaths_hook'};
  $sum_deaths_telefrag        = $RANKINGS{$ARGS{'player'}.'_deaths_telefrag'};
  $sum_deaths_unknown         = $RANKINGS{$ARGS{'player'}.'_deaths_unknown'};
  $sum_suicids_lava            = $RANKINGS{$ARGS{'player'}.'_suicids_lava'};
  $sum_suicids_slime           = $RANKINGS{$ARGS{'player'}.'_suicids_slime'};
  $sum_suicids_water           = $RANKINGS{$ARGS{'player'}.'_suicids_water'};
  $sum_suicids_squish          = $RANKINGS{$ARGS{'player'}.'_suicids_squish'};
  $sum_suicids_explosive       = $RANKINGS{$ARGS{'player'}.'_suicids_explosive'};
  $sum_suicids_rocketlauncher  = $RANKINGS{$ARGS{'player'}.'_suicids_rocketlauncher'};
  $sum_suicids_grenadelauncher = $RANKINGS{$ARGS{'player'}.'_suicids_grenadelauncher'};
  $sum_suicids_grenade         = $RANKINGS{$ARGS{'player'}.'_suicids_handgrenade'};
  $sum_suicids_bfg             = $RANKINGS{$ARGS{'player'}.'_suicids_bfg'};
  $sum_suicids_trapblaster     = $RANKINGS{$ARGS{'player'}.'_suicids_trapblaster'};
  $sum_suicids_traplaser       = $RANKINGS{$ARGS{'player'}.'_suicids_traplaser'};
  $sum_suicids_freefall        = $RANKINGS{$ARGS{'player'}.'_suicids_freefall'};
  $sum_suicids_command         = $RANKINGS{$ARGS{'player'}.'_suicids_command'};
  $sum_suicids_unknown         = $RANKINGS{$ARGS{'player'}.'_suicids_unknown'};

  $s_max = 0;
  if ($sum_kills_blaster > $s_max)         { $s_max = $sum_kills_blaster; }
  if ($sum_kills_shotgun > $s_max)         { $s_max = $sum_kills_shotgun; }
  if ($sum_kills_supershotgun > $s_max)    { $s_max = $sum_kills_supershotgun; }
  if ($sum_kills_machinegun > $s_max)      { $s_max = $sum_kills_machinegun; }
  if ($sum_kills_chaingun > $s_max)        { $s_max = $sum_kills_chaingun; }
  if ($sum_kills_grenadelauncher > $s_max) { $s_max = $sum_kills_grenadelauncher; }
  if ($sum_kills_rocketlauncher > $s_max)  { $s_max = $sum_kills_rocketlauncher; }
  if ($sum_kills_hyperblaster > $s_max)    { $s_max = $sum_kills_hyperblaster; }
  if ($sum_kills_railgun > $s_max)         { $s_max = $sum_kills_railgun; }
  if ($sum_kills_bfg > $s_max)             { $s_max = $sum_kills_bfg; }
  if ($sum_kills_grenade > $s_max)         { $s_max = $sum_kills_grenade; }
  if ($sum_kills_hook > $s_max)            { $s_max = $sum_kills_hook; }
  if ($sum_kills_telefrag > $s_max)        { $s_max = $sum_kills_telefrag; }
  if ($sum_kills_unknown > $s_max)         { $s_max = $sum_kills_unknown; }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }

  $gfx_kills_blaster         = int($sum_kills_blaster * $s_scale) + 1;
  $gfx_kills_shotgun         = int($sum_kills_shotgun * $s_scale) + 1;
  $gfx_kills_supershotgun    = int($sum_kills_supershotgun * $s_scale) + 1;
  $gfx_kills_machinegun      = int($sum_kills_machinegun * $s_scale) + 1;
  $gfx_kills_chaingun        = int($sum_kills_chaingun * $s_scale) + 1;
  $gfx_kills_grenadelauncher = int($sum_kills_grenadelauncher * $s_scale) + 1;
  $gfx_kills_rocketlauncher  = int($sum_kills_rocketlauncher * $s_scale) + 1;
  $gfx_kills_hyperblaster    = int($sum_kills_hyperblaster * $s_scale) + 1;
  $gfx_kills_railgun         = int($sum_kills_railgun * $s_scale) + 1;
  $gfx_kills_bfg             = int($sum_kills_bfg * $s_scale) + 1;
  $gfx_kills_grenade         = int($sum_kills_grenade * $s_scale) + 1;
  $gfx_kills_hook            = int($sum_kills_hook * $s_scale) + 1;
  $gfx_kills_telefrag        = int($sum_kills_telefrag * $s_scale) + 1;
  $gfx_kills_unknown         = int($sum_kills_unknown * $s_scale) + 1;

  $s_max = 0;
  if ($sum_deaths_blaster > $s_max)         { $s_max = $sum_deaths_blaster; }
  if ($sum_deaths_shotgun > $s_max)         { $s_max = $sum_deaths_shotgun; }
  if ($sum_deaths_supershotgun > $s_max)    { $s_max = $sum_deaths_supershotgun; }
  if ($sum_deaths_machinegun > $s_max)      { $s_max = $sum_deaths_machinegun; }
  if ($sum_deaths_chaingun > $s_max)        { $s_max = $sum_deaths_chaingun; }
  if ($sum_deaths_grenadelauncher > $s_max) { $s_max = $sum_deaths_grenadelauncher; }
  if ($sum_deaths_rocketlauncher > $s_max)  { $s_max = $sum_deaths_rocketlauncher; }
  if ($sum_deaths_hyperblaster > $s_max)    { $s_max = $sum_deaths_hyperblaster; }
  if ($sum_deaths_railgun > $s_max)         { $s_max = $sum_deaths_railgun; }
  if ($sum_deaths_bfg > $s_max)             { $s_max = $sum_deaths_bfg; }
  if ($sum_deaths_grenade > $s_max)         { $s_max = $sum_deaths_grenade; }
  if ($sum_deaths_hook > $s_max)            { $s_max = $sum_deaths_hook; }
  if ($sum_deaths_telefrag > $s_max)        { $s_max = $sum_deaths_telefrag; }
  if ($sum_deaths_unknown > $s_max)         { $s_max = $sum_deaths_unknown; }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }

  $gfx_deaths_blaster         = int($sum_deaths_blaster * $s_scale) + 1;
  $gfx_deaths_shotgun         = int($sum_deaths_shotgun * $s_scale) + 1;
  $gfx_deaths_supershotgun    = int($sum_deaths_supershotgun * $s_scale) + 1;
  $gfx_deaths_machinegun      = int($sum_deaths_machinegun * $s_scale) + 1;
  $gfx_deaths_chaingun        = int($sum_deaths_chaingun * $s_scale) + 1;
  $gfx_deaths_grenadelauncher = int($sum_deaths_grenadelauncher * $s_scale) + 1;
  $gfx_deaths_rocketlauncher  = int($sum_deaths_rocketlauncher * $s_scale) + 1;
  $gfx_deaths_hyperblaster    = int($sum_deaths_hyperblaster * $s_scale) + 1;
  $gfx_deaths_railgun         = int($sum_deaths_railgun * $s_scale) + 1;
  $gfx_deaths_bfg             = int($sum_deaths_bfg * $s_scale) + 1;
  $gfx_deaths_grenade         = int($sum_deaths_grenade * $s_scale) + 1;
  $gfx_deaths_hook            = int($sum_deaths_hook * $s_scale) + 1;
  $gfx_deaths_telefrag        = int($sum_deaths_telefrag * $s_scale) + 1;
  $gfx_deaths_unknown         = int($sum_deaths_unknown * $s_scale) + 1;

  $s_max = 0;
  if ($sum_suicids_lava > $s_max)            { $s_max = $sum_suicids_lava; }
  if ($sum_suicids_slime > $s_max)           { $s_max = $sum_suicids_slime; }
  if ($sum_suicids_water > $s_max)           { $s_max = $sum_suicids_water; }
  if ($sum_suicids_squish > $s_max)          { $s_max = $sum_suicids_squish; }
  if ($sum_suicids_explosive > $s_max)       { $s_max = $sum_suicids_explosive; }
  if ($sum_suicids_rocketlauncher > $s_max)  { $s_max = $sum_suicids_rocketlauncher; }
  if ($sum_suicids_grenadelauncher > $s_max) { $s_max = $sum_suicids_grenadelauncher; }
  if ($sum_suicids_grenade > $s_max)         { $s_max = $sum_suicids_grenade; }
  if ($sum_suicids_bfg > $s_max)             { $s_max = $sum_suicids_bfg; }
  if ($sum_suicids_trapblaster > $s_max)     { $s_max = $sum_suicids_trapblaster; }
  if ($sum_suicids_traplaser > $s_max)       { $s_max = $sum_suicids_traplaser; }
  if ($sum_suicids_freefall > $s_max)        { $s_max = $sum_suicids_freefall; }
  if ($sum_suicids_command > $s_max)         { $s_max = $sum_suicids_command; }
  if ($sum_suicids_unknown > $s_max)         { $s_max = $sum_suicids_unknown; }
  if ($s_max) { $s_scale = ( 50 / $s_max); } else { $s_scale = 1; }

  $gfx_suicids_lava            = int($sum_suicids_lava * $s_scale) + 1;
  $gfx_suicids_slime           = int($sum_suicids_slime * $s_scale) + 1;
  $gfx_suicids_water           = int($sum_suicids_water * $s_scale) + 1;
  $gfx_suicids_squish          = int($sum_suicids_squish * $s_scale) + 1;
  $gfx_suicids_explosive       = int($sum_suicids_explosive * $s_scale) + 1;
  $gfx_suicids_rocketlauncher  = int($sum_suicids_rocketlauncher * $s_scale) + 1;
  $gfx_suicids_grenadelauncher = int($sum_suicids_grenadelauncher * $s_scale) + 1;
  $gfx_suicids_grenade         = int($sum_suicids_grenade * $s_scale) + 1;
  $gfx_suicids_bfg             = int($sum_suicids_bfg * $s_scale) + 1;
  $gfx_suicids_trapblaster     = int($sum_suicids_trapblaster * $s_scale) + 1;
  $gfx_suicids_traplaser       = int($sum_suicids_traplaser * $s_scale) + 1;
  $gfx_suicids_freefall        = int($sum_suicids_freefall * $s_scale) + 1;
  $gfx_suicids_command         = int($sum_suicids_command * $s_scale) + 1;
  $gfx_suicids_unknown         = int($sum_suicids_unknown * $s_scale) + 1;

  ##### Here the LoopHTMLs will be created first.
  ##### This is needed to place it in the MainHTML later.
  ##### Remember that only certain KeyWords get replaced at this
  ##### Point.

  $s_args = &getArgs;

  $s_num = 0;
  for ($x=0; $x<$s_count_enemies; $x++) {
    if ($s_enemies[$x] eq $ARGS{'player'}) { $s_count_enemies++; next; }
    $s_num++;
    if ($s_num > (@PLAYERS - 1)) { last; }
    $s_html_enemy = $s_enemies[$x];
    $s_html_enemy =~ s/\</\&lt\;/g;
    $pat_enemyloop = "@html_enemy";
    $pat_enemyloop =~ s/#QUERYSTRING#/$s_args/g;
    $pat_enemyloop =~ s/#ENEMY_NUM#/$s_num/g;
    $pat_enemyloop =~ s/#ENEMY_NAME#/$s_html_enemy/g;
    $pat_enemyloop =~ s/#ENEMY_NAME_HEX#/$s_hexenemies[$x]/g;
    $pat_enemyloop =~ s/#ENEMY_KILLS#/$s_enemies_kills[$x]/g;
    $pat_enemyloop =~ s/#ENEMY_GFX#/$s_enemies_gfx[$x]/g;
    $s_enemyloop = $s_enemyloop.$pat_enemyloop;
  }

  $s_num = 0;
  for ($x=0; $x<$s_count_victims; $x++) {
    if ($s_victims[$x] eq $ARGS{'player'}) { $s_count_victims++; next; }
    $s_num++;
    if ($s_num > (@PLAYERS - 1)) { last; }
    $s_html_victim = $s_victims[$x];
    $s_html_victim =~ s/\</\&lt\;/g;
    $pat_victimloop = "@html_victim";
    $pat_victimloop =~ s/#QUERYSTRING#/$s_args/g;
    $pat_victimloop =~ s/#VICTIM_NUM#/$s_num/g;
    $pat_victimloop =~ s/#VICTIM_NAME#/$s_html_victim/g;
    $pat_victimloop =~ s/#VICTIM_NAME_HEX#/$s_hexvictims[$x]/g;
    $pat_victimloop =~ s/#VICTIM_KILLS#/$s_victims_kills[$x]/g;
    $pat_victimloop =~ s/#VICTIM_GFX#/$s_victims_gfx[$x]/g;
    $s_victimloop = $s_victimloop.$pat_victimloop;
  }

  ##### Now that all Values are computed the MainHTML will be searched for all known
  ##### Keywords. Of course the allready build Loops will be inserted if the needed
  ##### Keyword is found. All other Keywords get replaced with their Values.

  $html_main = "@html_detail";

  $html_main =~ s/#QUERYSTRING#/$s_args/g;
  $html_main =~ s/#LASTUPDATE#/$RANKINGS{'last_update'}/g;
  $html_main =~ s/#ENEMIESLOOP#/$s_enemyloop/g;
  $html_main =~ s/#VICTIMSLOOP#/$s_victimloop/g;

  $html_main =~ s/#PLAYER_NUMBER#/$s_number/g;
  $html_main =~ s/#PLAYER_NAME#/$s_name/g;
  $html_main =~ s/#PLAYER_NAME_HEX#/$s_hexname/g;
  $html_main =~ s/#PLAYER_KILLS#/$s_kills/g;
  $html_main =~ s/#PLAYER_DEATHS#/$s_deaths/g;
  $html_main =~ s/#PLAYER_SUICIDS#/$s_suicids/g;
  $html_main =~ s/#PLAYER_FRAGS#/$s_frags/g;
  $html_main =~ s/#PLAYER_SKILL#/$s_skill/g;
  $html_main =~ s/#PLAYER_SKILL_GFX#/51/g;
  $html_main =~ s/#PLAYER_EFF#/$s_eff/g;
  $html_main =~ s/#PLAYER_EFF_GFX#/51/g;
  $html_main =~ s/#PLAYER_DATE#/$s_date/g;
  for ($y=0; $y<@MAPS; $y++) {
    $html_main =~ s/#PLAYER_HISCORE_$MAPS[$y]_KILLS#/$maphiscore{'kills_'.$MAPS[$y]}/g;
    $html_main =~ s/#PLAYER_HISCORE_$MAPS[$y]_DEATHS#/$maphiscore{'deaths_'.$MAPS[$y]}/g;
    $html_main =~ s/#PLAYER_HISCORE_$MAPS[$y]_SUICIDS#/$maphiscore{'suicids_'.$MAPS[$y]}/g;
    $html_main =~ s/#PLAYER_MAP_$MAPS[$y]_KILLS#/$maptotal{'kills_'.$MAPS[$y]}/g;
    $html_main =~ s/#PLAYER_MAP_$MAPS[$y]_DEATHS#/$maptotal{'deaths_'.$MAPS[$y]}/g;
    $html_main =~ s/#PLAYER_MAP_$MAPS[$y]_SUICIDS#/$maptotal{'suicids_'.$MAPS[$y]}/g;
  }

  $html_main =~ s/#PLAYER_CTF_BASE_DEFEND#/$s_ctf_base_defend/g;
  $html_main =~ s/#PLAYER_CTF_CAPTURE_ASSIST#/$s_ctf_capture_assist/g;
  $html_main =~ s/#PLAYER_CTF_CARRIER_DEFEND#/$s_ctf_carrier_defend/g;
  $html_main =~ s/#PLAYER_CTF_CARRIER_KILLED#/$s_ctf_carrier_killed/g;
  $html_main =~ s/#PLAYER_CTF_FLAG_CAPTURE#/$s_ctf_flag_capture/g;
  $html_main =~ s/#PLAYER_CTF_FLAG_DEFEND#/$s_ctf_flag_defend/g;
  $html_main =~ s/#PLAYER_CTF_FLAG_LOST#/$s_ctf_flag_lost/g;
  $html_main =~ s/#PLAYER_CTF_FLAG_RETURN#/$s_ctf_flag_return/g;
  $html_main =~ s/#PLAYER_CTF_FLAG_STOLE#/$s_ctf_flag_stole/g;
  $html_main =~ s/#PLAYER_CTF_RETURN_ASSIST#/$s_ctf_return_assist/g;

  $html_main =~ s/#PLAYER_KILLS_BLASTER#/$sum_kills_blaster/g;
  $html_main =~ s/#PLAYER_KILLS_SHOTGUN#/$sum_kills_shotgun/g;
  $html_main =~ s/#PLAYER_KILLS_SUPERSHOTGUN#/$sum_kills_supershotgun/g;
  $html_main =~ s/#PLAYER_KILLS_MACHINEGUN#/$sum_kills_machinegun/g;
  $html_main =~ s/#PLAYER_KILLS_CHAINGUN#/$sum_kills_chaingun/g;
  $html_main =~ s/#PLAYER_KILLS_GRENADELAUNCHER#/$sum_kills_grenadelauncher/g;
  $html_main =~ s/#PLAYER_KILLS_ROCKETLAUNCHER#/$sum_kills_rocketlauncher/g;
  $html_main =~ s/#PLAYER_KILLS_HYPERBLASTER#/$sum_kills_hyperblaster/g;
  $html_main =~ s/#PLAYER_KILLS_RAILGUN#/$sum_kills_railgun/g;
  $html_main =~ s/#PLAYER_KILLS_BFG10K#/$sum_kills_bfg/g;
  $html_main =~ s/#PLAYER_KILLS_GRENADE#/$sum_kills_grenade/g;
  $html_main =~ s/#PLAYER_KILLS_HOOK#/$sum_kills_hook/g;
  $html_main =~ s/#PLAYER_KILLS_TELEFRAG#/$sum_kills_telefrag/g;
  $html_main =~ s/#PLAYER_KILLS_UNKNOWN#/$sum_kills_unknown/g;

  $html_main =~ s/#PLAYER_KILLS_BLASTER_GFX#/$gfx_kills_blaster/g;
  $html_main =~ s/#PLAYER_KILLS_SHOTGUN_GFX#/$gfx_kills_shotgun/g;
  $html_main =~ s/#PLAYER_KILLS_SUPERSHOTGUN_GFX#/$gfx_kills_supershotgun/g;
  $html_main =~ s/#PLAYER_KILLS_MACHINEGUN_GFX#/$gfx_kills_machinegun/g;
  $html_main =~ s/#PLAYER_KILLS_CHAINGUN_GFX#/$gfx_kills_chaingun/g;
  $html_main =~ s/#PLAYER_KILLS_GRENADELAUNCHER_GFX#/$gfx_kills_grenadelauncher/g;
  $html_main =~ s/#PLAYER_KILLS_ROCKETLAUNCHER_GFX#/$gfx_kills_rocketlauncher/g;
  $html_main =~ s/#PLAYER_KILLS_HYPERBLASTER_GFX#/$gfx_kills_hyperblaster/g;
  $html_main =~ s/#PLAYER_KILLS_RAILGUN_GFX#/$gfx_kills_railgun/g;
  $html_main =~ s/#PLAYER_KILLS_BFG10K_GFX#/$gfx_kills_bfg/g;
  $html_main =~ s/#PLAYER_KILLS_GRENADE_GFX#/$gfx_kills_grenade/g;
  $html_main =~ s/#PLAYER_KILLS_HOOK_GFX#/$gfx_kills_hook/g;
  $html_main =~ s/#PLAYER_KILLS_TELEFRAG_GFX#/$gfx_kills_telefrag/g;
  $html_main =~ s/#PLAYER_KILLS_UNKNOWN_GFX#/$gfx_kills_unknown/g;

  $html_main =~ s/#PLAYER_DEATHS_BLASTER#/$sum_deaths_blaster/g;
  $html_main =~ s/#PLAYER_DEATHS_SHOTGUN#/$sum_deaths_shotgun/g;
  $html_main =~ s/#PLAYER_DEATHS_SUPERSHOTGUN#/$sum_deaths_supershotgun/g;
  $html_main =~ s/#PLAYER_DEATHS_MACHINEGUN#/$sum_deaths_machinegun/g;
  $html_main =~ s/#PLAYER_DEATHS_CHAINGUN#/$sum_deaths_chaingun/g;
  $html_main =~ s/#PLAYER_DEATHS_GRENADELAUNCHER#/$sum_deaths_grenadelauncher/g;
  $html_main =~ s/#PLAYER_DEATHS_ROCKETLAUNCHER#/$sum_deaths_rocketlauncher/g;
  $html_main =~ s/#PLAYER_DEATHS_HYPERBLASTER#/$sum_deaths_hyperblaster/g;
  $html_main =~ s/#PLAYER_DEATHS_RAILGUN#/$sum_deaths_railgun/g;
  $html_main =~ s/#PLAYER_DEATHS_BFG10K#/$sum_deaths_bfg/g;
  $html_main =~ s/#PLAYER_DEATHS_GRENADE#/$sum_deaths_grenade/g;
  $html_main =~ s/#PLAYER_DEATHS_HOOK#/$sum_deaths_hook/g;
  $html_main =~ s/#PLAYER_DEATHS_TELEFRAG#/$sum_deaths_telefrag/g;
  $html_main =~ s/#PLAYER_DEATHS_UNKNOWN#/$sum_deaths_unknown/g;

  $html_main =~ s/#PLAYER_DEATHS_BLASTER_GFX#/$gfx_deaths_blaster/g;
  $html_main =~ s/#PLAYER_DEATHS_SHOTGUN_GFX#/$gfx_deaths_shotgun/g;
  $html_main =~ s/#PLAYER_DEATHS_SUPERSHOTGUN_GFX#/$gfx_deaths_supershotgun/g;
  $html_main =~ s/#PLAYER_DEATHS_MACHINEGUN_GFX#/$gfx_deaths_machinegun/g;
  $html_main =~ s/#PLAYER_DEATHS_CHAINGUN_GFX#/$gfx_deaths_chaingun/g;
  $html_main =~ s/#PLAYER_DEATHS_GRENADELAUNCHER_GFX#/$gfx_deaths_grenadelauncher/g;
  $html_main =~ s/#PLAYER_DEATHS_ROCKETLAUNCHER_GFX#/$gfx_deaths_rocketlauncher/g;
  $html_main =~ s/#PLAYER_DEATHS_HYPERBLASTER_GFX#/$gfx_deaths_hyperblaster/g;
  $html_main =~ s/#PLAYER_DEATHS_RAILGUN_GFX#/$gfx_deaths_railgun/g;
  $html_main =~ s/#PLAYER_DEATHS_BFG10K_GFX#/$gfx_deaths_bfg/g;
  $html_main =~ s/#PLAYER_DEATHS_GRENADE_GFX#/$gfx_deaths_grenade/g;
  $html_main =~ s/#PLAYER_DEATHS_HOOK_GFX#/$gfx_deaths_hook/g;
  $html_main =~ s/#PLAYER_DEATHS_TELEFRAG_GFX#/$gfx_deaths_telefrag/g;
  $html_main =~ s/#PLAYER_DEATHS_UNKNOWN_GFX#/$gfx_deaths_unknown/g;

  $html_main =~ s/#PLAYER_SUICID_LAVA#/$sum_suicids_lava/g;
  $html_main =~ s/#PLAYER_SUICID_SLIME#/$sum_suicids_slime/g;
  $html_main =~ s/#PLAYER_SUICID_WATER#/$sum_suicids_water/g;
  $html_main =~ s/#PLAYER_SUICID_SQUISH#/$sum_suicids_squish/g;
  $html_main =~ s/#PLAYER_SUICID_EXPLOSIVE#/$sum_suicids_explosive/g;
  $html_main =~ s/#PLAYER_SUICID_GRENADELAUNCHER#/$sum_suicids_grenadelauncher/g;
  $html_main =~ s/#PLAYER_SUICID_ROCKETLAUNCHER#/$sum_suicids_rocketlauncher/g;
  $html_main =~ s/#PLAYER_SUICID_BFG10K#/$sum_suicids_bfg/g;
  $html_main =~ s/#PLAYER_SUICID_GRENADE#/$sum_suicids_grenade/g;
  $html_main =~ s/#PLAYER_SUICID_BLASTERTRAP#/$sum_suicids_trapblaster/g;
  $html_main =~ s/#PLAYER_SUICID_LASERTRAP#/$sum_suicids_traplaser/g;
  $html_main =~ s/#PLAYER_SUICID_FREEFALL#/$sum_suicids_freefall/g;
  $html_main =~ s/#PLAYER_SUICID_KILLCOMMAND#/$sum_suicids_command/g;
  $html_main =~ s/#PLAYER_SUICID_UNKNOWN#/$sum_suicids_unknown/g;

  $html_main =~ s/#PLAYER_SUICID_LAVA_GFX#/$gfx_suicids_lava/g;
  $html_main =~ s/#PLAYER_SUICID_SLIME_GFX#/$gfx_suicids_slime/g;
  $html_main =~ s/#PLAYER_SUICID_WATER_GFX#/$gfx_suicids_water/g;
  $html_main =~ s/#PLAYER_SUICID_SQUISH_GFX#/$gfx_suicids_squish/g;
  $html_main =~ s/#PLAYER_SUICID_EXPLOSIVE_GFX#/$gfx_suicids_explosive/g;
  $html_main =~ s/#PLAYER_SUICID_GRENADELAUNCHER_GFX#/$gfx_suicids_grenadelauncher/g;
  $html_main =~ s/#PLAYER_SUICID_ROCKETLAUNCHER_GFX#/$gfx_suicids_rocketlauncher/g;
  $html_main =~ s/#PLAYER_SUICID_BFG10K_GFX#/$gfx_suicids_bfg/g;
  $html_main =~ s/#PLAYER_SUICID_GRENADE_GFX#/$gfx_suicids_grenade/g;
  $html_main =~ s/#PLAYER_SUICID_BLASTERTRAP_GFX#/$gfx_suicids_trapblaster/g;
  $html_main =~ s/#PLAYER_SUICID_LASERTRAP_GFX#/$gfx_suicids_traplaser/g;
  $html_main =~ s/#PLAYER_SUICID_FREEFALL_GFX#/$gfx_suicids_freefall/g;
  $html_main =~ s/#PLAYER_SUICID_KILLCOMMAND_GFX#/$gfx_suicids_command/g;
  $html_main =~ s/#PLAYER_SUICID_UNKNOWN_GFX#/$gfx_suicids_unknown/g;

  $html_main =~ s/#\w+#//g;

  ##### The HTML should be complete now. So it will be uploaded to the User.
  ##### The CGI-HTML-Header is needed.

  print "Content-type: text/html\n\n";
  print "$html_main";

}
