#!/usr/local/bin/perl5
#
###############################################################################
## ------------------------------------------------------------------------- ##
## ProgramName......... TripleX RankingS - ParserQ2GibStats.pl               ##
## ------------------------------------------------------------------------- ##
## Programmer.......... TripleX                                              ##
## eMail............... mrbrain@cs.tu-berlin.de                              ##
## Homepage............ http://triplex.home.pages.de/                        ##
## ------------------------------------------------------------------------- ##
##         (C) Copyright 1998 by TripleX - All Rights reserved!              ##
## ------------------------------------------------------------------------- ##
###############################################################################

###################################################################
# get Date and Time ###############################################
###################################################################

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

$month = ($mon + 1);

if ($sec < 10) { $sec = "0$sec"; }
if ($min < 10) { $min = "0$min"; }
if ($hour < 10) { $hour = "0$hour"; }
if ($month < 10) { $month = "0$month"; }
if ($mday < 10) { $mday = "0$mday"; }

$date = "$year/$month/$mday";
$time = "$hour\:$min\:$sec";

###################################################################
# take the Action #################################################
###################################################################

&startMsg;
&getArgs;
&readConfig;
&readPlayers;
&readRankings;
&rankLogFile;
&savePlayers;
&saveRankings;
exit;

###################################################################
# Subroutines #####################################################
###################################################################

sub convert_reg {
  $s_conv = shift(@_);
  $s_conv =~ s/\\/\\\\/g;
  $s_conv =~ s/\^/\\\^/g;
  $s_conv =~ s/\$/\\\$/g;
  $s_conv =~ s/\@/\\\@/g;
  $s_conv =~ s/\//\\\//g;
  $s_conv =~ s/\|/\\\|/g;
  $s_conv =~ s/\?/\\\?/g;
  $s_conv =~ s/\./\\\./g;
  $s_conv =~ s/\*/\\\*/g;
  $s_conv =~ s/\+/\\\+/g;
  $s_conv =~ s/\[/\\\[/g;
  $s_conv =~ s/\]/\\\]/g;
  $s_conv =~ s/\{/\\\{/g;
  $s_conv =~ s/\}/\\\}/g;
  $s_conv =~ s/\(/\\\(/g;
  $s_conv =~ s/\)/\\\)/g;
  return $s_conv;
}

sub startMsg {
  print "\n";
  print "  o[ TripleX QuakE II RankingS - GibStatsParser ]o\n";
  print "\n";
}

sub errorMsg {
  print "@_\n";
}

sub getArgs {
  $cfg = shift(@ARGV);
}

sub readConfig {
  if (!($cfg)) { &errorMsg("  ERROR: No ConfigFile specified!"); exit; }
  if (!open(FILE,"config/$cfg.cfg")) { &errorMsg("  ERROR: Can't read ConfigFile!"); exit; }
  @s_config = <FILE>;
  close(FILE);
  print "  Reading ConfigFile...";
  for ($x=0; $x<@s_config; $x++) {
    if (!($x%1000)) { print "."; }
    $s_config[$x] =~ s/\r//g;
    $s_config[$x] =~ s/\n//g;
    if ($s_config[$x] =~ /^\/\/.*$/) { next; }
    if ($s_config[$x] eq '') { next; }
    ($d_name,$d_value) = split(/\t+/,$s_config[$x]);
    $CONFIG{$d_name} = $d_value;
  }
  print "done\n";
}

sub readPlayers {
  if (!open(FILE,$CONFIG{'db_players'})) { &errorMsg("  Can't read Database of Players! New one will be created!"); return; }
  @s_players = <FILE>;
  close(FILE);
  print "  Reading PlayerBase...";
  for ($x=0; $x<@s_players; $x++) {
    if (!($x%1000)) { print "."; }
    $s_players[$x] =~ s/\r//g;
    $s_players[$x] =~ s/\n//g;
    push(@PLAYERS,$s_players[$x]);
  }
  print "done\n";
}

sub readRankings {
  if (!open(FILE,$CONFIG{'db_rankings'})) { &errorMsg("  Can't read Database of Rankings! New one will be created!"); return; }
  @s_rankings = <FILE>;
  close(FILE);
  print "  Reading DataBase...";
  for ($x=0; $x<@s_rankings; $x++) {
    if (!($x%1000)) { print "."; }
    $s_rankings[$x] =~ s/\r//g;
    $s_rankings[$x] =~ s/\n//g;
    ($d_name,$d_value) = split(/ = /,$s_rankings[$x]);
    $RANKINGS{$d_name} = $d_value;
  }
  print "done\n";
}

sub savePlayers {
  print "  Saving new PlayerBase...";
  if (!open(FILE,">$CONFIG{'db_players'}")) { die "  ERROR: Couldn't create PlayerBase!\n"; }
  $lines = 0;
  ##### Loop through all Players
  foreach $player (@PLAYERS) {
    $lines++;
    if (!($lines%1000)) { print "."; }
    ##### Check if Player was too long idle...
    if ($CONFIG{'time_maxidle'}) {
      ($d_year,$d_month,$d_day) = split(/\//,$date);
      $s_today = $d_day + (30 * $d_month) + (365 * $d_year);
      ($d_year,$d_month,$d_day) = split(/\//,$RANKINGS{$player.'_lastseen'});
      $s_last = $d_day + (30 * $d_month) + (365 * $d_year);
      ##### Remove all Data...
      if (($s_today - $s_last) > $CONFIG{'time_maxidle'}) {
        $s_check = &convert_reg($player);
        foreach $value (keys %RANKINGS) {
          $s_match = "\^".$s_check;           if ($value =~ /$s_match/) { delete($RANKINGS{$value}); next; }
          $s_match = "victim_".$s_check."\$"; if ($value =~ /$s_match/) { delete($RANKINGS{$value}); next; }
          $s_match = "enemy_".$s_check."\$";  if ($value =~ /$s_match/) { delete($RANKINGS{$value}); next; }
        }
        next;
      }
    }
    print FILE "$player\n";
  }
  close(FILE);
  print "done\n";
}

sub saveRankings {
  print "  Saving new DataBase...";
  if (!open(FILE,">$CONFIG{'db_rankings'}")) { die "  ERROR: Couldn't create DataBase!\n"; }
  $lines = 0;
  $RANKINGS{'last_update'} = "$date - $time";
  foreach $value (keys %RANKINGS) {
    $lines++;
    if (!($lines%1000)) { print "."; }
    print FILE "$value = $RANKINGS{$value}\n";
  }
  close(FILE);
  print "done\n";
}

sub rankLogFile {
    print "  Parsing GibStatsLogFile...";
    ##### read saved File...
    if (!open(FILE,$CONFIG{'log_input'})) { die "  ERROR: Can't open GibStatsLogFile!\n"; }
    @console = <FILE>;
    close(FILE);
    
    ##### build up the RankingArrays...
    $lines = 0;
    foreach $line (@console) {
	$lines++;
	if (!($lines%1000)) { print "."; }
	$line =~ s/\n//g;
	$line =~ s/\r//g;
	($tab1, $tab2, $tab3, $tab4, $tab5, $tab6) = split(/\t/, $line);

        ##########################################
        ##### Special Things to do on MapChange...
        ##########################################

	if (uc($tab3) eq "MAP") {
            ##### check for new HighScores...
            for ($i=0; $i<@PLAYERS; $i++) {
              if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'}) {
                $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'};
              }
              if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'}) {
                $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'};
              }
              if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'}) {
                $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'};
              }
              $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_kills'} += $RANKINGS{$PLAYERS[$i].'_map_current_kills'};
              $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_deaths'} += $RANKINGS{$PLAYERS[$i].'_map_current_deaths'};
              $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_suicids'} += $RANKINGS{$PLAYERS[$i].'_map_current_suicids'};
            }
            ##### Retrieve actual Map...
            $CURRENT_MAP = uc($tab4);
            ##### Prepare Players...
            for ($i=0; $i<@PLAYERS; $i++) {
              $RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'} = 0;
              $RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'} = 0;
              $RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'} = 0;
              $RANKINGS{$PLAYERS[$i].'_map_current_kills'} = 0;
              $RANKINGS{$PLAYERS[$i].'_map_current_deaths'} = 0;
              $RANKINGS{$PLAYERS[$i].'_map_current_suicids'} = 0;
            }
            next;
        }

        ############################################
        ##### Standard DeathMatch SucicidMessages...
        ############################################

	if ($tab3 eq "Suicide") {
	    $player1 = $tab1;
	    if ($tab4 eq "BFG10K") {
		$RANKINGS{$player1.'_suicids_bfg'}++;
	    } elsif ($tab4 eq "Rocket Launcher") {
		$RANKINGS{$player1.'_suicids_rocketlauncher'}++;
	    } elsif ($tab4 eq "Grenade Launcher") {
		$RANKINGS{$player1.'_suicids_grenadelauncher'}++;
	    } elsif ($tab4 eq "Hand Grenade") {
		$RANKINGS{$player1.'_suicids_handgrenade'}++;
	    } elsif ($tab4 eq "Lava") {
		$RANKINGS{$player1.'_suicids_lava'}++;
	    } elsif ($tab4 eq "Slime") {
		$RANKINGS{$player1.'_suicids_slime'}++;
	    } elsif ($tab4 eq "Drowned") {
		$RANKINGS{$player1.'_suicids_water'}++;
	    } elsif ($tab4 eq "Squished") {
		$RANKINGS{$player1.'_suicids_squish'}++;
	    } elsif ($tab4 eq "Fell") {
		$RANKINGS{$player1.'_suicids_freefall'}++;
	    } elsif ($tab4 eq "Lasered") {
		$RANKINGS{$player1.'_suicids_traplaser'}++;
	    } else {
		$RANKINGS{$player1.'_suicids_unknown'}++;
	    }
            $RANKINGS{$player1.'_hiscore_current_suicids'}++;
            $RANKINGS{$player1.'_map_current_suicids'}++;
	    $RANKINGS{$player1.'_suicids_total'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { 
		if ($player eq $player1) { 
		    $found=1; 
		} 
	    } 
	    if (!$found) { 
		@PLAYERS = (@PLAYERS, $player1) ;
	    }
	    next;
	}

        ############################################
        ##### Standard DeathMatch KillingMessages...
        ############################################

        if ($tab3 eq "Kill") {
	    $player1 = $tab2;
	    $player2 = $tab1;
	    if ($tab4 eq "Blaster") {
		$RANKINGS{$player1.'_deaths_blaster'}++;
		$RANKINGS{$player2.'_kills_blaster'}++;
	    } elsif ($tab4 eq "Shotgun") {
		$RANKINGS{$player1.'_deaths_shotgun'}++;
		$RANKINGS{$player2.'_kills_shotgun'}++;
	    } elsif ($tab4 eq "Super Shotgun") {
		$RANKINGS{$player1.'_deaths_supershotgun'}++;
		$RANKINGS{$player2.'_kills_supershotgun'}++;
	    } elsif ($tab4 eq "Machinegun") {
		$RANKINGS{$player1.'_deaths_machinegun'}++;
		$RANKINGS{$player2.'_kills_machinegun'}++;
	    } elsif ($tab4 eq "Chaingun") {
		$RANKINGS{$player1.'_deaths_chaingun'}++;
		$RANKINGS{$player2.'_kills_chaingun'}++;
	    } elsif ($tab4 eq "Grenade Launcher") {
		$RANKINGS{$player1.'_deaths_grenadelauncher'}++;
		$RANKINGS{$player2.'_kills_grenadelauncher'}++;
	    } elsif ($tab4 eq "Rocket Launcher") {
		$RANKINGS{$player1.'_deaths_rocketlauncher'}++;
		$RANKINGS{$player2.'_kills_rocketlauncher'}++;
	    } elsif ($tab4 eq "Hand Grenade") {
		$RANKINGS{$player1.'_deaths_handgrenade'}++;
		$RANKINGS{$player2.'_kills_handgrenade'}++;
	    } elsif ($tab4 eq "Hyperblaster") {
		$RANKINGS{$player1.'_deaths_hyperblaster'}++;
		$RANKINGS{$player2.'_kills_hyperblaster'}++;
	    } elsif ($tab4 eq "HyperBlaster") {
		$RANKINGS{$player1.'_deaths_hyperblaster'}++;
		$RANKINGS{$player2.'_kills_hyperblaster'}++;
	    } elsif ($tab4 eq "Railgun") {
		$RANKINGS{$player1.'_deaths_railgun'}++;
		$RANKINGS{$player2.'_kills_railgun'}++;
	    } elsif ($tab4 eq "BFG10K") {
		$RANKINGS{$player1.'_deaths_bfg'}++;
		$RANKINGS{$player2.'_kills_bfg'}++;
	    } elsif ($tab4 eq "Telefrag") {
		$RANKINGS{$player1.'_deaths_telefrag'}++;
		$RANKINGS{$player2.'_kills_telefrag'}++;
	    } elsif ($tab4 eq "Grappling Hook") {
		$RANKINGS{$player1.'_deaths_hook'}++;
		$RANKINGS{$player2.'_kills_hook'}++;
	    } else {
		$RANKINGS{$player1.'_deaths_unknown'}++;
		$RANKINGS{$player2.'_kills_unknown'}++;
	    }
            $RANKINGS{$player1.'_hiscore_current_deaths'}++;
            $RANKINGS{$player2.'_hiscore_current_kills'}++;
            $RANKINGS{$player1.'_map_current_deaths'}++;
            $RANKINGS{$player2.'_map_current_kills'}++;
	    $RANKINGS{$player1.'_deaths_total'}++;
	    $RANKINGS{$player2.'_kills_total'}++;
	    $RANKINGS{$player1.'_enemy_'.$player2}++;
	    $RANKINGS{$player2.'_victim_'.$player1}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $RANKINGS{$player2.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) {
		if ($player eq $player1) { 
		    $found=1;
		} 
	    } 
	    if (!$found) {
		@PLAYERS = (@PLAYERS, $player1); 
	    }
	    $found=0; 
	    foreach $player (@PLAYERS) {
		if ($player eq $player2) {
		    $found=1;
		} 
	    } 
	    if (!$found) {
		@PLAYERS = (@PLAYERS, $player2);
	    }
	    next;
	}

        #####################################
        ##### Special LMCTF ActionMessages...
        #####################################

	if ($tab3 eq "F Capture") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_flag_capture'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "F Def") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_flag_defend'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "F Return") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_flag_return'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "F Pickup") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_flag_stole'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "F Base Def") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_base_defend'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "FC Frag") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_carrier_killed'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "FC Def") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_carrier_defend'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "FC LostFlag") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_flag_lost'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "FC Frag Assist") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_capture_assist'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "F Return Assist") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_return_assist'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
	if ($tab3 eq "F Defend Assist") {
	    $player1 = $tab1;
	    $RANKINGS{$player1.'_ctf_capture_assist'}++;
	    $RANKINGS{$player1.'_lastseen'} = $date;
	    $found=0; 
	    foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } 
	    if (!$found) { @PLAYERS = (@PLAYERS, $player1); }
	    next;
	}
    }

    ##### check for new HighScores...
    for ($i=0; $i<@PLAYERS; $i++) {
      if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'}) {
        $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'};
      }
      if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'}) {
        $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'};
      }
      if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'}) {
        $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'};
      }
      $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_kills'} += $RANKINGS{$PLAYERS[$i].'_map_current_kills'};
      $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_deaths'} += $RANKINGS{$PLAYERS[$i].'_map_current_deaths'};
      $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_suicids'} += $RANKINGS{$PLAYERS[$i].'_map_current_suicids'};
    }

    print "done\n";
}
