#!/usr/local/bin/perl5
#
###############################################################################
## ------------------------------------------------------------------------- ##
## ProgramName......... TripleX RankingS - ParserQ2Console.pl                ##
## ------------------------------------------------------------------------- ##
## Programmer.......... TripleX                                              ##
## eMail............... mrbrain@cs.tu-berlin.de                              ##
## Homepage............ http://triplex.home.pages.de/                        ##
## ------------------------------------------------------------------------- ##
##         (C) Copyright 1998 by TripleX - All Rights reserved!              ##
## ------------------------------------------------------------------------- ##
###############################################################################

###################################################################
# get Date and Time ###############################################
###################################################################

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

$month = ($mon + 1);

if ($sec < 10) { $sec = "0$sec"; }
if ($min < 10) { $min = "0$min"; }
if ($hour < 10) { $hour = "0$hour"; }
if ($month < 10) { $month = "0$month"; }
if ($mday < 10) { $mday = "0$mday"; }

$date = "$year/$month/$mday";
$time = "$hour\:$min\:$sec";

###################################################################
# take the Action #################################################
###################################################################

&startMsg;
&getArgs;
&readConfig;
&readPlayers;
&readRankings;
&rankLogFile;
&savePlayers;
&saveRankings;
exit;

###################################################################
# Subroutines #####################################################
###################################################################

sub convert_reg {
  $s_conv = shift(@_);
  $s_conv =~ s/\\/\\\\/g;
  $s_conv =~ s/\^/\\\^/g;
  $s_conv =~ s/\$/\\\$/g;
  $s_conv =~ s/\@/\\\@/g;
  $s_conv =~ s/\//\\\//g;
  $s_conv =~ s/\|/\\\|/g;
  $s_conv =~ s/\?/\\\?/g;
  $s_conv =~ s/\./\\\./g;
  $s_conv =~ s/\*/\\\*/g;
  $s_conv =~ s/\+/\\\+/g;
  $s_conv =~ s/\[/\\\[/g;
  $s_conv =~ s/\]/\\\]/g;
  $s_conv =~ s/\{/\\\{/g;
  $s_conv =~ s/\}/\\\}/g;
  $s_conv =~ s/\(/\\\(/g;
  $s_conv =~ s/\)/\\\)/g;
  return $s_conv;
}

sub startMsg {
  print "\n";
  print "  o[ TripleX QuakE II RankingS - ConsoleParser ]o\n";
  print "\n";
}

sub errorMsg {
  print "@_\n";
}

sub getArgs {
  $cfg = shift(@ARGV);
}

sub readConfig {
  if (!($cfg)) { &errorMsg("  ERROR: No ConfigFile specified!"); exit; }
  if (!open(FILE,"config/$cfg.cfg")) { &errorMsg(" ERROR: Can't read ConfigFile!"); exit; }
  @s_config = <FILE>;
  close(FILE);
  print "  Reading ConfigFile...";
  for ($x=0; $x<@s_config; $x++) {
    if (!($x%1000)) { print "."; }
    $s_config[$x] =~ s/\r//g;
    $s_config[$x] =~ s/\n//g;
    if ($s_config[$x] =~ /^\/\/.*$/) { next; }
    if ($s_config[$x] eq '') { next; }
    ($d_name,$d_value) = split(/\t+/,$s_config[$x]);
    $CONFIG{$d_name} = $d_value;
  }
  print "done\n";
}

sub readPlayers {
  if (!open(FILE,$CONFIG{'db_players'})) { &errorMsg("  Can't read Database of Players - new one will be created!"); return; }
  @s_players = <FILE>;
  close(FILE);
  print "  Reading PlayerBase...";
  for ($x=0; $x<@s_players; $x++) {
    if (!($x%1000)) { print "."; }
    $s_players[$x] =~ s/\r//g;
    $s_players[$x] =~ s/\n//g;
    push(@PLAYERS,$s_players[$x]);
  }
  print "done\n";
}

sub readRankings {
  if (!open(FILE,$CONFIG{'db_rankings'})) { &errorMsg("  Can't read Database of Rankings - new one will be created!"); return; }
  @s_rankings = <FILE>;
  close(FILE);
  print "  Reading DataBase...";
  for ($x=0; $x<@s_rankings; $x++) {
    if (!($x%1000)) { print "."; }
    $s_rankings[$x] =~ s/\r//g;
    $s_rankings[$x] =~ s/\n//g;
    ($d_name,$d_value) = split(/ = /,$s_rankings[$x]);
    $RANKINGS{$d_name} = $d_value;
  }
  print "done\n";
}

sub savePlayers {
  print "  Saving new PlayerBase...";
  if (!open(FILE,">$CONFIG{'db_players'}")) { die "  ERROR: Couldn't create PlayerBase!\n"; }
  $lines = 0;
  ##### Loop through all Players
  foreach $player (@PLAYERS) {
    $lines++;
    if (!($lines%1000)) { print "."; }
    ##### Check if Player was too long idle...
    if ($CONFIG{'time_maxidle'}) {
      ($d_year,$d_month,$d_day) = split(/\//,$date);
      $s_today = $d_day + (30 * $d_month) + (365 * $d_year);
      ($d_year,$d_month,$d_day) = split(/\//,$RANKINGS{$player.'_lastseen'});
      $s_last = $d_day + (30 * $d_month) + (365 * $d_year);
      ##### Remove all Data...
      if (($s_today - $s_last) > $CONFIG{'time_maxidle'}) {
        $s_check = &convert_reg($player);
        foreach $value (keys %RANKINGS) {
          $s_match = "\^".$s_check;           if ($value =~ /$s_match/) { delete($RANKINGS{$value}); next; }
          $s_match = "victim_".$s_check."\$"; if ($value =~ /$s_match/) { delete($RANKINGS{$value}); next; }
          $s_match = "enemy_".$s_check."\$";  if ($value =~ /$s_match/) { delete($RANKINGS{$value}); next; }
        }
        next;
      }
    }
    print FILE "$player\n";
  }
  close(FILE);
  print "done\n";
}

sub saveRankings {
  print "  Saving new DataBase...";
  if (!open(FILE,">$CONFIG{'db_rankings'}")) { die "  ERROR: Couldn't create DataBase!\n"; }
  $lines = 0;
  $RANKINGS{'last_update'} = "$date - $time";
  foreach $value (keys %RANKINGS) {
    $lines++;
    if (!($lines%1000)) { print "."; }
    print FILE "$value = $RANKINGS{$value}\n";
  }
  close(FILE);
  print "done\n";
}

sub rankLogFile {
  print "  Parsing ConsoleLogFile...";
  ##### read saved File...
  if (!open(FILE,$CONFIG{'log_input'})) { die "  ERROR: Can't open ConsoleLogFile!\n"; }
  @console = <FILE>;
  close(FILE);

  ##### build up the RankingArrays...
  $lines = 0;
  foreach $line (@console) {
    $lines++;
    if (!($lines%1000)) { print "."; }
    $line =~ s/\n//g;
    $line =~ s/\r//g;
    $line =~ s/\.$//g;
    $line =~ s/\!$//g;
    #if (length($line) > 255) { next; }

    ##########################################
    ##### Special Things to do on MapChange...
    ##########################################

    if ($line =~ /^Map\: \w+.*$/) {
      ##### check for new HighScores...
      for ($i=0; $i<@PLAYERS; $i++) {
        if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'}) {
          $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'};
        }
        if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'}) {
          $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'};
        }
        if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'}) {
          $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'};
        }
        $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_kills'} += $RANKINGS{$PLAYERS[$i].'_map_current_kills'};
        $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_deaths'} += $RANKINGS{$PLAYERS[$i].'_map_current_deaths'};
        $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_suicids'} += $RANKINGS{$PLAYERS[$i].'_map_current_suicids'};
      }
      ##### Retrieve actual Map...
      $map = $line;
      $map =~ s/^Map\: (\w+).*$/\1/;
      $CURRENT_MAP = uc($map);
      ##### Prepare Players...
      for ($i=0; $i<@PLAYERS; $i++) {
        $RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'} = 0;
        $RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'} = 0;
        $RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'} = 0;
        $RANKINGS{$PLAYERS[$i].'_map_current_kills'} = 0;
        $RANKINGS{$PLAYERS[$i].'_map_current_deaths'} = 0;
        $RANKINGS{$PLAYERS[$i].'_map_current_suicids'} = 0;
      }
      next;
    }

    ############################################
    ##### Standard DeathMatch SucicidMessages...
    ############################################

    if ($line =~ /^.* died$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) died$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_unknown'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* feels pain$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) feels pain$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_unknown'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* killed himself$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) killed himself$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_command'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* killed herself$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) killed herself$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_command'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* should have used a smaller gun$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) should have used a smaller gun$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_bfg'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* blew himself up$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) blew himself up$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_rocketlauncher'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* blew herself up$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) blew herself up$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_rocketlauncher'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* tripped on his own grenade$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) tripped on his own grenade$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_handgrenade'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* tripped on her own grenade$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) tripped on her own grenade$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_handgrenade'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* tried to put the pin back in$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) tried to put the pin back in$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_grenadelauncher'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* was in the wrong place$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) was in the wrong place$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_bfg'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* got blasted$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) got blasted$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_trapblaster'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* saw the light$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) saw the light$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_traplaser'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* found a way out$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) found a way out$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_unknown'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* blew up$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) blew up$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_explosive'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* does a back flip into the lava$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) does a back flip into the lava$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_lava'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* melted$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) melted$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_slime'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* sank like a rock$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) sank like a rock$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_water'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* was squished$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) was squished$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_squish'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* cratered$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) cratered$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_freefall'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* suicides$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) suicides$/\1/;
      $RANKINGS{$player1.'_hiscore_current_suicids'}++;
      $RANKINGS{$player1.'_map_current_suicids'}++;
      $RANKINGS{$player1.'_suicids_command'}++;
      $RANKINGS{$player1.'_suicids_total'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }

    ############################################
    ##### Standard DeathMatch KillingMessages...
    ############################################

    if ($line =~ /^.* was killed by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was killed by (.*)$/\1/;
      $player2 =~ s/^(.*) was killed by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_unknown'}++;
      $RANKINGS{$player2.'_kills_unknown'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* tried to invade .*'s personal space$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) tried to invade (.*)'s personal space$/\1/;
      $player2 =~ s/^(.*) tried to invade (.*)'s personal space$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_telefrag'}++;
      $RANKINGS{$player2.'_kills_telefrag'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* didn't see .*'s handgrenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) didn't see (.*)'s handgrenade$/\1/;
      $player2 =~ s/^(.*) didn't see (.*)'s handgrenade$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_handgrenade'}++;
      $RANKINGS{$player2.'_kills_handgrenade'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* caught .*'s handgrenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) caught (.*)'s handgrenade$/\1/;
      $player2 =~ s/^(.*) caught (.*)'s handgrenade$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_handgrenade'}++;
      $RANKINGS{$player2.'_kills_handgrenade'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* couldn't hide from .*'s BFG$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) couldn't hide from (.*)'s BFG$/\1/;
      $player2 =~ s/^(.*) couldn't hide from (.*)'s BFG$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_bfg'}++;
      $RANKINGS{$player2.'_kills_bfg'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was disintegrated by .*'s BFG blast$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was disintegrated by (.*)'s BFG blast$/\1/;
      $player2 =~ s/^(.*) was disintegrated by (.*)'s BFG blast$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_bfg'}++;
      $RANKINGS{$player2.'_kills_bfg'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* saw the pretty lights from .*'s BFG$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) saw the pretty lights from (.*)'s BFG$/\1/;
      $player2 =~ s/^(.*) saw the pretty lights from (.*)'s BFG$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_bfg'}++;
      $RANKINGS{$player2.'_kills_bfg'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was melted by .*'s hyperblaster$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was melted by (.*)'s hyperblaster$/\1/;
      $player2 =~ s/^(.*) was melted by (.*)'s hyperblaster$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_hyperblaster'}++;
      $RANKINGS{$player2.'_kills_hyperblaster'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was railed by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was railed by (.*)$/\1/;
      $player2 =~ s/^(.*) was railed by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_railgun'}++;
      $RANKINGS{$player2.'_kills_railgun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* almost dodged .*'s rocket$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) almost dodged (.*)'s rocket$/\1/;
      $player2 =~ s/^(.*) almost dodged (.*)'s rocket$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_rocketlauncher'}++;
      $RANKINGS{$player2.'_kills_rocketlauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* ate .*'s rocket$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) ate (.*)'s rocket$/\1/;
      $player2 =~ s/^(.*) ate (.*)'s rocket$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_rocketlauncher'}++;
      $RANKINGS{$player2.'_kills_rocketlauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was shredded by .*'s shrapnel$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was shredded by (.*)'s shrapnel$/\1/;
      $player2 =~ s/^(.*) was shredded by (.*)'s shrapnel$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_grenadelauncher'}++;
      $RANKINGS{$player2.'_kills_grenadelauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was popped by .*'s grenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was popped by (.*)'s grenade$/\1/;
      $player2 =~ s/^(.*) was popped by (.*)'s grenade$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_grenadelauncher'}++;
      $RANKINGS{$player2.'_kills_grenadelauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was cut in half by .*'s chaingun$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was cut in half by (.*)'s chaingun$/\1/;
      $player2 =~ s/^(.*) was cut in half by (.*)'s chaingun$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_chaingun'}++;
      $RANKINGS{$player2.'_kills_chaingun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was machinegunned by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was machinegunned by (.*)$/\1/;
      $player2 =~ s/^(.*) was machinegunned by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_machinegun'}++;
      $RANKINGS{$player2.'_kills_machinegun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was blown away by .*'s super shotgun$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was blown away by (.*)'s super shotgun$/\1/;
      $player2 =~ s/^(.*) was blown away by (.*)'s super shotgun$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_supershotgun'}++;
      $RANKINGS{$player2.'_kills_supershotgun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was blasted by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was blasted by (.*)$/\1/;
      $player2 =~ s/^(.*) was blasted by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_blaster'}++;
      $RANKINGS{$player2.'_kills_blaster'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was gunned down by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was gunned down by (.*)$/\1/;
      $player2 =~ s/^(.*) was gunned down by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_shotgun'}++;
      $RANKINGS{$player2.'_kills_shotgun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }

    ###################################
    ##### PureDM DeathMatch-Messages...
    ###################################

    if ($line =~ /^.* chews on .*'s grenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) chews on (.*)'s grenade$/\1/;
      $player2 =~ s/^(.*) chews on (.*)'s grenade$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_greandelauncher'}++;
      $RANKINGS{$player2.'_kills_grenadelauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was skewered by .*'s grenade$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was skewered by (.*)'s railgun$/\1/;
      $player2 =~ s/^(.*) was skewered by (.*)'s railgun$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_railgun'}++;
      $RANKINGS{$player2.'_kills_railgun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* actually managed to kill .* with the blaster$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) actually managed to kill (.*) with the blaster$/\1/;
      $player2 =~ s/^(.*) actually managed to kill (.*) with the blaster$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player2.'_deaths_blaster'}++;
      $RANKINGS{$player1.'_kills_blaster'}++;
      $RANKINGS{$player2.'_deaths_total'}++;
      $RANKINGS{$player1.'_kills_total'}++;
      $RANKINGS{$player2.'_enemy_'.$player2}++;
      $RANKINGS{$player1.'_victim_'.$player1}++;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was blasted to Hell by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was blasted to Hell by (.*)$/\1/;
      $player2 =~ s/^(.*) was blasted to Hell by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_hyperblaster'}++;
      $RANKINGS{$player2.'_kills_hyperblaster'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* eats .*'s pineapple$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) eats (.*)'s pineapple$/\1/;
      $player2 =~ s/^(.*) eats (.*)'s pineapple$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_grenadelauncher'}++;
      $RANKINGS{$player2.'_kills_grenadelauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* feeds .* his rocket o' love$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) feeds (.*) his rocket o' love$/\1/;
      $player2 =~ s/^(.*) feeds (.*) his rocket o' love$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player2.'_deaths_rocketlauncher'}++;
      $RANKINGS{$player1.'_kills_rocketlauncher'}++;
      $RANKINGS{$player2.'_deaths_total'}++;
      $RANKINGS{$player1.'_kills_total'}++;
      $RANKINGS{$player2.'_enemy_'.$player2}++;
      $RANKINGS{$player1.'_victim_'.$player1}++;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was annihilated by .*'s BFG$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was annihilated by (.*)'s BFG$/\1/;
      $player2 =~ s/^(.*) was annihilated by (.*)'s BFG$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_bfg'}++;
      $RANKINGS{$player2.'_kills_bfg'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* is gibbed by .*'s pineapple$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) is gibbed by (.*)'s pineapple$/\1/;
      $player2 =~ s/^(.*) is gibbed by (.*)'s pineapple$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_grenadelauncher'}++;
      $RANKINGS{$player2.'_kills_grenadelauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* is mega-gibbed by .*'s pineapple$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) is mega-gibbed by (.*)'s pineapple$/\1/;
      $player2 =~ s/^(.*) is mega-gibbed by (.*)'s pineapple$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_grenadelauncher'}++;
      $RANKINGS{$player2.'_kills_grenadelauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was ground into hamburger by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was ground into hamburger by (.*)$/\1/;
      $player2 =~ s/^(.*) was ground into hamburger by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_chaingun'}++;
      $RANKINGS{$player2.'_kills_chaingun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* munches on .*'s fried green tomato$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) munches on (.*)'s fried green tomato$/\1/;
      $player2 =~ s/^(.*) munches on (.*)'s fried green tomato$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player2.'_deaths_handgrenade'}++;
      $RANKINGS{$player1.'_kills_handgrenade'}++;
      $RANKINGS{$player2.'_deaths_total'}++;
      $RANKINGS{$player1.'_kills_total'}++;
      $RANKINGS{$player2.'_enemy_'.$player2}++;
      $RANKINGS{$player1.'_victim_'.$player1}++;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was utterly vaporized by .*'s Quad BFG$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was utterly vaporized by (.*)'s Quad BFG$/\1/;
      $player2 =~ s/^(.*) was utterly vaporized by (.*)'s Quad BFG$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_bfg'}++;
      $RANKINGS{$player2.'_kills_bfg'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was chewed up by .*'s machinegun$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was chewed up by (.*)'s machinegun$/\1/;
      $player2 =~ s/^(.*) was chewed up by (.*)'s machinegun$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_machinegun'}++;
      $RANKINGS{$player2.'_kills_machinegun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was mowed down by .*'s machinegun$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was mowed down by (.*)'s machinegun$/\1/;
      $player2 =~ s/^(.*) was mowed down by (.*)'s machinegun$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_machinegun'}++;
      $RANKINGS{$player2.'_kills_machinegun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was blown to pieces by .*$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was blown to pieces by (.*)$/\1/;
      $player2 =~ s/^(.*) was blown to pieces by (.*)$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_supershotgun'}++;
      $RANKINGS{$player2.'_kills_supershotgun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* rode .*'s rocket$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) rode (.*)'s rocket$/\1/;
      $player2 =~ s/^(.*) rode (.*)'s rocket$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_rocketlauncher'}++;
      $RANKINGS{$player2.'_kills_rocketlauncher'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* quietly receives .*'s blaster$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) quietly receives (.*)'s blaster$/\1/;
      $player2 =~ s/^(.*) quietly receives (.*)'s blaster$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_blaster'}++;
      $RANKINGS{$player2.'_kills_blaster'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }
    if ($line =~ /^.* was chewed up by .*'s Quad machinegun$/) {
      $player1 = $line;
      $player2 = $line;
      $player1 =~ s/^(.*) was chewed up by (.*)'s Quad machinegun$/\1/;
      $player2 =~ s/^(.*) was chewed up by (.*)'s Quad machinegun$/\2/;
      $RANKINGS{$player1.'_hiscore_current_deaths'}++;
      $RANKINGS{$player2.'_hiscore_current_kills'}++;
      $RANKINGS{$player1.'_map_current_deaths'}++;
      $RANKINGS{$player2.'_map_current_kills'}++;
      $RANKINGS{$player1.'_deaths_machinegun'}++;
      $RANKINGS{$player2.'_kills_machinegun'}++;
      $RANKINGS{$player1.'_deaths_total'}++;
      $RANKINGS{$player2.'_kills_total'}++;
      $RANKINGS{$player1.'_enemy_'.$player2}++;
      $RANKINGS{$player2.'_victim_'.$player1}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $RANKINGS{$player2.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player2) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player2) }
      next;
    }

    #####################################
    ##### Special LMCTF ActionMessages...
    #####################################

    if ($line =~ /^.* lost the red flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) lost the red flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_lost'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* lost the blue flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) lost the blue flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_lost'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* lost your flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) lost your flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_lost'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* stole the red flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) stole the red flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_stole'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* stole the blue flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) stole the blue flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_stole'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* stole your flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) stole your flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_stole'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* captured the red flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) captured the red flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_capture'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* captured the blue flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) captured the blue flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_capture'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* captured your flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) captured your flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_capture'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* returned the red flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) returned the red flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_return'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* returned the blue flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) returned the blue flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_return'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* returned your flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) returned your flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_return'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the red flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the red flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the blue flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the blue flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends your flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends your flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the red base$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the red base$/\1/;
      $RANKINGS{$player1.'_ctf_base_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the blue base$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the blue base$/\1/;
      $RANKINGS{$player1.'_ctf_base_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends your base$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends your base$/\1/;
      $RANKINGS{$player1.'_ctf_base_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the red flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the red flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the blue flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the blue flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends your flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends your flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the red flag carrier from an aggressive enemy$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the red flag carrier from an aggressive enemy$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the blue flag carrier from an aggressive enemy$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the blue flag carrier from an aggressive enemy$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends your flag carrier from an aggressive enemy$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends your flag carrier from an aggressive enemy$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* killed the enemy flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) killed the enemy flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_killed'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* assisted the capture by killing the flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) assisted the capture by killing the flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_capture_assist'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* assisted the capture by defending the flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) assisted the capture by defending the flag$/\1/;
      $RANKINGS{$player1.'_ctf_capture_assist'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* assisted the capture by returning the flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) assisted the capture by returning the flag$/\1/;
      $RANKINGS{$player1.'_ctf_capture_assist'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* %s helped .* return the red flag.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) %s helped .* return the red flag$/\1/;
      $RANKINGS{$player1.'_ctf_return_assist'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* %s helped .* return the blue flag.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) %s helped .* return the blue flag$/\1/;
      $RANKINGS{$player1.'_ctf_return_assist'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* %s helped .* return your flag.$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) %s helped .* return your flag$/\1/;
      $RANKINGS{$player1.'_ctf_return_assist'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }

    #####################################
    ##### Special idCTF ActionMessages...
    #####################################

    if ($line =~ /^.* lost the RED flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) lost the RED flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_lost'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* lost the BLUE flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) lost the BLUE flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_lost'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* got the RED flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) got the RED flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_stole'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* got the BLUE flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) got the BLUE flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_stole'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* captured the RED flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) captured the RED flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_capture'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* captured the BLUE flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) captured the BLUE flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_capture'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* returned the RED flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) returned the RED flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_return'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
   }
    if ($line =~ /^.* returned the BLUE flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) returned the BLUE flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_return'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the RED flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the RED flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the BLUE flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the BLUE flag$/\1/;
      $RANKINGS{$player1.'_ctf_flag_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the RED base$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the RED base$/\1/;
      $RANKINGS{$player1.'_ctf_base_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the BLUE base$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the BLUE base$/\1/;
      $RANKINGS{$player1.'_ctf_base_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the RED's flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the RED's flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* defends the BLUE's flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) defends the BLUE's flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_defend'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* gets an assist for fragging the flag carrier$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) gets an assist for fragging the flag carrier$/\1/;
      $RANKINGS{$player1.'_ctf_carrier_killed'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
    if ($line =~ /^.* gets an assist for returning the flag$/) {
      $player1 = $line;
      $player1 =~ s/^(.*) gets an assist for returning the flag$/\1/;
      $RANKINGS{$player1.'_ctf_return_assist'}++;
      $RANKINGS{$player1.'_lastseen'} = $date;
      $found=0; foreach $player (@PLAYERS) { if ($player eq $player1) { $found=1; } } if (!$found) { @PLAYERS = (@PLAYERS, $player1) }
      next;
    }
  }

  ##### check for new HighScores...
  for ($i=0; $i<@PLAYERS; $i++) {
    if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'}) {
      $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_kills'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_kills'};
    }
    if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'}) {
      $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_deaths'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_deaths'};
    }
    if ($RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'} > $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'}) {
      $RANKINGS{$PLAYERS[$i].'_hiscore_'.$CURRENT_MAP.'_suicids'} = $RANKINGS{$PLAYERS[$i].'_hiscore_current_suicids'};
    }
    $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_kills'} += $RANKINGS{$PLAYERS[$i].'_map_current_kills'};
    $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_deaths'} += $RANKINGS{$PLAYERS[$i].'_map_current_deaths'};
    $RANKINGS{$PLAYERS[$i].'_map_'.$CURRENT_MAP.'_suicids'} += $RANKINGS{$PLAYERS[$i].'_map_current_suicids'};
  }

  print "done\n";
}
             