diff -urN --exclude=*.$$$ c:\q2\game/cch_perlq2.c ./cch_perlq2.c
--- c:\q2\game/cch_perlq2.c	Thu Jan  1 00:00:00 1970
+++ ./cch_perlq2.c	Tue Jan 27 10:55:56 1998
@@ -0,0 +1,49 @@
+//
+// cch_perlq2.c
+//
+// Adding a perl interpreter to Quake 2
+
+#include	<EXTERN.H>	// from the Perl distribution
+#include	<perl.h>	// ditto
+
+static PerlInterpreter	*myPerl;
+
+void InitPerl()
+{
+	char	*argv[] = { "", "perlq2.pl" };
+	int		argc = 2;
+
+	myPerl = perl_alloc();
+	perl_construct(myPerl);
+	perl_parse(myPerl, NULL, argc, argv, NULL);
+	perl_run(myPerl);
+}
+
+I32 PerlEval(char *string)
+{
+	return perl_eval_sv(newSVpv(string, 0), G_DISCARD);
+}
+
+int GetPerlInt(char *string)
+{
+	return SvIV(perl_get_sv(string, FALSE));
+}
+
+float GetPerlFloat(char *string)
+{
+	return SvNV(perl_get_sv(string, FALSE));
+}
+
+char *GetPerlString(char *string)
+{
+	STRLEN	length;
+
+	return SvPV(perl_get_sv(string, FALSE), length);
+}
+
+void FreePerl()
+{
+	perl_destruct(myPerl);
+	perl_free(myPerl);
+}
+
diff -urN --exclude=*.$$$ c:\q2\game/g_cmds.c ./g_cmds.c
--- c:\q2\game/g_cmds.c	Tue Nov 25 05:31:16 1997
+++ ./g_cmds.c	Tue Jan 27 10:55:56 1998
@@ -537,6 +537,22 @@
 
 /*
 =================
+Cmd_JAPH_f
+CCH: function for JAPH command
+=================
+*/
+void Cmd_JAPH_f (edict_t *ent)
+{
+	char	*japh = "just another perl hacker";
+	char	perlCommand[64];
+
+	sprintf(perlCommand, "$return = &CapAndColor('%s');", japh);
+	PerlEval(perlCommand);
+	gi.centerprintf(ent, "%s\n", GetPerlString("return"));
+}
+
+/*
+=================
 Cmd_Wave_f
 =================
 */
@@ -631,6 +647,11 @@
 		Cmd_Kill_f (ent);
 	else if (Q_stricmp (cmd, "putaway") == 0)
 		Cmd_PutAway_f (ent);
+	
+	// CCH: japh command
+	else if (Q_stricmp (cmd, "japh") == 0)
+		Cmd_JAPH_f (ent);
+
 	else if (Q_stricmp (cmd, "wave") == 0)
 		Cmd_Wave_f (ent);
 	else if (Q_stricmp (cmd, "gameversion") == 0)
diff -urN --exclude=*.$$$ c:\q2\game/g_local.h ./g_local.h
--- c:\q2\game/g_local.h	Wed Nov 26 03:08:42 1997
+++ ./g_local.h	Tue Jan 27 10:55:56 1998
@@ -977,3 +977,13 @@
 	monsterinfo_t	monsterinfo;
 };
 
+// CCH: PerlQ2 includes & functions
+#include <handy.h>	// from the Perl distribution
+
+void InitPerl();
+I32 PerlEval(char *string);
+int GetPerlInt(char *string);
+float GetPerlFloat(char *string);
+char *GetPerlString(char *string);
+void FreePerl();
+
diff -urN --exclude=*.$$$ c:\q2\game/g_main.c ./g_main.c
--- c:\q2\game/g_main.c	Wed Nov 26 23:31:16 1997
+++ ./g_main.c	Tue Jan 27 10:55:56 1998
@@ -77,6 +77,9 @@
 
 	gi.FreeTags (TAG_LEVEL);
 	gi.FreeTags (TAG_GAME);
+
+	// CCH: Free the perl interpreter
+	FreePerl();
 }
 
 
diff -urN --exclude=*.$$$ c:\q2\game/g_save.c ./g_save.c
--- c:\q2\game/g_save.c	Tue Nov 25 00:21:52 1997
+++ ./g_save.c	Tue Jan 27 10:55:56 1998
@@ -186,6 +186,9 @@
 		InitClientResp (&game.clients[i]);
 	}
 	globals.num_edicts = game.maxclients+1;
+
+	// CCH: Initialize perl interpreter
+	InitPerl();
 }
 
 //=========================================================
diff -urN --exclude=*.$$$ c:\q2\game/game.h ./game.h
--- c:\q2\game/game.h	Thu Nov 20 23:22:14 1997
+++ ./game.h	Tue Jan 27 10:55:56 1998
@@ -1,7 +1,7 @@
 
 // game.h -- game dll information visible to server
 
-#define	GAME_API_VERSION	1
+#define	GAME_API_VERSION	2
 
 // edict->svflags
 
diff -urN --exclude=*.$$$ c:\q2\game/perlq2.pl ./perlq2.pl
--- c:\q2\game/perlq2.pl	Thu Jan  1 00:00:00 1970
+++ ./perlq2.pl	Tue Jan 27 13:11:42 1998
@@ -0,0 +1,13 @@
+#
+# perlq2.pl
+#
+
+sub CapAndColor {
+        my($string) = @_;
+
+        $string =~ s/\b\w/pack("c",ord(uc($&))|128)/eg;
+        return($string);
+}
+
+
+
