#include "j_lchoice.h"
#include "g_local.h" // for error messages and the gi object

//Declare the global pointer to the level cycle.
//This will rotate around it, always pointing to the current node.

struct string64_node_t *curLevInCycle;

/* J_IMPORTLEVELCYCLE()
Read the file cycle.txt from the mod directory.
For each line, build a string node containing the text of the line, adding it to a
linked list.
When there are no more lines, link the last node back to the first.
Return a pointer to the node containing the text of the first line.
This is not the code from version 1.0; I was using an extra pointer to mark the start
of the cycle, but of course the last node always points to this anyway as its 'next'
so the new one is slightly less easy to understand, but also less clumpy.
*/

struct string64_node_t * J_ImportLevelCycle() {

        FILE *f;
        char instr[64];
        struct string64_node_t *node, *newnode;
		int lcount = 0;

		//allow for different mod pathnames
		char modpath[64] = MOD_PATH;
		strcat(modpath, "cycle.txt");

        if ((f = fopen(modpath, "r")) == NULL) {
                gi.bprintf(PRINT_HIGH, "J_ILC: Unable to open level cycle file cycle.txt.");
                return NULL;
        }

        //grab the first level name
        if ((node = malloc(sizeof(struct string64_node_t))) == NULL) {
                gi.error("Unable to allocate memory for cycle node.");
                return NULL;
        } else {
                if (!fgets(instr, 64, f)) { // no names in file, default to base1
                        strcpy(node->str, "base1");
                        node->next = node; // As in, a cycle of one.
                } else {
                        strcpy(node->str, instr);
                        J_ChopTrailingCR(node->str); // Level names can't have \n in them
                        node->next = node; // Assume this is the last node just in case.
                		lcount++;
				}
        }

        while (fgets(instr, 64, f)) { // keep on suckin'
                if ((newnode = malloc(sizeof(struct string64_node_t))) == NULL) {
                        gi.error("Unable to allocate memory for cycle node.");
                        return NULL; // FIX ME: Remember to treat this as an error when calling
                } // else
                strcpy(newnode->str, instr); // Give the node its contents
                J_ChopTrailingCR(newnode->str); // Level names no hablo \n
                newnode->next = node->next; // All nodes assume they are the last until told.
                node->next = newnode;  // Here, for example.
                node = newnode;        // Shift the whole assembly along one node, keep going.
        		lcount++;
		}

		gi.dprintf("LCYCLE: %i levels imported.\n", lcount);
        fclose(f);
        return newnode->next; // pointer to the first node
}

/* J_CHOPTRAILINGCR(char *)
Given a string, make sure that the last \n, if any is chopped off.
*/
void J_ChopTrailingCR(char * str) {
        if (str[strlen(str) -1] == '\n')
                str[strlen(str) - 1] = '\0';
}

/* J_IMPORTMOTD(char *)
Given a string, slurp the motd file into it.
*/
void J_ImportMOTD(char * outstr) {

	FILE *motdFile;
	char newline[80];
	char modpath[64] = MOD_PATH;
	int lcount = 0;

	strcat(modpath, "motd.txt");
	motdFile = fopen(modpath, "r");

	if(motdFile == NULL) {
		gi.error("J_ImportMOTD: Unable to open file motd.txt\n");
		return;
	}

	while (fgets(newline, 80, motdFile) != NULL) {
		strcat(outstr, newline);
		lcount++;
	}

	strcat(outstr, "\nServer running lcycle 1.1 by _JoJo\nhttp://jra.jra.com.au/quake2");
	gi.dprintf("LCYCLE: %i lines of MOTD read.\n", lcount);

	fclose(motdFile);

}
