#!/usr/local/bin/perl

use FileHandle;

my $maxmaps = 40;

my $scriptroot;
$scriptroot = "$0";
$scriptroot =~ s/\/[^\/]*$/\//;


# make sure master40 (and assume the rest) are present
$scriptroot = "" unless (-e "${scriptroot}master40.txt");
$scriptroot = "/" unless (-e "${scriptroot}master40.txt");
$scriptroot = "~/" unless (-e "${scriptroot}master40.txt");

my @masters = ("${scriptroot}master10.txt",
	       "${scriptroot}master20.txt",
	       "${scriptroot}master30.txt",
	       "${scriptroot}master40.txt");

my $config = "maplist.txt";
my $mapdefaults = "${scriptroot}mapdefaults.txt";
my $fourteam = 0;
my %default = ("HEALTH" => 9999999,
	       "MESSAGE" => "Unavailable",
	       "MAPNAME" => ""	# eventually, fill this in with map0
	      );
my $defbias = 5000;

my $mapno = 0;
my $cycledir = "qwmcycle";

my $singleteam = "\"maxammo_shells\" \"1022\"\n\"ammo_medikit\" \"0\"\n\"noise1\" \"1-Select-1\\n\\nShoot the Door to Your Favorite Map!\\n\"\n\"team_broadcast\" \"1-Select-1\\n\"";

my $cells = 0;

sub usage {
  die("$0 [-testing] [-team] [-map <maplist.txt>] [-nocells]\n");
}

sub add_map {
    my ($name, $msg, $health) = @_;

    $maps[$mapno++] = {"MAPNAME" => $name,
		       "MESSAGE" => $msg, 
		       "HEALTH" => $health
		       };
    if (!$maps[$mapno - 1]{"CFGFILE"}) {
	$cfgfile = "$cycledir/" . $maps[$mapno - 1]{"MAPNAME"} . ".cfg";
	$maps[$mapno - 1]{"CFGFILE"} = new FileHandle(">$cfgfile") or die("Couldn't create $cfgfile!");;
	$maps[$mapno - 1]{"CFGFILE"}->print($defaults);
    }
#    print "maps[$mapno++]->mapname = ", $maps[$mapno - 1]->{"MAPNAME"}, "\n" if ($testing);

}

sub read_config {

    mkdir($cycledir, 0744) if (! -d "$cycledir");

  open CONFIG, "<$mapdefaults" || die("Couldn't open map defaults $mapdefaults");
  $defaults = join("", <CONFIG>);
  close CONFIG;
  
  open CONFIG, "<$config" || die("Couldn't open map config file $config!");
  while (<CONFIG>) {
    next if (/^(;|\#)/ || /^\s*$/);
    if (/^(\S+)\s+"(.*)"\s+(\d*)$/) { 
	add_map($1, $2, $3 || $defbias);
	last if ($mapno == $maxmaps);
    } elsif (/^(\S+)\s+(\d*)$/) { 
	add_map($1, $1, $2 || $defbias);
	last if ($mapno == $maxmaps);
    } elsif (/^(localinfo .*)\s*$/ || /^(serverinfo .*)\s*$/) {
      
      $maps[$mapno - 1]{"CFGFILE"}->print($_);
      
  } elsif (/^(\S+)\s*$/) {
      add_map($1, $1, $defbias);
      last if ($mapno == $maxmaps);
  } else {
      print "WARNING: Couldn't parse line:\n\t$_\n";
      print "Did it wrap from the previous line?\n";
    }
  }
  close CONFIG;
  $default{"MAPNAME"} = $maps[0]{"MAPNAME"};
}

sub process_ent {
  my $mapfile = $masters[($mapno - 1)/ 10];
  open( MAPFILE, "<$mapfile" ) or die("Couldn't open master file $mapfile!");
  open( ENTFILE, ">vote40.ent") or die("Couldn't open vote40.ent!");
  
  print "Opened $mapfile\n" if ($testing);
  
  while (<MAPFILE>) {
    s/DOOR([0-9]+)_([A-Z]+)/$maps[$1 - 1]{$2} || $default{$2}/eg;
    # some random patterns for niceness. blech. 
    s/NUMMAPS/$mapno/g;
    s/SINGLETEAM/$singleteam/g;
    s/TEAM([1-4])/$1/g if ($fourteam);
    s/TEAM[1-4]/1/g unless ($fourteam);
    s/NUMCELLS/$cells/g;
    print ENTFILE;
    #	print if ($testing);
  }
  
  close ENTFILE;
  close MAPFILE;
}

sub main {
  while (@ARGV) {
    $_ = shift @ARGV;
    (/map/) && do {
      $config = shift @ARGV;
      next;
    };
    (/team/ || /4/) && do {
      $fourteam = 1;
      $singleteam = "";
      print "Selecting 4 Teams mode\n" if ($testing);
      next;
    };
    (/testing/) && do {
      $testing = 1;
      next;
    };
    (/cells/) && do {
      $cells = -15;
      next;
    };
    (/health/) && do {
      $defbias = shift @ARGV;
      next;
    };
    (/cycle/) && do {
      $cycledir = shift @ARGV;
      next;
    };
    print "Unknown option: $_\n";
    usage();
    }
  
  print "Running $0 (root: $scriptroot)\n" if ($testing);

    read_config();
    process_ent();
}


main();
