@echo off
REM ##########################################
REM #                                        #
REM # Filename: GROUPR.BAT                   #
REM # Purpose : Initialize the grouping of   #
REM #           all RETURN files             #
REM #                                        #
REM ##########################################
REM
REM ##########################################
REM #                                        #
REM # Check for existence of .bay files      #
REM #                                        #
REM ##########################################
REM
IF EXIST EXCESS0.BAY GOTO #ERROR
IF EXIST EXCESS1.BAY GOTO #ERROR
IF EXIST EXCESS2.BAY GOTO #ERROR
IF EXIST EXCESS3.BAY GOTO #ERROR
IF EXIST EXCESS4.BAY GOTO #ERROR
IF EXIST EXCESS5.BAY GOTO #ERROR
IF EXIST EXCESS6.BAY GOTO #ERROR
IF EXIST EXCESS7.BAY GOTO #ERROR

REM ##########################################
REM #                                        #
REM # Check for existence of .art files      #
REM #                                        #
REM ##########################################
IF EXIST TILES000.ART GOTO #ERROR2
IF EXIST TILES006.ART GOTO #ERROR2
IF EXIST TILES007.ART GOTO #ERROR2
IF EXIST TILES009.ART GOTO #ERROR2
IF EXIST TILES010.ART GOTO #ERROR2
IF EXIST TILES012.ART GOTO #ERROR2
IF EXIST TILES014.ART GOTO #ERROR2
IF EXIST TILES015.ART GOTO #ERROR2

REM ##########################################
REM #                                        #
REM # Check for existence of .con files      #
REM #                                        #
REM ##########################################
IF EXIST DEFS.CON GOTO #ERROR3
IF EXIST GAME.CON GOTO #ERROR3
IF EXIST USER.CON GOTO #ERROR3

REM ##########################################
REM #                                        #
REM # Check for existence of duke3d.grp and  #
REM # other various files                    #
REM #                                        #
REM ########################################## 
IF NOT EXIST DUKE3D.GRP GOTO #ERROR4
IF NOT EXIST KEXTRACT.EXE GOTO #ERROR4
IF NOT EXIST KGROUP.EXE GOTO #ERROR4
IF NOT EXIST RETURN1.ART GOTO #ERROR4
IF NOT EXIST RETURN2.ART GOTO #ERROR4
IF NOT EXIST RETURN3.ART GOTO #ERROR4
IF NOT EXIST RETURN4.ART GOTO #ERROR4
IF NOT EXIST RETURN5.ART GOTO #ERROR4
IF NOT EXIST RETURN6.ART GOTO #ERROR4
IF NOT EXIST RETURN7.ART GOTO #ERROR4
IF NOT EXIST RETURN8.ART GOTO #ERROR4

REM ##########################################
REM #                                        #
REM # Extract all files from duke3d.grp      #
REM #                                        #
REM ##########################################
:#EXTRACT
kextract duke3d.grp *.voc *.anm *.dat *.art

GOTO #RENAME

REM ##########################################
REM #                                        #
REM # Save user files & rename RETURN files. #
REM #                                        #
REM ##########################################
:#RENAME
rename tiles000.art,excess0.bay
rename tiles006.art,excess1.bay
rename tiles007.art,excess2.bay
rename tiles009.art,excess3.bay
rename tiles010.art,excess4.bay
rename tiles012.art,excess5.bay
rename tiles014.art,excess6.bay
rename tiles015.art,excess7.bay

GOTO #GROUP1


REM ##########################################
REM #                                        #
REM # Group excess art files into other grps #
REM #                                        #
REM ##########################################
:#GROUP1
kgroup excess.grp excess0.bay excess1.bay excess2.bay excess3.bay excess4.bay excess5.bay excess6.bay excess7.bay

GOTO #RENAME2


REM ##########################################
REM #                                        #
REM # Save user files & rename RETURN files. #
REM #                                        #
REM ##########################################
:#RENAME2
rename return1.art,tiles000.art
rename return2.art,tiles006.art
rename return3.art,tiles007.art
rename return4.art,tiles009.art
rename return5.art,tiles010.art
rename return6.art,tiles012.art
rename return7.art,tiles014.art
rename return8.art,tiles015.art

GOTO #GROUP


REM ##########################################
REM #                                        #
REM # Group all files into return.grp        #
REM #                                        #
REM ##########################################
:#GROUP
kgroup return.grp *.voc *.art *.dmo *.anm *.dat *.con *.map *.mid 

REM ##########################################
REM #                                        #
REM # Delete all excess files                #
REM #                                        #
REM ##########################################
DEL *.voc
DEL *.anm
DEL *.bay
DEL *.art
DEL *.mid
DEL *.map
ECHO Installation is complete!
ECHO Follow the rest of the installation instructions referred to in the
ECHO Return.txt file and have a ball! 

GOTO EXIT

REM ##########################################
REM #                                        #
REM # Bay Error Logic                        #
REM #                                        #
REM ##########################################
:#ERROR
CLS
ECHO The grouping of "The Return" group file cannot be initiated because one
ECHO or more .bay files exist in the current directory. Please remove all
ECHO .bay files from the current directory these .bay files are a "waste"
ECHO product of this .bat files and is not needed to play "The Return".
ECHO If you can not do this or any other task that the other errors have
ECHO given you, then move this .bat file along with the necessary files
ECHO it asks for to a seperate directory. There, you can try the request
ECHO again!

GOTO EXIT

REM ##########################################
REM #                                        #
REM # Artwork Error Logic                    #
REM #                                        #
REM ##########################################
:#ERROR2
CLS
ECHO The grouping of "The Return" group file cannot be initiated because 
ECHO tiles.art exist in the directory. Please
ECHO remove all or rename all of the specified .art files from the
ECHO current directory these artfiles are not needed to play "The Return".
ECHO If you can not do this or any other task that the other errors have
ECHO given you, then move this .bat file along with the necessary files
ECHO it asks for to a seperate directory. There, you can try the request
ECHO again!

GOTO EXIT

REM ##########################################
REM #                                        #
REM # Con Error Logic                        #
REM #                                        #
REM ##########################################
:#ERROR3
CLS
ECHO One or more of the original .con files exist in the current directory,
ECHO please remove, rename or back-up the original cons, they are not needed
ECHO to play "The Return". If you can not do this or any other task that
ECHO the other errors have given you, then move this .bat file along with
ECHO the necessary files it asks for to a seperate directory. There, you
ECHO can try the request again!

GOTO EXIT

REM ##########################################
REM #                                        #
REM # Not Existing Logic                     #
REM #                                        #
REM ##########################################
:#ERROR4
CLS
ECHO Any or all of the files could not be found in the current directory;
ECHO Duke3d.grp, Kextract.exe, Kgroup.exe, Return1.art, Return2.art,
ECHO Return3.art, Return4.art, Return5.art, Return6.art, Return7.art,
ECHO Return8.art. Please find these files and place them in the current
ECHO directory and try the request again!

GOTO EXIT

REM ##########################################
REM #                                        #
REM # Exit Logic                             #
REM #                                        #
REM ##########################################
:EXIT
