@echo off

rem First verify that the script command line is valid.
if NOT %0==install goto currentdir
if "%1"=="" goto usage
if "%1"=="-?" goto usage
if "%1"=="/?" goto usage
if NOT "%2"=="" goto tomanyparam

rem Now make sure that script is run from the install directory.
rem In other words, the files to be installed are in the current directory.
if NOT EXIST sersetup.exe goto noserial
if NOT EXIST commit.exe goto nocommit
if NOT EXIST allmodem.str goto nomodem

rem Now figure out which program we are installing for.
if EXIST %1\duke3d.exe goto doduke
if EXIST %1\doom.exe goto dodoom
if EXIST %1\doom2.exe goto dodoom

echo Could not find doom.exe, doom2.exe, or duke3d.exe in the specified
echo directory.  GamePhones installation aborted.
goto done

:dodoom
if EXIST %1\sersetup.bak goto doomalreadyinstalled
copy %1\sersetup.exe %1\sersetup.bak
copy sersetup.exe %1\sersetup.exe
copy allmodem.str %1\allmodem.str
echo GamePhones successfully installed to %1
goto done

:doomalreadyinstalled
echo A sersetup.bak file already exists in %1
echo Has Echo GamePhones already been installed?
echo If not, then please delete the sersetup.bak file.
echo GamePhones installation aborted.
goto done

:doduke
if EXIST %1\commit3d.exe goto dukealreadyinstalled
copy %1\commit.exe %1\commit3d.exe
copy commit.exe %1\commit.exe
copy allmodem.str %1\allmodem.str
echo GamePhones successfully installed to %1
goto done

:dukealreadyinstalled
echo A commit3d.exe file already exists in %1
echo A version of Echo GamePhones has already been installed!
echo Please run the remove.bat file before rerunning this install.bat file.
echo GamePhones installation aborted.
goto done

:nocommit
echo The commit.exe file is not in the current directory.
echo Please run install from the directory that contains the files to install.
echo GamePhones installation aborted.
goto done

:noserial
echo The sersetup.exe file is not in the current directory.
echo Please run install from the directory that contains the files to install.
echo GamePhones installation aborted.
goto done

:nomodem
echo The allmodem.str file is not in the current directory.
echo Please run install from the directory that contains the files to install.
echo GamePhones installation aborted.
goto done

:tomanyparam
echo To many parameters.
goto usage

:currentdir
echo You must run install from inside its own directory.

:usage
echo usage: install thefullpathtothegamedirectory  ex: install c:\duke3d

:done

